/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.conduits.conduit.redstone;

import com.enderio.core.api.client.gui.ITabPanel;
import com.enderio.core.common.util.DyeColor;
import com.enderio.core.common.vecmath.Vector4f;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Multimap;
import crazypants.enderio.base.conduit.ConduitUtil;
import crazypants.enderio.base.conduit.ConnectionMode;
import crazypants.enderio.base.conduit.IClientConduit;
import crazypants.enderio.base.conduit.IConduit;
import crazypants.enderio.base.conduit.IConduitNetwork;
import crazypants.enderio.base.conduit.IGuiExternalConnection;
import crazypants.enderio.base.conduit.RaytraceResult;
import crazypants.enderio.base.conduit.geom.CollidableCache;
import crazypants.enderio.base.conduit.geom.CollidableComponent;
import crazypants.enderio.base.conduit.redstone.ConnectivityTool;
import crazypants.enderio.base.conduit.redstone.signals.Signal;
import crazypants.enderio.base.conduit.redstone.signals.SignalSource;
import crazypants.enderio.base.conduit.registry.ConduitRegistry;
import crazypants.enderio.base.diagnostics.Prof;
import crazypants.enderio.base.render.registry.TextureRegistry;
import crazypants.enderio.base.tool.ToolUtil;
import crazypants.enderio.conduits.conduit.AbstractConduit;
import crazypants.enderio.conduits.conduit.IConduitComponent;
import crazypants.enderio.conduits.conduit.redstone.IRedstoneConduit;
import crazypants.enderio.conduits.conduit.redstone.RedstoneConduitNetwork;
import crazypants.enderio.conduits.config.ConduitConfig;
import crazypants.enderio.conduits.gui.RedstoneSettings;
import crazypants.enderio.conduits.init.ConduitObject;
import crazypants.enderio.conduits.render.BlockStateWrapperConduitBundle;
import dan200.computercraft.api.ComputerCraftAPI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockRedstoneWire;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.Optional;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class InsulatedRedstoneConduit
extends AbstractConduit
implements IRedstoneConduit,
IConduitComponent {
    static final Map<String, TextureRegistry.TextureSupplier> ICONS = new HashMap<String, TextureRegistry.TextureSupplier>();
    public static final TextureRegistry.TextureSupplier ICON_IN_OUT_KEY;
    public static final TextureRegistry.TextureSupplier ICON_KEY_IN_OUT_BG;
    public static final TextureRegistry.TextureSupplier ICON_KEY_INPUT;
    public static final TextureRegistry.TextureSupplier ICON_KEY_OUTPUT;
    public static final TextureRegistry.TextureSupplier ICON_KEY_IN_OUT_OUT;
    public static final TextureRegistry.TextureSupplier ICON_KEY_IN_OUT_IN;
    private Map<EnumFacing, ConnectionMode> forcedConnections = new EnumMap<EnumFacing, ConnectionMode>(EnumFacing.class);
    private Map<EnumFacing, DyeColor> inputSignalColors = new EnumMap<EnumFacing, DyeColor>(EnumFacing.class);
    private Map<EnumFacing, DyeColor> outputSignalColors = new EnumMap<EnumFacing, DyeColor>(EnumFacing.class);
    private Map<EnumFacing, Boolean> signalStrengths = new EnumMap<EnumFacing, Boolean>(EnumFacing.class);
    private final List<Set<Signal>> externalSignals = new ArrayList<Set<Signal>>();
    private RedstoneConduitNetwork network;
    private int activeUpdateCooldown = 0;
    private boolean activeDirty = false;
    private boolean connectionsDirty = false;

    public InsulatedRedstoneConduit() {
        for (EnumFacing ignored : EnumFacing.field_82609_l) {
            this.externalSignals.add(new HashSet());
        }
    }

    @Nullable
    public IConduitNetwork<IRedstoneConduit, IRedstoneConduit> getNetwork() {
        return this.network;
    }

    @Override
    public boolean setNetwork(@Nonnull IConduitNetwork<?, ?> network) {
        this.network = (RedstoneConduitNetwork)network;
        return true;
    }

    @Override
    public void clearNetwork() {
        this.network = null;
    }

    @Override
    @Nonnull
    public Class<? extends IConduit> getBaseConduitType() {
        return IRedstoneConduit.class;
    }

    @Override
    public void updateNetwork() {
        World world = this.getBundle().getEntity().func_145831_w();
        if (world != null) {
            this.updateNetwork(world);
        }
    }

    @Override
    public void updateEntity(@Nonnull World world) {
        super.updateEntity(world);
        if (!world.field_72995_K) {
            if (this.activeUpdateCooldown > 0) {
                --this.activeUpdateCooldown;
                Prof.start((IBlockAccess)world, "updateActiveState");
                this.updateActiveState();
                Prof.stop((IBlockAccess)world);
            }
            if (this.connectionsDirty) {
                if (this.hasExternalConnections()) {
                    this.network.updateInputsFromConduit(this, false);
                }
                this.connectionsDirty = false;
            }
        }
    }

    @Override
    public void setActive(boolean active) {
        if (active != this.active) {
            this.activeDirty = true;
        }
        this.active = active;
        this.updateActiveState();
    }

    private void updateActiveState() {
        if (ConduitConfig.showState.get().booleanValue() && this.activeDirty && this.activeUpdateCooldown == 0) {
            this.setClientStateDirty();
            this.activeDirty = false;
            this.activeUpdateCooldown = 4;
        }
    }

    @Override
    public void onChunkUnload() {
        RedstoneConduitNetwork networkR = (RedstoneConduitNetwork)this.getNetwork();
        if (networkR != null) {
            ArrayListMultimap oldSignals = ArrayListMultimap.create(networkR.getSignals());
            ArrayList conduits = Lists.newArrayList(networkR.getConduits());
            super.onChunkUnload();
            networkR.afterChunkUnload(conduits, (Multimap<SignalSource, Signal>)oldSignals);
        }
    }

    @Override
    public boolean onBlockActivated(@Nonnull EntityPlayer player, @Nonnull EnumHand hand, @Nonnull RaytraceResult res, @Nonnull List<RaytraceResult> all) {
        World world = this.getBundle().getEntity().func_145831_w();
        if (!world.field_72995_K) {
            DyeColor col = DyeColor.getColorFromDye((ItemStack)player.func_184586_b(hand));
            if (col != null && res.component != null) {
                this.setInputSignalColor(res.component.dir, col);
                return true;
            }
            if (ToolUtil.isToolEquipped(player, hand) && res != null && res.component != null) {
                EnumFacing connDir = res.component.dir;
                EnumFacing faceHit = res.movingObjectPosition.field_178784_b;
                if (connDir == null || connDir == faceHit) {
                    BlockPos pos = this.getBundle().getLocation().func_177972_a(faceHit);
                    Block id = world.func_180495_p(pos).func_177230_c();
                    if (id == ConduitRegistry.getConduitModObjectNN().getBlock()) {
                        IRedstoneConduit neighbour = ConduitUtil.getConduit(world, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p(), IRedstoneConduit.class);
                        if (neighbour != null && neighbour.getConnectionMode(faceHit.func_176734_d()) == ConnectionMode.DISABLED) {
                            neighbour.setConnectionMode(faceHit.func_176734_d(), ConnectionMode.NOT_SET);
                        }
                        this.setConnectionMode(faceHit, ConnectionMode.NOT_SET);
                        return ConduitUtil.connectConduits(this, faceHit);
                    }
                    this.forceConnectionMode(faceHit, ConnectionMode.IN_OUT);
                    return true;
                }
                if (this.externalConnections.contains(connDir)) {
                    if (this.network != null) {
                        this.network.destroyNetwork();
                    }
                    this.externalConnectionRemoved(connDir);
                    this.forceConnectionMode(connDir, ConnectionMode.DISABLED);
                    return true;
                }
                if (this.containsConduitConnection(connDir)) {
                    BlockPos pos = this.getBundle().getLocation().func_177972_a(connDir);
                    IRedstoneConduit neighbour = ConduitUtil.getConduit(this.getBundle().getEntity().func_145831_w(), pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p(), IRedstoneConduit.class);
                    if (neighbour != null) {
                        if (this.network != null) {
                            this.network.destroyNetwork();
                        }
                        if (neighbour.getNetwork() != null) {
                            neighbour.getNetwork().destroyNetwork();
                        }
                        neighbour.conduitConnectionRemoved(connDir.func_176734_d());
                        this.conduitConnectionRemoved(connDir);
                        neighbour.connectionsChanged();
                        this.connectionsChanged();
                        this.updateNetwork();
                        neighbour.updateNetwork();
                        return true;
                    }
                }
            }
        }
        return false;
    }

    @Override
    public void forceConnectionMode(@Nonnull EnumFacing dir, @Nonnull ConnectionMode mode) {
        this.setConnectionMode(dir, mode);
        this.forcedConnections.put(dir, mode);
        this.onAddedToBundle();
        if (this.network != null) {
            this.network.updateInputsFromConduit(this, false);
        }
    }

    @Override
    @Nonnull
    public ItemStack createItem() {
        return new ItemStack(ConduitObject.item_redstone_conduit.getItemNN(), 1, 0);
    }

    @Override
    public void onInputsChanged(@Nonnull EnumFacing side, int[] inputValues) {
    }

    @Override
    public void onInputChanged(@Nonnull EnumFacing side, int inputValue) {
    }

    @Override
    @Nonnull
    public DyeColor getInputSignalColor(@Nonnull EnumFacing dir) {
        DyeColor res = this.inputSignalColors.get(dir);
        if (res == null) {
            return DyeColor.RED;
        }
        return res;
    }

    @Override
    public void setInputSignalColor(@Nonnull EnumFacing dir, @Nonnull DyeColor col) {
        this.inputSignalColors.put(dir, col);
        if (this.network != null) {
            this.network.updateInputsFromConduit(this, false);
        }
        this.setClientStateDirty();
        this.collidablesDirty = true;
    }

    @Override
    @Nonnull
    public DyeColor getOutputSignalColor(@Nonnull EnumFacing dir) {
        DyeColor res = this.outputSignalColors.get(dir);
        if (res == null) {
            return DyeColor.RED;
        }
        return res;
    }

    @Override
    public void setOutputSignalColor(@Nonnull EnumFacing dir, @Nonnull DyeColor col) {
        this.outputSignalColors.put(dir, col);
        if (this.network != null) {
            this.network.updateInputsFromConduit(this, false);
        }
        this.setClientStateDirty();
        this.collidablesDirty = true;
    }

    @Override
    public boolean isOutputStrong(@Nonnull EnumFacing dir) {
        if (this.signalStrengths.containsKey(dir)) {
            return this.signalStrengths.get(dir);
        }
        return false;
    }

    @Override
    public void setOutputStrength(@Nonnull EnumFacing dir, boolean isStrong) {
        if (this.isOutputStrong(dir) != isStrong) {
            if (isStrong) {
                this.signalStrengths.put(dir, isStrong);
            } else {
                this.signalStrengths.remove(dir);
            }
            if (this.network != null) {
                this.network.notifyNeigborsOfSignalUpdate();
            }
        }
    }

    @Override
    public boolean canConnectToExternal(@Nonnull EnumFacing direction, boolean ignoreConnectionState) {
        BlockPos pos;
        if (ignoreConnectionState) {
            return true;
        }
        ConnectionMode forcedConnection = this.forcedConnections.get(direction);
        if (forcedConnection == ConnectionMode.DISABLED) {
            return false;
        }
        if (forcedConnection == ConnectionMode.IN_OUT || forcedConnection == ConnectionMode.OUTPUT || forcedConnection == ConnectionMode.INPUT) {
            return true;
        }
        World world = this.getBundle().getBundleworld();
        IBlockState bs = world.func_180495_p(pos = this.getBundle().getLocation().func_177972_a(direction));
        if (bs.func_177230_c() == ConduitRegistry.getConduitModObjectNN().getBlock()) {
            return false;
        }
        return ConnectivityTool.shouldAutoConnectRedstone(world, bs, pos, direction.func_176734_d());
    }

    @Override
    public int isProvidingWeakPower(@Nonnull EnumFacing toDirection) {
        if (!this.getConnectionMode(toDirection = toDirection.func_176734_d()).acceptsInput()) {
            return 0;
        }
        if (this.network == null || !this.network.isNetworkEnabled()) {
            return 0;
        }
        int result = 0;
        for (Signal signal : this.getNetworkOutputs(toDirection)) {
            if (signal.getSource().equals((Object)this.getPos().func_177972_a(toDirection))) continue;
            result = Math.max(result, signal.getStrength());
        }
        return result;
    }

    @Nonnull
    private BlockPos getPos() {
        return this.getBundle().getLocation();
    }

    @Override
    public int isProvidingStrongPower(@Nonnull EnumFacing toDirection) {
        if (this.isOutputStrong(toDirection.func_176734_d())) {
            return this.isProvidingWeakPower(toDirection);
        }
        return 0;
    }

    @Override
    @Nonnull
    public Collection<Signal> getNetworkOutputs(@Nonnull EnumFacing side) {
        ConnectionMode mode = this.getConnectionMode(side);
        if (this.network == null || !mode.acceptsInput()) {
            return Collections.emptySet();
        }
        Collection allSigs = this.network.getSignals().values();
        if (allSigs.isEmpty()) {
            return allSigs;
        }
        DyeColor col = this.getOutputSignalColor(side);
        HashSet<Signal> result = new HashSet<Signal>();
        for (Signal signal : allSigs) {
            if (signal.getColor() != col) continue;
            result.add(signal);
        }
        return result;
    }

    @Override
    @Nonnull
    public Set<Signal> getNetworkInputs(@Nonnull EnumFacing side) {
        if (this.network != null) {
            this.network.setNetworkEnabled(false);
        }
        HashSet<Signal> signals = new HashSet<Signal>();
        if (this.acceptSignalsForDir(side)) {
            int input = this.getExternalPowerLevel(side);
            if (input > 0) {
                BlockPos pos = this.getBundle().getLocation().func_177972_a(side);
                Signal signal = new Signal(pos, side, input, this.getInputSignalColor(side));
                signals.add(signal);
            }
            if (Loader.isModLoaded((String)"computercraft")) {
                BlockPos loc = this.getBundle().getLocation().func_177972_a(side);
                int bundledInput = this.getComputerCraftBundledPowerLevel(side);
                if (bundledInput >= 0) {
                    for (int i = 0; i < 16; ++i) {
                        int color = bundledInput >>> i & 1;
                        Signal signal = new Signal(loc, side, color == 1 ? 16 : 0, DyeColor.fromIndex((int)Math.max(0, 15 - i)));
                        signals.add(signal);
                    }
                }
            }
        }
        if (this.network != null) {
            this.network.setNetworkEnabled(true);
        }
        HashMap<DyeColor, Signal> res = new HashMap<DyeColor, Signal>();
        for (Signal signal : signals) {
            if (signal == null || res.containsKey(signal.getColor()) && signal.getStrength() <= ((Signal)res.get(signal.getColor())).getStrength()) continue;
            res.put(signal.getColor(), signal);
        }
        return new HashSet<Signal>(res.values());
    }

    protected int getExternalPowerLevel(@Nonnull EnumFacing dir) {
        World world = this.getBundle().getBundleworld();
        BlockPos loc = this.getBundle().getLocation().func_177972_a(dir);
        int res = 0;
        if (world.func_175667_e(loc)) {
            int strong = world.func_175627_a(loc, dir);
            if (strong > 0) {
                return strong;
            }
            res = world.func_175651_c(loc, dir);
            IBlockState bs = world.func_180495_p(loc);
            Block block = bs.func_177230_c();
            if (res <= 15 && block == Blocks.field_150488_af) {
                int wireIn = (Integer)bs.func_177229_b((IProperty)BlockRedstoneWire.field_176351_O);
                res = Math.max(res, wireIn);
            }
        }
        return res;
    }

    @Optional.Method(modid="computercraft")
    protected int getComputerCraftBundledPowerLevel(EnumFacing dir) {
        BlockPos pos;
        World world = this.getBundle().getBundleworld();
        if (world.func_175667_e(pos = this.getBundle().getLocation().func_177972_a(dir))) {
            return ComputerCraftAPI.getBundledRedstoneOutput((World)world, (BlockPos)pos, (EnumFacing)dir.func_176734_d());
        }
        return -1;
    }

    @Override
    @Nonnull
    public ConnectionMode getConnectionMode(@Nonnull EnumFacing dir) {
        ConnectionMode res = this.forcedConnections.get(dir);
        if (res == null) {
            return this.getDefaultConnectionMode();
        }
        return res;
    }

    @Override
    public boolean onNeighborBlockChange(@Nonnull Block blockId) {
        World world = this.getBundle().getBundleworld();
        if (world.field_72995_K) {
            return false;
        }
        boolean res = super.onNeighborBlockChange(blockId);
        if (this.network == null || this.network.updatingNetwork) {
            return false;
        }
        if (blockId != ConduitRegistry.getConduitModObjectNN().getBlock()) {
            this.connectionsDirty = true;
        }
        return res;
    }

    private boolean acceptSignalsForDir(@Nonnull EnumFacing dir) {
        if (!this.getConnectionMode(dir).acceptsOutput()) {
            return false;
        }
        BlockPos loc = this.getBundle().getLocation().func_177972_a(dir);
        return ConduitUtil.getConduit(this.getBundle().getEntity().func_145831_w(), loc.func_177958_n(), loc.func_177956_o(), loc.func_177952_p(), IRedstoneConduit.class) == null;
    }

    @Override
    @Nonnull
    public Collection<CollidableComponent> createCollidables(@Nonnull CollidableCache.CacheKey key) {
        Collection<CollidableComponent> baseCollidables = super.createCollidables(key);
        if (key.dir == null) {
            return baseCollidables;
        }
        ArrayList<CollidableComponent> result = new ArrayList<CollidableComponent>();
        result.addAll(baseCollidables);
        return result;
    }

    @Override
    public int getRedstoneSignalForColor(@Nonnull DyeColor col) {
        if (this.network != null) {
            return this.network.getSignalStrengthForColor(col);
        }
        return 0;
    }

    @Override
    @Nonnull
    public TextureAtlasSprite getTextureForState(@Nonnull CollidableComponent component) {
        if (component.dir == null) {
            return ConduitConfig.showState.get() != false && this.isActive() ? ICONS.get("blocks/redstone_insulated_conduit_core_on").get(TextureAtlasSprite.class) : ICONS.get("blocks/redstone_insulated_conduit_core_off").get(TextureAtlasSprite.class);
        }
        return ICONS.get("blocks/redstone_insulated_conduit").get(TextureAtlasSprite.class);
    }

    @Override
    @Nonnull
    public TextureAtlasSprite getTransmitionTextureForState(@Nonnull CollidableComponent component) {
        return ConduitConfig.showState.get() != false && this.isActive() ? ICONS.get("blocks/redstone_conduit_transmission").get(TextureAtlasSprite.class) : ICONS.get("blocks/redstone_conduit").get(TextureAtlasSprite.class);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    @Nonnull
    public Vector4f getTransmitionTextureColorForState(@Nonnull CollidableComponent component) {
        return null;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    @Nonnull
    public TextureAtlasSprite getTextureForInputMode() {
        return ICON_KEY_INPUT.get(TextureAtlasSprite.class);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    @Nonnull
    public TextureAtlasSprite getTextureForInOutMode(boolean input) {
        return input ? ICON_KEY_IN_OUT_IN.get(TextureAtlasSprite.class) : ICON_KEY_IN_OUT_OUT.get(TextureAtlasSprite.class);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    @Nonnull
    public TextureAtlasSprite getTextureForOutputMode() {
        return ICON_KEY_OUTPUT.get(TextureAtlasSprite.class);
    }

    @SideOnly(value=Side.CLIENT)
    public TextureAtlasSprite getTextureForInOutMode() {
        return ICON_IN_OUT_KEY.get(TextureAtlasSprite.class);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    @Nonnull
    public TextureAtlasSprite getTextureForInOutBackground() {
        return ICON_KEY_IN_OUT_BG.get(TextureAtlasSprite.class);
    }

    @Override
    protected void readTypeSettings(@Nonnull EnumFacing dir, @Nonnull NBTTagCompound dataRoot) {
        this.setInputSignalColor(dir, DyeColor.values()[dataRoot.func_74765_d("signalColor")]);
        this.setOutputSignalColor(dir, DyeColor.values()[dataRoot.func_74765_d("outputSignalColor")]);
        this.setOutputStrength(dir, dataRoot.func_74767_n("signalStrong"));
    }

    @Override
    protected void writeTypeSettingsToNbt(@Nonnull EnumFacing dir, @Nonnull NBTTagCompound dataRoot) {
        dataRoot.func_74777_a("signalColor", (short)this.getInputSignalColor(dir).ordinal());
        dataRoot.func_74777_a("outputSignalColor", (short)this.getOutputSignalColor(dir).ordinal());
        dataRoot.func_74757_a("signalStrong", this.isOutputStrong(dir));
    }

    @Override
    public void writeToNBT(@Nonnull NBTTagCompound nbtRoot) {
        DyeColor col;
        int i;
        byte[] modes;
        super.writeToNBT(nbtRoot);
        if (this.forcedConnections.size() >= 0) {
            modes = new byte[6];
            i = 0;
            for (EnumFacing dir : EnumFacing.field_82609_l) {
                ConnectionMode mode = this.forcedConnections.get(dir);
                modes[i] = mode != null ? (int)mode.ordinal() : -1;
                ++i;
            }
            nbtRoot.func_74773_a("forcedConnections", modes);
        }
        if (this.inputSignalColors.size() >= 0) {
            modes = new byte[6];
            i = 0;
            for (EnumFacing dir : EnumFacing.field_82609_l) {
                col = this.inputSignalColors.get(dir);
                modes[i] = col != null ? (int)col.ordinal() : -1;
                ++i;
            }
            nbtRoot.func_74773_a("signalColors", modes);
        }
        if (this.outputSignalColors.size() >= 0) {
            modes = new byte[6];
            i = 0;
            for (EnumFacing dir : EnumFacing.field_82609_l) {
                col = this.outputSignalColors.get(dir);
                modes[i] = col != null ? (int)col.ordinal() : -1;
                ++i;
            }
            nbtRoot.func_74773_a("outputSignalColors", modes);
        }
        if (this.signalStrengths.size() >= 0) {
            modes = new byte[6];
            i = 0;
            for (EnumFacing dir : EnumFacing.field_82609_l) {
                boolean isStrong = this.isOutputStrong(dir);
                modes[i] = isStrong ? (byte)1 : 0;
                ++i;
            }
            nbtRoot.func_74773_a("signalStrengths", modes);
        }
    }

    @Override
    public void readFromNBT(@Nonnull NBTTagCompound nbtRoot) {
        super.readFromNBT(nbtRoot);
        this.forcedConnections.clear();
        byte[] modes = nbtRoot.func_74770_j("forcedConnections");
        if (modes != null && modes.length == 6) {
            int i = 0;
            for (EnumFacing dir : EnumFacing.field_82609_l) {
                if (modes[i] >= 0) {
                    this.forcedConnections.put(dir, ConnectionMode.values()[modes[i]]);
                }
                ++i;
            }
        }
        this.inputSignalColors.clear();
        byte[] cols = nbtRoot.func_74770_j("signalColors");
        if (cols != null && cols.length == 6) {
            int i = 0;
            for (EnumFacing dir : EnumFacing.field_82609_l) {
                if (cols[i] >= 0) {
                    this.inputSignalColors.put(dir, DyeColor.values()[cols[i]]);
                }
                ++i;
            }
        }
        this.outputSignalColors.clear();
        byte[] outCols = nbtRoot.func_74770_j("outputSignalColors");
        if (outCols != null && outCols.length == 6) {
            int i = 0;
            for (EnumFacing dir : EnumFacing.field_82609_l) {
                if (outCols[i] >= 0) {
                    this.outputSignalColors.put(dir, DyeColor.values()[outCols[i]]);
                }
                ++i;
            }
        }
        this.signalStrengths.clear();
        byte[] strengths = nbtRoot.func_74770_j("signalStrengths");
        if (strengths != null && strengths.length == 6) {
            int i = 0;
            for (EnumFacing dir : EnumFacing.field_82609_l) {
                if (strengths[i] > 0) {
                    this.signalStrengths.put(dir, true);
                }
                ++i;
            }
        }
    }

    @Override
    public String toString() {
        return "RedstoneConduit [network=" + this.network + " connections=" + this.conduitConnections + " active=" + this.active + "]";
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void hashCodeForModelCaching(BlockStateWrapperConduitBundle.ConduitCacheKey hashCodes) {
        super.hashCodeForModelCaching(hashCodes);
        hashCodes.addEnum(this.inputSignalColors);
        hashCodes.addEnum(this.outputSignalColors);
        if (ConduitConfig.showState.get().booleanValue() && this.isActive()) {
            hashCodes.add(1);
        }
    }

    @Nonnull
    public RedstoneConduitNetwork createNetworkForType() {
        return new RedstoneConduitNetwork();
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    @Nonnull
    public ITabPanel createGuiPanel(@Nonnull IGuiExternalConnection gui, @Nonnull IClientConduit con) {
        return new RedstoneSettings(gui, con);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public boolean updateGuiPanel(@Nonnull ITabPanel panel) {
        if (panel instanceof RedstoneSettings) {
            return ((RedstoneSettings)panel).updateConduit(this);
        }
        return false;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public int getGuiPanelTabOrder() {
        return 2;
    }

    public boolean hasCapability(@Nonnull Capability<?> capability, @Nullable EnumFacing facing) {
        return false;
    }

    @Nullable
    public <T> T getCapability(@Nonnull Capability<T> capability, @Nullable EnumFacing facing) {
        return null;
    }

    @Override
    @Nonnull
    public String getConduitProbeInfo(@Nonnull EntityPlayer player) {
        return "";
    }

    static {
        ICONS.put("blocks/redstone_insulated_conduit_core_off", TextureRegistry.registerTexture("blocks/redstone_insulated_conduit_core_off"));
        ICONS.put("blocks/redstone_insulated_conduit_core_on", TextureRegistry.registerTexture("blocks/redstone_insulated_conduit_core_on"));
        ICONS.put("blocks/redstone_insulated_conduit", TextureRegistry.registerTexture("blocks/redstone_insulated_conduit"));
        ICONS.put("blocks/redstone_conduit", TextureRegistry.registerTexture("blocks/redstone_conduit"));
        ICONS.put("blocks/redstone_conduit_transmission", TextureRegistry.registerTexture("blocks/redstone_conduit_transmission"));
        ICON_IN_OUT_KEY = TextureRegistry.registerTexture("blocks/item_conduit_in_out");
        ICON_KEY_IN_OUT_BG = TextureRegistry.registerTexture("blocks/item_conduit_io_connector");
        ICON_KEY_INPUT = TextureRegistry.registerTexture("blocks/item_conduit_input");
        ICON_KEY_OUTPUT = TextureRegistry.registerTexture("blocks/item_conduit_output");
        ICON_KEY_IN_OUT_OUT = TextureRegistry.registerTexture("blocks/item_conduit_in_out_out");
        ICON_KEY_IN_OUT_IN = TextureRegistry.registerTexture("blocks/item_conduit_in_out_in");
    }
}

