/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.conduits.conduit.power;

import crazypants.enderio.base.Log;
import crazypants.enderio.base.conduit.ConnectionMode;
import crazypants.enderio.base.diagnostics.Prof;
import crazypants.enderio.base.power.IPowerInterface;
import crazypants.enderio.base.power.IPowerStorage;
import crazypants.enderio.conduits.conduit.power.IPowerConduit;
import crazypants.enderio.conduits.conduit.power.PowerConduitNetwork;
import crazypants.enderio.conduits.conduit.power.PowerTracker;
import crazypants.enderio.conduits.config.ConduitConfig;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.profiler.Profiler;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;

public class NetworkPowerManager {
    private final PowerConduitNetwork network;
    int maxEnergyStored;
    int energyStored;
    private final List<PowerConduitNetwork.ReceptorEntry> receptors = new ArrayList<PowerConduitNetwork.ReceptorEntry>();
    private ListIterator<PowerConduitNetwork.ReceptorEntry> receptorIterator = this.receptors.listIterator();
    private final List<PowerConduitNetwork.ReceptorEntry> storageReceptors = new ArrayList<PowerConduitNetwork.ReceptorEntry>();
    private boolean receptorsDirty = true;
    private final Map<IPowerConduit, PowerTracker> powerTrackers = new HashMap<IPowerConduit, PowerTracker>();
    private final PowerTracker networkPowerTracker = new PowerTracker();
    private final CapBankSupply capSupply = new CapBankSupply();
    private int errorSupressionA = 0;
    private int errorSupressionB = 0;

    public NetworkPowerManager(@Nonnull PowerConduitNetwork network, @Nonnull World world) {
        this.network = network;
        this.maxEnergyStored = 64;
    }

    public PowerTracker getTracker(IPowerConduit conduit) {
        return this.powerTrackers.get(conduit);
    }

    public PowerTracker getNetworkPowerTracker() {
        return this.networkPowerTracker;
    }

    public int getPowerInConduits() {
        return this.energyStored;
    }

    public int getMaxPowerInConduits() {
        return this.maxEnergyStored;
    }

    public long getPowerInCapacitorBanks() {
        if (this.capSupply == null) {
            return 0L;
        }
        return this.capSupply.stored;
    }

    public long getMaxPowerInCapacitorBanks() {
        if (this.capSupply == null) {
            return 0L;
        }
        return this.capSupply.maxCap;
    }

    public long getPowerInReceptors() {
        long result = 0L;
        HashSet<Object> done = new HashSet<Object>();
        for (PowerConduitNetwork.ReceptorEntry re : this.receptors) {
            IPowerInterface powerReceptor;
            if (re.emmiter.getConnectionsDirty() || done.contains((powerReceptor = re.powerInterface).getProvider())) continue;
            done.add(powerReceptor.getProvider());
            result += (long)powerReceptor.getEnergyStored();
        }
        return result;
    }

    public long getMaxPowerInReceptors() {
        long result = 0L;
        HashSet<Object> done = new HashSet<Object>();
        for (PowerConduitNetwork.ReceptorEntry re : this.receptors) {
            IPowerInterface powerReceptor;
            if (re.emmiter.getConnectionsDirty() || done.contains((powerReceptor = re.powerInterface).getProvider())) continue;
            done.add(powerReceptor.getProvider());
            result += (long)powerReceptor.getMaxEnergyStored();
        }
        return result;
    }

    public void applyRecievedPower(@Nullable Profiler theProfiler) {
        block3: {
            try {
                this.doApplyRecievedPower(theProfiler);
            }
            catch (Exception e) {
                if (this.errorSupressionA-- <= 0) {
                    Log.warn("NetworkPowerManager: Exception thrown when updating power network " + e);
                    e.printStackTrace();
                    this.errorSupressionA = 200;
                    this.errorSupressionB = 20;
                }
                if (this.errorSupressionB-- > 0) break block3;
                Log.warn("NetworkPowerManager: Exception thrown when updating power network " + e);
                this.errorSupressionB = 20;
            }
        }
    }

    public void doApplyRecievedPower(@Nullable Profiler profiler) {
        int available;
        this.trackerStartTick();
        Prof.start(profiler, "checkReceptors");
        this.checkReceptors();
        Prof.next(profiler, "updateNetworkStorage");
        this.updateNetworkStorage();
        this.networkPowerTracker.tickStart(this.energyStored);
        Prof.next(profiler, "capSupplyInit");
        this.capSupply.init();
        int numReceptors = this.receptors.size();
        int wasAvailable = available = this.energyStored + this.capSupply.canExtract;
        if (available <= 0 || this.receptors.isEmpty() && this.storageReceptors.isEmpty()) {
            this.trackerEndTick();
            this.networkPowerTracker.tickEnd(this.energyStored);
            Prof.stop(profiler);
            return;
        }
        Prof.next(profiler, "sendEnergy");
        for (int appliedCount = 0; available > 0 && appliedCount < numReceptors; ++appliedCount) {
            if (!this.receptors.isEmpty() && !this.receptorIterator.hasNext()) {
                this.receptorIterator = this.receptors.listIterator();
            }
            PowerConduitNetwork.ReceptorEntry r = this.receptorIterator.next();
            IPowerInterface pp = r.powerInterface;
            if (pp == null) continue;
            int canOffer = Math.min(r.emmiter.getMaxEnergyExtracted(r.direction), available);
            Prof.start(profiler, "", pp.getProvider());
            int used = pp.receiveEnergy(canOffer, false);
            Prof.next(profiler, "trackEnergy");
            used = Math.max(0, used);
            this.trackerSend(r.emmiter, used, false);
            Prof.stop(profiler);
            if ((available -= used) <= 0) break;
        }
        int used = wasAvailable - available;
        this.energyStored -= used;
        Prof.next(profiler, "capBankUpdate");
        if (!this.capSupply.capBanks.isEmpty()) {
            int capBankChange = 0;
            if (this.energyStored < 0) {
                capBankChange = this.energyStored;
                this.energyStored = 0;
            } else if (this.energyStored > 0) {
                capBankChange = Math.min(this.energyStored, this.capSupply.canFill);
                this.energyStored -= capBankChange;
            }
            if (capBankChange < 0) {
                this.capSupply.remove(Math.abs(capBankChange));
            } else if (capBankChange > 0) {
                this.capSupply.add(capBankChange);
            }
            this.capSupply.balance();
        }
        Prof.next(profiler, "conduitUpdate");
        this.distributeStorageToConduits();
        Prof.next(profiler, "trackEnergy");
        this.trackerEndTick();
        this.networkPowerTracker.tickEnd(this.energyStored);
        Prof.stop(profiler);
    }

    private void trackerStartTick() {
        if (!ConduitConfig.detailedTracking.get().booleanValue()) {
            return;
        }
        for (IPowerConduit con : this.network.getConduits()) {
            if (!con.hasExternalConnections()) continue;
            PowerTracker tracker = this.getOrCreateTracker(con);
            tracker.tickStart(con.getEnergyStored());
        }
    }

    private void trackerSend(@Nonnull IPowerConduit con, int sent, boolean fromBank) {
        if (!fromBank) {
            this.networkPowerTracker.powerSent(sent);
        }
        if (!ConduitConfig.detailedTracking.get().booleanValue()) {
            return;
        }
        this.getOrCreateTracker(con).powerSent(sent);
    }

    private void trackerRecieve(@Nonnull IPowerConduit con, int recieved, boolean fromBank) {
        if (!fromBank) {
            this.networkPowerTracker.powerRecieved(recieved);
        }
        if (!ConduitConfig.detailedTracking.get().booleanValue()) {
            return;
        }
        this.getOrCreateTracker(con).powerRecieved(recieved);
    }

    private void trackerEndTick() {
        if (!ConduitConfig.detailedTracking.get().booleanValue()) {
            return;
        }
        for (IPowerConduit con : this.network.getConduits()) {
            if (!con.hasExternalConnections()) continue;
            PowerTracker tracker = this.getOrCreateTracker(con);
            tracker.tickEnd(con.getEnergyStored());
        }
    }

    private PowerTracker getOrCreateTracker(@Nonnull IPowerConduit con) {
        PowerTracker result = this.powerTrackers.get(con);
        if (result == null) {
            result = new PowerTracker();
            this.powerTrackers.put(con, result);
        }
        return result;
    }

    private void distributeStorageToConduits() {
        if (this.maxEnergyStored <= 0 || this.energyStored <= 0) {
            for (IPowerConduit con : this.network.getConduits()) {
                con.setEnergyStored(0);
            }
            return;
        }
        this.energyStored = MathHelper.func_76125_a((int)this.energyStored, (int)0, (int)this.maxEnergyStored);
        float filledRatio = (float)this.energyStored / (float)this.maxEnergyStored;
        int energyLeft = this.energyStored;
        for (IPowerConduit con : this.network.getConduits()) {
            if (energyLeft > 0) {
                int give = (int)Math.ceil((float)con.getMaxEnergyStored() * filledRatio);
                give = Math.min(give, con.getMaxEnergyStored());
                give = Math.min(give, energyLeft);
                con.setEnergyStored(give);
                energyLeft -= give;
                continue;
            }
            con.setEnergyStored(0);
        }
    }

    boolean isActive() {
        return this.energyStored > 0;
    }

    private void updateNetworkStorage() {
        this.maxEnergyStored = 0;
        this.energyStored = 0;
        for (IPowerConduit con : this.network.getConduits()) {
            this.maxEnergyStored += con.getMaxEnergyStored();
            con.onTick();
            this.energyStored += con.getEnergyStored();
        }
        this.energyStored = MathHelper.func_76125_a((int)this.energyStored, (int)0, (int)this.maxEnergyStored);
    }

    public void receptorsChanged() {
        this.receptorsDirty = true;
    }

    private void checkReceptors() {
        if (!this.receptorsDirty) {
            return;
        }
        this.receptors.clear();
        this.storageReceptors.clear();
        for (PowerConduitNetwork.ReceptorEntry rec : this.network.getPowerReceptors()) {
            if (rec.powerInterface.getProvider() != null && rec.powerInterface.getProvider() instanceof IPowerStorage) {
                this.storageReceptors.add(rec);
                continue;
            }
            this.receptors.add(rec);
        }
        this.receptorIterator = this.receptors.listIterator();
        this.receptorsDirty = false;
    }

    void onNetworkDestroyed() {
    }

    private int minAbs(int amount, int limit) {
        if (amount < 0) {
            return Math.max(amount, -limit);
        }
        return Math.min(amount, limit);
    }

    private static class CapBankSupplyEntry {
        final IPowerStorage capBank;
        final int canExtract;
        final int canFill;
        int toBalance;
        IPowerConduit emmiter;
        EnumFacing direction;

        private CapBankSupplyEntry(IPowerStorage capBank, int available, int canFill, IPowerConduit emmiter, EnumFacing direction) {
            this.capBank = capBank;
            this.canExtract = available;
            this.canFill = canFill;
            this.emmiter = emmiter;
            this.direction = direction;
        }

        void calcToBalance(double targetRatio) {
            if (this.capBank.isCreative()) {
                this.toBalance = 0;
                return;
            }
            long targetAmount = (long)Math.floor((double)this.capBank.getMaxEnergyStoredL() * targetRatio);
            long b = targetAmount - this.capBank.getEnergyStoredL();
            this.toBalance = b < 0L ? -this.canExtract : this.canFill;
        }
    }

    private class CapBankSupply {
        int canExtract;
        int canFill;
        Set<IPowerStorage> capBanks = new HashSet<IPowerStorage>();
        double filledRatio;
        long stored = 0L;
        long maxCap = 0L;
        List<CapBankSupplyEntry> enteries = new ArrayList<CapBankSupplyEntry>();

        CapBankSupply() {
        }

        void init() {
            this.capBanks.clear();
            this.enteries.clear();
            this.canExtract = 0;
            this.canFill = 0;
            this.stored = 0L;
            this.maxCap = 0L;
            double toBalance = 0.0;
            double maxToBalance = 0.0;
            for (PowerConduitNetwork.ReceptorEntry rec : NetworkPowerManager.this.storageReceptors) {
                IPowerStorage cb = (IPowerStorage)rec.powerInterface.getProvider();
                boolean processed = this.capBanks.contains(cb.getController());
                if (!processed) {
                    this.stored += cb.getEnergyStoredL();
                    this.maxCap += cb.getMaxEnergyStoredL();
                    this.capBanks.add(cb.getController());
                }
                if (rec.emmiter.getConnectionMode(rec.direction) == ConnectionMode.IN_OUT) {
                    toBalance += (double)cb.getEnergyStoredL();
                    maxToBalance += (double)cb.getMaxEnergyStoredL();
                }
                long canGet = 0L;
                long canFill = 0L;
                if (!cb.isNetworkControlledIo(rec.direction.func_176734_d())) continue;
                if (cb.isOutputEnabled(rec.direction.func_176734_d())) {
                    canGet = Math.min(cb.getEnergyStoredL(), (long)cb.getMaxOutput());
                    canGet = Math.min(canGet, (long)rec.emmiter.getMaxEnergyRecieved(rec.direction));
                    this.canExtract = (int)((long)this.canExtract + canGet);
                }
                if (cb.isInputEnabled(rec.direction.func_176734_d())) {
                    canFill = Math.min(cb.getMaxEnergyStoredL() - cb.getEnergyStoredL(), (long)cb.getMaxInput());
                    canFill = Math.min(canFill, (long)rec.emmiter.getMaxEnergyExtracted(rec.direction));
                    this.canFill = (int)((long)this.canFill + canFill);
                }
                this.enteries.add(new CapBankSupplyEntry(cb, (int)canGet, (int)canFill, rec.emmiter, rec.direction));
            }
            this.filledRatio = 0.0;
            if (maxToBalance > 0.0) {
                this.filledRatio = toBalance / maxToBalance;
            }
        }

        void balance() {
            if (this.enteries.size() < 2) {
                return;
            }
            this.init();
            int canRemove = 0;
            int canAdd = 0;
            for (CapBankSupplyEntry entry : this.enteries) {
                if (entry.emmiter.getConnectionMode(entry.direction) != ConnectionMode.IN_OUT) continue;
                entry.calcToBalance(this.filledRatio);
                if (entry.toBalance < 0) {
                    canRemove += -entry.toBalance;
                    continue;
                }
                canAdd += entry.toBalance;
            }
            int toalTransferAmount = Math.min(canAdd, canRemove);
            for (int i = 0; i < this.enteries.size() && toalTransferAmount > 0; ++i) {
                CapBankSupplyEntry from = this.enteries.get(i);
                if (from.emmiter.getConnectionMode(from.direction) != ConnectionMode.IN_OUT) continue;
                int amount = from.toBalance;
                amount = NetworkPowerManager.this.minAbs(amount, toalTransferAmount);
                from.capBank.addEnergy(amount);
                toalTransferAmount -= Math.abs(amount);
                int toTranfser = Math.abs(amount);
                for (int j = i + 1; j < this.enteries.size() && toTranfser > 0; ++j) {
                    CapBankSupplyEntry to = this.enteries.get(j);
                    if (Math.signum(amount) == Math.signum(to.toBalance)) continue;
                    int toAmount = Math.min(toTranfser, Math.abs(to.toBalance));
                    to.capBank.addEnergy(toAmount * (int)Math.signum(to.toBalance));
                    toTranfser -= toAmount;
                }
            }
        }

        void remove(int amount) {
            if (this.canExtract <= 0 || amount <= 0) {
                return;
            }
            double ratio = (double)amount / (double)this.canExtract;
            for (CapBankSupplyEntry entry : this.enteries) {
                long use = (int)Math.ceil(ratio * (double)entry.canExtract);
                use = Math.min(use, (long)amount);
                use = Math.min(use, (long)entry.canExtract);
                entry.capBank.addEnergy((int)(-use));
                NetworkPowerManager.this.trackerRecieve(entry.emmiter, (int)use, true);
                if ((amount = (int)((long)amount - use)) != 0) continue;
                return;
            }
        }

        void add(int amount) {
            if (this.canFill <= 0 || amount <= 0) {
                return;
            }
            double ratio = (double)amount / (double)this.canFill;
            for (CapBankSupplyEntry entry : this.enteries) {
                long add = (int)Math.ceil(ratio * (double)entry.canFill);
                add = Math.min(add, (long)entry.canFill);
                add = Math.min(add, (long)amount);
                entry.capBank.addEnergy((int)add);
                NetworkPowerManager.this.trackerSend(entry.emmiter, (int)add, true);
                if ((amount = (int)((long)amount - add)) != 0) continue;
                return;
            }
        }
    }
}

