/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.conduits.conduit.liquid;

import com.enderio.core.common.util.DyeColor;
import com.enderio.core.common.util.NNList;
import com.enderio.core.common.vecmath.Vector4f;
import crazypants.enderio.base.conduit.ConduitUtil;
import crazypants.enderio.base.conduit.ConnectionMode;
import crazypants.enderio.base.conduit.IConduit;
import crazypants.enderio.base.conduit.IConduitNetwork;
import crazypants.enderio.base.conduit.RaytraceResult;
import crazypants.enderio.base.conduit.geom.CollidableComponent;
import crazypants.enderio.base.filter.FilterRegistry;
import crazypants.enderio.base.filter.capability.CapabilityFilterHolder;
import crazypants.enderio.base.filter.capability.IFilterHolder;
import crazypants.enderio.base.filter.fluid.FluidFilter;
import crazypants.enderio.base.filter.fluid.IFluidFilter;
import crazypants.enderio.base.machine.modes.RedstoneControlMode;
import crazypants.enderio.base.render.registry.TextureRegistry;
import crazypants.enderio.base.tool.ToolUtil;
import crazypants.enderio.conduits.capability.CapabilityUpgradeHolder;
import crazypants.enderio.conduits.capability.IUpgradeHolder;
import crazypants.enderio.conduits.conduit.IConduitComponent;
import crazypants.enderio.conduits.conduit.liquid.AbstractLiquidConduit;
import crazypants.enderio.conduits.conduit.liquid.EnderLiquidConduitNetwork;
import crazypants.enderio.conduits.conduit.liquid.ILiquidConduit;
import crazypants.enderio.conduits.init.ConduitObject;
import crazypants.enderio.conduits.render.BlockStateWrapperConduitBundle;
import crazypants.enderio.util.Prep;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.FluidTankProperties;
import net.minecraftforge.fluids.capability.IFluidTankProperties;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class EnderLiquidConduit
extends AbstractLiquidConduit
implements IConduitComponent,
IFilterHolder<IFluidFilter>,
IUpgradeHolder {
    public static final TextureRegistry.TextureSupplier ICON_KEY = TextureRegistry.registerTexture("blocks/liquid_conduit_ender");
    public static final TextureRegistry.TextureSupplier ICON_CORE_KEY = TextureRegistry.registerTexture("blocks/liquid_conduit_core_ender");
    public static final TextureRegistry.TextureSupplier ICON_IN_OUT_KEY = TextureRegistry.registerTexture("blocks/liquid_conduit_advanced_in_out");
    public static final TextureRegistry.TextureSupplier ICON_KEY_IN_OUT_BG = TextureRegistry.registerTexture("blocks/item_conduit_io_connector");
    public static final TextureRegistry.TextureSupplier ICON_KEY_INPUT = TextureRegistry.registerTexture("blocks/item_conduit_input");
    public static final TextureRegistry.TextureSupplier ICON_KEY_OUTPUT = TextureRegistry.registerTexture("blocks/item_conduit_output");
    public static final TextureRegistry.TextureSupplier ICON_KEY_IN_OUT_OUT = TextureRegistry.registerTexture("blocks/item_conduit_in_out_out");
    public static final TextureRegistry.TextureSupplier ICON_KEY_IN_OUT_IN = TextureRegistry.registerTexture("blocks/item_conduit_in_out_in");
    private EnderLiquidConduitNetwork network;
    private int ticksSinceFailedExtract;
    private final EnumMap<EnumFacing, IFluidFilter> outputFilters = new EnumMap(EnumFacing.class);
    private final EnumMap<EnumFacing, IFluidFilter> inputFilters = new EnumMap(EnumFacing.class);
    private final EnumMap<EnumFacing, ItemStack> outputFilterUpgrades = new EnumMap(EnumFacing.class);
    private final EnumMap<EnumFacing, ItemStack> inputFilterUpgrades = new EnumMap(EnumFacing.class);
    private final EnumMap<EnumFacing, DyeColor> inputColors = new EnumMap(EnumFacing.class);
    private final EnumMap<EnumFacing, DyeColor> outputColors = new EnumMap(EnumFacing.class);
    protected final EnumMap<EnumFacing, Integer> priorities = new EnumMap(EnumFacing.class);
    protected final EnumMap<EnumFacing, Boolean> roundRobin = new EnumMap(EnumFacing.class);
    protected final EnumMap<EnumFacing, Boolean> selfFeed = new EnumMap(EnumFacing.class);
    protected final EnumMap<EnumFacing, ItemStack> functionUpgrades = new EnumMap(EnumFacing.class);

    public EnderLiquidConduit() {
        NNList.NNIterator itr = NNList.FACING.fastIterator();
        while (itr.hasNext()) {
            EnumFacing dir = (EnumFacing)itr.next();
            this.outputFilterUpgrades.put(dir, ItemStack.field_190927_a);
            this.inputFilterUpgrades.put(dir, ItemStack.field_190927_a);
            this.functionUpgrades.put(dir, ItemStack.field_190927_a);
            this.roundRobin.put(dir, true);
        }
    }

    @Override
    @Nonnull
    public ItemStack createItem() {
        return new ItemStack(ConduitObject.item_liquid_conduit.getItemNN(), 1, 2);
    }

    @Override
    @Nonnull
    public NNList<ItemStack> getDrops() {
        NNList<ItemStack> res = super.getDrops();
        for (ItemStack stack : this.functionUpgrades.values()) {
            res.add((Object)stack);
        }
        for (ItemStack stack : this.inputFilterUpgrades.values()) {
            res.add((Object)stack);
        }
        for (ItemStack stack : this.outputFilterUpgrades.values()) {
            res.add((Object)stack);
        }
        return res;
    }

    @Override
    public boolean onBlockActivated(@Nonnull EntityPlayer player, @Nonnull EnumHand hand, @Nonnull RaytraceResult res, @Nonnull List<RaytraceResult> all) {
        if (Prep.isInvalid(player.func_184586_b(hand))) {
            return false;
        }
        if (ToolUtil.isToolEquipped(player, hand)) {
            CollidableComponent component;
            if (!this.getBundle().getEntity().func_145831_w().field_72995_K && (component = res.component) != null) {
                EnumFacing connDir = component.dir;
                EnumFacing faceHit = res.movingObjectPosition.field_178784_b;
                if (connDir == null || connDir == faceHit) {
                    if (this.getConnectionMode(faceHit) == ConnectionMode.DISABLED) {
                        this.setConnectionMode(faceHit, this.getNextConnectionMode(faceHit));
                        return true;
                    }
                    BlockPos pos = this.getBundle().getLocation().func_177972_a(faceHit);
                    ILiquidConduit n = ConduitUtil.getConduit(this.getBundle().getEntity().func_145831_w(), pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p(), ILiquidConduit.class);
                    if (n == null) {
                        return false;
                    }
                    if (!(n instanceof EnderLiquidConduit)) {
                        return false;
                    }
                    return ConduitUtil.connectConduits(this, faceHit);
                }
                if (this.containsExternalConnection(connDir)) {
                    this.setConnectionMode(connDir, this.getNextConnectionMode(connDir));
                } else if (this.containsConduitConnection(connDir)) {
                    ConduitUtil.disconnectConduits(this, connDir);
                }
            }
            return true;
        }
        return false;
    }

    @Override
    @Nullable
    public IConduitNetwork<?, ?> getNetwork() {
        return this.network;
    }

    public IFluidFilter getFilter(@Nonnull EnumFacing dir, boolean isInput) {
        if (isInput) {
            return this.inputFilters.get(dir);
        }
        return this.outputFilters.get(dir);
    }

    public void setFilter(@Nonnull EnumFacing dir, @Nonnull IFluidFilter filter, boolean isInput) {
        if (isInput) {
            this.inputFilters.put(dir, filter);
        } else {
            this.outputFilters.put(dir, filter);
        }
        this.setClientStateDirty();
    }

    @Nonnull
    public ItemStack getFilterStack(@Nonnull EnumFacing dir, boolean isInput) {
        if (isInput) {
            return this.inputFilterUpgrades.get(dir);
        }
        return this.outputFilterUpgrades.get(dir);
    }

    public void setFilterStack(@Nonnull EnumFacing dir, @Nonnull ItemStack stack, boolean isInput) {
        if (isInput) {
            this.inputFilterUpgrades.put(dir, stack);
        } else {
            this.outputFilterUpgrades.put(dir, stack);
        }
        this.setFilter(dir, (IFluidFilter)FilterRegistry.getFilterForUpgrade(stack), isInput);
        this.setClientStateDirty();
    }

    @Override
    public boolean setNetwork(@Nonnull IConduitNetwork<?, ?> network) {
        if (!(network instanceof EnderLiquidConduitNetwork)) {
            return false;
        }
        this.network = (EnderLiquidConduitNetwork)network;
        for (EnumFacing dir : this.externalConnections) {
            this.network.connectionChanged(this, dir);
        }
        return true;
    }

    @Override
    public void clearNetwork() {
        this.network = null;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    @Nonnull
    public TextureAtlasSprite getTextureForState(@Nonnull CollidableComponent component) {
        if (component.dir == null) {
            return ICON_CORE_KEY.get(TextureAtlasSprite.class);
        }
        return ICON_KEY.get(TextureAtlasSprite.class);
    }

    @SideOnly(value=Side.CLIENT)
    public TextureAtlasSprite getTextureForInputMode() {
        return ICON_KEY_INPUT.get(TextureAtlasSprite.class);
    }

    @SideOnly(value=Side.CLIENT)
    public TextureAtlasSprite getTextureForInOutMode(boolean input) {
        return input ? ICON_KEY_IN_OUT_IN.get(TextureAtlasSprite.class) : ICON_KEY_IN_OUT_OUT.get(TextureAtlasSprite.class);
    }

    @SideOnly(value=Side.CLIENT)
    public TextureAtlasSprite getTextureForOutputMode() {
        return ICON_KEY_OUTPUT.get(TextureAtlasSprite.class);
    }

    @SideOnly(value=Side.CLIENT)
    public TextureAtlasSprite getTextureForInOutMode() {
        return ICON_IN_OUT_KEY.get(TextureAtlasSprite.class);
    }

    @SideOnly(value=Side.CLIENT)
    public TextureAtlasSprite getTextureForInOutBackground() {
        return ICON_KEY_IN_OUT_BG.get(TextureAtlasSprite.class);
    }

    @Override
    @Nonnull
    public TextureAtlasSprite getTransmitionTextureForState(@Nonnull CollidableComponent component) {
        return null;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    @Nonnull
    public Vector4f getTransmitionTextureColorForState(@Nonnull CollidableComponent component) {
        return null;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void hashCodeForModelCaching(BlockStateWrapperConduitBundle.ConduitCacheKey hashCodes) {
        super.hashCodeForModelCaching(hashCodes);
        hashCodes.addEnum(this.outputColors);
        hashCodes.addEnum(this.inputColors);
    }

    @Override
    public boolean canConnectToConduit(@Nonnull EnumFacing direction, @Nonnull IConduit con) {
        if (!super.canConnectToConduit(direction, con)) {
            return false;
        }
        return con instanceof EnderLiquidConduit;
    }

    @Override
    public void setConnectionMode(@Nonnull EnumFacing dir, @Nonnull ConnectionMode mode) {
        super.setConnectionMode(dir, mode);
        this.refreshConnections(dir);
    }

    @Override
    public void setExtractionRedstoneMode(@Nonnull RedstoneControlMode mode, @Nonnull EnumFacing dir) {
        super.setExtractionRedstoneMode(mode, dir);
        this.refreshConnections(dir);
    }

    private void refreshConnections(@Nonnull EnumFacing dir) {
        if (this.network == null) {
            return;
        }
        this.network.connectionChanged(this, dir);
    }

    @Override
    public void externalConnectionAdded(@Nonnull EnumFacing fromDirection) {
        super.externalConnectionAdded(fromDirection);
        this.refreshConnections(fromDirection);
    }

    @Override
    public void externalConnectionRemoved(@Nonnull EnumFacing fromDirection) {
        super.externalConnectionRemoved(fromDirection);
        this.refreshConnections(fromDirection);
    }

    @Override
    public void updateEntity(@Nonnull World world) {
        super.updateEntity(world);
        if (world.field_72995_K) {
            return;
        }
        this.doExtract();
    }

    private void doExtract() {
        if (!this.hasExtractableMode()) {
            return;
        }
        if (this.network == null) {
            return;
        }
        ++this.ticksSinceFailedExtract;
        if (this.ticksSinceFailedExtract > 25 && this.ticksSinceFailedExtract % 10 != 0) {
            return;
        }
        for (EnumFacing dir : this.externalConnections) {
            if (!this.autoExtractForDir(dir) || !this.network.extractFrom(this, dir)) continue;
            this.ticksSinceFailedExtract = 0;
        }
    }

    public int fill(FluidStack resource, boolean doFill) {
        return 0;
    }

    public IFluidTankProperties[] getTankProperties() {
        return new IFluidTankProperties[0];
    }

    @Nullable
    public FluidStack drain(FluidStack resource, boolean doDrain) {
        return null;
    }

    @Nullable
    public FluidStack drain(int maxDrain, boolean doDrain) {
        return null;
    }

    @Override
    public boolean canFill(EnumFacing from, FluidStack fluid) {
        if (this.network == null) {
            return false;
        }
        return this.getConnectionMode(from).acceptsInput();
    }

    @Override
    public boolean canDrain(EnumFacing from, FluidStack fluid) {
        return false;
    }

    @Override
    protected void readTypeSettings(@Nonnull EnumFacing dir, @Nonnull NBTTagCompound dataRoot) {
        super.readTypeSettings(dir, dataRoot);
        if (dataRoot.func_74764_b("outputFilters")) {
            FluidFilter out = new FluidFilter();
            out.readFromNBT(dataRoot.func_74775_l("outputFilters"));
            this.outputFilters.put(dir, out);
        }
        if (dataRoot.func_74764_b("inputFilters")) {
            FluidFilter in = new FluidFilter();
            in.readFromNBT(dataRoot.func_74775_l("inputFilters"));
            this.inputFilters.put(dir, in);
        }
    }

    @Override
    protected void writeTypeSettingsToNbt(@Nonnull EnumFacing dir, @Nonnull NBTTagCompound dataRoot) {
        IFluidFilter in;
        super.writeTypeSettingsToNbt(dir, dataRoot);
        IFluidFilter out = this.outputFilters.get(dir);
        if (out != null) {
            NBTTagCompound outTag = new NBTTagCompound();
            out.writeToNBT(outTag);
            dataRoot.func_74782_a("outputFilters", (NBTBase)outTag);
        }
        if ((in = this.inputFilters.get(dir)) != null) {
            NBTTagCompound inTag = new NBTTagCompound();
            in.writeToNBT(inTag);
            dataRoot.func_74782_a("inputFilters", (NBTBase)inTag);
        }
    }

    private boolean isDefault(IFluidFilter f) {
        if (f instanceof FluidFilter) {
            return ((FluidFilter)f).isDefault();
        }
        return false;
    }

    @Override
    public void writeToNBT(@Nonnull NBTTagCompound nbtRoot) {
        NBTTagCompound itemRoot;
        IFluidFilter filter;
        ItemStack up;
        NBTTagCompound itemRoot2;
        IFluidFilter f;
        super.writeToNBT(nbtRoot);
        for (Map.Entry<EnumFacing, IFluidFilter> entry : this.inputFilters.entrySet()) {
            if (entry.getValue() == null || this.isDefault(f = entry.getValue())) continue;
            NBTTagCompound itemRoot22 = new NBTTagCompound();
            FilterRegistry.writeFilterToNbt(f, itemRoot22);
            nbtRoot.func_74782_a("inFluidFilts." + entry.getKey().name(), (NBTBase)itemRoot22);
        }
        for (Map.Entry<EnumFacing, IFluidFilter> entry : this.outputFilters.entrySet()) {
            if (entry.getValue() == null || this.isDefault(f = entry.getValue())) continue;
            itemRoot2 = new NBTTagCompound();
            FilterRegistry.writeFilterToNbt(f, itemRoot2);
            nbtRoot.func_74782_a("outFluidFilts." + entry.getKey().name(), (NBTBase)itemRoot2);
        }
        for (Map.Entry<EnumFacing, IFluidFilter> entry : this.inputFilterUpgrades.entrySet()) {
            if (entry.getValue() == null) continue;
            up = (ItemStack)entry.getValue();
            filter = this.getFilter(entry.getKey(), true);
            FilterRegistry.writeFilterToStack(filter, up);
            itemRoot = new NBTTagCompound();
            up.func_77955_b(itemRoot);
            nbtRoot.func_74782_a("inputFluidFilterUpgrades." + entry.getKey().name(), (NBTBase)itemRoot);
        }
        for (Map.Entry<EnumFacing, IFluidFilter> entry : this.outputFilterUpgrades.entrySet()) {
            if (entry.getValue() == null) continue;
            up = (ItemStack)entry.getValue();
            filter = this.getFilter(entry.getKey(), false);
            FilterRegistry.writeFilterToStack(filter, up);
            itemRoot = new NBTTagCompound();
            up.func_77955_b(itemRoot);
            nbtRoot.func_74782_a("outputFluidFilterUpgrades." + entry.getKey().name(), (NBTBase)itemRoot);
        }
        for (Map.Entry<EnumFacing, IFluidFilter> entry : this.inputColors.entrySet()) {
            if (entry.getValue() == null) continue;
            short ord = (short)((DyeColor)entry.getValue()).ordinal();
            nbtRoot.func_74777_a("inSC." + entry.getKey().name(), ord);
        }
        for (Map.Entry<EnumFacing, IFluidFilter> entry : this.outputColors.entrySet()) {
            if (entry.getValue() == null) continue;
            short ord = (short)((DyeColor)entry.getValue()).ordinal();
            nbtRoot.func_74777_a("outSC." + entry.getKey().name(), ord);
        }
        for (Map.Entry<EnumFacing, Object> entry : this.priorities.entrySet()) {
            if (entry.getValue() == null) continue;
            nbtRoot.func_74768_a("priority." + entry.getKey().name(), ((Integer)entry.getValue()).intValue());
        }
        for (Map.Entry<EnumFacing, Object> entry : this.roundRobin.entrySet()) {
            if (entry.getValue() == null) continue;
            nbtRoot.func_74757_a("roundRobin." + entry.getKey().name(), ((Boolean)entry.getValue()).booleanValue());
        }
        for (Map.Entry<EnumFacing, Object> entry : this.selfFeed.entrySet()) {
            if (entry.getValue() == null) continue;
            nbtRoot.func_74757_a("selfFeed." + entry.getKey().name(), ((Boolean)entry.getValue()).booleanValue());
        }
        for (Map.Entry<EnumFacing, Object> entry : this.functionUpgrades.entrySet()) {
            if (entry.getValue() == null) continue;
            ItemStack up2 = (ItemStack)entry.getValue();
            itemRoot2 = new NBTTagCompound();
            up2.func_77955_b(itemRoot2);
            nbtRoot.func_74782_a("functionUpgrades." + entry.getKey().name(), (NBTBase)itemRoot2);
        }
    }

    @Override
    public void readFromNBT(@Nonnull NBTTagCompound nbtRoot) {
        super.readFromNBT(nbtRoot);
        for (EnumFacing dir : EnumFacing.field_82609_l) {
            short ord;
            ItemStack ups;
            NBTTagCompound upTag;
            IFluidFilter filter;
            NBTTagCompound filterTag;
            String key = "inFluidFilts." + dir.name();
            if (nbtRoot.func_74764_b(key)) {
                filterTag = (NBTTagCompound)nbtRoot.func_74781_a(key);
                filter = (IFluidFilter)FilterRegistry.loadFilterFromNbt(filterTag);
                this.inputFilters.put(dir, filter);
            }
            if (nbtRoot.func_74764_b(key = "inputFluidFilterUpgrades." + dir.name())) {
                upTag = (NBTTagCompound)nbtRoot.func_74781_a(key);
                ups = new ItemStack(upTag);
                this.inputFilterUpgrades.put(dir, ups);
            }
            if (nbtRoot.func_74764_b(key = "outputFluidFilterUpgrades." + dir.name())) {
                upTag = (NBTTagCompound)nbtRoot.func_74781_a(key);
                ups = new ItemStack(upTag);
                this.outputFilterUpgrades.put(dir, ups);
            }
            if (nbtRoot.func_74764_b(key = "outFluidFilts." + dir.name())) {
                filterTag = (NBTTagCompound)nbtRoot.func_74781_a(key);
                filter = (IFluidFilter)FilterRegistry.loadFilterFromNbt(filterTag);
                this.outputFilters.put(dir, filter);
            }
            if (nbtRoot.func_74764_b(key = "inSC." + dir.name()) && (ord = nbtRoot.func_74765_d(key)) >= 0 && ord < DyeColor.values().length) {
                this.inputColors.put(dir, DyeColor.values()[ord]);
            }
            if (nbtRoot.func_74764_b(key = "outSC." + dir.name()) && (ord = nbtRoot.func_74765_d(key)) >= 0 && ord < DyeColor.values().length) {
                this.outputColors.put(dir, DyeColor.values()[ord]);
            }
            if (nbtRoot.func_74764_b(key = "priority." + dir.name())) {
                int val = nbtRoot.func_74762_e(key);
                this.priorities.put(dir, val);
            }
            if (nbtRoot.func_74764_b(key = "roundRobin." + dir.name())) {
                boolean val = nbtRoot.func_74767_n(key);
                this.roundRobin.put(dir, val);
            }
            if (nbtRoot.func_74764_b(key = "selfFeed." + dir.name())) {
                boolean val = nbtRoot.func_74767_n(key);
                this.selfFeed.put(dir, val);
            }
            if (!nbtRoot.func_74764_b(key = "functionUpgrades." + dir.name())) continue;
            NBTTagCompound upTag2 = (NBTTagCompound)nbtRoot.func_74781_a(key);
            ups = new ItemStack(upTag2);
            this.functionUpgrades.put(dir, ups);
        }
        this.connectionsDirty = true;
    }

    @Nonnull
    public EnderLiquidConduitNetwork createNetworkForType() {
        return new EnderLiquidConduitNetwork();
    }

    @Override
    public boolean hasCapability(@Nonnull Capability<?> capability, @Nullable EnumFacing facing) {
        if (capability == CapabilityFilterHolder.FILTER_HOLDER_CAPABILITY || capability == CapabilityUpgradeHolder.UPGRADE_HOLDER_CAPABILITY && this.containsExternalConnection(facing)) {
            return true;
        }
        return super.hasCapability(capability, facing);
    }

    @Override
    @Nonnull
    public ItemStack getFilterStack(int filterIndex, int param1) {
        if (filterIndex == 3) {
            return this.getFilterStack(EnumFacing.func_82600_a((int)param1), true);
        }
        if (filterIndex == 4) {
            return this.getFilterStack(EnumFacing.func_82600_a((int)param1), false);
        }
        return ItemStack.field_190927_a;
    }

    @Override
    public IFluidFilter getFilter(int filterIndex, int param1) {
        if (filterIndex == 3) {
            return this.getFilter(EnumFacing.func_82600_a((int)param1), true);
        }
        if (filterIndex == 4) {
            return this.getFilter(EnumFacing.func_82600_a((int)param1), false);
        }
        return null;
    }

    @Override
    public void setFilter(int filterIndex, int param1, @Nonnull IFluidFilter filter) {
        if (filterIndex == 3) {
            this.setFilter(EnumFacing.func_82600_a((int)param1), filter, true);
        } else if (filterIndex == 4) {
            this.setFilter(EnumFacing.func_82600_a((int)param1), filter, false);
        }
    }

    @Override
    public void setFilterStack(int filterIndex, int param1, @Nonnull ItemStack stack) {
        if (filterIndex == 3) {
            this.setFilterStack(EnumFacing.func_82600_a((int)param1), stack, true);
        } else if (filterIndex == 4) {
            this.setFilterStack(EnumFacing.func_82600_a((int)param1), stack, false);
        }
    }

    @Override
    public int getInputFilterIndex() {
        return 3;
    }

    @Override
    public int getOutputFilterIndex() {
        return 4;
    }

    @Nonnull
    public DyeColor getInputColor(@Nonnull EnumFacing dir) {
        DyeColor result = this.inputColors.get(dir);
        if (result == null) {
            return DyeColor.GREEN;
        }
        return result;
    }

    @Nonnull
    public DyeColor getOutputColor(@Nonnull EnumFacing dir) {
        DyeColor result = this.outputColors.get(dir);
        if (result == null) {
            return DyeColor.GREEN;
        }
        return result;
    }

    public void setInputColor(@Nonnull EnumFacing dir, @Nonnull DyeColor col) {
        this.inputColors.put(dir, col);
        if (this.network != null) {
            this.refreshConnections(dir);
        }
        this.setClientStateDirty();
        this.collidablesDirty = true;
    }

    public void setOutputColor(@Nonnull EnumFacing dir, @Nonnull DyeColor col) {
        this.outputColors.put(dir, col);
        if (this.network != null) {
            this.refreshConnections(dir);
        }
        this.setClientStateDirty();
        this.collidablesDirty = true;
    }

    public int getOutputPriority(@Nonnull EnumFacing dir) {
        Integer res = this.priorities.get(dir);
        if (res == null) {
            return 0;
        }
        return res;
    }

    public void setOutputPriority(@Nonnull EnumFacing dir, int priority) {
        if (priority == 0) {
            this.priorities.remove(dir);
        } else {
            this.priorities.put(dir, priority);
        }
        if (this.network != null) {
            this.refreshConnections(dir);
        }
    }

    public boolean isRoundRobinEnabled(@Nonnull EnumFacing dir) {
        Boolean val = this.roundRobin.get(dir);
        if (val == null) {
            return false;
        }
        return val;
    }

    public void setRoundRobinEnabled(@Nonnull EnumFacing dir, boolean enabled) {
        if (!enabled) {
            this.roundRobin.remove(dir);
        } else {
            this.roundRobin.put(dir, enabled);
        }
        if (this.network != null) {
            this.network.connectionChanged(this, dir);
        }
    }

    public boolean isSelfFeedEnabled(@Nonnull EnumFacing dir) {
        Boolean val = this.selfFeed.get(dir);
        if (val == null) {
            return false;
        }
        return val;
    }

    public void setSelfFeedEnabled(@Nonnull EnumFacing dir, boolean enabled) {
        if (!enabled) {
            this.selfFeed.remove(dir);
        } else {
            this.selfFeed.put(dir, enabled);
        }
        if (this.network != null) {
            this.network.connectionChanged(this, dir);
        }
    }

    @Nonnull
    public ItemStack getFunctionUpgrade(@Nonnull EnumFacing dir) {
        return this.functionUpgrades.get(dir);
    }

    public void setFunctionUpgrade(@Nonnull EnumFacing dir, @Nonnull ItemStack upgrade) {
        this.functionUpgrades.put(dir, upgrade);
        this.setClientStateDirty();
    }

    @Override
    @Nonnull
    public ItemStack getUpgradeStack(int param1) {
        return this.getFunctionUpgrade(EnumFacing.func_82600_a((int)param1));
    }

    @Override
    public void setUpgradeStack(int param1, @Nonnull ItemStack stack) {
        this.setFunctionUpgrade(EnumFacing.func_82600_a((int)param1), stack);
    }

    @Override
    @Nullable
    public <T> T getCapability(@Nonnull Capability<T> capability, @Nullable EnumFacing facing) {
        if (capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
            return (T)new ConnectionEnderLiquidSide(facing);
        }
        if (capability == CapabilityFilterHolder.FILTER_HOLDER_CAPABILITY || capability == CapabilityUpgradeHolder.UPGRADE_HOLDER_CAPABILITY) {
            return (T)this;
        }
        return null;
    }

    protected class ConnectionEnderLiquidSide
    extends AbstractLiquidConduit.ConnectionLiquidSide {
        public ConnectionEnderLiquidSide(EnumFacing side) {
            super(side);
        }

        @Override
        public int fill(FluidStack resource, boolean doFill) {
            if (EnderLiquidConduit.this.canFill(this.side, resource)) {
                return EnderLiquidConduit.this.network.fillFrom(EnderLiquidConduit.this, this.side, resource, doFill);
            }
            return 0;
        }

        @Override
        public IFluidTankProperties[] getTankProperties() {
            if (EnderLiquidConduit.this.network == null) {
                return new FluidTankProperties[0];
            }
            return EnderLiquidConduit.this.network.getTankProperties(EnderLiquidConduit.this, this.side);
        }
    }
}

