/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.conduits.conduit.item;

import com.enderio.core.common.util.RoundRobinIterator;
import crazypants.enderio.base.Log;
import crazypants.enderio.base.capability.ItemTools;
import crazypants.enderio.base.conduit.ConnectionMode;
import crazypants.enderio.base.conduit.IConduit;
import crazypants.enderio.base.filter.item.IItemFilter;
import crazypants.enderio.base.filter.item.ILimitedItemFilter;
import crazypants.enderio.conduits.conduit.item.IItemConduit;
import crazypants.enderio.conduits.conduit.item.ItemConduitNetwork;
import crazypants.enderio.conduits.config.ConduitConfig;
import crazypants.enderio.util.Prep;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.items.IItemHandler;

public class NetworkedInventory {
    private static final boolean SIMULATE = true;
    private static final boolean EXECUTE = false;
    @Nonnull
    private final IItemConduit con;
    @Nonnull
    private final EnumFacing conDir;
    @Nonnull
    private final BlockPos location;
    @Nonnull
    private final EnumFacing inventorySide;
    @Nonnull
    private final List<Target> sendPriority = new ArrayList<Target>();
    @Nonnull
    private final RoundRobinIterator<Target> rrIter = new RoundRobinIterator(this.sendPriority);
    private int extractFromSlot = -1;
    private int tickDeficit;
    @Nonnull
    private final World world;
    @Nonnull
    private final ItemConduitNetwork network;
    @Nonnull
    private final String invName;

    NetworkedInventory(@Nonnull ItemConduitNetwork network, @Nonnull IItemConduit con, @Nonnull EnumFacing conDir, @Nonnull IItemHandler inv, @Nonnull BlockPos location) {
        this.network = network;
        this.inventorySide = conDir.func_176734_d();
        this.con = con;
        this.conDir = conDir;
        this.location = location;
        this.world = con.getBundle().getBundleworld();
        IBlockState bs = this.world.func_180495_p(location);
        this.invName = bs.func_177230_c().func_149732_F();
    }

    @Nonnull
    public BlockPos getLocation() {
        return this.location;
    }

    @Nonnull
    public IItemConduit getCon() {
        return this.con;
    }

    @Nonnull
    public EnumFacing getConDir() {
        return this.conDir;
    }

    @Nonnull
    public List<Target> getSendPriority() {
        return this.sendPriority;
    }

    public boolean hasTarget(@Nonnull IConduit conduit, @Nonnull EnumFacing dir) {
        if (conduit instanceof IItemConduit) {
            for (Target t : this.sendPriority) {
                if (t.inv.getCon() != conduit || t.inv.getConDir() != dir) continue;
                return true;
            }
        }
        return false;
    }

    public boolean canExtract() {
        ConnectionMode mode = this.con.getConnectionMode(this.conDir);
        return mode == ConnectionMode.INPUT || mode == ConnectionMode.IN_OUT;
    }

    public boolean canInsert() {
        ConnectionMode mode = this.con.getConnectionMode(this.conDir);
        return mode == ConnectionMode.OUTPUT || mode == ConnectionMode.IN_OUT;
    }

    public boolean isSticky() {
        return this.con.getOutputFilter(this.conDir) != null && this.con.getOutputFilter(this.conDir).isValid() && this.con.getOutputFilter(this.conDir).isSticky();
    }

    public int getPriority() {
        return this.con.getOutputPriority(this.conDir);
    }

    public void onTick() {
        if (this.tickDeficit <= 0 && this.canExtract() && this.con.isExtractionRedstoneConditionMet(this.conDir)) {
            this.transferItems();
        }
        --this.tickDeficit;
        if (this.tickDeficit < -1) {
            this.tickDeficit = 20;
        }
    }

    private int nextSlot(int numSlots) {
        ++this.extractFromSlot;
        if (this.extractFromSlot >= numSlots || this.extractFromSlot < 0) {
            this.extractFromSlot = 0;
        }
        return this.extractFromSlot;
    }

    private void setNextStartingSlot(int slot) {
        this.extractFromSlot = slot;
        --this.extractFromSlot;
    }

    private boolean transferItems() {
        IItemHandler inventory = this.getInventory();
        if (inventory == null) {
            return false;
        }
        int numSlots = inventory.getSlots();
        if (numSlots < 1) {
            return false;
        }
        int maxExtracted = this.con.getMaximumExtracted(this.conDir);
        IItemFilter filter = this.con.getInputFilter(this.conDir);
        int slot = -1;
        int slotChecksPerTick = Math.min(numSlots, ItemConduitNetwork.MAX_SLOT_CHECK_PER_TICK);
        for (int i = 0; i < slotChecksPerTick; ++i) {
            slot = this.nextSlot(numSlots);
            ItemStack item = inventory.extractItem(slot, maxExtracted, true);
            if (!Prep.isValid(item)) continue;
            if (filter instanceof ILimitedItemFilter && filter.isLimited()) {
                int count = filter.getMaxCountThatPassesFilter(this.getInventory(), item);
                if (count <= 0) {
                    item = Prep.getEmpty();
                } else if (count < Integer.MAX_VALUE) {
                    ItemStack stackInSlot = inventory.getStackInSlot(slot);
                    if (stackInSlot.func_190916_E() <= count) {
                        item = Prep.getEmpty();
                    } else if (stackInSlot.func_190916_E() - item.func_190916_E() < count) {
                        item = inventory.extractItem(slot, stackInSlot.func_190916_E() - count, true);
                    }
                }
            } else if (filter != null && !filter.doesItemPassFilter(this.getInventory(), item)) {
                item = Prep.getEmpty();
            }
            if (!Prep.isValid(item) || !this.doTransfer(inventory, item, slot)) continue;
            this.setNextStartingSlot(slot);
            return true;
        }
        return false;
    }

    private boolean doTransfer(@Nonnull IItemHandler inventory, @Nonnull ItemStack extractedItem, int slot) {
        int numInserted = this.insertIntoTargets(extractedItem.func_77946_l());
        if (numInserted <= 0) {
            return false;
        }
        ItemStack extracted = inventory.extractItem(slot, numInserted, false);
        if (Prep.isInvalid(extracted) || extracted.func_190916_E() != numInserted || extracted.func_77973_b() != extractedItem.func_77973_b()) {
            Log.warn("NetworkedInventory.itemExtracted: Inserted " + numInserted + " " + extractedItem.func_82833_r() + " but only removed " + (Prep.isInvalid(extracted) ? "null" : extracted.func_190916_E() + " " + extracted.func_82833_r()) + " from " + inventory + " at " + this.location);
        }
        this.onItemExtracted(slot, numInserted);
        return true;
    }

    public void onItemExtracted(int slot, int numInserted) {
        this.con.itemsExtracted(numInserted, slot);
        this.tickDeficit = Math.round((float)numInserted * this.con.getTickTimePerItem(this.conDir));
    }

    public int insertIntoTargets(@Nonnull ItemStack toExtract) {
        int totalToInsert;
        if (Prep.isInvalid(toExtract)) {
            return 0;
        }
        int leftToInsert = totalToInsert = toExtract.func_190916_E();
        boolean matchedStickyInput = false;
        Iterable<Target> targets = this.getTargetIterator();
        for (Target target : targets) {
            if (target.stickyInput && !matchedStickyInput) {
                IItemFilter of = target.inv.getCon().getInputFilter(target.inv.getConDir());
                boolean bl = matchedStickyInput = of != null && of.isValid() && of.doesItemPassFilter(this.getInventory(), toExtract);
            }
            if (!target.stickyInput && matchedStickyInput) continue;
            int inserted = target.inv.insertItem(toExtract);
            if (inserted > 0) {
                toExtract.func_190918_g(inserted);
                leftToInsert -= inserted;
            }
            if (leftToInsert > 0) continue;
            return totalToInsert;
        }
        return totalToInsert - leftToInsert;
    }

    private Iterable<Target> getTargetIterator() {
        if (this.con.isRoundRobinEnabled(this.conDir)) {
            return this.rrIter;
        }
        return this.sendPriority;
    }

    public int insertItem(@Nonnull ItemStack item) {
        if (!this.canInsert() || Prep.isInvalid(item)) {
            return 0;
        }
        IItemFilter filter = this.con.getOutputFilter(this.conDir);
        if (filter instanceof ILimitedItemFilter && filter.isLimited()) {
            int count = filter.getMaxCountThatPassesFilter(this.getInventory(), item);
            if (count <= 0) {
                return 0;
            }
            int maxInsert = ItemTools.getInsertLimit(this.getInventory(), item, count);
            if (maxInsert <= 0) {
                return 0;
            }
            if (maxInsert < item.func_190916_E()) {
                item = item.func_77946_l();
                item.func_190920_e(maxInsert);
            }
        } else if (filter != null && !filter.doesItemPassFilter(this.getInventory(), item)) {
            return 0;
        }
        return ItemTools.doInsertItem(this.getInventory(), item);
    }

    public void updateInsertOrder() {
        this.sendPriority.clear();
        if (!this.canExtract()) {
            return;
        }
        ArrayList<Target> result = new ArrayList<Target>();
        for (NetworkedInventory other : this.network.inventories) {
            if (!this.con.isSelfFeedEnabled(this.conDir) && other == this || !other.canInsert() || this.con.getInputColor(this.conDir) != other.getCon().getOutputColor(other.getConDir())) continue;
            if (ConduitConfig.usePhyscialDistance.get().booleanValue()) {
                this.sendPriority.add(new Target(other, this.distanceTo(other), other.isSticky(), other.getPriority()));
                continue;
            }
            result.add(new Target(other, 9999999, other.isSticky(), other.getPriority()));
        }
        if (ConduitConfig.usePhyscialDistance.get().booleanValue()) {
            Collections.sort(this.sendPriority);
        } else if (!result.isEmpty()) {
            HashMap<BlockPos, Integer> visited = new HashMap<BlockPos, Integer>();
            ArrayList<BlockPos> steps = new ArrayList<BlockPos>();
            steps.add(this.con.getBundle().getLocation());
            this.calculateDistances(result, visited, steps, 0);
            this.sendPriority.addAll(result);
            Collections.sort(this.sendPriority);
        }
    }

    private void calculateDistances(@Nonnull List<Target> targets, @Nonnull Map<BlockPos, Integer> visited, @Nonnull List<BlockPos> steps, int distance) {
        if (steps.isEmpty()) {
            return;
        }
        ArrayList<BlockPos> nextSteps = new ArrayList<BlockPos>();
        for (BlockPos pos : steps) {
            IItemConduit con1 = this.network.conMap.get(pos);
            if (con1 == null) continue;
            for (EnumFacing dir : con1.getExternalConnections()) {
                Target target = this.getTarget(targets, con1, dir);
                if (target == null || target.distance <= distance) continue;
                target.distance = distance;
            }
            if (!visited.containsKey(pos)) {
                visited.put(pos, distance);
            } else {
                int prevDist = visited.get(pos);
                if (prevDist <= distance) continue;
                visited.put(pos, distance);
            }
            for (EnumFacing dir : con1.getConduitConnections()) {
                nextSteps.add(pos.func_177972_a(dir));
            }
        }
        this.calculateDistances(targets, visited, nextSteps, distance + 1);
    }

    private Target getTarget(@Nonnull List<Target> targets, @Nonnull IItemConduit con1, @Nonnull EnumFacing dir) {
        for (Target target : targets) {
            if (target == null || target.inv == null || target.inv.getConDir() != dir || !target.inv.getCon().getBundle().getLocation().equals((Object)con1.getBundle().getLocation())) continue;
            return target;
        }
        return null;
    }

    private int distanceTo(NetworkedInventory other) {
        return (int)this.con.getBundle().getLocation().func_177951_i((Vec3i)other.getCon().getBundle().getLocation());
    }

    @Nullable
    public IItemHandler getInventory() {
        return ItemTools.getExternalInventory((IBlockAccess)this.world, this.location, this.inventorySide);
    }

    public EnumFacing getInventorySide() {
        return this.inventorySide;
    }

    @Nonnull
    public String getLocalizedInventoryName() {
        return this.invName;
    }

    public boolean isAt(BlockPos pos) {
        return this.location.equals((Object)pos);
    }

    static class Target
    implements Comparable<Target> {
        NetworkedInventory inv;
        int distance;
        boolean stickyInput;
        int priority;

        Target(@Nonnull NetworkedInventory inv, int distance, boolean stickyInput, int priority) {
            this.inv = inv;
            this.distance = distance;
            this.stickyInput = stickyInput;
            this.priority = priority;
        }

        @Override
        public int compareTo(Target o) {
            if (this.stickyInput && !o.stickyInput) {
                return -1;
            }
            if (!this.stickyInput && o.stickyInput) {
                return 1;
            }
            if (this.priority != o.priority) {
                return ItemConduitNetwork.compare(o.priority, this.priority);
            }
            return ItemConduitNetwork.compare(this.distance, o.distance);
        }
    }
}

