/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.conduits.conduit.item;

import crazypants.enderio.base.diagnostics.Prof;
import crazypants.enderio.base.filter.item.IItemFilter;
import crazypants.enderio.conduits.conduit.AbstractConduitNetwork;
import crazypants.enderio.conduits.conduit.item.ChangeLog;
import crazypants.enderio.conduits.conduit.item.IInventoryDatabaseServer;
import crazypants.enderio.conduits.conduit.item.IInventoryPanel;
import crazypants.enderio.conduits.conduit.item.IItemConduit;
import crazypants.enderio.conduits.conduit.item.IServerItemEntry;
import crazypants.enderio.conduits.conduit.item.ItemConduit;
import crazypants.enderio.conduits.conduit.item.NetworkedInventory;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.item.ItemStack;
import net.minecraft.profiler.Profiler;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.items.IItemHandler;

public class ItemConduitNetwork
extends AbstractConduitNetwork<IItemConduit, IItemConduit> {
    final List<NetworkedInventory> inventories = new ArrayList<NetworkedInventory>();
    private final Map<BlockPos, List<NetworkedInventory>> invMap = new HashMap<BlockPos, List<NetworkedInventory>>();
    final Map<BlockPos, IItemConduit> conMap = new HashMap<BlockPos, IItemConduit>();
    private boolean requiresSort = true;
    private boolean doingSend = false;
    private int changeCount;
    static int MAX_SLOT_CHECK_PER_TICK = 64;

    public ItemConduitNetwork() {
        super(IItemConduit.class, IItemConduit.class);
    }

    @Override
    public void addConduit(@Nonnull IItemConduit con) {
        super.addConduit(con);
        this.conMap.put(con.getBundle().getLocation(), con);
        TileEntity te = con.getBundle().getEntity();
        if (te != null) {
            for (EnumFacing direction : con.getExternalConnections()) {
                IItemHandler extCon = con.getExternalInventory(direction);
                if (extCon == null) continue;
                BlockPos p = te.func_174877_v().func_177972_a(direction);
                this.inventoryAdded(con, direction, p, extCon);
            }
        }
    }

    public void inventoryAdded(@Nonnull IItemConduit itemConduit, @Nonnull EnumFacing direction, @Nonnull BlockPos pos, @Nonnull IItemHandler externalInventory) {
        NetworkedInventory inv = new NetworkedInventory(this, itemConduit, direction, externalInventory, pos);
        this.inventories.add(inv);
        this.getOrCreate(pos).add(inv);
        this.requiresSort = true;
    }

    public NetworkedInventory getInventory(@Nonnull IItemConduit conduit, @Nonnull EnumFacing dir) {
        for (NetworkedInventory inv : this.inventories) {
            if (inv.getCon() != conduit || inv.getConDir() != dir) continue;
            return inv;
        }
        return null;
    }

    private List<NetworkedInventory> getOrCreate(@Nonnull BlockPos pos) {
        List<NetworkedInventory> res = this.invMap.get(pos);
        if (res == null) {
            res = new ArrayList<NetworkedInventory>();
            this.invMap.put(pos, res);
        }
        return res;
    }

    public void inventoryRemoved(@Nonnull ItemConduit itemConduit, @Nonnull BlockPos pos) {
        List<NetworkedInventory> invs = this.getOrCreate(pos);
        NetworkedInventory remove = null;
        for (NetworkedInventory ni : invs) {
            if (!ni.getCon().getBundle().getLocation().equals((Object)itemConduit.getBundle().getLocation())) continue;
            remove = ni;
            break;
        }
        if (remove != null) {
            invs.remove(remove);
            this.inventories.remove(remove);
            this.requiresSort = true;
        }
    }

    public void routesChanged() {
        this.requiresSort = true;
    }

    public int getChangeCount() {
        return this.changeCount;
    }

    private IItemHandler getTargetInventory(NetworkedInventory.Target target) {
        if (target.inv != null) {
            return target.inv.getInventory();
        }
        return null;
    }

    public List<String> getTargetsForExtraction(@Nonnull BlockPos extractFrom, @Nonnull IItemConduit con, @Nonnull ItemStack input) {
        ArrayList<String> result = new ArrayList<String>();
        List<NetworkedInventory> invs = this.getOrCreate(extractFrom);
        for (NetworkedInventory source : invs) {
            List<NetworkedInventory.Target> sendPriority;
            if (!source.getCon().getBundle().getLocation().equals((Object)con.getBundle().getLocation()) || (sendPriority = source.getSendPriority()) == null) continue;
            for (NetworkedInventory.Target t : sendPriority) {
                IItemFilter f = t.inv.getCon().getOutputFilter(t.inv.getConDir());
                if (!input.func_190926_b() && f != null && !f.doesItemPassFilter(this.getTargetInventory(t), input)) continue;
                String s = t.inv.getLocalizedInventoryName() + " " + t.inv.getLocation().toString() + " Distance [" + t.distance + "] ";
                result.add(s);
            }
        }
        return result;
    }

    public List<String> getInputSourcesFor(@Nonnull IItemConduit con, @Nonnull EnumFacing dir, @Nonnull ItemStack input) {
        ArrayList<String> result = new ArrayList<String>();
        for (NetworkedInventory inv : this.inventories) {
            if (!inv.hasTarget(con, dir)) continue;
            IItemFilter f = inv.getCon().getInputFilter(inv.getConDir());
            if (!input.func_190926_b() && f != null && !f.doesItemPassFilter(inv.getInventory(), input)) continue;
            result.add(inv.getLocalizedInventoryName() + " " + inv.getLocation().toString());
        }
        return result;
    }

    @Override
    public void tickEnd(TickEvent.ServerTickEvent event, @Nullable Profiler profiler) {
        for (NetworkedInventory ni : this.inventories) {
            if (this.requiresSort) {
                Prof.start(profiler, "updateInsertOrder_", (Object)ni.getInventory());
                ni.updateInsertOrder();
                Prof.stop(profiler);
            }
            Prof.start(profiler, "NetworkedInventoryTick_", (Object)ni.getInventory());
            ni.onTick();
            Prof.stop(profiler);
        }
        if (this.requiresSort) {
            this.requiresSort = false;
            ++this.changeCount;
        }
    }

    static int compare(int x, int y) {
        return x < y ? -1 : (x == y ? 0 : 1);
    }

    public List<NetworkedInventory> getInventoryPanelSources() {
        return Collections.emptyList();
    }

    public IInventoryDatabaseServer getDatabase() {
        return new IInventoryDatabaseServer(){

            @Override
            public int getGeneration() {
                return 0;
            }

            @Override
            public IServerItemEntry lookupItem(ItemStack stack, IServerItemEntry hint, boolean create) {
                return null;
            }

            @Override
            public IServerItemEntry getItem(int dbID) {
                return null;
            }

            @Override
            public IServerItemEntry getExistingItem(int dbID) {
                return null;
            }

            @Override
            public boolean isCurrent() {
                return false;
            }

            @Override
            public void addChangeLog(ChangeLog cl) {
            }

            @Override
            public void removeChangeLog(ChangeLog cl) {
            }

            @Override
            public List<? extends IServerItemEntry> decompressMissingItems(byte[] compressed) throws IOException {
                return null;
            }

            @Override
            public byte[] compressItemInfo(List<? extends IServerItemEntry> items) throws IOException {
                return null;
            }

            @Override
            public byte[] compressItemList() throws IOException {
                return null;
            }

            @Override
            public byte[] compressChangedItems(Collection<? extends IServerItemEntry> items) throws IOException {
                return null;
            }

            @Override
            public void resetDatabase() {
            }

            @Override
            public int getNumInventories() {
                return 0;
            }

            @Override
            public float getPower() {
                return 0.0f;
            }

            @Override
            public void addPower(float power) {
            }

            @Override
            public boolean isOperational() {
                return false;
            }

            @Override
            public int extractItems(IServerItemEntry entry, int count, IInventoryPanel te) {
                return 0;
            }

            @Override
            public void tick() {
            }

            @Override
            public void sendChangeLogs() {
            }

            @Override
            public void onNeighborChange(BlockPos neighborPos) {
            }

            @Override
            public void entryChanged(IServerItemEntry entry) {
            }
        };
    }
}

