/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.conduits.conduit.item;

import com.enderio.core.api.client.gui.ITabPanel;
import com.enderio.core.common.util.DyeColor;
import com.enderio.core.common.util.NNList;
import com.enderio.core.common.vecmath.Vector4f;
import crazypants.enderio.base.EnderIO;
import crazypants.enderio.base.capability.ItemTools;
import crazypants.enderio.base.conduit.ConduitUtil;
import crazypants.enderio.base.conduit.ConnectionMode;
import crazypants.enderio.base.conduit.IClientConduit;
import crazypants.enderio.base.conduit.IConduit;
import crazypants.enderio.base.conduit.IConduitNetwork;
import crazypants.enderio.base.conduit.IGuiExternalConnection;
import crazypants.enderio.base.conduit.RaytraceResult;
import crazypants.enderio.base.conduit.geom.CollidableComponent;
import crazypants.enderio.base.conduit.item.FunctionUpgrade;
import crazypants.enderio.base.conduit.item.ItemFunctionUpgrade;
import crazypants.enderio.base.filter.FilterRegistry;
import crazypants.enderio.base.filter.capability.CapabilityFilterHolder;
import crazypants.enderio.base.filter.capability.IFilterHolder;
import crazypants.enderio.base.filter.item.IItemFilter;
import crazypants.enderio.base.filter.item.ItemFilter;
import crazypants.enderio.base.item.conduitprobe.PacketConduitProbe;
import crazypants.enderio.base.machine.modes.RedstoneControlMode;
import crazypants.enderio.base.render.registry.TextureRegistry;
import crazypants.enderio.base.tool.ToolUtil;
import crazypants.enderio.conduits.capability.CapabilityUpgradeHolder;
import crazypants.enderio.conduits.capability.IUpgradeHolder;
import crazypants.enderio.conduits.conduit.AbstractConduit;
import crazypants.enderio.conduits.conduit.IConduitComponent;
import crazypants.enderio.conduits.conduit.item.IItemConduit;
import crazypants.enderio.conduits.conduit.item.ItemConduitNetwork;
import crazypants.enderio.conduits.conduit.item.NetworkedInventory;
import crazypants.enderio.conduits.gui.GuiExternalConnection;
import crazypants.enderio.conduits.gui.ItemSettings;
import crazypants.enderio.conduits.init.ConduitObject;
import crazypants.enderio.conduits.render.BlockStateWrapperConduitBundle;
import crazypants.enderio.powertools.lang.Lang;
import crazypants.enderio.powertools.network.PacketHandler;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;

public class ItemConduit
extends AbstractConduit
implements IItemConduit,
IConduitComponent,
IFilterHolder<IItemFilter>,
IUpgradeHolder {
    public static Capability<IItemHandler> ITEM_HANDLER_CAPABILITY = CapabilityItemHandler.ITEM_HANDLER_CAPABILITY;
    public static final String EXTERNAL_INTERFACE_GEOM = "ExternalInterface";
    public static final TextureRegistry.TextureSupplier ICON_KEY = TextureRegistry.registerTexture("blocks/item_conduit");
    public static final TextureRegistry.TextureSupplier ICON_KEY_CORE = TextureRegistry.registerTexture("blocks/item_conduit_core");
    public static final TextureRegistry.TextureSupplier ICON_KEY_INPUT = TextureRegistry.registerTexture("blocks/item_conduit_input");
    public static final TextureRegistry.TextureSupplier ICON_KEY_OUTPUT = TextureRegistry.registerTexture("blocks/item_conduit_output");
    public static final TextureRegistry.TextureSupplier ICON_KEY_IN_OUT_OUT = TextureRegistry.registerTexture("blocks/item_conduit_in_out_out");
    public static final TextureRegistry.TextureSupplier ICON_KEY_IN_OUT_IN = TextureRegistry.registerTexture("blocks/item_conduit_in_out_in");
    public static final TextureRegistry.TextureSupplier ICON_KEY_IN_OUT_BG = TextureRegistry.registerTexture("blocks/item_conduit_io_connector");
    public static final TextureRegistry.TextureSupplier ICON_KEY_ENDER = TextureRegistry.registerTexture("blocks/ender_still");
    ItemConduitNetwork network;
    protected final EnumMap<EnumFacing, RedstoneControlMode> extractionModes = new EnumMap(EnumFacing.class);
    protected final EnumMap<EnumFacing, DyeColor> extractionColors = new EnumMap(EnumFacing.class);
    protected final EnumMap<EnumFacing, IItemFilter> outputFilters = new EnumMap(EnumFacing.class);
    protected final EnumMap<EnumFacing, IItemFilter> inputFilters = new EnumMap(EnumFacing.class);
    protected final EnumMap<EnumFacing, ItemStack> outputFilterUpgrades = new EnumMap(EnumFacing.class);
    protected final EnumMap<EnumFacing, ItemStack> inputFilterUpgrades = new EnumMap(EnumFacing.class);
    protected final EnumMap<EnumFacing, ItemStack> functionUpgrades = new EnumMap(EnumFacing.class);
    protected final EnumMap<EnumFacing, Boolean> selfFeed = new EnumMap(EnumFacing.class);
    protected final EnumMap<EnumFacing, Boolean> roundRobin = new EnumMap(EnumFacing.class);
    protected final EnumMap<EnumFacing, Integer> priority = new EnumMap(EnumFacing.class);
    protected final EnumMap<EnumFacing, DyeColor> outputColors = new EnumMap(EnumFacing.class);
    protected final EnumMap<EnumFacing, DyeColor> inputColors = new EnumMap(EnumFacing.class);
    private int metaData;

    public ItemConduit() {
        this(0);
    }

    public ItemConduit(int itemDamage) {
        this.metaData = itemDamage;
        NNList.NNIterator itr = NNList.FACING.fastIterator();
        while (itr.hasNext()) {
            EnumFacing dir = (EnumFacing)itr.next();
            this.outputFilterUpgrades.put(dir, ItemStack.field_190927_a);
            this.inputFilterUpgrades.put(dir, ItemStack.field_190927_a);
            this.functionUpgrades.put(dir, ItemStack.field_190927_a);
        }
    }

    @Override
    protected void readTypeSettings(@Nonnull EnumFacing dir, @Nonnull NBTTagCompound dataRoot) {
        this.setExtractionSignalColor(dir, DyeColor.values()[dataRoot.func_74765_d("extractionSignalColor")]);
        this.setExtractionRedstoneMode(RedstoneControlMode.values()[dataRoot.func_74765_d("extractionRedstoneMode")], dir);
        this.setInputColor(dir, DyeColor.values()[dataRoot.func_74765_d("inputColor")]);
        this.setOutputColor(dir, DyeColor.values()[dataRoot.func_74765_d("outputColor")]);
        this.setSelfFeedEnabled(dir, dataRoot.func_74767_n("selfFeed"));
        this.setRoundRobinEnabled(dir, dataRoot.func_74767_n("roundRobin"));
        this.setOutputPriority(dir, dataRoot.func_74762_e("outputPriority"));
    }

    @Override
    protected void writeTypeSettingsToNbt(@Nonnull EnumFacing dir, @Nonnull NBTTagCompound dataRoot) {
        dataRoot.func_74777_a("extractionSignalColor", (short)this.getExtractionSignalColor(dir).ordinal());
        dataRoot.func_74777_a("extractionRedstoneMode", (short)this.getExtractionRedstoneMode(dir).ordinal());
        dataRoot.func_74777_a("inputColor", (short)this.getInputColor(dir).ordinal());
        dataRoot.func_74777_a("outputColor", (short)this.getOutputColor(dir).ordinal());
        dataRoot.func_74757_a("selfFeed", this.isSelfFeedEnabled(dir));
        dataRoot.func_74757_a("roundRobin", this.isRoundRobinEnabled(dir));
        dataRoot.func_74768_a("outputPriority", this.getOutputPriority(dir));
    }

    @Override
    @Nonnull
    public NNList<ItemStack> getDrops() {
        NNList<ItemStack> res = super.getDrops();
        for (ItemStack stack : this.functionUpgrades.values()) {
            res.add((Object)stack);
        }
        for (ItemStack stack : this.inputFilterUpgrades.values()) {
            res.add((Object)stack);
        }
        for (ItemStack stack : this.outputFilterUpgrades.values()) {
            res.add((Object)stack);
        }
        return res;
    }

    @Override
    public boolean onBlockActivated(@Nonnull EntityPlayer player, @Nonnull EnumHand hand, @Nonnull RaytraceResult res, @Nonnull List<RaytraceResult> all) {
        EnumFacing connDir;
        if (ConduitUtil.isProbeEquipped(player, hand)) {
            return false;
        }
        if (ToolUtil.isToolEquipped(player, hand)) {
            if (!this.getBundle().getEntity().func_145831_w().field_72995_K && res != null && res.component != null) {
                EnumFacing connDir2 = res.component.dir;
                EnumFacing faceHit = res.movingObjectPosition.field_178784_b;
                if (connDir2 == null || connDir2 == faceHit) {
                    if (this.getConnectionMode(faceHit) == ConnectionMode.DISABLED) {
                        this.setConnectionMode(faceHit, this.getNextConnectionMode(faceHit));
                        return true;
                    }
                    return ConduitUtil.connectConduits(this, faceHit);
                }
                if (this.externalConnections.contains(connDir2)) {
                    this.setConnectionMode(connDir2, this.getNextConnectionMode(connDir2));
                    return true;
                }
                if (this.containsConduitConnection(connDir2)) {
                    ConduitUtil.disconnectConduits(this, connDir2);
                    return true;
                }
            }
        } else if (res != null && res.component != null && (connDir = res.component.dir) != null && this.containsExternalConnection(connDir)) {
            if (player.field_70170_p.field_72995_K) {
                PacketHandler.sendToServer(new PacketConduitProbe(this.getBundle().getLocation(), connDir));
            }
            return true;
        }
        return false;
    }

    @Override
    public void setInputFilter(@Nonnull EnumFacing dir, @Nonnull IItemFilter filter) {
        this.inputFilters.put(dir, filter);
        if (this.network != null) {
            this.network.routesChanged();
        }
        this.setClientStateDirty();
    }

    @Override
    public void setOutputFilter(@Nonnull EnumFacing dir, @Nonnull IItemFilter filter) {
        this.outputFilters.put(dir, filter);
        if (this.network != null) {
            this.network.routesChanged();
        }
        this.setClientStateDirty();
    }

    @Override
    public IItemFilter getInputFilter(@Nonnull EnumFacing dir) {
        return this.inputFilters.get(dir);
    }

    @Override
    public IItemFilter getOutputFilter(@Nonnull EnumFacing dir) {
        return this.outputFilters.get(dir);
    }

    @Override
    public void setInputFilterUpgrade(@Nonnull EnumFacing dir, @Nonnull ItemStack stack) {
        this.inputFilterUpgrades.put(dir, stack);
        this.setInputFilter(dir, (IItemFilter)FilterRegistry.getFilterForUpgrade(stack));
        this.setClientStateDirty();
    }

    @Override
    public void setOutputFilterUpgrade(@Nonnull EnumFacing dir, @Nonnull ItemStack stack) {
        this.outputFilterUpgrades.put(dir, stack);
        this.setOutputFilter(dir, (IItemFilter)FilterRegistry.getFilterForUpgrade(stack));
        this.setClientStateDirty();
    }

    @Override
    @Nonnull
    public ItemStack getInputFilterUpgrade(@Nonnull EnumFacing dir) {
        return this.inputFilterUpgrades.get(dir);
    }

    @Override
    @Nonnull
    public ItemStack getOutputFilterUpgrade(@Nonnull EnumFacing dir) {
        return this.outputFilterUpgrades.get(dir);
    }

    @Override
    public void setFunctionUpgrade(@Nonnull EnumFacing dir, @Nonnull ItemStack upgrade) {
        this.functionUpgrades.put(dir, upgrade);
        this.setClientStateDirty();
    }

    @Override
    @Nonnull
    public ItemStack getFunctionUpgrade(@Nonnull EnumFacing dir) {
        return this.functionUpgrades.get(dir);
    }

    @Override
    public int getMetaData() {
        return this.metaData;
    }

    @Override
    public void setExtractionRedstoneMode(@Nonnull RedstoneControlMode mode, @Nonnull EnumFacing dir) {
        this.extractionModes.put(dir, mode);
    }

    @Override
    @Nonnull
    public RedstoneControlMode getExtractionRedstoneMode(@Nonnull EnumFacing dir) {
        RedstoneControlMode res = this.extractionModes.get(dir);
        if (res == null) {
            res = RedstoneControlMode.NEVER;
        }
        return res;
    }

    @Override
    public void setExtractionSignalColor(@Nonnull EnumFacing dir, @Nonnull DyeColor col) {
        this.extractionColors.put(dir, col);
    }

    @Override
    @Nonnull
    public DyeColor getExtractionSignalColor(@Nonnull EnumFacing dir) {
        DyeColor result = this.extractionColors.get(dir);
        if (result == null) {
            return DyeColor.RED;
        }
        return result;
    }

    @Override
    public boolean isExtractionRedstoneConditionMet(@Nonnull EnumFacing dir) {
        RedstoneControlMode mode = this.getExtractionRedstoneMode(dir);
        return ConduitUtil.isRedstoneControlModeMet(this, mode, this.getExtractionSignalColor(dir));
    }

    @Override
    @Nonnull
    public DyeColor getInputColor(@Nonnull EnumFacing dir) {
        DyeColor result = this.inputColors.get(dir);
        if (result == null) {
            return DyeColor.GREEN;
        }
        return result;
    }

    @Override
    @Nonnull
    public DyeColor getOutputColor(@Nonnull EnumFacing dir) {
        DyeColor result = this.outputColors.get(dir);
        if (result == null) {
            return DyeColor.GREEN;
        }
        return result;
    }

    @Override
    public void setInputColor(@Nonnull EnumFacing dir, @Nonnull DyeColor col) {
        this.inputColors.put(dir, col);
        if (this.network != null) {
            this.network.routesChanged();
        }
        this.setClientStateDirty();
        this.collidablesDirty = true;
    }

    @Override
    public void setOutputColor(@Nonnull EnumFacing dir, @Nonnull DyeColor col) {
        this.outputColors.put(dir, col);
        if (this.network != null) {
            this.network.routesChanged();
        }
        this.setClientStateDirty();
        this.collidablesDirty = true;
    }

    @Override
    public int getMaximumExtracted(@Nonnull EnumFacing dir) {
        ItemStack stack = this.functionUpgrades.get(dir);
        if (stack.func_190926_b()) {
            return 4;
        }
        FunctionUpgrade functionUpgrade = ItemFunctionUpgrade.getFunctionUpgrade(stack);
        return functionUpgrade.getMaximumExtracted(stack.func_190916_E());
    }

    @Override
    public float getTickTimePerItem(@Nonnull EnumFacing dir) {
        float maxExtract = 10.0f / (float)this.getMaximumExtracted(dir);
        return maxExtract;
    }

    @Override
    public void itemsExtracted(int numExtracted, int slot) {
    }

    @Override
    public void externalConnectionAdded(@Nonnull EnumFacing direction) {
        super.externalConnectionAdded(direction);
        this.checkInventoryConnections(direction);
    }

    @Override
    public IItemHandler getExternalInventory(@Nonnull EnumFacing direction) {
        World world = this.getBundle().getBundleworld();
        BlockPos loc = this.getBundle().getLocation().func_177972_a(direction);
        return ItemTools.getExternalInventory((IBlockAccess)world, loc, direction.func_176734_d());
    }

    @Override
    public void externalConnectionRemoved(@Nonnull EnumFacing direction) {
        this.externalConnections.remove(direction);
        this.connectionsChanged();
        this.checkInventoryConnections(direction);
    }

    private void checkInventoryConnections(@Nonnull EnumFacing direction) {
        if (this.network != null) {
            BlockPos p = this.bundle.getEntity().func_174877_v().func_177972_a(direction);
            NetworkedInventory networkedInventory = this.network.getInventory(this, direction);
            if (this.externalConnections.contains(direction) && this.getConnectionMode(direction) != ConnectionMode.DISABLED) {
                if (networkedInventory == null) {
                    this.network.inventoryAdded(this, direction, p, this.getExternalInventory(direction));
                }
            } else if (networkedInventory != null) {
                this.network.inventoryRemoved(this, p);
            }
        }
    }

    @Override
    public void setConnectionMode(@Nonnull EnumFacing dir, @Nonnull ConnectionMode mode) {
        ConnectionMode oldVal = (ConnectionMode)((Object)this.conectionModes.get(dir));
        if (oldVal == mode) {
            return;
        }
        super.setConnectionMode(dir, mode);
        this.checkInventoryConnections(dir);
        if (this.network != null) {
            this.network.routesChanged();
        }
    }

    @Override
    public boolean isSelfFeedEnabled(@Nonnull EnumFacing dir) {
        Boolean val = this.selfFeed.get(dir);
        if (val == null) {
            return false;
        }
        return val;
    }

    @Override
    public void setSelfFeedEnabled(@Nonnull EnumFacing dir, boolean enabled) {
        if (!enabled) {
            this.selfFeed.remove(dir);
        } else {
            this.selfFeed.put(dir, enabled);
        }
        if (this.network != null) {
            this.network.routesChanged();
        }
    }

    @Override
    public boolean isRoundRobinEnabled(@Nonnull EnumFacing dir) {
        Boolean val = this.roundRobin.get(dir);
        if (val == null) {
            return false;
        }
        return val;
    }

    @Override
    public void setRoundRobinEnabled(@Nonnull EnumFacing dir, boolean enabled) {
        if (!enabled) {
            this.roundRobin.remove(dir);
        } else {
            this.roundRobin.put(dir, enabled);
        }
        if (this.network != null) {
            this.network.routesChanged();
        }
    }

    @Override
    public int getOutputPriority(@Nonnull EnumFacing dir) {
        Integer res = this.priority.get(dir);
        if (res == null) {
            return 0;
        }
        return res;
    }

    @Override
    public void setOutputPriority(@Nonnull EnumFacing dir, int priority) {
        if (priority == 0) {
            this.priority.remove(dir);
        } else {
            this.priority.put(dir, priority);
        }
        if (this.network != null) {
            this.network.routesChanged();
        }
    }

    @Override
    public boolean canConnectToExternal(@Nonnull EnumFacing direction, boolean ignoreDisabled) {
        return this.getExternalInventory(direction) != null;
    }

    @Override
    @Nonnull
    protected ConnectionMode getDefaultConnectionMode() {
        return ConnectionMode.INPUT;
    }

    @Override
    @Nonnull
    public Class<? extends IConduit> getBaseConduitType() {
        return IItemConduit.class;
    }

    @Override
    @Nonnull
    public ItemStack createItem() {
        ItemStack result = new ItemStack(ConduitObject.item_item_conduit.getItemNN(), 1, this.metaData);
        return result;
    }

    @Nullable
    public ItemConduitNetwork getNetwork() {
        return this.network;
    }

    @Override
    public boolean setNetwork(@Nonnull IConduitNetwork<?, ?> network) {
        this.network = (ItemConduitNetwork)network;
        return true;
    }

    @Override
    public void clearNetwork() {
        this.network = null;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public TextureAtlasSprite getTextureForInputMode() {
        return ICON_KEY_INPUT.get(TextureAtlasSprite.class);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public TextureAtlasSprite getTextureForOutputMode() {
        return ICON_KEY_OUTPUT.get(TextureAtlasSprite.class);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public TextureAtlasSprite getTextureForInOutMode(boolean input) {
        return input ? ICON_KEY_IN_OUT_IN.get(TextureAtlasSprite.class) : ICON_KEY_IN_OUT_OUT.get(TextureAtlasSprite.class);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public TextureAtlasSprite getTextureForInOutBackground() {
        return ICON_KEY_IN_OUT_BG.get(TextureAtlasSprite.class);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public TextureAtlasSprite getEnderIcon() {
        return ICON_KEY_ENDER.get(TextureAtlasSprite.class);
    }

    @SideOnly(value=Side.CLIENT)
    public TextureAtlasSprite getCoreIcon() {
        return ICON_KEY_CORE.get(TextureAtlasSprite.class);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    @Nonnull
    public TextureAtlasSprite getTextureForState(@Nonnull CollidableComponent component) {
        if (component.dir == null) {
            return this.getCoreIcon();
        }
        if (EXTERNAL_INTERFACE_GEOM.equals(component.data)) {
            return this.getCoreIcon();
        }
        return ICON_KEY.get(TextureAtlasSprite.class);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    @Nonnull
    public TextureAtlasSprite getTransmitionTextureForState(@Nonnull CollidableComponent component) {
        return this.getEnderIcon();
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public Vector4f getTransmitionTextureColorForState(@Nonnull CollidableComponent component) {
        return null;
    }

    @Override
    public void writeToNBT(@Nonnull NBTTagCompound nbtRoot) {
        NBTTagCompound itemRoot;
        IItemFilter filter;
        NBTTagCompound itemRoot2;
        ItemStack up;
        IItemFilter f;
        super.writeToNBT(nbtRoot);
        for (Map.Entry<EnumFacing, IItemFilter> entry : this.inputFilters.entrySet()) {
            if (entry.getValue() == null || this.isDefault(f = entry.getValue())) continue;
            NBTTagCompound itemRoot22 = new NBTTagCompound();
            FilterRegistry.writeFilterToNbt(f, itemRoot22);
            nbtRoot.func_74782_a("inFilts." + entry.getKey().name(), (NBTBase)itemRoot22);
        }
        for (Map.Entry<EnumFacing, IItemFilter> entry : this.functionUpgrades.entrySet()) {
            if (entry.getValue() == null) continue;
            up = (ItemStack)entry.getValue();
            itemRoot2 = new NBTTagCompound();
            up.func_77955_b(itemRoot2);
            nbtRoot.func_74782_a("functionUpgrades." + entry.getKey().name(), (NBTBase)itemRoot2);
        }
        for (Map.Entry<EnumFacing, IItemFilter> entry : this.outputFilters.entrySet()) {
            if (entry.getValue() == null || this.isDefault(f = entry.getValue())) continue;
            itemRoot2 = new NBTTagCompound();
            FilterRegistry.writeFilterToNbt(f, itemRoot2);
            nbtRoot.func_74782_a("outFilts." + entry.getKey().name(), (NBTBase)itemRoot2);
        }
        for (Map.Entry<EnumFacing, IItemFilter> entry : this.inputFilterUpgrades.entrySet()) {
            if (entry.getValue() == null) continue;
            up = (ItemStack)entry.getValue();
            filter = this.getInputFilter(entry.getKey());
            FilterRegistry.writeFilterToStack(filter, up);
            itemRoot = new NBTTagCompound();
            up.func_77955_b(itemRoot);
            nbtRoot.func_74782_a("inputFilterUpgrades." + entry.getKey().name(), (NBTBase)itemRoot);
        }
        for (Map.Entry<EnumFacing, IItemFilter> entry : this.outputFilterUpgrades.entrySet()) {
            if (entry.getValue() == null) continue;
            up = (ItemStack)entry.getValue();
            filter = this.getOutputFilter(entry.getKey());
            FilterRegistry.writeFilterToStack(filter, up);
            itemRoot = new NBTTagCompound();
            up.func_77955_b(itemRoot);
            nbtRoot.func_74782_a("outputFilterUpgrades." + entry.getKey().name(), (NBTBase)itemRoot);
        }
        for (Map.Entry<EnumFacing, Object> entry : this.extractionModes.entrySet()) {
            if (entry.getValue() == null) continue;
            short ord = (short)((RedstoneControlMode)((Object)entry.getValue())).ordinal();
            nbtRoot.func_74777_a("extRM." + entry.getKey().name(), ord);
        }
        for (Map.Entry<EnumFacing, Object> entry : this.extractionColors.entrySet()) {
            if (entry.getValue() == null) continue;
            short ord = (short)((DyeColor)entry.getValue()).ordinal();
            nbtRoot.func_74777_a("extSC." + entry.getKey().name(), ord);
        }
        for (Map.Entry<EnumFacing, Object> entry : this.selfFeed.entrySet()) {
            if (entry.getValue() == null) continue;
            nbtRoot.func_74757_a("selfFeed." + entry.getKey().name(), ((Boolean)entry.getValue()).booleanValue());
        }
        for (Map.Entry<EnumFacing, Object> entry : this.roundRobin.entrySet()) {
            if (entry.getValue() == null) continue;
            nbtRoot.func_74757_a("roundRobin." + entry.getKey().name(), ((Boolean)entry.getValue()).booleanValue());
        }
        for (Map.Entry<EnumFacing, Object> entry : this.priority.entrySet()) {
            if (entry.getValue() == null) continue;
            nbtRoot.func_74768_a("priority." + entry.getKey().name(), ((Integer)entry.getValue()).intValue());
        }
        for (Map.Entry<EnumFacing, Object> entry : this.inputColors.entrySet()) {
            if (entry.getValue() == null) continue;
            short ord = (short)((DyeColor)entry.getValue()).ordinal();
            nbtRoot.func_74777_a("inSC." + entry.getKey().name(), ord);
        }
        for (Map.Entry<EnumFacing, Object> entry : this.outputColors.entrySet()) {
            if (entry.getValue() == null) continue;
            short ord = (short)((DyeColor)entry.getValue()).ordinal();
            nbtRoot.func_74777_a("outSC." + entry.getKey().name(), ord);
        }
    }

    private boolean isDefault(IItemFilter f) {
        if (f instanceof ItemFilter) {
            return ((ItemFilter)f).isDefault();
        }
        return false;
    }

    @Override
    public void readFromNBT(@Nonnull NBTTagCompound nbtRoot) {
        super.readFromNBT(nbtRoot);
        this.metaData = nbtRoot.func_74764_b("metaData") ? (int)nbtRoot.func_74765_d("metaData") : 0;
        for (EnumFacing dir : EnumFacing.field_82609_l) {
            short ord;
            ItemStack ups;
            NBTTagCompound upTag;
            IItemFilter filter;
            NBTTagCompound filterTag;
            String key = "inFilts." + dir.name();
            if (nbtRoot.func_74764_b(key)) {
                filterTag = (NBTTagCompound)nbtRoot.func_74781_a(key);
                filter = (IItemFilter)FilterRegistry.loadFilterFromNbt(filterTag);
                this.inputFilters.put(dir, filter);
            }
            if (nbtRoot.func_74764_b(key = "functionUpgrades." + dir.name())) {
                upTag = (NBTTagCompound)nbtRoot.func_74781_a(key);
                ups = new ItemStack(upTag);
                this.functionUpgrades.put(dir, ups);
            }
            if (nbtRoot.func_74764_b(key = "inputFilterUpgrades." + dir.name())) {
                upTag = (NBTTagCompound)nbtRoot.func_74781_a(key);
                ups = new ItemStack(upTag);
                this.inputFilterUpgrades.put(dir, ups);
            }
            if (nbtRoot.func_74764_b(key = "outputFilterUpgrades." + dir.name())) {
                upTag = (NBTTagCompound)nbtRoot.func_74781_a(key);
                ups = new ItemStack(upTag);
                this.outputFilterUpgrades.put(dir, ups);
            }
            if (nbtRoot.func_74764_b(key = "outFilts." + dir.name())) {
                filterTag = (NBTTagCompound)nbtRoot.func_74781_a(key);
                filter = (IItemFilter)FilterRegistry.loadFilterFromNbt(filterTag);
                this.outputFilters.put(dir, filter);
            }
            if (nbtRoot.func_74764_b(key = "extRM." + dir.name()) && (ord = nbtRoot.func_74765_d(key)) >= 0 && ord < RedstoneControlMode.values().length) {
                this.extractionModes.put(dir, RedstoneControlMode.values()[ord]);
            }
            if (nbtRoot.func_74764_b(key = "extSC." + dir.name()) && (ord = nbtRoot.func_74765_d(key)) >= 0 && ord < DyeColor.values().length) {
                this.extractionColors.put(dir, DyeColor.values()[ord]);
            }
            if (nbtRoot.func_74764_b(key = "selfFeed." + dir.name())) {
                boolean val = nbtRoot.func_74767_n(key);
                this.selfFeed.put(dir, val);
            }
            if (nbtRoot.func_74764_b(key = "roundRobin." + dir.name())) {
                boolean val = nbtRoot.func_74767_n(key);
                this.roundRobin.put(dir, val);
            }
            if (nbtRoot.func_74764_b(key = "priority." + dir.name())) {
                int val = nbtRoot.func_74762_e(key);
                this.priority.put(dir, val);
            }
            if (nbtRoot.func_74764_b(key = "inSC." + dir.name()) && (ord = nbtRoot.func_74765_d(key)) >= 0 && ord < DyeColor.values().length) {
                this.inputColors.put(dir, DyeColor.values()[ord]);
            }
            if (!nbtRoot.func_74764_b(key = "outSC." + dir.name()) || (ord = nbtRoot.func_74765_d(key)) < 0 || ord >= DyeColor.values().length) continue;
            this.outputColors.put(dir, DyeColor.values()[ord]);
        }
        this.connectionsDirty = true;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void hashCodeForModelCaching(BlockStateWrapperConduitBundle.ConduitCacheKey hashCodes) {
        super.hashCodeForModelCaching(hashCodes);
        hashCodes.addEnum(this.outputColors);
        hashCodes.addEnum(this.inputColors);
    }

    @Override
    public void invalidate() {
        super.invalidate();
        if (this.network != null) {
            BlockPos pos = this.bundle.getEntity().func_174877_v();
            for (EnumFacing direction : this.externalConnections) {
                try {
                    BlockPos p = pos.func_177972_a(direction);
                    this.network.inventoryRemoved(this, p);
                }
                catch (Throwable throwable) {}
            }
        }
    }

    @Nonnull
    public ItemConduitNetwork createNetworkForType() {
        return new ItemConduitNetwork();
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    @Nonnull
    public ITabPanel createGuiPanel(@Nonnull IGuiExternalConnection gui, @Nonnull IClientConduit con) {
        return new ItemSettings((GuiExternalConnection)gui, con);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public boolean updateGuiPanel(@Nonnull ITabPanel panel) {
        if (panel instanceof ItemSettings) {
            return ((ItemSettings)panel).updateConduit(this);
        }
        return false;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public int getGuiPanelTabOrder() {
        return 0;
    }

    public boolean hasCapability(@Nonnull Capability<?> capability, @Nullable EnumFacing facing) {
        return capability == CapabilityFilterHolder.FILTER_HOLDER_CAPABILITY || capability == CapabilityUpgradeHolder.UPGRADE_HOLDER_CAPABILITY && this.getExternalConnections().contains(facing);
    }

    @Nullable
    public <T> T getCapability(@Nonnull Capability<T> capability, @Nullable EnumFacing facing) {
        if (capability == CapabilityFilterHolder.FILTER_HOLDER_CAPABILITY || capability == CapabilityUpgradeHolder.UPGRADE_HOLDER_CAPABILITY) {
            return (T)this;
        }
        return null;
    }

    @Override
    public IItemFilter getFilter(int filterId, int param1) {
        if (filterId == 1) {
            return this.getInputFilter(EnumFacing.func_82600_a((int)param1));
        }
        if (filterId == 2) {
            return this.getOutputFilter(EnumFacing.func_82600_a((int)param1));
        }
        return null;
    }

    @Override
    public void setFilter(int filterId, int param1, @Nonnull IItemFilter filter) {
        if (filterId == 1) {
            this.setInputFilter(EnumFacing.func_82600_a((int)param1), filter);
        } else if (filterId == 2) {
            this.setOutputFilter(EnumFacing.func_82600_a((int)param1), filter);
        }
    }

    @Override
    @Nullable
    public IItemHandler getInventoryForSnapshot(int filterId, int param1) {
        ItemConduitNetwork icn = this.getNetwork();
        if (icn != null) {
            return icn.getInventory(this, EnumFacing.func_82600_a((int)param1)).getInventory();
        }
        return null;
    }

    @Override
    @Nonnull
    public ItemStack getFilterStack(int filterIndex, int param1) {
        if (filterIndex == 1) {
            return this.getInputFilterUpgrade(EnumFacing.func_82600_a((int)param1));
        }
        if (filterIndex == 2) {
            return this.getOutputFilterUpgrade(EnumFacing.func_82600_a((int)param1));
        }
        return ItemStack.field_190927_a;
    }

    @Override
    public void setFilterStack(int filterIndex, int param1, @Nonnull ItemStack stack) {
        if (filterIndex == 1) {
            this.setInputFilterUpgrade(EnumFacing.func_82600_a((int)param1), stack);
        } else if (filterIndex == 2) {
            this.setOutputFilterUpgrade(EnumFacing.func_82600_a((int)param1), stack);
        }
    }

    @Override
    @Nonnull
    public ItemStack getUpgradeStack(int param1) {
        return this.getFunctionUpgrade(EnumFacing.func_82600_a((int)param1));
    }

    @Override
    public void setUpgradeStack(int param1, @Nonnull ItemStack stack) {
        this.setFunctionUpgrade(EnumFacing.func_82600_a((int)param1), stack);
    }

    @Override
    public int getInputFilterIndex() {
        return 1;
    }

    @Override
    public int getOutputFilterIndex() {
        return 2;
    }

    @Override
    @Nonnull
    public String getConduitProbeInfo(@Nonnull EntityPlayer player) {
        StringBuilder sb = new StringBuilder();
        ItemStack input = player.func_184614_ca();
        if (this.getExternalConnections().isEmpty()) {
            sb.append(Lang.GUI_CONDUIT_PROBE_ITEM_HEADING.get());
            sb.append(" ");
            sb.append(Lang.GUI_CONDUIT_PROBE_ITEM_NO_CONNECTIONS.get());
            sb.append("\n");
        } else {
            for (EnumFacing dir : this.getExternalConnections()) {
                List<String> targets;
                ConnectionMode mode = this.getConnectionMode(dir);
                TextFormatting color = TextFormatting.GREEN;
                sb.append(color);
                sb.append(Lang.GUI_CONDUIT_PROBE_ITEM_HEADING.get());
                sb.append(" ");
                sb.append(Lang.GUI_CONDUIT_PROBE_CONNECTION_DIR.get());
                sb.append(" ");
                sb.append(dir);
                sb.append("\n");
                ItemConduitNetwork icn = this.getNetwork();
                if (icn != null && mode.acceptsInput()) {
                    color = TextFormatting.BLUE;
                    sb.append(color);
                    sb.append(" ");
                    if (input.func_190926_b()) {
                        sb.append(Lang.GUI_CONDUIT_PROBE_EXTRACTED_ITEMS.get());
                    } else {
                        sb.append(Lang.GUI_CONDUIT_PROBE_EXTRACTED_ITEM.get());
                        sb.append(" ");
                        sb.append(input.func_82833_r());
                    }
                    sb.append(" ");
                    targets = icn.getTargetsForExtraction(this.getBundle().getLocation().func_177972_a(dir), this, input);
                    if (targets.isEmpty()) {
                        sb.append(" ");
                        sb.append(Lang.GUI_CONDUIT_PROBE_NO_OUTPUTS.get());
                        sb.append(".\n");
                    } else {
                        sb.append(" ");
                        sb.append(Lang.GUI_CONDUIT_PROBE_INSERTED_INTO.get());
                        sb.append("\n");
                        for (String str : targets) {
                            sb.append("  - ");
                            sb.append(str);
                            sb.append(" ");
                            sb.append("\n");
                        }
                    }
                }
                if (icn == null || !mode.acceptsOutput()) continue;
                color = TextFormatting.BLUE;
                sb.append(color + " ");
                targets = icn.getInputSourcesFor(this, dir, input);
                if (targets.isEmpty()) {
                    if (input.func_190926_b()) {
                        sb.append(Lang.GUI_CONDUIT_PROBE_NO_ITEMS.get());
                        continue;
                    }
                    sb.append(Lang.GUI_CONDUIT_PROBE_NO_ITEM.get());
                    sb.append(" ");
                    sb.append(input.func_82833_r());
                    continue;
                }
                if (input.func_190926_b()) {
                    sb.append(Lang.GUI_CONDUIT_PROBE_RECEIVE_ITEMS.get());
                } else {
                    sb.append(Lang.GUI_CONDUIT_PROBE_RECEIVE_ITEM1.get());
                    sb.append(" ");
                    sb.append(input.func_82833_r());
                    sb.append(" ");
                    sb.append(EnderIO.lang.localize(Lang.GUI_CONDUIT_PROBE_RECEIVE_ITEM2.get()));
                }
                sb.append("\n");
                for (String str : targets) {
                    sb.append("  - ");
                    sb.append(str);
                    sb.append("\n");
                }
            }
        }
        return sb.toString();
    }
}

