/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.conduits.conduit.item;

import com.enderio.core.common.util.ItemUtil;
import crazypants.enderio.base.EnderIOTab;
import crazypants.enderio.base.conduit.ConduitUtil;
import crazypants.enderio.base.conduit.IConduitBundle;
import crazypants.enderio.base.conduit.IConduitItem;
import crazypants.enderio.base.conduit.IServerConduit;
import crazypants.enderio.base.conduit.registry.ConduitRegistry;
import crazypants.enderio.base.init.IModObject;
import crazypants.enderio.base.render.IHaveRenderers;
import crazypants.enderio.conduits.conduit.ItemConduitSubtype;
import crazypants.enderio.util.ClientUtil;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public abstract class AbstractItemConduit
extends Item
implements IConduitItem,
IHaveRenderers {
    protected IModObject modObj;
    protected ItemConduitSubtype[] subtypes;

    protected AbstractItemConduit(@Nonnull IModObject modObj, ItemConduitSubtype ... subtypes) {
        this.modObj = modObj;
        this.subtypes = subtypes;
        this.func_77637_a(EnderIOTab.tabEnderIO);
        this.func_77655_b(modObj.getUnlocalisedName());
        this.func_77625_d(64);
        this.func_77627_a(true);
        this.setRegistryName(modObj.getUnlocalisedName());
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void registerRenderers(@Nonnull IModObject modObject) {
        for (int i = 0; i < this.subtypes.length; ++i) {
            ClientUtil.regRenderer((Item)this, i, new ResourceLocation(this.subtypes[i].modelLocation));
        }
    }

    @Nonnull
    public EnumActionResult func_180614_a(@Nonnull EntityPlayer player, @Nonnull World world, @Nonnull BlockPos pos, @Nonnull EnumHand hand, @Nonnull EnumFacing side, float hitX, float hitY, float hitZ) {
        ItemStack held = player.func_184586_b(hand);
        BlockPos placeAt = this.canPlaceItem(held, ConduitRegistry.getConduitModObjectNN().getBlockNN().func_176223_P(), player, world, pos, side);
        if (placeAt != null) {
            TileEntity te;
            if (!world.field_72995_K && world.func_180501_a(placeAt, ConduitRegistry.getConduitModObjectNN().getBlockNN().func_176223_P(), 1) && (te = world.func_175625_s(placeAt)) instanceof IConduitBundle) {
                IConduitBundle bundle = (IConduitBundle)te;
                bundle.addConduit(this.createConduit(held, player));
                ConduitUtil.playBreakSound(SoundType.field_185852_e, world, placeAt);
            }
            if (!player.field_71075_bZ.field_75098_d) {
                held.func_190918_g(1);
            }
            return EnumActionResult.SUCCESS;
        }
        BlockPos place = pos.func_177972_a(side);
        if (world.func_180495_p(place).func_177230_c() == ConduitRegistry.getConduitModObjectNN().getBlock()) {
            IConduitBundle bundle = (IConduitBundle)world.func_175625_s(place);
            if (bundle == null) {
                return EnumActionResult.PASS;
            }
            if (!bundle.hasType(this.getBaseConduitType())) {
                if (!world.field_72995_K) {
                    IServerConduit con = this.createConduit(held, player);
                    if (con == null) {
                        return EnumActionResult.PASS;
                    }
                    bundle.addConduit(con);
                    ConduitUtil.playBreakSound(SoundType.field_185852_e, world, place);
                    if (!player.field_71075_bZ.field_75098_d) {
                        held.func_190918_g(1);
                    }
                }
                return EnumActionResult.SUCCESS;
            }
        }
        return EnumActionResult.PASS;
    }

    @Nonnull
    public EnumActionResult onItemUseFirst(@Nonnull EntityPlayer player, @Nonnull World world, @Nonnull BlockPos pos, @Nonnull EnumFacing side, float hitX, float hitY, float hitZ, @Nonnull EnumHand hand) {
        ItemStack held = player.func_184586_b(hand);
        if (player.func_70093_af()) {
            return EnumActionResult.PASS;
        }
        TileEntity te = world.func_175625_s(pos);
        if (te == null || !(te instanceof IConduitBundle)) {
            return EnumActionResult.PASS;
        }
        IConduitBundle bundle = (IConduitBundle)te;
        Object existingConduit = bundle.getConduit(this.getBaseConduitType());
        if (existingConduit == null) {
            return EnumActionResult.PASS;
        }
        ItemStack existingConduitAsItemStack = existingConduit.createItem();
        if (!ItemUtil.areStacksEqual((ItemStack)existingConduitAsItemStack, (ItemStack)held)) {
            if (!world.field_72995_K) {
                IServerConduit newConduit = this.createConduit(held, player);
                if (newConduit == null) {
                    return EnumActionResult.PASS;
                }
                bundle.removeConduit((IServerConduit)existingConduit);
                bundle.addConduit(newConduit);
                if (!player.field_71075_bZ.field_75098_d) {
                    held.func_190918_g(1);
                    for (ItemStack drop : existingConduit.getDrops()) {
                        if (player.field_71071_by.func_70441_a(drop)) continue;
                        ItemUtil.spawnItemInWorldWithRandomMotion((World)world, (ItemStack)drop, (BlockPos)pos, (float)hitX, (float)hitY, (float)hitZ, (float)1.1f);
                    }
                    player.field_71069_bz.func_75142_b();
                }
                return EnumActionResult.FAIL;
            }
            player.func_184609_a(hand);
        }
        return EnumActionResult.PASS;
    }

    @Nonnull
    public String func_77667_c(@Nonnull ItemStack stack) {
        int i = MathHelper.func_76125_a((int)stack.func_77952_i(), (int)0, (int)(this.subtypes.length - 1));
        return this.subtypes[i].unlocalisedName;
    }

    public void func_150895_a(@Nonnull CreativeTabs tab, @Nonnull NonNullList<ItemStack> stacks) {
        if (this.func_194125_a(tab)) {
            for (int j = 0; j < this.subtypes.length; ++j) {
                stacks.add((Object)new ItemStack((Item)this, 1, j));
            }
        }
    }

    private BlockPos canPlaceItem(@Nonnull ItemStack held, IBlockState blockToPlace, @Nonnull EntityPlayer player, @Nonnull World world, @Nonnull BlockPos pos, @Nonnull EnumFacing side) {
        if (held.func_190926_b() || blockToPlace == null) {
            return null;
        }
        IBlockState bs = world.func_180495_p(pos);
        Block block = bs.func_177230_c();
        if (!block.func_176200_f((IBlockAccess)world, pos)) {
            pos = pos.func_177972_a(side);
        }
        if (!player.func_175151_a(pos, side, held)) {
            return null;
        }
        if (pos.func_177956_o() == 255 && blockToPlace.func_185904_a().func_76220_a()) {
            return null;
        }
        if (world.func_190527_a(blockToPlace.func_177230_c(), pos, false, side, (Entity)player)) {
            return pos;
        }
        return null;
    }
}

