/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.conduits.conduit.item;

import crazypants.enderio.base.EnderIO;
import crazypants.enderio.conduits.conduit.item.IInventoryDatabaseServer;
import crazypants.enderio.conduits.conduit.item.IServerItemEntry;
import crazypants.enderio.conduits.conduit.item.SlotKey;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.BlockPos;

public abstract class AbstractInventory {
    static final SlotKey[] NO_SLOTS = new SlotKey[0];
    protected SlotKey[] slotKeys = NO_SLOTS;
    protected long nextScan = -1L;
    protected boolean taggedForScanning = false;
    protected float taggingbias = 0.0f;
    protected boolean inScan = false;

    protected void markForScanning() {
        this.taggedForScanning = true;
    }

    public void markForScanning(BlockPos pos) {
    }

    public boolean shouldBeScannedNow(long now) {
        return this.taggedForScanning || this.nextScan <= now;
    }

    public void markScanned() {
        this.nextScan = EnderIO.proxy.getServerTickCount() + (long)Math.max(Math.min(1 + (this.slotKeys.length + 8) / 9, 1200), 30);
        if (this.taggingbias > 50.0f) {
            this.nextScan += 2400L;
        } else if (this.taggingbias > 5.0f) {
            this.nextScan += 300L;
        }
        this.taggedForScanning = false;
        this.inScan = false;
    }

    private void onChangeFound() {
        if (!this.inScan) {
            this.inScan = true;
            this.taggingbias = this.taggedForScanning ? (this.taggingbias += 1.0f) : (float)((double)this.taggingbias * 0.5);
        }
    }

    protected void setEmpty(IInventoryDatabaseServer db) {
        if (this.slotKeys.length != 0) {
            this.reset(db, 0);
        }
    }

    protected void reset(IInventoryDatabaseServer db, int count) {
        for (SlotKey slotKey : this.slotKeys) {
            if (slotKey == null) continue;
            slotKey.remove(db);
        }
        this.slotKeys = new SlotKey[count];
    }

    protected void updateSlot(IInventoryDatabaseServer db, int slot, ItemStack stack) {
        if (stack == null) {
            this.emptySlot(db, slot);
        } else {
            this.updateSlot(db, slot, stack, stack.func_190916_E());
        }
    }

    protected void updateSlot(IInventoryDatabaseServer db, int slot, ItemStack stack, int count) {
        SlotKey slotKey = this.slotKeys[slot];
        IServerItemEntry current = slotKey != null ? slotKey.item : null;
        IServerItemEntry key = db.lookupItem(stack, current, true);
        if (key != current) {
            this.onChangeFound();
            this.updateSlotKey(db, slot, slotKey, key, count);
        } else if (slotKey != null && slotKey.count != count) {
            this.onChangeFound();
            slotKey.count = count;
            db.entryChanged(current);
        }
    }

    protected void emptySlot(IInventoryDatabaseServer db, int slot) {
        SlotKey slotKey = this.slotKeys[slot];
        if (slotKey != null) {
            this.onChangeFound();
            slotKey.remove(db);
            this.slotKeys[slot] = null;
        }
    }

    private void updateSlotKey(IInventoryDatabaseServer db, int slot, SlotKey slotKey, IServerItemEntry key, int count) {
        if (slotKey != null) {
            slotKey.remove(db);
            slotKey = null;
        }
        if (key != null) {
            slotKey = new SlotKey(this, slot, key, count);
            key.addSlot(slotKey);
            db.entryChanged(key);
        }
        this.slotKeys[slot] = slotKey;
    }

    protected void updateCount(IInventoryDatabaseServer db, int slot, IServerItemEntry entry, int count) {
        SlotKey slotKey = this.slotKeys[slot];
        if (slotKey != null && slotKey.count != count && slotKey.item == entry) {
            if (count == 0) {
                slotKey.remove(db);
                this.slotKeys[slot] = null;
            } else {
                slotKey.count = count;
                db.entryChanged(slotKey.item);
            }
        }
    }

    public abstract int scanInventory(IInventoryDatabaseServer var1);

    public abstract int extractItem(IInventoryDatabaseServer var1, IServerItemEntry var2, int var3, int var4);
}

