/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.conduits.conduit;

import com.enderio.core.common.NBTAction;
import crazypants.enderio.base.Log;
import crazypants.enderio.base.conduit.ConduitUtil;
import crazypants.enderio.base.conduit.IConduit;
import crazypants.enderio.base.conduit.IServerConduit;
import crazypants.enderio.util.NbtValue;
import info.loenwind.autosave.Registry;
import info.loenwind.autosave.exceptions.NoHandlerFoundException;
import info.loenwind.autosave.handlers.IHandler;
import info.loenwind.autosave.handlers.java.HandleAbstractCollection;
import java.lang.reflect.Field;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;

public class ConduitHandler
implements IHandler<IConduit> {
    @Override
    public boolean canHandle(Class<?> clazz) {
        return ConduitHandler.class.isAssignableFrom(clazz);
    }

    @Override
    public boolean store(@Nonnull Registry registry, @Nonnull Set<NBTAction> phase, @Nonnull NBTTagCompound nbt, @Nonnull String name, @Nonnull IConduit object) throws IllegalArgumentException, IllegalAccessException, InstantiationException, NoHandlerFoundException {
        if (object instanceof IServerConduit) {
            NBTTagCompound root = new NBTTagCompound();
            ConduitUtil.writeToNBT((IServerConduit)object, root);
            nbt.func_74782_a(name, (NBTBase)root);
        } else {
            Log.error("Logic error: Attempting to store client conduit procy as NBT for phase(S) " + phase);
        }
        return true;
    }

    @Override
    public IConduit read(@Nonnull Registry registry, @Nonnull Set<NBTAction> phase, @Nonnull NBTTagCompound nbt, @Nullable Field field, @Nonnull String name, @Nullable IConduit object) throws IllegalArgumentException, IllegalAccessException, InstantiationException, NoHandlerFoundException {
        NBTTagCompound conduitTag;
        NBTTagCompound root;
        if (nbt.func_74764_b(name) && (object = this.read(phase, root = nbt.func_74775_l(name))) == null && (conduitTag = NbtValue.CONDUIT.getTag(root)) != null) {
            object = this.read(phase, conduitTag);
        }
        return object;
    }

    private IConduit read(@Nonnull Set<NBTAction> phase, @Nonnull NBTTagCompound conduitTag) {
        return phase.contains(NBTAction.CLIENT) ? ConduitUtil.readClientConduitFromNBT(conduitTag) : ConduitUtil.readConduitFromNBT(conduitTag);
    }

    static {
        Registry.GLOBAL_REGISTRY.register(new ConduitHandler());
    }

    public static class ConduitCopyOnWriteArrayListHandler
    extends HandleAbstractCollection<IConduit, CopyOnWriteArrayList<IConduit>> {
        public ConduitCopyOnWriteArrayListHandler() {
            super(new ConduitHandler());
        }

        @Override
        @Nonnull
        protected CopyOnWriteArrayList<IConduit> makeCollection() {
            return new CopyOnWriteArrayList<IConduit>();
        }

        @Override
        public CopyOnWriteArrayList<IConduit> read(@Nonnull Registry registry, @Nonnull Set<NBTAction> phase, @Nonnull NBTTagCompound nbt, @Nullable Field field, @Nonnull String name, @Nullable CopyOnWriteArrayList<IConduit> object) throws IllegalArgumentException, IllegalAccessException, InstantiationException, NoHandlerFoundException {
            CopyOnWriteArrayList<IConduit> result = super.read(registry, phase, nbt, field, name, object);
            if (result != null) {
                while (result.remove(null)) {
                }
            }
            return result;
        }
    }
}

