/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.conduits.conduit;

import com.enderio.core.common.util.NNList;
import com.enderio.core.common.util.NullHelper;
import crazypants.enderio.base.conduit.ConduitUtil;
import crazypants.enderio.base.conduit.ConnectionMode;
import crazypants.enderio.base.conduit.IClientConduit;
import crazypants.enderio.base.conduit.IConduit;
import crazypants.enderio.base.conduit.IConduitBundle;
import crazypants.enderio.base.conduit.IConduitNetwork;
import crazypants.enderio.base.conduit.IServerConduit;
import crazypants.enderio.base.conduit.RaytraceResult;
import crazypants.enderio.base.conduit.geom.CollidableCache;
import crazypants.enderio.base.conduit.geom.CollidableComponent;
import crazypants.enderio.base.conduit.geom.ConduitGeometryUtil;
import crazypants.enderio.base.conduit.registry.ConduitRegistry;
import crazypants.enderio.base.diagnostics.Prof;
import crazypants.enderio.conduits.render.BlockStateWrapperConduitBundle;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public abstract class AbstractConduit
implements IServerConduit,
IClientConduit.WithDefaultRendering {
    @Nonnull
    protected final Set<EnumFacing> conduitConnections = EnumSet.noneOf(EnumFacing.class);
    @Nonnull
    protected final Set<EnumFacing> externalConnections = EnumSet.noneOf(EnumFacing.class);
    public static final float STUB_WIDTH = 0.2f;
    public static final float STUB_HEIGHT = 0.2f;
    public static final float TRANSMISSION_SCALE = 0.3f;
    @Nullable
    protected IConduitBundle bundle;
    protected boolean active;
    protected List<CollidableComponent> collidables;
    @Nonnull
    protected final EnumMap<EnumFacing, ConnectionMode> conectionModes = new EnumMap(EnumFacing.class);
    protected boolean collidablesDirty = true;
    private boolean clientStateDirty = true;
    private boolean dodgyChangeSinceLastCallFlagForBundle = true;
    protected boolean connectionsDirty = true;
    protected boolean readFromNbt = false;
    private Integer lastExternalRedstoneLevel = null;

    protected AbstractConduit() {
    }

    @Override
    public boolean writeConnectionSettingsToNBT(@Nonnull EnumFacing dir, @Nonnull NBTTagCompound nbt) {
        if (!this.getExternalConnections().contains(dir)) {
            return false;
        }
        NBTTagCompound dataRoot = this.getNbtRootForType(nbt, true);
        dataRoot.func_74777_a("connectionMode", (short)this.getConnectionMode(dir).ordinal());
        this.writeTypeSettingsToNbt(dir, dataRoot);
        return true;
    }

    @Override
    public boolean readConduitSettingsFromNBT(@Nonnull EnumFacing dir, @Nonnull NBTTagCompound nbt) {
        if (!this.getExternalConnections().contains(dir)) {
            return false;
        }
        NBTTagCompound dataRoot = this.getNbtRootForType(nbt, false);
        if (dataRoot == null) {
            return false;
        }
        if (dataRoot.func_74764_b("connectionMode")) {
            ConnectionMode mode = (ConnectionMode)((Object)NullHelper.first((Object[])new ConnectionMode[]{ConnectionMode.values()[dataRoot.func_74765_d("connectionMode")], this.getDefaultConnectionMode()}));
            this.setConnectionMode(dir, mode);
        }
        this.readTypeSettings(dir, dataRoot);
        return true;
    }

    protected void readTypeSettings(@Nonnull EnumFacing dir, @Nonnull NBTTagCompound dataRoot) {
    }

    protected void writeTypeSettingsToNbt(@Nonnull EnumFacing dir, @Nonnull NBTTagCompound dataRoot) {
    }

    protected NBTTagCompound getNbtRootForType(@Nonnull NBTTagCompound nbt, boolean createIfNull) {
        Class<? extends IConduit> bt = this.getBaseConduitType();
        String dataRootName = (String)NullHelper.notnullJ((Object)bt.getSimpleName(), (String)"Class#getSimpleName");
        NBTTagCompound dataRoot = null;
        if (nbt.func_74764_b(dataRootName)) {
            dataRoot = nbt.func_74775_l(dataRootName);
        }
        if (dataRoot == null && createIfNull) {
            dataRoot = new NBTTagCompound();
            nbt.func_74782_a(dataRootName, (NBTBase)dataRoot);
        }
        return dataRoot;
    }

    @Override
    @Nonnull
    public ConnectionMode getConnectionMode(@Nonnull EnumFacing dir) {
        ConnectionMode res = this.conectionModes.get(dir);
        if (res == null) {
            return this.getDefaultConnectionMode();
        }
        return res;
    }

    @Nonnull
    protected ConnectionMode getDefaultConnectionMode() {
        return ConnectionMode.IN_OUT;
    }

    @Override
    public void setConnectionMode(@Nonnull EnumFacing dir, @Nonnull ConnectionMode mode) {
        ConnectionMode oldVal = this.conectionModes.get(dir);
        if (oldVal == mode) {
            return;
        }
        if (mode == this.getDefaultConnectionMode()) {
            this.conectionModes.remove(dir);
        } else {
            this.conectionModes.put(dir, mode);
        }
        this.connectionsChanged();
    }

    @Override
    public boolean supportsConnectionMode(@Nonnull ConnectionMode mode) {
        if (mode == this.getDefaultConnectionMode() && this.conectionModes.size() != 6) {
            return true;
        }
        for (ConnectionMode cm : this.conectionModes.values()) {
            if (cm != mode) continue;
            return true;
        }
        return false;
    }

    @Override
    @Nonnull
    public ConnectionMode getNextConnectionMode(@Nonnull EnumFacing dir) {
        ConnectionMode curMode = this.getConnectionMode(dir);
        ConnectionMode next = ConnectionMode.getNext(curMode);
        if (next == ConnectionMode.NOT_SET) {
            next = ConnectionMode.IN_OUT;
        }
        return next;
    }

    @Override
    @Nonnull
    public ConnectionMode getPreviousConnectionMode(@Nonnull EnumFacing dir) {
        ConnectionMode curMode = this.getConnectionMode(dir);
        ConnectionMode prev = ConnectionMode.getPrevious(curMode);
        if (prev == ConnectionMode.NOT_SET) {
            prev = ConnectionMode.DISABLED;
        }
        return prev;
    }

    @Override
    public boolean haveCollidablesChangedSinceLastCall() {
        if (this.dodgyChangeSinceLastCallFlagForBundle) {
            this.dodgyChangeSinceLastCallFlagForBundle = false;
            return true;
        }
        return false;
    }

    @Override
    public void setBundle(@Nullable IConduitBundle tileConduitBundle) {
        this.bundle = tileConduitBundle;
    }

    @Override
    @Nonnull
    public IConduitBundle getBundle() {
        return (IConduitBundle)NullHelper.notnull((Object)this.bundle, (String)"Logic error in conduit---no bundle set");
    }

    @Override
    @Nonnull
    public Set<EnumFacing> getConduitConnections() {
        return this.conduitConnections;
    }

    @Override
    public boolean containsConduitConnection(@Nonnull EnumFacing dir) {
        return this.conduitConnections.contains(dir);
    }

    @Override
    public void conduitConnectionAdded(@Nonnull EnumFacing fromDirection) {
        this.conduitConnections.add(fromDirection);
    }

    @Override
    public void conduitConnectionRemoved(@Nonnull EnumFacing fromDirection) {
        this.conduitConnections.remove(fromDirection);
    }

    @Override
    public boolean canConnectToConduit(@Nonnull EnumFacing direction, @Nonnull IConduit conduit) {
        return this.getConnectionMode(direction) != ConnectionMode.DISABLED && conduit.getConnectionMode(direction.func_176734_d()) != ConnectionMode.DISABLED;
    }

    @Override
    public boolean canConnectToExternal(@Nonnull EnumFacing direction, boolean ignoreConnectionMode) {
        return false;
    }

    @Override
    @Nonnull
    public Set<EnumFacing> getExternalConnections() {
        return this.externalConnections;
    }

    @Override
    public boolean hasExternalConnections() {
        return !this.externalConnections.isEmpty();
    }

    @Override
    public boolean hasConduitConnections() {
        return !this.conduitConnections.isEmpty();
    }

    @Override
    public boolean containsExternalConnection(@Nonnull EnumFacing dir) {
        return this.externalConnections.contains(dir);
    }

    @Override
    public void externalConnectionAdded(@Nonnull EnumFacing fromDirection) {
        this.externalConnections.add(fromDirection);
    }

    @Override
    public void externalConnectionRemoved(@Nonnull EnumFacing fromDirection) {
        this.externalConnections.remove(fromDirection);
    }

    @Override
    public boolean isActive() {
        return this.active;
    }

    @Override
    public void setActive(boolean active) {
        if (active != this.active) {
            this.clientStateDirty = true;
        }
        this.active = active;
    }

    @Override
    public void writeToNBT(@Nonnull NBTTagCompound conduitBody) {
        int i;
        int[] dirs = new int[this.conduitConnections.size()];
        Iterator<EnumFacing> cons = this.conduitConnections.iterator();
        for (i = 0; i < dirs.length; ++i) {
            dirs[i] = cons.next().ordinal();
        }
        conduitBody.func_74783_a("connections", dirs);
        dirs = new int[this.externalConnections.size()];
        cons = this.externalConnections.iterator();
        for (i = 0; i < dirs.length; ++i) {
            dirs[i] = cons.next().ordinal();
        }
        conduitBody.func_74783_a("externalConnections", dirs);
        conduitBody.func_74757_a("signalActive", this.active);
        if (this.conectionModes.size() > 0) {
            byte[] modes = new byte[6];
            int i2 = 0;
            NNList.NNIterator itr = NNList.FACING.fastIterator();
            while (itr.hasNext()) {
                modes[i2] = (byte)this.getConnectionMode((EnumFacing)itr.next()).ordinal();
                ++i2;
            }
            conduitBody.func_74773_a("conModes", modes);
        }
    }

    @Override
    public void readFromNBT(@Nonnull NBTTagCompound conduitBody) {
        int i;
        this.conduitConnections.clear();
        int[] dirs = conduitBody.func_74759_k("connections");
        for (i = 0; i < dirs.length; ++i) {
            this.conduitConnections.add(EnumFacing.values()[dirs[i]]);
        }
        this.externalConnections.clear();
        dirs = conduitBody.func_74759_k("externalConnections");
        for (i = 0; i < dirs.length; ++i) {
            this.externalConnections.add(EnumFacing.values()[dirs[i]]);
        }
        this.active = conduitBody.func_74767_n("signalActive");
        this.conectionModes.clear();
        byte[] modes = conduitBody.func_74770_j("conModes");
        if (modes.length == 6) {
            int i2 = 0;
            for (EnumFacing dir : EnumFacing.field_82609_l) {
                this.conectionModes.put(dir, ConnectionMode.values()[modes[i2]]);
                ++i2;
            }
        }
        this.readFromNbt = true;
    }

    @Override
    public int getLightValue() {
        return 0;
    }

    @Override
    public boolean onBlockActivated(@Nonnull EntityPlayer player, @Nonnull EnumHand hand, @Nonnull RaytraceResult res, @Nonnull List<RaytraceResult> all) {
        return false;
    }

    @Override
    public float getSelfIlluminationForState(@Nonnull CollidableComponent component) {
        return this.isActive() ? 1.0f : 0.0f;
    }

    @Override
    public float getTransmitionGeometryScale() {
        return 0.3f;
    }

    @Override
    public void onChunkUnload() {
        IConduitNetwork<?, ?> network = this.getNetwork();
        if (network != null) {
            network.destroyNetwork();
        }
    }

    @Override
    public void updateEntity(@Nonnull World world) {
        if (world.field_72995_K) {
            return;
        }
        Prof.start((IBlockAccess)world, "updateNetwork");
        this.updateNetwork(world);
        Prof.next((IBlockAccess)world, "updateConnections");
        this.updateConnections();
        this.readFromNbt = false;
        if (this.clientStateDirty) {
            this.getBundle().dirty();
            this.clientStateDirty = false;
        }
        Prof.stop((IBlockAccess)world);
    }

    private void updateConnections() {
        if (!this.connectionsDirty && !this.readFromNbt) {
            return;
        }
        boolean externalConnectionsChanged = false;
        ArrayList<EnumFacing> copy = new ArrayList<EnumFacing>(this.externalConnections);
        for (EnumFacing dir : copy) {
            if (this.canConnectToExternal(dir, false) && !this.readFromNbt) continue;
            this.externalConnectionRemoved(dir);
            externalConnectionsChanged = true;
        }
        for (EnumFacing dir : EnumFacing.field_82609_l) {
            if (this.conduitConnections.contains(dir) || this.externalConnections.contains(dir) || !this.canConnectToExternal(dir, false)) continue;
            this.externalConnectionAdded(dir);
            externalConnectionsChanged = true;
        }
        if (externalConnectionsChanged) {
            this.connectionsChanged();
        }
        this.connectionsDirty = false;
    }

    @Override
    public void connectionsChanged() {
        this.collidablesDirty = true;
        this.clientStateDirty = true;
        this.dodgyChangeSinceLastCallFlagForBundle = true;
    }

    protected void setClientStateDirty() {
        this.clientStateDirty = true;
    }

    protected void updateNetwork(World world) {
        BlockPos pos = this.getBundle().getLocation();
        if (this.getNetwork() == null && world.func_175667_e(pos)) {
            ConduitUtil.ensureValidNetwork(this);
            if (this.getNetwork() != null) {
                this.getNetwork().sendBlockUpdatesForEntireNetwork();
                if (this.readFromNbt) {
                    this.connectionsChanged();
                }
            }
        }
    }

    @Override
    public void onAddedToBundle() {
        TileEntity te = this.bundle.getEntity();
        World world = te.func_145831_w();
        this.conduitConnections.clear();
        for (EnumFacing dir : EnumFacing.field_82609_l) {
            IConduit neighbour = ConduitUtil.getConduit(world, te, dir, this.getBaseConduitType());
            if (!(neighbour instanceof IServerConduit) || !((IServerConduit)neighbour).canConnectToConduit(dir.func_176734_d(), this)) continue;
            this.conduitConnections.add(dir);
            ((IServerConduit)neighbour).conduitConnectionAdded(dir.func_176734_d());
            ((IServerConduit)neighbour).connectionsChanged();
        }
        this.externalConnections.clear();
        for (EnumFacing dir : EnumFacing.field_82609_l) {
            if (this.containsConduitConnection(dir) || !this.canConnectToExternal(dir, false)) continue;
            this.externalConnectionAdded(dir);
        }
        this.connectionsChanged();
    }

    @Override
    public void onAfterRemovedFromBundle() {
        TileEntity te = this.getBundle().getEntity();
        World world = te.func_145831_w();
        for (EnumFacing dir : this.conduitConnections) {
            IConduit neighbour = ConduitUtil.getConduit(world, te, dir, this.getBaseConduitType());
            if (!(neighbour instanceof IServerConduit)) continue;
            ((IServerConduit)neighbour).conduitConnectionRemoved(dir.func_176734_d());
            ((IServerConduit)neighbour).connectionsChanged();
        }
        this.conduitConnections.clear();
        if (!this.externalConnections.isEmpty()) {
            world.func_175685_c(te.func_174877_v(), te.func_145838_q(), true);
        }
        this.externalConnections.clear();
        IConduitNetwork<?, ?> network = this.getNetwork();
        if (network != null) {
            network.destroyNetwork();
        }
        this.connectionsChanged();
    }

    @Override
    public boolean onNeighborBlockChange(@Nonnull Block block) {
        if (block == ConduitRegistry.getConduitModObjectNN().getBlock()) {
            return false;
        }
        this.lastExternalRedstoneLevel = null;
        EnumSet<EnumFacing> newCons = EnumSet.noneOf(EnumFacing.class);
        for (EnumFacing dir : EnumFacing.field_82609_l) {
            if (this.containsConduitConnection(dir) || !this.canConnectToExternal(dir, false)) continue;
            newCons.add(dir);
        }
        if (newCons.size() != this.externalConnections.size()) {
            this.connectionsDirty = true;
            return true;
        }
        for (EnumFacing dir : this.externalConnections) {
            if (newCons.remove(dir)) continue;
            this.connectionsDirty = true;
            return true;
        }
        if (!newCons.isEmpty()) {
            this.connectionsDirty = true;
            return true;
        }
        return false;
    }

    @Override
    public boolean onNeighborChange(@Nonnull BlockPos neighbourPos) {
        return false;
    }

    @Override
    @Nonnull
    public Collection<CollidableComponent> createCollidables(@Nonnull CollidableCache.CacheKey key) {
        return (Collection)NullHelper.notnullJ(Collections.singletonList(new CollidableComponent(this.getCollidableType(), ConduitGeometryUtil.instance.getBoundingBox(this.getBaseConduitType(), key.dir, key.isStub, key.offset), key.dir, null)), (String)"Collections#singletonList");
    }

    @Override
    @Nonnull
    public Class<? extends IConduit> getCollidableType() {
        return this.getBaseConduitType();
    }

    @Nonnull
    public List<CollidableComponent> getCollidableComponents() {
        if (this.collidables != null && !this.collidablesDirty) {
            return this.collidables;
        }
        ArrayList<CollidableComponent> result = new ArrayList<CollidableComponent>();
        for (EnumFacing dir : EnumFacing.field_82609_l) {
            Collection<CollidableComponent> col = this.getCollidables(dir);
            if (col == null) continue;
            result.addAll(col);
        }
        this.collidables = result;
        this.collidablesDirty = false;
        return result;
    }

    protected boolean renderStub(@Nonnull EnumFacing dir) {
        return false;
    }

    private Collection<CollidableComponent> getCollidables(@Nonnull EnumFacing dir) {
        CollidableCache cc = CollidableCache.instance;
        Class<? extends IConduit> type = this.getCollidableType();
        if (this.isConnectedTo(dir) && this.getConnectionMode(dir) != ConnectionMode.DISABLED) {
            return cc.getCollidables(cc.createKey(type, this.getBundle().getOffset(this.getBaseConduitType(), dir), dir, this.renderStub(dir)), this);
        }
        return null;
    }

    @Override
    public boolean shouldMirrorTexture() {
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public void hashCodeForModelCaching(BlockStateWrapperConduitBundle.ConduitCacheKey hashCodes) {
        hashCodes.add(this.getClass());
        hashCodes.add(this.conduitConnections, this.externalConnections, this.conectionModes);
    }

    @Override
    public void invalidate() {
    }

    @Override
    public int getExternalRedstoneLevel() {
        if (this.lastExternalRedstoneLevel == null) {
            if (this.bundle == null) {
                return 0;
            }
            TileEntity te = this.getBundle().getEntity();
            this.lastExternalRedstoneLevel = ConduitUtil.isBlockIndirectlyGettingPoweredIfLoaded(te.func_145831_w(), te.func_174877_v());
        }
        return this.lastExternalRedstoneLevel;
    }

    public String toString() {
        return "AbstractConduit [getClass()=" + this.getClass() + ", lastExternalRedstoneLevel=" + this.lastExternalRedstoneLevel + ", getConduitConnections()=" + this.getConduitConnections() + ", getExternalConnections()=" + this.getExternalConnections() + ", getNetwork()=" + this.getNetwork() + "]";
    }
}

