/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.base.xp;

import javax.annotation.Nonnull;
import net.minecraft.entity.player.EntityPlayer;

public class XpUtil {
    public static final int RATIO = 20;
    private static final int[] xpmap = new int[21863];

    public static int liquidToExperience(int liquid) {
        return liquid / 20;
    }

    public static int experienceToLiquid(int xp) {
        return xp * 20;
    }

    public static int getLiquidForLevel(int level) {
        return XpUtil.experienceToLiquid(XpUtil.getExperienceForLevel(level));
    }

    public static int getExperienceForLevel(int level) {
        if (level <= 0) {
            return 0;
        }
        if (level >= 21863) {
            return Integer.MAX_VALUE;
        }
        return xpmap[level];
    }

    public static int getXpBarCapacity(int level) {
        if (level == 0) {
            return 0;
        }
        if (level <= 15) {
            return XpUtil.xpMath(level, 7, 2);
        }
        if (level <= 30) {
            return 315 + XpUtil.xpMath(level - 15, 37, 5);
        }
        return 1395 + XpUtil.xpMath(level - 30, 112, 9);
    }

    private static int xpMath(int n, int a, int d) {
        return n * (2 * a + (n - 1) * d) / 2;
    }

    public static int getLevelForExperience(int experience) {
        for (int i = 1; i < xpmap.length; ++i) {
            if (xpmap[i] <= experience) continue;
            return i - 1;
        }
        return xpmap.length;
    }

    public static int getPlayerXP(@Nonnull EntityPlayer player) {
        return (int)((float)XpUtil.getExperienceForLevel(player.field_71068_ca) + player.field_71106_cc * (float)player.func_71050_bK());
    }

    public static void addPlayerXP(@Nonnull EntityPlayer player, int amount) {
        int experience;
        player.field_71067_cb = experience = Math.max(0, XpUtil.getPlayerXP(player) + amount);
        player.field_71068_ca = XpUtil.getLevelForExperience(experience);
        int expForLevel = XpUtil.getExperienceForLevel(player.field_71068_ca);
        player.field_71106_cc = (float)(experience - expForLevel) / (float)player.func_71050_bK();
    }

    static {
        int res = 0;
        for (int i = 0; i < 21863; ++i) {
            if ((res += XpUtil.getXpBarCapacity(i)) < 0) {
                res = Integer.MAX_VALUE;
            }
            XpUtil.xpmap[i] = res;
        }
    }
}

