/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.base.recipe.vat;

import com.enderio.core.common.util.FluidUtil;
import com.enderio.core.common.util.NNList;
import crazypants.enderio.base.Log;
import crazypants.enderio.base.recipe.IRecipe;
import crazypants.enderio.base.recipe.IRecipeInput;
import crazypants.enderio.base.recipe.MachineRecipeInput;
import crazypants.enderio.base.recipe.MachineRecipeRegistry;
import crazypants.enderio.base.recipe.RecipeOutput;
import crazypants.enderio.base.recipe.vat.VatMachineRecipe;
import crazypants.enderio.base.recipe.vat.VatRecipe;
import crazypants.enderio.util.Prep;
import javax.annotation.Nonnull;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;

public class VatRecipeManager {
    @Nonnull
    static final VatRecipeManager instance = new VatRecipeManager();
    @Nonnull
    private final NNList<IRecipe> recipes = new NNList();

    @Nonnull
    public static VatRecipeManager getInstance() {
        return instance;
    }

    public void create() {
        MachineRecipeRegistry.instance.registerRecipe("vat", new VatMachineRecipe());
    }

    public IRecipe getRecipeForInput(@Nonnull NNList<MachineRecipeInput> inputs) {
        if (inputs.size() == 0) {
            return null;
        }
        for (IRecipe recipe : this.recipes) {
            if (!recipe.isInputForRecipe(inputs)) continue;
            return recipe;
        }
        return null;
    }

    public void addRecipe(@Nonnull IRecipe recipe) {
        if (!recipe.isValid()) {
            Log.debug("Could not add invalid Vat recipe: " + recipe);
            return;
        }
        this.recipes.add((Object)new VatRecipe(recipe));
    }

    @Nonnull
    public NNList<IRecipe> getRecipes() {
        return this.recipes;
    }

    public boolean isValidInput(@Nonnull MachineRecipeInput input) {
        for (IRecipe recipe : this.recipes) {
            if (Prep.isValid(input.item) && recipe.isValidInput(input.slotNumber, input.item)) {
                return true;
            }
            if (input.fluid == null || !recipe.isValidInput(input.fluid)) continue;
            return true;
        }
        return false;
    }

    public boolean isValidInput(@Nonnull NNList<MachineRecipeInput> inputs) {
        for (IRecipe recipe : this.recipes) {
            boolean allValid = true;
            for (MachineRecipeInput input : inputs) {
                if (Prep.isValid(input.item)) {
                    allValid = recipe.isValidInput(input.slotNumber, input.item);
                } else if (input.fluid != null) {
                    allValid = recipe.isValidInput(input.fluid);
                }
                if (allValid) continue;
                break;
            }
            if (!allValid) continue;
            return true;
        }
        return false;
    }

    public float getMultiplierForInput(Fluid inputFluid, @Nonnull ItemStack input, Fluid output) {
        if (Prep.isValid(input) || output != null) {
            for (IRecipe recipe : this.recipes) {
                RecipeOutput out = recipe.getOutputs()[0];
                IRecipeInput in = recipe.getInputs()[recipe.getInputs().length - 1];
                FluidStack fluidOutput = out.getFluidOutput();
                if (inputFluid != null && (!FluidUtil.areFluidsTheSame((Fluid)in.getFluidInput().getFluid(), (Fluid)inputFluid) || output != null && (fluidOutput == null || !FluidUtil.areFluidsTheSame((Fluid)fluidOutput.getFluid(), (Fluid)output)))) continue;
                for (IRecipeInput ri : recipe.getInputs()) {
                    if (!ri.isInput(input)) continue;
                    return ri.getMulitplier();
                }
            }
        }
        float found = -1.0f;
        for (IRecipe recipe : this.recipes) {
            for (IRecipeInput ri : recipe.getInputs()) {
                if (!ri.isInput(input) || !(found < 0.0f) && !(found > ri.getMulitplier())) continue;
                found = ri.getMulitplier();
            }
        }
        return found > 0.0f ? found : 0.0f;
    }
}

