/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.base.recipe.painter;

import crazypants.enderio.base.conduit.facade.ItemConduitFacade;
import crazypants.enderio.base.paint.PaintUtil;
import crazypants.enderio.base.recipe.IMachineRecipe;
import crazypants.enderio.base.recipe.MachineRecipeInput;
import crazypants.enderio.base.recipe.painter.AbstractPainterTemplate;
import crazypants.enderio.util.Prep;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.item.ItemStack;

public class FacadePainterRecipe
extends AbstractPainterTemplate<ItemConduitFacade> {
    public FacadePainterRecipe(ItemConduitFacade facade) {
        PaintUtil.registerPaintable(facade);
    }

    @Override
    public boolean isValidTarget(@Nonnull ItemStack target) {
        return Prep.isValid(target) && target.func_77973_b() instanceof ItemConduitFacade;
    }

    @Override
    @Nonnull
    public IMachineRecipe.ResultStack[] getCompletedResult(@Nonnull ItemStack paintSource, @Nonnull ItemStack target) {
        if (Prep.isInvalid(target) || Prep.isInvalid(paintSource)) {
            return new IMachineRecipe.ResultStack[0];
        }
        Block paintBlock = PaintUtil.getBlockFromItem(paintSource);
        if (paintBlock == null) {
            return new IMachineRecipe.ResultStack[0];
        }
        IBlockState paintState = PaintUtil.Block$getBlockFromItem_stack$getItem___$getStateFromMeta_stack$getMetadata___(paintSource, paintBlock);
        if (paintState == null) {
            return new IMachineRecipe.ResultStack[0];
        }
        ItemStack result = target.func_77946_l();
        result.func_190920_e(1);
        PaintUtil.setSourceBlock(result, paintState);
        return new IMachineRecipe.ResultStack[]{new IMachineRecipe.ResultStack(result)};
    }

    @Override
    public boolean isRecipe(@Nonnull ItemStack paintSource, @Nonnull ItemStack target) {
        return this.isValidTarget(target) && this.isValidPaint(paintSource);
    }

    @Override
    public boolean isPartialRecipe(@Nonnull ItemStack paintSource, @Nonnull ItemStack target) {
        if (Prep.isInvalid(paintSource)) {
            return this.isValidTarget(target);
        }
        if (Prep.isInvalid(target)) {
            return this.isValidPaint(paintSource);
        }
        return this.isValidTarget(target) && this.isValidPaint(paintSource);
    }

    protected boolean isValidPaint(@Nonnull ItemStack paintSource) {
        return Prep.isValid(paintSource) && PaintUtil.isValid(paintSource, null);
    }

    @Override
    public boolean isValidInput(@Nonnull MachineRecipeInput input) {
        if (input.slotNumber == 0) {
            return this.isValidTarget(input.item);
        }
        if (input.slotNumber == 1) {
            return this.isValidPaint(input.item);
        }
        return false;
    }

    @Override
    protected void registerTargetsWithTooltipProvider() {
    }
}

