/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.base.recipe.painter;

import com.enderio.core.common.util.NNList;
import crazypants.enderio.base.config.config.RecipeConfig;
import crazypants.enderio.base.recipe.IMachineRecipe;
import crazypants.enderio.base.recipe.MachineRecipeInput;
import crazypants.enderio.base.recipe.RecipeBonusType;
import crazypants.enderio.util.Prep;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.item.ItemStack;

public abstract class AbstractPainterTemplate<T>
implements IMachineRecipe {
    public AbstractPainterTemplate() {
        this.registerTargetsWithTooltipProvider();
    }

    protected abstract void registerTargetsWithTooltipProvider();

    public abstract boolean isValidTarget(@Nonnull ItemStack var1);

    @Nonnull
    public abstract IMachineRecipe.ResultStack[] getCompletedResult(@Nonnull ItemStack var1, @Nonnull ItemStack var2);

    public abstract boolean isRecipe(@Nonnull ItemStack var1, @Nonnull ItemStack var2);

    public abstract boolean isPartialRecipe(@Nonnull ItemStack var1, @Nonnull ItemStack var2);

    @Override
    public int getEnergyRequired(@Nonnull NNList<MachineRecipeInput> inputs) {
        return RecipeConfig.energyPerTask.get();
    }

    @Override
    @Nonnull
    public RecipeBonusType getBonusType(@Nonnull NNList<MachineRecipeInput> inputs) {
        return RecipeBonusType.NONE;
    }

    @Nonnull
    public ItemStack getTarget(@Nonnull NNList<MachineRecipeInput> inputs) {
        return MachineRecipeInput.getInputForSlot(0, inputs);
    }

    @Nonnull
    public ItemStack getPaintSource(@Nonnull NNList<MachineRecipeInput> inputs) {
        return MachineRecipeInput.getInputForSlot(1, inputs);
    }

    @Override
    public final boolean isRecipe(@Nonnull NNList<MachineRecipeInput> inputs) {
        return this.isRecipe(this.getPaintSource(inputs), this.getTarget(inputs));
    }

    @Override
    @Nonnull
    public final IMachineRecipe.ResultStack[] getCompletedResult(long nextSeed, float chanceMultiplier, @Nonnull NNList<MachineRecipeInput> inputs) {
        return this.getCompletedResult(this.getPaintSource(inputs), this.getTarget(inputs));
    }

    @Override
    @Nonnull
    public String getMachineName() {
        return "painter";
    }

    @Override
    @Nonnull
    public String getUid() {
        return this.getClass().getCanonicalName() + "@" + Integer.toHexString(this.hashCode());
    }

    public int getQuantityConsumed(@Nonnull MachineRecipeInput input) {
        return input.slotNumber == 0 ? 1 : 0;
    }

    @Override
    @Nonnull
    public List<MachineRecipeInput> getQuantitiesConsumed(@Nonnull NNList<MachineRecipeInput> inputs) {
        MachineRecipeInput consume = null;
        for (MachineRecipeInput input : inputs) {
            if (input == null || input.slotNumber != 0 || !Prep.isValid(input.item)) continue;
            ItemStack consumed = input.item.func_77946_l();
            consumed.func_190920_e(1);
            consume = new MachineRecipeInput(input.slotNumber, consumed);
        }
        if (consume != null) {
            return Collections.singletonList(consume);
        }
        return Collections.emptyList();
    }

    @Override
    public float getExperienceForOutput(@Nonnull ItemStack output) {
        return 0.0f;
    }

    @Override
    public abstract boolean isValidInput(@Nonnull MachineRecipeInput var1);
}

