/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.base.recipe;

import com.enderio.core.common.util.NNList;
import crazypants.enderio.base.recipe.IManyToOneRecipe;
import crazypants.enderio.base.recipe.IRecipeInput;
import crazypants.enderio.base.recipe.MachineRecipeInput;
import crazypants.enderio.base.recipe.Recipe;
import crazypants.enderio.base.recipe.RecipeBonusType;
import crazypants.enderio.base.recipe.RecipeOutput;
import crazypants.enderio.util.Prep;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.FluidStack;

public class BasicManyToOneRecipe
implements IManyToOneRecipe {
    private final int energyRequired;
    @Nonnull
    private final ItemStack output;
    @Nonnull
    private final RecipeBonusType bonusType;
    @Nonnull
    private final Recipe recipe;
    private boolean synthetic = false;

    public BasicManyToOneRecipe(@Nonnull Recipe recipe) {
        this.recipe = recipe;
        this.output = recipe.getOutputs()[0].getOutput().func_77946_l();
        this.energyRequired = recipe.getEnergyRequired();
        this.bonusType = recipe.getBonusType();
    }

    @Override
    public boolean isValidRecipeComponents(ItemStack ... items) {
        NNList inputs = new NNList((Object[])this.recipe.getInputs());
        for (ItemStack is : items) {
            if (is == null || !Prep.isValid(is)) continue;
            IRecipeInput remove = null;
            for (IRecipeInput ri : inputs) {
                if (!ri.isInput(is)) continue;
                remove = ri;
                break;
            }
            if (remove != null) {
                inputs.remove(remove);
                continue;
            }
            return false;
        }
        return true;
    }

    @Override
    @Nonnull
    public ItemStack getOutput() {
        return this.output;
    }

    @Override
    public boolean isValidInput(int slot, @Nonnull ItemStack input) {
        if (Prep.isInvalid(input)) {
            return false;
        }
        return this.getRecipeComponentFromInput(input) != null;
    }

    @Override
    public boolean isValidInput(@Nonnull FluidStack fluid) {
        return false;
    }

    @Override
    public boolean isValid() {
        return this.recipe.isValid();
    }

    @Override
    public int getEnergyRequired() {
        return this.energyRequired;
    }

    @Override
    @Nonnull
    public RecipeBonusType getBonusType() {
        return this.bonusType;
    }

    @Override
    @Nonnull
    public RecipeOutput[] getOutputs() {
        return this.recipe.getOutputs();
    }

    @Override
    @Nonnull
    public NNList<ItemStack> getInputStacks() {
        return this.recipe.getInputStacks();
    }

    @Override
    public boolean isInputForRecipe(NNList<MachineRecipeInput> inputs) {
        if (inputs == null) {
            return false;
        }
        return this.recipe.isInputForRecipe(inputs);
    }

    @Override
    @Nonnull
    public IRecipeInput[] getInputs() {
        return this.recipe.getInputs();
    }

    @Override
    public NNList<FluidStack> getInputFluidStacks() {
        return NNList.emptyList();
    }

    private ItemStack getRecipeComponentFromInput(@Nonnull ItemStack input) {
        if (Prep.isInvalid(input)) {
            return null;
        }
        for (IRecipeInput ri : this.recipe.getInputs()) {
            if (!ri.isInput(input)) continue;
            return ri.getInput();
        }
        return null;
    }

    @Override
    @Nonnull
    public NNList<List<ItemStack>> getInputStackAlternatives() {
        return this.recipe.getInputStackAlternatives();
    }

    public String toString() {
        return "BasicManyToOneRecipe [output=" + this.output + ", recipe=" + this.recipe + "]";
    }

    @Override
    public boolean isSynthetic() {
        return this.synthetic;
    }

    public BasicManyToOneRecipe setSynthetic() {
        this.synthetic = true;
        return this;
    }
}

