/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.base.power.wireless;

import com.enderio.core.common.util.BlockCoord;
import com.enderio.core.common.util.NNList;
import com.enderio.core.common.util.NullHelper;
import crazypants.enderio.base.config.config.ChargerConfig;
import crazypants.enderio.base.integration.baubles.BaublesUtil;
import crazypants.enderio.base.power.wireless.IWirelessCharger;
import crazypants.enderio.util.Prep;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nonnull;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.relauncher.Side;

@Mod.EventBusSubscriber(modid="enderio")
public class WirelessChargerController {
    @Nonnull
    public static WirelessChargerController instance = new WirelessChargerController();
    @Nonnull
    private final Map<Integer, Map<BlockPos, IWirelessCharger>> perWorldChargers = new HashMap<Integer, Map<BlockPos, IWirelessCharger>>();
    private int changeCount;

    private WirelessChargerController() {
    }

    public void registerCharger(@Nonnull IWirelessCharger charger) {
        Map<BlockPos, IWirelessCharger> chargers = this.getChargersForWorld(charger.getworld());
        chargers.put(charger.getLocation(), charger);
        ++this.changeCount;
    }

    public void deregisterCharger(@Nonnull IWirelessCharger charger) {
        Map<BlockPos, IWirelessCharger> chargers = this.getChargersForWorld(charger.getworld());
        chargers.remove(charger.getLocation());
        ++this.changeCount;
    }

    @SubscribeEvent
    public static void onPlayerTick(TickEvent.PlayerTickEvent event) {
        if (event.side == Side.CLIENT || event.phase != TickEvent.Phase.END || event.player.func_175149_v()) {
            return;
        }
        instance.chargePlayersItems((EntityPlayer)NullHelper.notnullF((Object)event.player, (String)"TickEvent.PlayerTickEvent without player"));
    }

    public int getChangeCount() {
        return this.changeCount;
    }

    public void getChargers(@Nonnull World world, @Nonnull BlockPos pos, @Nonnull Collection<IWirelessCharger> res) {
        Map<BlockPos, IWirelessCharger> chargers = this.getChargersForWorld(world);
        for (IWirelessCharger wc : chargers.values()) {
            if (!this.inRange(wc.getLocation(), pos)) continue;
            res.add(wc);
        }
    }

    public void chargePlayersItems(@Nonnull EntityPlayer player) {
        Map<BlockPos, IWirelessCharger> chargers = this.getChargersForWorld(player.field_70170_p);
        if (chargers.isEmpty()) {
            return;
        }
        BlockPos pos = BlockCoord.get((Entity)player);
        for (IWirelessCharger charger : chargers.values()) {
            boolean done;
            if (!charger.isActive() || !this.inRange(charger.getLocation(), pos) || !(done = this.chargeFromCapBank(player, charger))) continue;
            return;
        }
    }

    private boolean inRange(BlockPos a, BlockPos b) {
        int RANGE = ChargerConfig.wirelessRange.get();
        int dx = a.func_177958_n() - b.func_177958_n();
        if (dx > RANGE || dx < -RANGE) {
            return false;
        }
        int dz = a.func_177952_p() - b.func_177952_p();
        if (dz > RANGE || dz < -RANGE) {
            return false;
        }
        int dy = a.func_177956_o() - b.func_177956_o();
        return dx * dx + dy * dy + dz * dz <= RANGE * RANGE;
    }

    private boolean chargeFromCapBank(@Nonnull EntityPlayer player, @Nonnull IWirelessCharger charger) {
        boolean res = charger.chargeItems((NonNullList<ItemStack>)player.field_71071_by.field_70460_b);
        res |= charger.chargeItems((NonNullList<ItemStack>)player.field_71071_by.field_70462_a);
        res |= charger.chargeItems((NonNullList<ItemStack>)player.field_71071_by.field_184439_c);
        IInventory baubles = BaublesUtil.instance().getBaubles(player);
        if (baubles != null) {
            for (int i = 0; i < baubles.func_70302_i_(); ++i) {
                ItemStack item = baubles.func_70301_a(i);
                if (!Prep.isValid(item)) continue;
                item = item.func_77946_l();
                if (!charger.chargeItems((NonNullList<ItemStack>)new NNList((Object[])new ItemStack[]{item}))) continue;
                baubles.func_70299_a(i, item);
                res = true;
            }
        }
        if (res) {
            player.field_71069_bz.func_75142_b();
        }
        return res;
    }

    @Nonnull
    private Map<BlockPos, IWirelessCharger> getChargersForWorld(@Nonnull World world) {
        Map<BlockPos, IWirelessCharger> res = this.perWorldChargers.get(world.field_73011_w.getDimension());
        if (res == null) {
            res = new HashMap<BlockPos, IWirelessCharger>();
            this.perWorldChargers.put(world.field_73011_w.getDimension(), res);
        }
        return res;
    }

    public Collection<IWirelessCharger> getChargers(@Nonnull World world) {
        return this.getChargerMap(world).values();
    }

    public Map<BlockPos, IWirelessCharger> getChargerMap(@Nonnull World world) {
        return this.perWorldChargers.get(world.field_73011_w.getDimension());
    }
}

