/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.base.power.wireless;

import com.enderio.core.common.util.NNList;
import crazypants.enderio.base.power.wireless.IWirelessCharger;
import crazypants.enderio.base.power.wireless.WirelessChargerController;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import javax.annotation.Nonnull;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;

public class WirelessChargedLocation {
    @Nonnull
    private final TileEntity te;
    private int lastChangeCount;
    @Nonnull
    private final NNList<IWirelessCharger> chargers;

    public WirelessChargedLocation(@Nonnull TileEntity te) {
        this.te = te;
        this.chargers = new NNList();
        this.lastChangeCount = WirelessChargerController.instance.getChangeCount() - 1;
    }

    private void updateChargers() {
        WirelessChargerController wcc = WirelessChargerController.instance;
        this.chargers.clear();
        this.lastChangeCount = wcc.getChangeCount();
        final BlockPos bc = this.te.func_174877_v();
        wcc.getChargers(this.te.func_145831_w(), bc, (Collection<IWirelessCharger>)this.chargers);
        Collections.sort(this.chargers, new Comparator<IWirelessCharger>(){

            @Override
            public int compare(IWirelessCharger o1, IWirelessCharger o2) {
                double dist1 = o1.getLocation().func_177951_i((Vec3i)bc);
                double dist2 = o2.getLocation().func_177951_i((Vec3i)bc);
                return Double.compare(dist1, dist2);
            }
        });
    }

    private void checkChangeCount() {
        if (this.lastChangeCount != WirelessChargerController.instance.getChangeCount()) {
            this.updateChargers();
        }
    }

    public boolean chargeItems(NonNullList<ItemStack> items) {
        this.checkChangeCount();
        for (IWirelessCharger wc : this.chargers) {
            if (!wc.isActive() || !wc.chargeItems(items)) continue;
            return true;
        }
        return false;
    }

    public int takeEnergy(int max) {
        IWirelessCharger wc;
        this.checkChangeCount();
        int charged = 0;
        NNList.NNIterator nNIterator = this.chargers.iterator();
        while (nNIterator.hasNext() && (!(wc = (IWirelessCharger)nNIterator.next()).isActive() || (charged += wc.takeEnergy(max - charged)) < max)) {
        }
        return charged;
    }
}

