/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.base.power;

import com.enderio.core.common.util.NNList;
import crazypants.enderio.base.machine.base.te.AbstractMachineEntity;
import crazypants.enderio.base.power.IPowerInterface;
import crazypants.enderio.base.power.PowerHandlerUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import javax.annotation.Nonnull;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.ICapabilityProvider;

public class PowerDistributor
implements NNList.Callback<EnumFacing> {
    @Nonnull
    private final List<Receptor> receptors = new ArrayList<Receptor>();
    private ListIterator<Receptor> receptorIterator = this.receptors.listIterator();
    private boolean receptorsDirty = true;
    @Nonnull
    private final BlockPos bc;
    private TileEntity transmitter;

    public PowerDistributor(@Nonnull BlockPos bc) {
        this.bc = bc;
    }

    public void neighboursChanged() {
        this.receptorsDirty = true;
    }

    public int transmitEnergy(@Nonnull World world, int available) {
        int transmitted = 0;
        this.checkReceptors(world);
        if (!this.receptors.isEmpty() && !this.receptorIterator.hasNext()) {
            this.receptorIterator = this.receptors.listIterator();
        }
        int numReceptors = this.receptors.size();
        for (int appliedCount = 0; this.receptorIterator.hasNext() && available > 0 && appliedCount < numReceptors; ++appliedCount) {
            Receptor receptor = this.receptorIterator.next();
            IPowerInterface pp = receptor.receptor;
            int used = pp.receiveEnergy(available, false);
            transmitted += used;
            if ((available -= used) <= 0) break;
            if (this.receptors.isEmpty() || this.receptorIterator.hasNext()) continue;
            this.receptorIterator = this.receptors.listIterator();
        }
        return transmitted;
    }

    private void checkReceptors(@Nonnull World world) {
        if (!this.receptorsDirty) {
            return;
        }
        this.receptors.clear();
        this.transmitter = world.func_175625_s(this.bc);
        NNList.FACING.apply((NNList.Callback)this);
        this.receptorIterator = this.receptors.listIterator();
        this.receptorsDirty = false;
    }

    public void apply(@Nonnull EnumFacing dir) {
        IPowerInterface pi;
        if ((!(this.transmitter instanceof AbstractMachineEntity) || ((AbstractMachineEntity)this.transmitter).getIoMode(dir).canOutput()) && (pi = PowerHandlerUtil.getPowerInterface((ICapabilityProvider)this.transmitter.func_145831_w().func_175625_s(this.bc.func_177972_a(dir)), dir.func_176734_d())) != null) {
            this.receptors.add(new Receptor(pi, dir));
        }
    }

    static class Receptor {
        @Nonnull
        IPowerInterface receptor;
        @Nonnull
        EnumFacing fromDir;

        private Receptor(@Nonnull IPowerInterface rec, @Nonnull EnumFacing fromDir) {
            this.receptor = rec;
            this.fromDir = fromDir;
        }
    }
}

