/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.base.paint;

import com.enderio.core.common.util.FluidUtil;
import com.enderio.core.common.util.stackable.Things;
import crazypants.enderio.base.lang.Lang;
import crazypants.enderio.base.paint.IPaintable;
import crazypants.enderio.base.paint.PaintSourceValidator;
import crazypants.enderio.util.NbtValue;
import crazypants.enderio.util.Prep;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockLog;
import net.minecraft.block.BlockSlab;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyDirection;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemPiston;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraftforge.fluids.FluidStack;

public class PaintUtil {
    private static final BlockRenderLayer BREAKING = null;
    private static Things paintables = new Things();

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static boolean isValid(@Nonnull ItemStack paintSource, Block target) {
        boolean solidPaint = false;
        boolean textureOnly = false;
        if (Prep.isValid(paintSource)) {
            if (!PaintSourceValidator.instance.isValidSourceDefault(paintSource)) {
                return false;
            }
            Block block = PaintUtil.getBlockFromItem(paintSource);
            if (block == null) return false;
            if (block == Blocks.field_150350_a) {
                return false;
            }
            IBlockState bs = PaintUtil.Block$getBlockFromItem_stack$getItem___$getStateFromMeta_stack$getMetadata___(paintSource, block);
            solidPaint = bs.func_185914_p();
            if (!PaintUtil.shouldHaveModel(block)) {
                if (!PaintUtil.shouldHaveTexture(block)) return false;
                textureOnly = true;
            } else if (block instanceof IPaintable && (bs = ((IPaintable)block).getPaintSource(block, paintSource)) != null) {
                return false;
            }
        }
        if (target == null) {
            return Prep.isValid(paintSource);
        }
        if (Prep.isInvalid(paintSource)) {
            return target instanceof IPaintable;
        }
        if (target instanceof IPaintable.ITexturePaintableBlock) {
            return true;
        }
        if (target instanceof IPaintable.ISolidBlockPaintableBlock) {
            if (!solidPaint) return false;
            if (textureOnly) return false;
            return true;
        }
        if (target instanceof IPaintable.INonSolidBlockPaintableBlock) {
            if (solidPaint) return false;
            if (textureOnly) return false;
            return true;
        }
        if (!(target instanceof IPaintable.IBlockPaintableBlock)) return false;
        if (textureOnly) return false;
        return true;
    }

    public static IBlockState rotate(@Nonnull IBlockState paintSource) {
        for (IProperty prop : paintSource.func_177227_a()) {
            if (prop instanceof PropertyDirection) {
                return paintSource.func_177231_a(prop);
            }
            if (prop != BlockSlab.field_176554_a) continue;
            return paintSource.func_177231_a(prop);
        }
        if (paintSource.func_177230_c() instanceof BlockLog) {
            return paintSource.func_177231_a((IProperty)BlockLog.field_176299_a);
        }
        return paintSource;
    }

    public static void writeNbt(NBTTagCompound nbtRoot, IBlockState paintSource) {
        if (nbtRoot == null) {
            return;
        }
        if (paintSource == null) {
            NbtValue.BLOCKSTATE.removeTag(nbtRoot);
        } else {
            NbtValue.BLOCKSTATE.setTag(nbtRoot, NBTUtil.func_190009_a((NBTTagCompound)new NBTTagCompound(), (IBlockState)paintSource));
        }
    }

    public static IBlockState readNbt(NBTTagCompound nbtRoot) {
        IBlockState paint;
        NBTTagCompound tag;
        if (NbtValue.BLOCKSTATE.hasTag(nbtRoot) && (tag = NbtValue.BLOCKSTATE.getTag(nbtRoot)) != null && (paint = NBTUtil.func_190008_d((NBTTagCompound)tag)) != Blocks.field_150350_a.func_176223_P()) {
            return paint;
        }
        return null;
    }

    public static boolean isPainted(@Nonnull ItemStack itemStack) {
        return NbtValue.BLOCKSTATE.hasTag(itemStack);
    }

    public static IBlockState getSourceBlock(@Nonnull ItemStack itemStack) {
        return PaintUtil.readNbt(itemStack.func_77978_p());
    }

    public static void setSourceBlock(@Nonnull ItemStack itemStack, IBlockState paintSource) {
        if (Prep.isInvalid(itemStack)) {
            return;
        }
        if (paintSource == null || paintSource == Blocks.field_150350_a) {
            NbtValue.BLOCKSTATE.removeTag(itemStack);
            return;
        }
        NbtValue.BLOCKSTATE.setTag(itemStack, NBTUtil.func_190009_a((NBTTagCompound)new NBTTagCompound(), (IBlockState)paintSource));
    }

    public static String getTooltTipText(@Nonnull ItemStack itemStack) {
        String sourceName = null;
        if (itemStack.func_77973_b() instanceof IWithPaintName) {
            sourceName = ((IWithPaintName)itemStack.func_77973_b()).getPaintName(itemStack);
        } else {
            Block block;
            IBlockState state = PaintUtil.getSourceBlock(itemStack);
            if (state != null && (block = state.func_177230_c()) != Blocks.field_150350_a) {
                Item itemFromBlock = Item.func_150898_a((Block)block);
                if (itemFromBlock != Items.field_190931_a) {
                    ItemStack is = new ItemStack(itemFromBlock, 1, block.func_176201_c(state));
                    sourceName = is.func_82833_r();
                } else {
                    sourceName = block.func_149732_F();
                }
            }
        }
        if (sourceName == null || sourceName.isEmpty()) {
            return Lang.PAINTED_NOT.get();
        }
        return Lang.PAINTED_WITH.get(sourceName);
    }

    @Nonnull
    public static ItemStack getPaintAsStack(IBlockState state) {
        Block block;
        Item itemFromBlock;
        if (state != null && (itemFromBlock = Item.func_150898_a((Block)(block = state.func_177230_c()))) != Items.field_190931_a) {
            return new ItemStack(itemFromBlock, 1, block.func_176201_c(state));
        }
        return Prep.getEmpty();
    }

    public static boolean shouldHaveModel(Block block) {
        if (block == null) {
            return false;
        }
        return block.func_176223_P().func_185901_i() == EnumBlockRenderType.MODEL;
    }

    public static boolean shouldHaveTexture(Block block) {
        if (block == null) {
            return false;
        }
        EnumBlockRenderType rt = block.func_176223_P().func_185901_i();
        return rt != EnumBlockRenderType.INVISIBLE;
    }

    public static Block getBlockFromItem(Item itemIn) {
        if (itemIn != null) {
            if (itemIn instanceof ItemBlock) {
                return ((ItemBlock)itemIn).func_179223_d();
            }
            FluidStack fluidStack = FluidUtil.getFluidTypeFromItem((ItemStack)new ItemStack(itemIn));
            if (fluidStack != null) {
                return fluidStack.getFluid().getBlock();
            }
        }
        return null;
    }

    public static Block getBlockFromItem(@Nonnull ItemStack itemStack) {
        if (Prep.isValid(itemStack)) {
            if (itemStack.func_77973_b() instanceof ItemBlock) {
                return ((ItemBlock)itemStack.func_77973_b()).func_179223_d();
            }
            FluidStack fluidStack = FluidUtil.getFluidTypeFromItem((ItemStack)itemStack);
            if (fluidStack != null && fluidStack.getFluid() != null) {
                return fluidStack.getFluid().getBlock();
            }
        }
        return null;
    }

    public static boolean canRenderInLayer(@Nullable IBlockState paintSource, @Nonnull BlockRenderLayer blockLayer) {
        if (blockLayer == BREAKING) {
            return true;
        }
        if (paintSource != null) {
            return paintSource.func_177230_c().canRenderInLayer(paintSource, blockLayer);
        }
        return blockLayer == BlockRenderLayer.SOLID;
    }

    public static IBlockState Block$getBlockFromItem_stack$getItem___$getStateFromMeta_stack$getMetadata___(ItemStack paintSource, Block paintBlock) {
        if (paintSource.func_77973_b().getClass() == ItemPiston.class) {
            return paintBlock.func_176223_P();
        }
        return paintBlock.func_176203_a(paintSource.func_77973_b().func_77647_b(paintSource.func_77960_j()));
    }

    public static void registerPaintable(Block ... blocks) {
        for (Block block : blocks) {
            if (block instanceof IPaintable) continue;
            paintables.add(block);
        }
    }

    public static void registerPaintable(Item ... items) {
        for (Item item : items) {
            if (Block.func_149634_a((Item)item) instanceof IPaintable) continue;
            paintables.add(item);
        }
    }

    public static boolean isPaintable(@Nonnull ItemStack stack) {
        if (Prep.isInvalid(stack)) {
            return false;
        }
        return PaintUtil.isPainted(stack) || Block.func_149634_a((Item)stack.func_77973_b()) instanceof IPaintable || paintables.contains(stack);
    }

    public static interface IWithPaintName {
        @Nullable
        public String getPaintName(@Nonnull ItemStack var1);
    }
}

