/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.base.network;

import crazypants.enderio.base.network.PacketHandler;
import crazypants.enderio.util.ClientUtil;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;

public class PacketSpawnParticles
implements IMessage {
    private double posX;
    private double posY;
    private double posZ;
    private List<EnumParticleTypes> particles;
    private int count;

    public PacketSpawnParticles() {
    }

    public static void create(Entity position, EnumParticleTypes ... particles) {
        PacketSpawnParticles.create(position, 5, particles);
    }

    public static void create(Entity position, int count, EnumParticleTypes ... particles) {
        PacketHandler.INSTANCE.sendToAllAround((IMessage)new PacketSpawnParticles(position.field_70165_t, position.field_70163_u + (double)position.field_70131_O * 0.8, position.field_70161_v, count, particles), new BlockPos(position), position.field_70170_p);
    }

    public static void create(World world, BlockPos position, EnumParticleTypes ... particles) {
        PacketSpawnParticles.create(world, position, 5, particles);
    }

    public static void create(World world, BlockPos position, int count, EnumParticleTypes ... particles) {
        PacketHandler.INSTANCE.sendToAllAround((IMessage)new PacketSpawnParticles((double)position.func_177958_n() + 0.5, (double)position.func_177956_o() + 0.5, (double)position.func_177952_p() + 0.5, count, particles), position, world);
    }

    private PacketSpawnParticles(double posX, double posY, double posZ, int count, EnumParticleTypes ... particles) {
        this.posX = posX;
        this.posY = posY;
        this.posZ = posZ;
        this.count = count;
        this.particles = Arrays.asList(particles);
    }

    public void toBytes(ByteBuf buffer) {
        buffer.writeFloat((float)this.posX);
        buffer.writeFloat((float)this.posY);
        buffer.writeFloat((float)this.posZ);
        buffer.writeByte(this.count);
        int size = this.particles.size();
        buffer.writeByte(size);
        for (EnumParticleTypes particle : this.particles) {
            buffer.writeByte(particle.ordinal());
        }
    }

    public void fromBytes(ByteBuf buffer) {
        this.posX = buffer.readFloat();
        this.posY = buffer.readFloat();
        this.posZ = buffer.readFloat();
        this.count = buffer.readByte();
        int size = buffer.readByte();
        this.particles = new ArrayList<EnumParticleTypes>(size);
        for (int i = 0; i < size; ++i) {
            this.particles.add(EnumParticleTypes.values()[buffer.readByte()]);
        }
    }

    public static class Handler
    implements IMessageHandler<PacketSpawnParticles, IMessage> {
        public IMessage onMessage(PacketSpawnParticles message, MessageContext ctx) {
            for (EnumParticleTypes particle : message.particles) {
                if (particle == null) continue;
                ClientUtil.spawnParcticles(message.posX, message.posY, message.posZ, message.count, particle);
            }
            return null;
        }
    }
}

