/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.base.machine.baselegacy;

import com.enderio.core.api.common.util.IProgressTile;
import com.enderio.core.common.NBTAction;
import com.enderio.core.common.util.NNList;
import crazypants.enderio.base.capacitor.ICapacitorKey;
import crazypants.enderio.base.machine.baselegacy.AbstractPowerConsumerEntity;
import crazypants.enderio.base.machine.baselegacy.SlotDefinition;
import crazypants.enderio.base.machine.interfaces.IPoweredTask;
import crazypants.enderio.base.machine.task.PoweredTask;
import crazypants.enderio.base.machine.task.PoweredTaskProgress;
import crazypants.enderio.base.recipe.IMachineRecipe;
import crazypants.enderio.base.recipe.MachineRecipeInput;
import crazypants.enderio.base.recipe.MachineRecipeRegistry;
import crazypants.enderio.util.Prep;
import info.loenwind.autosave.annotations.Storable;
import info.loenwind.autosave.annotations.Store;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

@Storable
public abstract class AbstractPoweredTaskEntity
extends AbstractPowerConsumerEntity
implements IProgressTile {
    @Store(value={NBTAction.SAVE, NBTAction.ITEM})
    protected IPoweredTask currentTask = null;
    @Store(value={NBTAction.SAVE, NBTAction.ITEM})
    protected IMachineRecipe lastCompletedRecipe;
    protected IMachineRecipe cachedNextRecipe;
    protected int ticksSinceCheckedRecipe = 0;
    protected boolean startFailed = false;
    private Long theNextSeed = null;

    protected AbstractPoweredTaskEntity(@Nonnull SlotDefinition slotDefinition, @Nonnull ICapacitorKey maxEnergyRecieved, @Nonnull ICapacitorKey maxEnergyStored, @Nonnull ICapacitorKey maxEnergyUsed) {
        super(slotDefinition, maxEnergyRecieved, maxEnergyStored, maxEnergyUsed);
    }

    @Override
    public boolean isActive() {
        return this.currentTask == null ? false : this.currentTask.getProgress() >= 0.0f && this.hasPower() && this.redstoneCheckPassed;
    }

    public float getProgress() {
        return this.currentTask == null ? -1.0f : this.currentTask.getProgress();
    }

    @Nonnull
    public TileEntity getTileEntity() {
        return this;
    }

    public void setProgress(float progress) {
        this.currentTask = progress < 0.0f ? null : new PoweredTaskProgress(progress);
    }

    public IPoweredTask getCurrentTask() {
        return this.currentTask;
    }

    public float getExperienceForOutput(@Nonnull ItemStack output) {
        if (this.lastCompletedRecipe == null) {
            return 0.0f;
        }
        return this.lastCompletedRecipe.getExperienceForOutput(output);
    }

    public boolean getRedstoneChecksPassed() {
        return this.redstoneCheckPassed;
    }

    @Override
    protected boolean processTasks(boolean redstoneChecksPassed) {
        IMachineRecipe nextRecipe;
        if (!redstoneChecksPassed) {
            return false;
        }
        boolean requiresClientSync = false;
        requiresClientSync |= this.checkProgress(redstoneChecksPassed);
        if (this.currentTask != null || !this.hasPower() || !this.hasInputStacks()) {
            return requiresClientSync;
        }
        if (this.startFailed) {
            ++this.ticksSinceCheckedRecipe;
            if (this.ticksSinceCheckedRecipe < 20) {
                return false;
            }
        }
        this.ticksSinceCheckedRecipe = 0;
        if (this.theNextSeed == null) {
            this.theNextSeed = this.random.nextLong();
        }
        if ((nextRecipe = this.canStartNextTask(this.theNextSeed)) != null) {
            boolean started = this.startNextTask(nextRecipe, this.theNextSeed);
            if (started) {
                this.theNextSeed = null;
            }
            this.startFailed = !started;
        } else {
            this.startFailed = true;
        }
        return requiresClientSync;
    }

    protected boolean checkProgress(boolean redstoneChecksPassed) {
        if (this.currentTask == null || !this.hasPower()) {
            return false;
        }
        if (redstoneChecksPassed && !this.currentTask.isComplete()) {
            this.usePower();
        }
        if (this.currentTask.isComplete()) {
            this.taskComplete();
            return false;
        }
        return false;
    }

    @Override
    protected int usePower(int wantToUse) {
        int used = super.usePower(wantToUse);
        if (this.currentTask != null) {
            this.currentTask.update(used);
        }
        return used;
    }

    protected void taskComplete() {
        if (this.currentTask != null) {
            this.lastCompletedRecipe = this.currentTask.getRecipe();
            IMachineRecipe.ResultStack[] output = this.currentTask.getCompletedResult();
            if (output.length > 0) {
                this.mergeResults(output);
            }
        }
        this.damageCapacitor();
        this.func_70296_d();
        this.currentTask = null;
    }

    protected void mergeResults(@Nonnull IMachineRecipe.ResultStack[] results) {
        int numOutputSlots = this.slotDefinition.getNumOutputSlots();
        if (numOutputSlots > 0) {
            ArrayList<ItemStack> outputStacks = new ArrayList<ItemStack>(numOutputSlots);
            for (int i = this.slotDefinition.minOutputSlot; i <= this.slotDefinition.maxOutputSlot; ++i) {
                ItemStack it = this.inventory[i];
                if (it != null && Prep.isValid(it)) {
                    it = it.func_77946_l();
                }
                outputStacks.add(it);
            }
            for (IMachineRecipe.ResultStack result : results) {
                if (Prep.isValid(result.item)) {
                    int numMerged = this.mergeItemResult(result.item, outputStacks);
                    if (numMerged <= 0) continue;
                    result.item.func_190918_g(numMerged);
                    continue;
                }
                if (result.fluid == null) continue;
                this.mergeFluidResult(result);
            }
            int listIndex = 0;
            for (int i = this.slotDefinition.minOutputSlot; i <= this.slotDefinition.maxOutputSlot; ++i) {
                ItemStack st = (ItemStack)outputStacks.get(listIndex);
                if (st != null && Prep.isValid(st)) {
                    st = st.func_77946_l();
                }
                this.inventory[i] = st;
                ++listIndex;
            }
        } else {
            for (IMachineRecipe.ResultStack result : results) {
                if (Prep.isValid(result.item)) {
                    Block.func_180635_a((World)this.field_145850_b, (BlockPos)this.field_174879_c, (ItemStack)result.item.func_77946_l());
                    result.item.func_190920_e(0);
                    continue;
                }
                if (result.fluid == null) continue;
                this.mergeFluidResult(result);
            }
        }
        this.cachedNextRecipe = null;
    }

    protected void mergeFluidResult(@Nonnull IMachineRecipe.ResultStack result) {
    }

    protected void drainInputFluid(@Nonnull MachineRecipeInput fluid) {
    }

    protected boolean canInsertResultFluid(@Nonnull IMachineRecipe.ResultStack fluid) {
        return false;
    }

    protected int mergeItemResult(@Nonnull ItemStack item, @Nonnull List<ItemStack> outputStacks) {
        ItemStack copy = item.func_77946_l();
        if (Prep.isInvalid(copy)) {
            return 0;
        }
        int firstFreeSlot = -1;
        for (int i = 0; i < outputStacks.size(); ++i) {
            ItemStack outStack = outputStacks.get(i);
            if (outStack != null && Prep.isValid(outStack)) {
                int num = this.getNumCanMerge(outStack, copy);
                outStack.func_190917_f(num);
                copy.func_190918_g(num);
                if (!Prep.isInvalid(copy)) continue;
                return item.func_190916_E();
            }
            if (firstFreeSlot >= 0) continue;
            firstFreeSlot = i;
        }
        if (firstFreeSlot >= 0) {
            outputStacks.set(firstFreeSlot, copy);
            return item.func_190916_E();
        }
        return 0;
    }

    @Nonnull
    protected NNList<MachineRecipeInput> getRecipeInputs() {
        NNList res = new NNList();
        for (int slot = this.slotDefinition.minInputSlot; slot <= this.slotDefinition.maxInputSlot; ++slot) {
            ItemStack item = this.getStackInSlot(slot);
            if (!Prep.isValid(item)) continue;
            res.add((Object)new MachineRecipeInput(slot, item));
        }
        return res;
    }

    @Nullable
    protected IMachineRecipe getNextRecipe() {
        if (this.cachedNextRecipe == null) {
            this.cachedNextRecipe = MachineRecipeRegistry.instance.getRecipeForInputs(this.getMachineName(), this.getRecipeInputs());
        }
        return this.cachedNextRecipe;
    }

    protected IMachineRecipe canStartNextTask(long nextSeed) {
        IMachineRecipe nextRecipe = this.getNextRecipe();
        if (nextRecipe == null) {
            return null;
        }
        return this.canInsertResult(nextSeed, nextRecipe) ? nextRecipe : null;
    }

    protected boolean canInsertResult(long nextSeed, @Nonnull IMachineRecipe nextRecipe) {
        IPoweredTask task = this.createTask(nextRecipe, nextSeed);
        if (task == null) {
            return false;
        }
        IMachineRecipe.ResultStack[] nextResults = task.getCompletedResult();
        ArrayList<ItemStack> outputStacks = null;
        int numOutputSlots = this.slotDefinition.getNumOutputSlots();
        if (numOutputSlots > 0) {
            outputStacks = new ArrayList<ItemStack>(numOutputSlots);
            boolean allFull = true;
            for (int i = this.slotDefinition.minOutputSlot; i <= this.slotDefinition.maxOutputSlot; ++i) {
                ItemStack st = this.inventory[i];
                if (st != null && Prep.isValid(st)) {
                    st = st.func_77946_l();
                    if (allFull && st.func_190916_E() < st.func_77976_d()) {
                        allFull = false;
                    }
                } else {
                    allFull = false;
                }
                outputStacks.add(st);
            }
            if (allFull) {
                return false;
            }
        }
        for (IMachineRecipe.ResultStack result : nextResults) {
            if (!(Prep.isValid(result.item) ? outputStacks == null || this.mergeItemResult(result.item, outputStacks) == 0 : result.fluid != null && !this.canInsertResultFluid(result))) continue;
            return false;
        }
        return true;
    }

    protected boolean hasInputStacks() {
        int fromSlot = this.slotDefinition.minInputSlot;
        for (int i = 0; i < this.slotDefinition.getNumInputSlots(); ++i) {
            ItemStack itemStack = this.inventory[fromSlot];
            if (itemStack != null && Prep.isValid(itemStack)) {
                return true;
            }
            ++fromSlot;
        }
        return false;
    }

    protected int getNumCanMerge(@Nonnull ItemStack itemStack, @Nonnull ItemStack result) {
        if (!itemStack.func_77969_a(result) || !ItemStack.func_77970_a((ItemStack)itemStack, (ItemStack)result)) {
            return 0;
        }
        return Math.min(itemStack.func_77976_d() - itemStack.func_190916_E(), result.func_190916_E());
    }

    protected boolean startNextTask(@Nonnull IMachineRecipe nextRecipe, long nextSeed) {
        if (this.hasPower() && nextRecipe.isRecipe(this.getRecipeInputs())) {
            this.currentTask = this.createTask(nextRecipe, nextSeed);
            List<MachineRecipeInput> consumed = nextRecipe.getQuantitiesConsumed(this.getRecipeInputs());
            for (MachineRecipeInput item : consumed) {
                if (item == null) continue;
                if (Prep.isValid(item.item)) {
                    this.getStackInSlot(item.slotNumber).func_190918_g(item.item.func_190916_E());
                    continue;
                }
                if (item.fluid == null) continue;
                this.drainInputFluid(item);
            }
            return true;
        }
        return false;
    }

    @Nullable
    protected IPoweredTask createTask(@Nonnull IMachineRecipe nextRecipe, long nextSeed) {
        return new PoweredTask(nextRecipe, nextSeed, this.getRecipeInputs());
    }

    @Override
    protected void onAfterNbtRead() {
        super.onAfterNbtRead();
        this.cachedNextRecipe = null;
    }

    @Override
    public void setInventorySlotContents(int slot, @Nonnull ItemStack contents) {
        super.setInventorySlotContents(slot, contents);
        if (this.slotDefinition.isInputSlot(slot)) {
            this.cachedNextRecipe = null;
        }
    }

    @Override
    @Nonnull
    public abstract String getMachineName();
}

