/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.base.machine.baselegacy;

import com.enderio.core.common.NBTAction;
import com.enderio.core.common.util.NullHelper;
import com.enderio.core.common.vecmath.VecmathUtil;
import crazypants.enderio.base.capacitor.CapacitorHelper;
import crazypants.enderio.base.capacitor.DefaultCapacitorData;
import crazypants.enderio.base.capacitor.ICapacitorData;
import crazypants.enderio.base.capacitor.ICapacitorKey;
import crazypants.enderio.base.machine.baselegacy.AbstractInventoryMachineEntity;
import crazypants.enderio.base.machine.baselegacy.PacketLegacyPowerStorage;
import crazypants.enderio.base.machine.baselegacy.SlotDefinition;
import crazypants.enderio.base.machine.gui.IPowerBarData;
import crazypants.enderio.base.network.PacketHandler;
import crazypants.enderio.base.power.ILegacyPoweredTile;
import crazypants.enderio.util.NbtValue;
import info.loenwind.autosave.annotations.Storable;
import info.loenwind.autosave.annotations.Store;
import java.util.Random;
import javax.annotation.Nonnull;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.MathHelper;

@Storable
public abstract class AbstractPoweredMachineEntity
extends AbstractInventoryMachineEntity
implements ILegacyPoweredTile,
IPowerBarData {
    @Nonnull
    private ICapacitorData capacitorData = DefaultCapacitorData.NONE;
    @Nonnull
    protected final ICapacitorKey maxEnergyRecieved;
    @Nonnull
    protected final ICapacitorKey maxEnergyStored;
    @Nonnull
    protected final ICapacitorKey maxEnergyUsed;
    private ICapacitorKey energyLoss = null;
    @Store(value={NBTAction.SAVE, NBTAction.CLIENT})
    private int storedEnergyRF;
    protected float lastSyncPowerStored = -1.0f;
    @Store(value={NBTAction.SAVE, NBTAction.CLIENT})
    protected boolean isCapacitorDamageable = false;
    @Nonnull
    protected Random random = new Random();

    public AbstractPoweredMachineEntity(@Nonnull SlotDefinition slotDefinition, @Nonnull ICapacitorKey maxEnergyRecieved, @Nonnull ICapacitorKey maxEnergyStored, @Nonnull ICapacitorKey maxEnergyUsed) {
        super(slotDefinition);
        this.maxEnergyRecieved = maxEnergyRecieved;
        this.maxEnergyStored = maxEnergyStored;
        this.maxEnergyUsed = maxEnergyUsed;
    }

    public void init() {
        super.init();
        this.onCapacitorDataChange();
    }

    @Override
    public void doUpdate() {
        super.doUpdate();
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        this.losePower(this.getPowerLossPerTick());
        int scaledPower = this.scaledPower();
        if (this.lastSyncPowerStored != (float)scaledPower && (this.lastSyncPowerStored == 0.0f || scaledPower == 0 || this.shouldDoWorkThisTick(20))) {
            this.lastSyncPowerStored = scaledPower;
            PacketHandler.sendToAllAround(new PacketLegacyPowerStorage(this), (TileEntity)this);
        }
    }

    protected int scaledPower() {
        if (this.storedEnergyRF == 0) {
            return 0;
        }
        return 1 + this.storedEnergyRF / 1000;
    }

    public int getPowerLossPerTick() {
        return this.energyLoss != null ? this.energyLoss.get(this.getCapacitorData()) : 0;
    }

    @Override
    public boolean canConnectEnergy(@Nonnull EnumFacing from) {
        return !this.isSideDisabled(from);
    }

    @Override
    public int getMaxEnergyStored() {
        return this.maxEnergyStored.get(this.getCapacitorData());
    }

    @Override
    public void setEnergyStored(int stored) {
        this.storedEnergyRF = this.field_145850_b.field_72995_K ? stored : MathHelper.func_76125_a((int)stored, (int)0, (int)this.getMaxEnergyStored());
    }

    @Override
    public int getEnergyStored() {
        return this.storedEnergyRF;
    }

    @Override
    public boolean displayPower() {
        return true;
    }

    public boolean hasPower() {
        return this.storedEnergyRF > 0;
    }

    @Override
    @Nonnull
    public ICapacitorData getCapacitorData() {
        if (this.slotDefinition.getNumUpgradeSlots() <= 0) {
            return DefaultCapacitorData.BASIC_CAPACITOR;
        }
        return this.capacitorData;
    }

    public int getEnergyStoredScaled(int scale) {
        int maxEnergyStored2 = this.getMaxEnergyStored();
        return maxEnergyStored2 == 0 ? 0 : VecmathUtil.clamp((int)Math.round((float)scale * ((float)this.storedEnergyRF / (float)maxEnergyStored2)), (int)0, (int)scale);
    }

    public void onCapacitorDataChange() {
        this.setEnergyStored(this.getEnergyStored());
    }

    public int getPowerUsePerTick() {
        return this.maxEnergyUsed.get(this.getCapacitorData());
    }

    @Override
    public void setInventorySlotContents(int slot, @Nonnull ItemStack contents) {
        super.setInventorySlotContents(slot, contents);
        if (this.slotDefinition.isUpgradeSlot(slot)) {
            this.updateCapacitorFromSlot();
        }
    }

    private void updateCapacitorFromSlot() {
        if (this.slotDefinition.getNumUpgradeSlots() <= 0) {
            this.capacitorData = DefaultCapacitorData.BASIC_CAPACITOR;
        } else {
            ItemStack stack = this.inventory[this.slotDefinition.minUpgradeSlot];
            ICapacitorData capacitorDataFromItemStack = (ICapacitorData)NullHelper.first((Object[])new ICapacitorData[]{CapacitorHelper.getCapacitorDataFromItemStack((ItemStack)NullHelper.first((Object[])new ItemStack[]{stack, ItemStack.field_190927_a})), DefaultCapacitorData.NONE});
            if (!this.capacitorData.equals(capacitorDataFromItemStack)) {
                this.capacitorData = capacitorDataFromItemStack;
                this.isCapacitorDamageable = stack.func_77984_f();
                this.onCapacitorDataChange();
            }
        }
    }

    protected void damageCapacitor() {
        ItemStack cap;
        if (this.isCapacitorDamageable && (cap = this.inventory[this.slotDefinition.minUpgradeSlot]).func_96631_a(1, this.random, null)) {
            this.setInventorySlotContents(this.slotDefinition.minUpgradeSlot, ItemStack.field_190927_a);
        }
    }

    @Override
    protected void onAfterNbtRead() {
        super.onAfterNbtRead();
        this.updateCapacitorFromSlot();
    }

    @Override
    public void readCustomNBT(@Nonnull ItemStack stack) {
        super.readCustomNBT(stack);
        this.setEnergyStored(NbtValue.ENERGY.getInt(stack));
    }

    @Override
    public void writeCustomNBT(@Nonnull ItemStack stack) {
        super.writeCustomNBT(stack);
        NbtValue.ENERGY.setInt(stack, this.getEnergyStored());
        NbtValue.ENERGY_BUFFER.setInt(stack, this.getMaxEnergyStored());
    }

    protected final boolean tryToUsePower() {
        if (this.getCapacitorData() == DefaultCapacitorData.NONE) {
            return false;
        }
        int powerUsePerTick = this.getPowerUsePerTick();
        if (powerUsePerTick <= 0) {
            return true;
        }
        if (powerUsePerTick <= this.getEnergyStored()) {
            this.usePower(powerUsePerTick);
            return true;
        }
        return false;
    }

    protected final int usePower() {
        return this.usePower(this.getPowerUsePerTick());
    }

    protected int usePower(int wantToUse) {
        int used = Math.min(this.getEnergyStored(), wantToUse);
        this.setEnergyStored(Math.max(0, this.getEnergyStored() - used));
        return used;
    }

    protected int losePower(int wantToUse) {
        int used = Math.min(this.getEnergyStored(), wantToUse);
        this.setEnergyStored(Math.max(0, this.getEnergyStored() - used));
        return used;
    }

    public ICapacitorKey getEnergyLoss() {
        return this.energyLoss;
    }

    public void setEnergyLoss(ICapacitorKey energyLoss) {
        this.energyLoss = energyLoss;
    }

    @Override
    public int getMaxUsage() {
        return this.getMaxUsage(this.maxEnergyUsed);
    }

    public int getMaxUsage(@Nonnull ICapacitorKey key) {
        return key.get(this.capacitorData);
    }
}

