/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.base.machine.baselegacy;

import crazypants.enderio.base.init.IModObject;
import crazypants.enderio.base.machine.base.block.AbstractMachineBlock;
import crazypants.enderio.base.machine.baselegacy.AbstractInventoryMachineEntity;
import crazypants.enderio.util.Prep;
import javax.annotation.Nonnull;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public abstract class AbstractInventoryMachineBlock<T extends AbstractInventoryMachineEntity>
extends AbstractMachineBlock<T> {
    protected AbstractInventoryMachineBlock(@Nonnull IModObject mo, @Nonnull Material mat) {
        super(mo, mat);
    }

    protected AbstractInventoryMachineBlock(@Nonnull IModObject mo) {
        super(mo);
    }

    @Override
    public boolean func_180639_a(@Nonnull World world, @Nonnull BlockPos pos, @Nonnull IBlockState state, @Nonnull EntityPlayer entityPlayer, @Nonnull EnumHand hand, @Nonnull EnumFacing side, float hitX, float hitY, float hitZ) {
        AbstractInventoryMachineEntity machine = (AbstractInventoryMachineEntity)this.getTileEntity((IBlockAccess)world, pos);
        ItemStack heldItem = entityPlayer.func_184586_b(hand);
        if (Prep.isValid(heldItem) && machine != null && machine.isValidUpgrade(heldItem)) {
            int slot = machine.getSlotDefinition().getMinUpgradeSlot();
            ItemStack temp = machine.getStackInSlot(slot);
            if (Prep.isInvalid(temp)) {
                machine.setInventorySlotContents(slot, heldItem.func_77979_a(1));
                entityPlayer.field_71071_by.func_70296_d();
                return true;
            }
            if (!ItemStack.func_179545_c((ItemStack)heldItem, (ItemStack)temp)) {
                machine.setInventorySlotContents(slot, heldItem.func_77979_a(1));
                entityPlayer.field_71071_by.func_70296_d();
                if (!entityPlayer.field_71071_by.func_70441_a(temp)) {
                    entityPlayer.func_71019_a(temp, true);
                }
                return true;
            }
        }
        return super.func_180639_a(world, pos, state, entityPlayer, hand, side, hitX, hitY, hitZ);
    }

    public int func_180641_l(@Nonnull IBlockState state, @Nonnull World worldIn, @Nonnull BlockPos pos) {
        AbstractInventoryMachineEntity inv = (AbstractInventoryMachineEntity)this.getTileEntity((IBlockAccess)worldIn, pos);
        if (inv == null) {
            return 0;
        }
        int i = 0;
        float f = 0.0f;
        for (int j = 0; j < inv.getSizeInventory(); ++j) {
            ItemStack itemstack = inv.getStackInSlot(j);
            if (itemstack.func_190926_b()) continue;
            f += (float)itemstack.func_190916_E() / (float)Math.min(inv.getInventoryStackLimit(j), itemstack.func_77976_d());
            ++i;
        }
        return MathHelper.func_76141_d((float)((f /= (float)inv.getSizeInventory()) * 14.0f)) + (i > 0 ? 1 : 0);
    }
}

