/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.base.machine.base.te;

import com.enderio.core.common.NBTAction;
import com.enderio.core.common.inventory.Callback;
import com.enderio.core.common.inventory.EnderInventory;
import com.enderio.core.common.inventory.InventorySlot;
import com.enderio.core.common.vecmath.VecmathUtil;
import crazypants.enderio.base.capability.Filters;
import crazypants.enderio.base.capacitor.ICapacitorData;
import crazypants.enderio.base.capacitor.ICapacitorKey;
import crazypants.enderio.base.machine.base.network.PacketPowerStorage;
import crazypants.enderio.base.machine.base.te.AbstractCapabilityMachineEntity;
import crazypants.enderio.base.network.PacketHandler;
import crazypants.enderio.base.power.EnergyTank;
import crazypants.enderio.util.NbtValue;
import info.loenwind.autosave.annotations.Storable;
import info.loenwind.autosave.annotations.Store;
import java.util.Random;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

@Storable
public abstract class AbstractCapabilityPoweredMachineEntity
extends AbstractCapabilityMachineEntity {
    @Nonnull
    protected static final String CAPSLOT = "cap";
    @Nonnull
    public final Callback<ItemStack> CAP_CALLBACK = new Callback<ItemStack>(){

        public final void onChange(@Nonnull ItemStack oldStack, @Nonnull ItemStack newStack) {
            AbstractCapabilityPoweredMachineEntity.this.updateCapacitorFromSlot();
        }
    };
    @Store(value={NBTAction.SAVE, NBTAction.CLIENT})
    @Nonnull
    private final EnergyTank energy;
    protected float lastSyncPowerStored = -1.0f;
    @Store(value={NBTAction.SAVE, NBTAction.CLIENT})
    protected boolean isCapacitorDamageable = false;
    @Nonnull
    private Random random = new Random();

    protected AbstractCapabilityPoweredMachineEntity(@Nonnull ICapacitorKey maxEnergyRecieved, @Nonnull ICapacitorKey maxEnergyStored, @Nonnull ICapacitorKey maxEnergyUsed) {
        this(null, maxEnergyRecieved, maxEnergyStored, maxEnergyUsed);
    }

    protected AbstractCapabilityPoweredMachineEntity(@Nullable EnderInventory subclassInventory, @Nonnull ICapacitorKey maxEnergyRecieved, @Nonnull ICapacitorKey maxEnergyStored, @Nonnull ICapacitorKey maxEnergyUsed) {
        super(subclassInventory);
        this.getInventory().add(EnderInventory.Type.UPGRADE, CAPSLOT, new InventorySlot(Filters.CAPACITORS, null, this.CAP_CALLBACK, 1));
        this.energy = new EnergyTank((TileEntity)this, maxEnergyRecieved, maxEnergyStored, maxEnergyUsed);
        this.updateCapacitorFromSlot();
    }

    @Override
    public void doUpdate() {
        super.doUpdate();
        if (!this.field_145850_b.field_72995_K) {
            this.energy.loseEnergy();
            int scaledPower = this.scaledPower();
            if (this.lastSyncPowerStored != (float)scaledPower && (this.lastSyncPowerStored == 0.0f || scaledPower == 0 || this.shouldDoWorkThisTick(20))) {
                this.lastSyncPowerStored = scaledPower;
                PacketHandler.sendToAllAround((IMessage)new PacketPowerStorage(this), (TileEntity)this);
            }
        }
    }

    protected int scaledPower() {
        if (this.getEnergy().getEnergyStored() == 0) {
            return 0;
        }
        return 1 + this.getEnergy().getEnergyStored() / 1000;
    }

    public boolean displayPower() {
        return true;
    }

    public boolean hasPower() {
        return this.getEnergy().getEnergyStored() > 0;
    }

    @Nonnull
    public ICapacitorData getCapacitorData() {
        return this.getEnergy().getCapacitorData();
    }

    @Nonnull
    public EnergyTank getEnergy() {
        return this.energy;
    }

    public int getEnergyStoredScaled(int scale) {
        int maxEnergyStored2 = this.getEnergy().getMaxEnergyStored();
        return maxEnergyStored2 == 0 ? 0 : VecmathUtil.clamp((int)Math.round((float)scale * ((float)this.getEnergy().getEnergyStored() / (float)maxEnergyStored2)), (int)0, (int)scale);
    }

    protected void onCapacitorDataChange() {
    }

    private void updateCapacitorFromSlot() {
        if (this.getEnergy().updateCapacitorFromSlot(this.getInventory().getSlot(CAPSLOT))) {
            this.isCapacitorDamageable = this.getInventory().getSlot(CAPSLOT).get().func_77984_f();
            this.onCapacitorDataChange();
        }
    }

    @Override
    protected boolean processTasks(boolean redstoneCheck) {
        this.damageCapacitor();
        return true;
    }

    protected void damageCapacitor() {
        ItemStack cap;
        if (this.isCapacitorDamageable && (cap = this.getInventory().getSlot(CAPSLOT).get()).func_96631_a(1, this.random, null)) {
            this.getInventory().getSlot(CAPSLOT).clear();
        }
    }

    @Override
    public void readCustomNBT(@Nonnull ItemStack stack) {
        super.readCustomNBT(stack);
        this.energy.setEnergyStored(NbtValue.ENERGY.getInt(stack));
    }

    @Override
    public void writeCustomNBT(@Nonnull ItemStack stack) {
        super.writeCustomNBT(stack);
        NbtValue.ENERGY.setInt(stack, this.energy.getEnergyStored());
        NbtValue.ENERGY_BUFFER.setInt(stack, this.energy.getMaxEnergyStored());
    }

    @Override
    protected void onAfterNbtRead() {
        super.onAfterNbtRead();
        this.updateCapacitorFromSlot();
    }

    @Override
    public boolean hasCapability(@Nonnull Capability<?> capability, @Nullable EnumFacing facingIn) {
        if (capability == CapabilityEnergy.ENERGY) {
            return facingIn == null || this.getIoMode(facingIn).canInputOrOutput();
        }
        return super.hasCapability(capability, facingIn);
    }

    @Override
    public <T> T getCapability(@Nonnull Capability<T> capability, @Nullable EnumFacing facingIn) {
        if (capability == CapabilityEnergy.ENERGY) {
            return (T)this.getEnergy().get(facingIn);
        }
        return super.getCapability(capability, facingIn);
    }
}

