/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.base.machine.base.block;

import crazypants.enderio.base.BlockEio;
import crazypants.enderio.base.TileEntityEio;
import crazypants.enderio.base.init.IModObject;
import crazypants.enderio.util.Prep;
import java.util.Random;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.EnumPushReaction;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class BlockMachineExtension
extends BlockEio<TileEntityEio> {
    @Nonnull
    private final AxisAlignedBB AABB;
    @Nonnull
    private final IModObject parent;
    @Nonnull
    private final EnumFacing parentOffset;

    public BlockMachineExtension(@Nonnull IModObject modObject, @Nonnull IModObject parent, @Nonnull AxisAlignedBB AABB) {
        super(modObject);
        this.func_149647_a(null);
        this.func_149711_c(2.0f);
        this.func_149672_a(SoundType.field_185852_e);
        this.setHarvestLevel("pickaxe", 0);
        this.parent = parent;
        this.AABB = AABB;
        this.parentOffset = EnumFacing.DOWN;
        this.setShape(this.mkShape(BlockFaceShape.UNDEFINED));
    }

    @Override
    @Nullable
    public Item createBlockItem(@Nonnull IModObject modObject) {
        return null;
    }

    @Nonnull
    protected IModObject getParent() {
        return this.parent;
    }

    @Nonnull
    protected EnumFacing getParentOffset() {
        return this.parentOffset;
    }

    @Nonnull
    protected BlockPos getParentPos(@Nonnull BlockPos pos) {
        return pos.func_177972_a(this.getParentOffset());
    }

    @Nonnull
    protected IBlockState getParentBlockState(@Nonnull World world, @Nonnull BlockPos pos) {
        return world.func_180495_p(this.getParentPos(pos));
    }

    @Nonnull
    protected Block getParentBlock(@Nonnull World world, @Nonnull BlockPos pos) {
        return this.getParentBlockState(world, pos).func_177230_c();
    }

    @Nonnull
    public AxisAlignedBB func_185496_a(@Nonnull IBlockState state, @Nonnull IBlockAccess source, @Nonnull BlockPos pos) {
        return this.AABB;
    }

    protected boolean checkParent(@Nonnull World world, @Nonnull BlockPos pos) {
        if (this.getParentBlock(world, pos) == this.getParent().getBlockNN()) {
            return true;
        }
        world.func_175698_g(pos);
        return false;
    }

    @Override
    public boolean func_180639_a(@Nonnull World world, @Nonnull BlockPos pos, @Nonnull IBlockState state, @Nonnull EntityPlayer entityPlayer, @Nonnull EnumHand hand, @Nonnull EnumFacing side, float hitX, float hitY, float hitZ) {
        if (this.checkParent(world, pos)) {
            return this.getParentBlock(world, pos).func_180639_a(world, this.getParentPos(pos), this.getParentBlockState(world, pos), entityPlayer, hand, side, hitX, hitY, hitZ);
        }
        return false;
    }

    @Override
    public boolean canBeWrenched() {
        return true;
    }

    public boolean removedByPlayer(@Nonnull IBlockState state, @Nonnull World world, @Nonnull BlockPos pos, @Nonnull EntityPlayer player, boolean willHarvest) {
        if (this.checkParent(world, pos)) {
            return this.getParentBlock(world, pos).removedByPlayer(this.getParentBlockState(world, pos), world, this.getParentPos(pos), player, willHarvest);
        }
        return true;
    }

    public void func_180657_a(@Nonnull World world, @Nonnull EntityPlayer player, @Nonnull BlockPos pos, @Nonnull IBlockState state, @Nullable TileEntity te, @Nonnull ItemStack stack) {
        if (this.checkParent(world, pos)) {
            this.getParentBlock(world, pos).func_180657_a(world, player, this.getParentPos(pos), this.getParentBlockState(world, pos), world.func_175625_s(this.getParentPos(pos)), stack);
        }
        world.func_175698_g(pos);
    }

    @Nonnull
    public ItemStack getPickBlock(@Nonnull IBlockState state, @Nonnull RayTraceResult target, @Nonnull World world, @Nonnull BlockPos pos, @Nonnull EntityPlayer player) {
        if (this.checkParent(world, pos)) {
            return this.getParentBlock(world, pos).getPickBlock(this.getParentBlockState(world, pos), target, world, this.getParentPos(pos), player);
        }
        return Prep.getEmpty();
    }

    @Nonnull
    public Item func_180660_a(@Nonnull IBlockState state, @Nonnull Random rand, int fortune) {
        return Items.field_190931_a;
    }

    @Nonnull
    public EnumPushReaction func_149656_h(@Nonnull IBlockState state) {
        return EnumPushReaction.BLOCK;
    }

    public boolean canRenderInLayer(@Nonnull IBlockState state, @Nonnull BlockRenderLayer layer) {
        return false;
    }

    @Nonnull
    public EnumBlockRenderType func_149645_b(@Nonnull IBlockState state) {
        return EnumBlockRenderType.INVISIBLE;
    }

    public float func_149638_a(@Nonnull Entity exploder) {
        return 99999.0f;
    }

    @Nonnull
    public String func_149732_F() {
        return this.getParent().getBlockNN().func_149732_F();
    }

    public boolean func_149686_d(@Nonnull IBlockState state) {
        return false;
    }

    public boolean func_149662_c(@Nonnull IBlockState state) {
        return false;
    }

    public void func_189540_a(@Nonnull IBlockState state, @Nonnull World worldIn, @Nonnull BlockPos pos, @Nonnull Block blockIn, @Nonnull BlockPos fromPos) {
        this.checkParent(worldIn, pos);
    }

    public void func_149666_a(@Nonnull CreativeTabs tab, @Nonnull NonNullList<ItemStack> list) {
    }
}

