/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.base.loot;

import com.enderio.core.common.util.NNList;
import crazypants.enderio.base.capacitor.CapacitorHelper;
import crazypants.enderio.base.capacitor.CapacitorKey;
import crazypants.enderio.base.capacitor.ICapacitorKey;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.util.WeightedRandom;

public class WeightedUpgrade {
    @Nonnull
    public final CapacitorHelper.SetType setType;
    @Nonnull
    public final ICapacitorKey capacitorKey;
    @Nonnull
    public final String langKey;

    private WeightedUpgrade(@Nonnull CapacitorHelper.SetType setType, @Nonnull ICapacitorKey capacitorKey, @Nonnull String langKey) {
        this.setType = setType;
        this.capacitorKey = capacitorKey;
        this.langKey = "loot.capacitor." + langKey;
    }

    public static void registerWeightedUpgrade(@Nonnull CapacitorHelper.SetType setType, @Nonnull ICapacitorKey capacitorKey, @Nonnull String langKey, int weight) {
        WeightedUpgrade.registerWeightedUpgrade(new WeightedUpgrade(setType, capacitorKey, langKey), weight);
    }

    public static void registerWeightedUpgrade(@Nonnull WeightedUpgrade upgrade, int weight) {
        WeightedUpgradeImpl.weightedUpgrades.add((Object)new WeightedUpgradeImpl(weight, upgrade));
    }

    @Nonnull
    public static NNList<WeightedUpgradeImpl> getWeightedupgrades() {
        return WeightedUpgradeImpl.weightedUpgrades;
    }

    @Nullable
    public static WeightedUpgrade getByRawString(String raw) {
        for (WeightedUpgradeImpl wa : WeightedUpgradeImpl.weightedUpgrades) {
            switch (((WeightedUpgradeImpl)wa).upgrade.setType) {
                case NAME: {
                    if (!((WeightedUpgradeImpl)wa).upgrade.capacitorKey.getName().equals(raw)) break;
                    return wa.upgrade;
                }
                case TYPE: {
                    if (!((WeightedUpgradeImpl)wa).upgrade.capacitorKey.getValueType().getName().equals(raw)) break;
                    return wa.upgrade;
                }
            }
        }
        return null;
    }

    static {
        WeightedUpgrade.registerWeightedUpgrade(CapacitorHelper.SetType.TYPE, CapacitorKey.LEGACY_ENERGY_INTAKE, "intake", 20);
        WeightedUpgrade.registerWeightedUpgrade(CapacitorHelper.SetType.TYPE, CapacitorKey.LEGACY_ENERGY_BUFFER, "buffer", 20);
    }

    public static class WeightedUpgradeImpl
    extends WeightedRandom.Item {
        @Nonnull
        private static final NNList<WeightedUpgradeImpl> weightedUpgrades = new NNList();
        @Nonnull
        private final WeightedUpgrade upgrade;

        private WeightedUpgradeImpl(int weight, @Nonnull WeightedUpgrade upgrade) {
            super(weight);
            this.upgrade = upgrade;
        }

        @Nonnull
        public WeightedUpgrade getUpgrade() {
            return this.upgrade;
        }
    }
}

