/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.base.loot;

import com.enderio.core.common.util.NullHelper;
import crazypants.enderio.base.fluid.Fluids;
import crazypants.enderio.base.init.ModObject;
import crazypants.enderio.base.loot.LootSelector;
import crazypants.enderio.base.loot.SetRandomDarkUpgrade;
import crazypants.enderio.base.loot.SetRandomEnergy;
import crazypants.enderio.base.material.alloy.Alloy;
import crazypants.enderio.base.material.material.Material;
import crazypants.enderio.util.CapturedMob;
import javax.annotation.Nonnull;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.storage.loot.LootEntry;
import net.minecraft.world.storage.loot.LootEntryItem;
import net.minecraft.world.storage.loot.LootPool;
import net.minecraft.world.storage.loot.LootTable;
import net.minecraft.world.storage.loot.LootTableList;
import net.minecraft.world.storage.loot.RandomValueRange;
import net.minecraft.world.storage.loot.conditions.LootCondition;
import net.minecraft.world.storage.loot.conditions.RandomChance;
import net.minecraft.world.storage.loot.functions.LootFunction;
import net.minecraft.world.storage.loot.functions.SetCount;
import net.minecraft.world.storage.loot.functions.SetDamage;
import net.minecraft.world.storage.loot.functions.SetMetadata;
import net.minecraft.world.storage.loot.functions.SetNBT;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.LootTableLoadEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class LootManager {
    @Nonnull
    private static final LootCondition[] NO_CONDITIONS = new LootCondition[0];
    private static LootManager INSTANCE = new LootManager();
    int capCount = 0;
    @Nonnull
    private static final LootSelector ls = new LootSelector(NO_CONDITIONS);

    public static void init(@Nonnull FMLPostInitializationEvent event) {
        MinecraftForge.EVENT_BUS.register((Object)INSTANCE);
    }

    private LootManager() {
    }

    @SubscribeEvent
    public void onLootTableLoad(@Nonnull LootTableLoadEvent evt) {
        LootTable table = evt.getTable();
        LootPool lp = new LootPool(new LootEntry[0], NO_CONDITIONS, new RandomValueRange(1.0f, 3.0f), new RandomValueRange(0.0f, 0.0f), "Ender IO");
        if (evt.getName().equals((Object)LootTableList.field_186422_d)) {
            lp.addEntry(this.createLootEntry(Alloy.DARK_STEEL.getStackIngot(), 1, 3, 0.25f));
            lp.addEntry(this.createLootEntry(ModObject.itemConduitProbe.getItemNN(), 0.1f));
            lp.addEntry(this.createLootEntry(Items.field_151128_bU, 3, 16, 0.25f));
            lp.addEntry(this.createLootEntry(Items.field_151075_bm, 1, 4, 0.2f));
            lp.addEntry(this.createLootEntry(Items.field_151079_bi, 1, 2, 0.3f));
            lp.addEntry(this.createDarkSteelLootEntry(ModObject.itemDarkSteelSword.getItemNN(), 0.1f));
            lp.addEntry(this.createDarkSteelLootEntry(ModObject.itemDarkSteelBoots.getItemNN(), 0.1f));
            lp.addEntry(this.createLootEntry(Material.GEAR_WOOD.getStack(), 1, 2, 0.5f));
            lp.addEntry(this.createLootCapacitor(0.15f));
            lp.addEntry(this.createLootCapacitor(0.15f));
            lp.addEntry(this.createLootCapacitor(0.15f));
        } else if (evt.getName().equals((Object)LootTableList.field_186424_f)) {
            lp.addEntry(this.createLootEntry(Alloy.DARK_STEEL.getStackIngot(), 1, 3, 0.05f));
            lp.addEntry(this.createLootEntry(Items.field_151079_bi, 1, 2, 0.1f));
            lp.addEntry(this.createDarkSteelLootEntry(ModObject.itemDarkSteelSword.getItemNN(), 0.2f));
            lp.addEntry(this.createLootEntry(Material.GEAR_WOOD.getStack(), 1, 2, 0.5f));
            lp.addEntry(this.createLootCapacitor(0.15f));
            lp.addEntry(this.createLootCapacitor(0.05f));
            lp.addEntry(this.createLootEntry(ModObject.blockExitRail.getItemNN(), 1, 2, 0.15f));
        } else if (evt.getName().equals((Object)LootTableList.field_186425_g)) {
            lp.addEntry(this.createDarkSteelLootEntry(ModObject.itemDarkSteelBoots.getItemNN(), 0.1f));
            lp.addEntry(this.createLootEntry(Material.GEAR_IRON.getStack(), 1, 2, 0.5f));
            lp.addEntry(this.createLootCapacitor(0.15f));
        } else if (evt.getName().equals((Object)LootTableList.field_186431_m)) {
            CapturedMob polarBear = CapturedMob.create(new ResourceLocation("minecraft", "polar_bear"));
            if (polarBear != null) {
                lp.addEntry((LootEntry)new LootEntryItem(ModObject.itemSoulVial.getItemNN(), 1, 1, new LootFunction[]{this.setCount(1, 1), new SetNBT(NO_CONDITIONS, polarBear.toNbt(null))}, new LootCondition[]{new RandomChance(0.2f)}, "PolarBearSoulVial"));
            }
            lp.addEntry(this.createLootEntry(ModObject.itemSoulVial.getItemNN(), 1, 3, 0.5f));
            lp.addEntry(this.createLootCapacitor(0.05f));
        } else if (evt.getName().equals((Object)LootTableList.field_189420_m)) {
            ItemStack bucket = Fluids.FIRE_WATER.getBucket();
            lp.addEntry((LootEntry)new LootEntryItem(bucket.func_77973_b(), 1, 1, new LootFunction[]{this.setCount(1, 1), this.setMetadata(bucket.func_77960_j()), this.setNBT(bucket)}, new LootCondition[]{new RandomChance(0.05f)}, bucket.func_77973_b().func_77658_a() + ":" + bucket.func_77960_j()));
        } else if (evt.getName().equals((Object)LootTableList.field_186423_e)) {
            lp.addEntry(this.createLootEntry(Alloy.ELECTRICAL_STEEL.getStackIngot(), 2, 6, 0.2f));
            lp.addEntry(this.createLootEntry(Alloy.REDSTONE_ALLOY.getStackIngot(), 3, 6, 0.35f));
            lp.addEntry(this.createLootEntry(Alloy.DARK_STEEL.getStackIngot(), 3, 6, 0.35f));
            lp.addEntry(this.createLootEntry(Alloy.PULSATING_IRON.getStackIngot(), 1, 2, 0.3f));
            lp.addEntry(this.createLootEntry(Alloy.VIBRANT_ALLOY.getStackIngot(), 1, 2, 0.2f));
            lp.addEntry(this.createLootEntry(Material.GEAR_WOOD.getStack(), 1, 2, 0.5f));
            lp.addEntry(this.createLootEntry(Material.GEAR_STONE.getStack(), 1, 2, 0.4f));
            lp.addEntry(this.createLootEntry(Material.GEAR_IRON.getStack(), 1, 2, 0.25f));
            lp.addEntry(this.createLootEntry(Material.GEAR_ENERGIZED.getStack(), 1, 2, 0.125f));
            lp.addEntry(this.createLootEntry(Material.GEAR_VIBRANT.getStack(), 1, 2, 0.0625f));
            lp.addEntry(this.createDarkSteelLootEntry(ModObject.itemDarkSteelSword.getItemNN(), 1, 1, 0.25f));
            lp.addEntry(this.createDarkSteelLootEntry(ModObject.itemDarkSteelBoots.getItemNN(), 1, 1, 0.25f));
            lp.addEntry(this.createLootCapacitor(0.1f));
        } else if (evt.getName().equals((Object)LootTableList.field_186429_k)) {
            lp.addEntry(this.createDarkSteelLootEntry(ModObject.itemDarkSteelSword.getItemNN(), 0.2f));
            lp.addEntry(this.createLootEntry(Material.GEAR_VIBRANT.getStack(), 1, 2, 0.0625f));
            lp.addEntry(this.createLootEntry(ModObject.itemTravelStaff.getItemNN(), 0.1f));
            lp.addEntry(this.createLootCapacitor(25.0f));
        } else if (evt.getName().equals((Object)LootTableList.field_186430_l)) {
            lp.addEntry(this.createDarkSteelLootEntry(ModObject.itemDarkSteelSword.getItemNN(), 1, 1, 0.25f));
            lp.addEntry(this.createLootEntry(ModObject.itemTravelStaff.getItemNN(), 1, 1, 0.1f));
            lp.addEntry(this.createLootCapacitor(0.25f));
            lp.addEntry(this.createLootCapacitor(0.25f));
        } else if (evt.getName().equals((Object)LootTableList.field_191192_o)) {
            lp.addEntry(this.createDarkSteelLootEntry(ModObject.itemDarkSteelBow.getItemNN(), 1, 1, 0.25f));
            lp.addEntry(this.createDarkSteelLootEntry(ModObject.itemDarkSteelAxe.getItemNN(), 1, 1, 0.25f));
            lp.addEntry(this.createLootEntry(Material.GEAR_STONE.getStack(), 1, 2, 0.4f));
            lp.addEntry(this.createLootCapacitor(0.25f));
            lp.addEntry(this.createLootEntry(ModObject.itemTravelStaff.getItemNN(), 1, 1, 0.1f));
        } else if (evt.getName().equals((Object)LootTableList.field_186421_c)) {
            CapturedMob shulker = CapturedMob.create(new ResourceLocation("minecraft", "shulker"));
            if (shulker != null) {
                lp.addEntry((LootEntry)new LootEntryItem(ModObject.itemSoulVial.getItemNN(), 1, 1, new LootFunction[]{this.setCount(1, 1), new SetNBT(NO_CONDITIONS, shulker.toNbt(null))}, new LootCondition[]{new RandomChance(0.2f)}, "ShulkerSoulVial"));
            }
            lp.addEntry(this.createLootEntry(ModObject.itemSoulVial.getItemNN(), 1, 3, 0.5f));
            lp.addEntry(this.createLootEntry(Material.GEAR_ENERGIZED.getStack(), 1, 2, 0.125f));
            lp.addEntry(this.createLootEntry(Material.GEAR_VIBRANT.getStack(), 1, 2, 0.125f));
            lp.addEntry(this.createLootCapacitor(0.05f));
            lp.addEntry(this.createDarkSteelLootEntry(ModObject.itemDarkSteelBow.getItemNN(), 1, 1, 0.25f));
        } else {
            return;
        }
        if (table.isFrozen()) {
            throw new RuntimeException("Some other mod (a list of suspects is printed in the log file) put a frozen loot table into the load event for loot table '" + evt.getName() + "'. This is a bug in that other mod. Ender IO is the victim here. Don't blame the victim!");
        }
        table.addPool(lp);
    }

    @Nonnull
    private LootEntry createLootEntry(@Nonnull Item item, float chance) {
        return this.createLootEntry(item, 1, 1, chance);
    }

    @Nonnull
    private LootEntry createLootEntry(@Nonnull Item item, int minSize, int maxSize, float chance) {
        return this.createLootEntry(item, 0, minSize, maxSize, chance);
    }

    @Nonnull
    private LootEntry createLootEntry(@Nonnull Item item, int meta, int minStackSize, int maxStackSize, float chance) {
        LootCondition[] chanceCond = new LootCondition[]{new RandomChance(chance)};
        ResourceLocation registryName = (ResourceLocation)NullHelper.notnull((Object)item.getRegistryName(), (String)"found unregistered item");
        if (item.func_77645_m()) {
            return new LootEntryItem(item, 1, 1, new LootFunction[]{this.setCount(minStackSize, maxStackSize), this.setDamage(item, meta), this.setEnergy()}, chanceCond, registryName.toString() + ":" + meta);
        }
        return new LootEntryItem(item, 1, 1, new LootFunction[]{this.setCount(minStackSize, maxStackSize), this.setMetadata(meta)}, chanceCond, registryName.toString() + ":" + meta);
    }

    @Nonnull
    private LootEntry createLootEntry(@Nonnull ItemStack stack, int minStackSize, int maxStackSize, float chance) {
        LootCondition[] chanceCond = new LootCondition[]{new RandomChance(chance)};
        ResourceLocation registryName = (ResourceLocation)NullHelper.notnull((Object)stack.func_77973_b().getRegistryName(), (String)"found unregistered item");
        return new LootEntryItem(stack.func_77973_b(), 1, 1, new LootFunction[]{this.setCount(minStackSize, maxStackSize), this.setMetadata(stack.func_77960_j())}, chanceCond, registryName.toString() + ":" + stack.func_77960_j());
    }

    @Nonnull
    private LootEntry createDarkSteelLootEntry(@Nonnull Item item, float chance) {
        return this.createDarkSteelLootEntry(item, 1, 1, chance);
    }

    @Nonnull
    private LootEntry createDarkSteelLootEntry(@Nonnull Item item, int minSize, int maxSize, float chance) {
        return this.createDarkSteelLootEntry(item, 0, minSize, maxSize, chance);
    }

    @Nonnull
    private LootEntry createDarkSteelLootEntry(@Nonnull Item item, int meta, int minStackSize, int maxStackSize, float chance) {
        LootCondition[] chanceCond = new LootCondition[]{new RandomChance(chance)};
        ResourceLocation registryName = (ResourceLocation)NullHelper.notnull((Object)item.getRegistryName(), (String)"found unregistered item");
        return new LootEntryItem(item, 1, 1, new LootFunction[]{this.setCount(minStackSize, maxStackSize), this.setDamage(item, meta), this.setUpgrades(), this.setEnergy()}, chanceCond, registryName.toString() + ":" + meta);
    }

    @Nonnull
    private LootEntry createLootCapacitor(float chance) {
        ++this.capCount;
        return new LootEntryItem(ModObject.itemBasicCapacitor.getItemNN(), 1, 1, new LootFunction[]{ls, this.setMetadata(3, 4)}, new LootCondition[]{new RandomChance(chance)}, ModObject.itemBasicCapacitor.getUnlocalisedName() + this.capCount);
    }

    @Nonnull
    private SetCount setCount(int min, int max) {
        return new SetCount(NO_CONDITIONS, new RandomValueRange((float)min, (float)min));
    }

    @Nonnull
    private SetDamage setDamage(Item item, int damage) {
        return new SetDamage(NO_CONDITIONS, new RandomValueRange(damage > 0 ? (float)damage : 1.0f, damage > 0 ? (float)damage : (float)item.func_77612_l()));
    }

    @Nonnull
    private SetMetadata setMetadata(int metaMin, int metaMax) {
        return new SetMetadata(NO_CONDITIONS, new RandomValueRange((float)metaMin, (float)metaMax));
    }

    @Nonnull
    private SetMetadata setMetadata(int meta) {
        return new SetMetadata(NO_CONDITIONS, new RandomValueRange((float)meta));
    }

    @Nonnull
    private SetRandomEnergy setEnergy() {
        return new SetRandomEnergy(NO_CONDITIONS);
    }

    @Nonnull
    private SetRandomDarkUpgrade setUpgrades() {
        return new SetRandomDarkUpgrade(NO_CONDITIONS);
    }

    @Nonnull
    private SetNBT setNBT(ItemStack stack) {
        return new SetNBT(NO_CONDITIONS, (NBTTagCompound)NullHelper.first((Object[])new NBTTagCompound[]{stack.func_77978_p(), new NBTTagCompound()}));
    }
}

