/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.base.item.xptransfer;

import com.enderio.core.api.client.gui.IResourceTooltipProvider;
import com.enderio.core.common.fluid.FluidWrapper;
import com.enderio.core.common.fluid.IFluidWrapper;
import crazypants.enderio.base.EnderIOTab;
import crazypants.enderio.base.fluid.Fluids;
import crazypants.enderio.base.init.IModObject;
import crazypants.enderio.base.item.xptransfer.PacketXpTransferEffects;
import crazypants.enderio.base.network.PacketHandler;
import crazypants.enderio.base.xp.XpUtil;
import javax.annotation.Nonnull;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemXpTransfer
extends Item
implements IResourceTooltipProvider {
    public static ItemXpTransfer create(@Nonnull IModObject modObject) {
        return new ItemXpTransfer(modObject);
    }

    protected ItemXpTransfer(@Nonnull IModObject modObject) {
        this.func_77637_a(EnderIOTab.tabEnderIOItems);
        modObject.apply(this);
        this.func_77625_d(1);
        this.func_77627_a(true);
    }

    @Nonnull
    public EnumActionResult onItemUseFirst(@Nonnull EntityPlayer player, @Nonnull World world, @Nonnull BlockPos pos, @Nonnull EnumFacing side, float hitX, float hitY, float hitZ, @Nonnull EnumHand hand) {
        boolean res;
        if (world.field_72995_K) {
            return EnumActionResult.PASS;
        }
        boolean swing = false;
        if (player.func_70093_af()) {
            swing = res = ItemXpTransfer.tranferFromPlayerToBlock(player, world, pos, side);
        } else {
            res = ItemXpTransfer.tranferFromBlockToPlayer(player, world, pos, side);
        }
        if (res) {
            ItemXpTransfer.sendXPUpdate(player, world, pos, swing);
            return EnumActionResult.SUCCESS;
        }
        return EnumActionResult.PASS;
    }

    public static void sendXPUpdate(@Nonnull EntityPlayer player, @Nonnull World world, @Nonnull BlockPos pos, boolean swing) {
        PacketHandler.INSTANCE.sendTo((IMessage)new PacketXpTransferEffects(swing, pos), (EntityPlayerMP)player);
        world.func_184134_a((double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5, SoundEvents.field_187604_bf, SoundCategory.PLAYERS, 0.1f, 0.5f * ((world.field_73012_v.nextFloat() - world.field_73012_v.nextFloat()) * 0.7f + 1.8f), false);
    }

    public static boolean tranferFromBlockToPlayer(@Nonnull EntityPlayer player, @Nonnull World world, @Nonnull BlockPos pos, @Nonnull EnumFacing side) {
        FluidStack availableFluid;
        IFluidWrapper wrapper = FluidWrapper.wrap((IBlockAccess)world, (BlockPos)pos, (EnumFacing)side);
        if (wrapper != null && (availableFluid = wrapper.getAvailableFluid()) != null && availableFluid.getFluid() == Fluids.XP_JUICE.getFluid() && availableFluid.amount > 0) {
            int currentXP = XpUtil.getPlayerXP(player);
            int nextLevelXP = XpUtil.getExperienceForLevel(player.field_71068_ca + 1);
            int requiredXP = nextLevelXP - currentXP;
            int fluidVolume = XpUtil.experienceToLiquid(requiredXP);
            FluidStack fs = new FluidStack(Fluids.XP_JUICE.getFluid(), fluidVolume);
            FluidStack res = wrapper.drain(fs);
            if (res != null && res.amount > 0) {
                int xpToGive = XpUtil.liquidToExperience(res.amount);
                XpUtil.addPlayerXP(player, xpToGive);
                return true;
            }
        }
        return false;
    }

    public static boolean tranferFromPlayerToBlock(@Nonnull EntityPlayer player, @Nonnull World world, @Nonnull BlockPos pos, @Nonnull EnumFacing side) {
        if (player.field_71067_cb <= 0) {
            return false;
        }
        IFluidWrapper wrapper = FluidWrapper.wrap((IBlockAccess)world, (BlockPos)pos, (EnumFacing)side);
        if (wrapper != null) {
            int fluidVolume = XpUtil.experienceToLiquid(XpUtil.getPlayerXP(player));
            FluidStack fs = new FluidStack(Fluids.XP_JUICE.getFluid(), fluidVolume);
            int takenVolume = wrapper.fill(fs);
            if (takenVolume > 0) {
                int xpToTake = XpUtil.liquidToExperience(takenVolume);
                XpUtil.addPlayerXP(player, -xpToTake);
                return true;
            }
        }
        return false;
    }

    @Nonnull
    public String getUnlocalizedNameForTooltip(@Nonnull ItemStack stack) {
        return this.func_77658_a();
    }

    public boolean doesSneakBypassUse(@Nonnull ItemStack stack, @Nonnull IBlockAccess world, @Nonnull BlockPos pos, @Nonnull EntityPlayer player) {
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_77662_d() {
        return true;
    }
}

