/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.base.item.spawner;

import com.enderio.core.common.util.NNMap;
import com.enderio.core.common.util.NullHelper;
import crazypants.enderio.base.Log;
import crazypants.enderio.base.config.config.BrokenSpawnerConfig;
import crazypants.enderio.base.init.ModObject;
import crazypants.enderio.base.recipe.spawner.PoweredSpawnerRecipeRegistry;
import crazypants.enderio.util.CapturedMob;
import crazypants.enderio.util.Prep;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import javax.annotation.Nonnull;
import net.minecraft.block.BlockMobSpawner;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.MobSpawnerBaseLogic;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityMobSpawner;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.relauncher.ReflectionHelper;

@Mod.EventBusSubscriber(modid="enderio")
public class BrokenSpawnerHandler {
    private static Method getEntityIdMethod;
    private static Field spawnDelayField;
    @Nonnull
    private static final NNMap<BlockPos, ItemStack> dropCache;

    @SubscribeEvent
    public static void onBreakEvent(BlockEvent.BreakEvent evt) {
        if (evt.getState().func_177230_c() instanceof BlockMobSpawner) {
            if (!(evt.getPlayer() == null || evt.getPlayer().field_71075_bZ.field_75098_d || evt.getPlayer().field_70170_p.field_72995_K || evt.isCanceled())) {
                TileEntity tile = evt.getPlayer().field_70170_p.func_175625_s((BlockPos)NullHelper.notnullF((Object)evt.getPos(), (String)"BlockEvent.BreakEvent.getPos()"));
                if (tile instanceof TileEntityMobSpawner) {
                    if (Math.random() > BrokenSpawnerConfig.brokenSpawnerDropChance.get()) {
                        return;
                    }
                    ItemStack equipped = evt.getPlayer().func_184614_ca();
                    if (Prep.isValid(equipped) && BrokenSpawnerConfig.brokenSpawnerToolBlacklist.get().contains(equipped)) {
                        return;
                    }
                    TileEntityMobSpawner spawner = (TileEntityMobSpawner)tile;
                    MobSpawnerBaseLogic logic = spawner.func_145881_a();
                    ResourceLocation entityName = BrokenSpawnerHandler.getEntityName(logic);
                    if (entityName != null && !BrokenSpawnerHandler.isBlackListed(entityName)) {
                        CapturedMob capturedMob = CapturedMob.create(entityName);
                        if (capturedMob != null) {
                            ItemStack drop = capturedMob.toStack(ModObject.itemBrokenSpawner.getItemNN(), 0, 1);
                            dropCache.put((Object)evt.getPos().func_185334_h(), (Object)drop);
                            for (int i = (int)(Math.random() * 7.0); i > 0; --i) {
                                BrokenSpawnerHandler.setSpawnDelay(logic);
                                logic.func_98278_g();
                            }
                        } else {
                            dropCache.put((Object)evt.getPos().func_185334_h(), (Object)Prep.getEmpty());
                        }
                    }
                }
            } else {
                dropCache.put((Object)evt.getPos().func_185334_h(), (Object)Prep.getEmpty());
            }
        }
    }

    @SubscribeEvent
    public static void onHarvestDropsEvent(BlockEvent.HarvestDropsEvent evt) {
        if (!evt.isCanceled() && evt.getState().func_177230_c() instanceof BlockMobSpawner) {
            if (dropCache.containsKey((Object)evt.getPos())) {
                ItemStack stack = (ItemStack)dropCache.get((Object)evt.getPos());
                if (Prep.isValid(stack)) {
                    evt.getDrops().add(stack);
                    dropCache.put((Object)evt.getPos().func_185334_h(), (Object)Prep.getEmpty());
                }
            } else {
                try {
                    for (Object object : evt.getWorld().field_147482_g) {
                        CapturedMob capturedMob;
                        MobSpawnerBaseLogic logic;
                        ResourceLocation entityName;
                        if (!(object instanceof TileEntityMobSpawner)) continue;
                        TileEntityMobSpawner spawner = (TileEntityMobSpawner)object;
                        BlockPos p = spawner.func_174877_v();
                        if (spawner.func_145831_w() != evt.getWorld() || !p.equals((Object)evt.getPos()) || (entityName = BrokenSpawnerHandler.getEntityName(logic = spawner.func_145881_a())) == null || BrokenSpawnerHandler.isBlackListed(entityName) || (capturedMob = CapturedMob.create(entityName)) == null) continue;
                        evt.getDrops().add(capturedMob.toStack(ModObject.itemBrokenSpawner.getItemNN(), 0, 1));
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }

    private static ResourceLocation getEntityName(MobSpawnerBaseLogic logic) {
        if (getEntityIdMethod != null) {
            try {
                return (ResourceLocation)getEntityIdMethod.invoke((Object)logic, new Object[0]);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    private static void setSpawnDelay(MobSpawnerBaseLogic logic) {
        if (spawnDelayField != null) {
            try {
                spawnDelayField.set(logic, 0);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    @SubscribeEvent
    public static void onServerTick(TickEvent.ServerTickEvent event) {
        if (event.phase == TickEvent.Phase.END) {
            dropCache.clear();
        }
    }

    public static boolean isBlackListed(@Nonnull ResourceLocation entityId) {
        return PoweredSpawnerRecipeRegistry.getInstance().isBlackListed(entityId);
    }

    static {
        try {
            getEntityIdMethod = ReflectionHelper.findMethod(MobSpawnerBaseLogic.class, (String)"getEntityId", (String)"func_190895_g", (Class[])new Class[0]);
        }
        catch (Exception e) {
            Log.error("Broken Spawner: Could not find method: getEntityId/func_190895_g");
        }
        try {
            spawnDelayField = ReflectionHelper.findField(MobSpawnerBaseLogic.class, (String[])new String[]{"spawnDelay", "field_98286_b"});
        }
        catch (Exception e) {
            Log.error("Broken Spawner: Could not find field: spawnDelay/field_98286_b");
        }
        dropCache = new NNMap.Brutal();
    }
}

