/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.base.item.darksteel.upgrade.speed;

import com.enderio.core.common.util.Log;
import com.enderio.core.common.util.NullHelper;
import crazypants.enderio.base.config.Config;
import crazypants.enderio.base.handler.darksteel.DarkSteelController;
import crazypants.enderio.base.item.darksteel.attributes.DarkSteelAttributeModifiers;
import crazypants.enderio.base.item.darksteel.upgrade.energy.EnergyUpgrade;
import crazypants.enderio.base.item.darksteel.upgrade.energy.EnergyUpgradeManager;
import crazypants.enderio.base.item.darksteel.upgrade.speed.SpeedUpgrade;
import java.util.UUID;
import javax.annotation.Nonnull;
import net.minecraft.client.entity.AbstractClientPlayer;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.IAttributeInstance;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemStack;
import net.minecraftforge.client.event.FOVUpdateEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@Mod.EventBusSubscriber(modid="enderio", value={Side.CLIENT})
public class SpeedController {
    private static boolean ignoreFovEvent = false;

    public static void updateSpeed(@Nonnull EntityPlayer player) {
        if (player.field_70170_p.field_72995_K) {
            return;
        }
        SpeedController.clearModifiers(player);
        if (!player.field_70122_E) {
            return;
        }
        SpeedUpgrade speedUpgrade = SpeedController.getActiveSpeedUpgrade(player);
        if (speedUpgrade == null) {
            return;
        }
        double horzMovement = Math.abs(player.field_70140_Q - player.field_70141_P);
        double costModifier = player.func_70051_ag() ? (double)Config.darkSteelSprintPowerCost : (double)Config.darkSteelWalkPowerCost;
        int cost = (int)(horzMovement * costModifier);
        SpeedController.setModifiers(player);
        DarkSteelController.usePlayerEnergy(player, EntityEquipmentSlot.LEGS, cost);
    }

    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent
    public static void handleFovUpdate(@Nonnull FOVUpdateEvent evt) {
        if (ignoreFovEvent) {
            return;
        }
        EntityPlayer player = (EntityPlayer)NullHelper.notnullF((Object)evt.getEntity(), (String)"FOVUpdateEvent has no player");
        if (SpeedController.clearModifiers(player)) {
            evt.setNewfov(SpeedController.getVanillaFovModifier(player));
            SpeedController.setModifiers(player);
        }
    }

    private static void setModifiers(@Nonnull EntityPlayer player) {
        EnergyUpgrade energyUpgrade;
        SpeedUpgrade speedUpgrade = SpeedController.getActiveSpeedUpgrade(player);
        if (speedUpgrade != null && (energyUpgrade = SpeedController.getActiveEnergyUpgrade(player)) != null) {
            IAttributeInstance moveInst = player.func_110140_aT().func_111151_a(SharedMonsterAttributes.field_111263_d);
            AttributeModifier modifier = DarkSteelAttributeModifiers.getWalkSpeed(player.func_70051_ag(), speedUpgrade.getLevel(), energyUpgrade.getLevel());
            moveInst.func_111121_a(modifier);
        }
    }

    private static boolean clearModifiers(@Nonnull EntityPlayer player) {
        UUID uuid;
        IAttributeInstance moveInst = player.func_110140_aT().func_111151_a(SharedMonsterAttributes.field_111263_d);
        AttributeModifier modifier = moveInst.func_111127_a(uuid = DarkSteelAttributeModifiers.getWalkSpeed(false, 1, 0).func_111167_a());
        if (modifier != null) {
            moveInst.func_111124_b(modifier);
            return true;
        }
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    private static float getVanillaFovModifier(@Nonnull EntityPlayer player) {
        if (!(player instanceof AbstractClientPlayer)) {
            Log.warn((String)("invalid player type when adjusting FOV " + player));
            return 1.0f;
        }
        try {
            ignoreFovEvent = true;
            float f = ((AbstractClientPlayer)player).func_175156_o();
            return f;
        }
        finally {
            ignoreFovEvent = false;
        }
    }

    private static SpeedUpgrade getActiveSpeedUpgrade(@Nonnull EntityPlayer player) {
        ItemStack leggings = player.func_184582_a(EntityEquipmentSlot.LEGS);
        SpeedUpgrade speedUpgrade = SpeedUpgrade.loadAnyFromItem(leggings);
        if (speedUpgrade == null) {
            return null;
        }
        if (DarkSteelController.isSpeedActive(player) && DarkSteelController.getPlayerEnergy(player, EntityEquipmentSlot.LEGS) > 0) {
            return speedUpgrade;
        }
        return null;
    }

    private static EnergyUpgrade getActiveEnergyUpgrade(@Nonnull EntityPlayer player) {
        ItemStack leggings = player.func_184582_a(EntityEquipmentSlot.LEGS);
        EnergyUpgrade.EnergyUpgradeHolder energyUpgradeHolder = EnergyUpgradeManager.loadFromItem(leggings);
        if (energyUpgradeHolder != null && energyUpgradeHolder.getEnergy() > 0) {
            return energyUpgradeHolder.getUpgrade();
        }
        return null;
    }
}

