/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.base.item.darksteel.upgrade.glider;

import com.enderio.core.common.util.Util;
import com.enderio.core.common.vecmath.VecmathUtil;
import com.enderio.core.common.vecmath.Vector3d;
import com.enderio.core.common.vecmath.Vector4d;
import crazypants.enderio.api.upgrades.IDarkSteelItem;
import crazypants.enderio.api.upgrades.IHasPlayerRenderer;
import crazypants.enderio.api.upgrades.IRenderUpgrade;
import crazypants.enderio.base.config.Config;
import crazypants.enderio.base.handler.darksteel.AbstractUpgrade;
import crazypants.enderio.base.handler.darksteel.DarkSteelController;
import crazypants.enderio.base.item.darksteel.upgrade.elytra.ElytraUpgrade;
import crazypants.enderio.base.item.darksteel.upgrade.glider.GliderUpgradeLayer;
import crazypants.enderio.base.material.material.Material;
import javax.annotation.Nonnull;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class GliderUpgrade
extends AbstractUpgrade
implements IHasPlayerRenderer {
    @Nonnull
    private static final String UPGRADE_NAME = "glide";
    @Nonnull
    public static final GliderUpgrade INSTANCE = new GliderUpgrade();

    public GliderUpgrade() {
        super(UPGRADE_NAME, "enderio.darksteel.upgrade.glider", Material.GLIDER_WINGS.getStack(), Config.darkSteelGliderCost);
    }

    @Override
    public boolean canAddToItem(@Nonnull ItemStack stack, @Nonnull IDarkSteelItem item) {
        return item.isForSlot(EntityEquipmentSlot.CHEST) && !ElytraUpgrade.INSTANCE.hasUpgrade(stack, item) && !this.hasUpgrade(stack, item);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    @Nonnull
    public IRenderUpgrade getRender() {
        return GliderUpgradeLayer.instance;
    }

    @Override
    public void onPlayerTick(@Nonnull ItemStack stack, @Nonnull IDarkSteelItem item, @Nonnull EntityPlayer player) {
        if (!DarkSteelController.isGlideActive(player)) {
            return;
        }
        if (!player.field_70122_E && player.field_70181_x < 0.0 && !player.func_70093_af() && !player.func_70090_H()) {
            double horizontalSpeed = Config.darkSteelGliderHorizontalSpeed;
            double verticalSpeed = Config.darkSteelGliderVerticalSpeed;
            if (player.func_70051_ag()) {
                verticalSpeed = Config.darkSteelGliderVerticalSpeedSprinting;
            }
            Vector3d look = Util.getLookVecEio((EntityPlayer)player);
            Vector3d side = new Vector3d();
            side.cross(new Vector3d(0.0, 1.0, 0.0), look);
            Vector3d playerPos = new Vector3d(player.field_70169_q, player.field_70167_r, player.field_70166_s);
            Vector3d b = new Vector3d(playerPos);
            b.y += 1.0;
            Vector3d c = new Vector3d(playerPos);
            c.add(side);
            Vector4d plane = new Vector4d();
            VecmathUtil.computePlaneEquation((Vector3d)playerPos, (Vector3d)b, (Vector3d)c, (Vector4d)plane);
            double dist = Math.abs(VecmathUtil.distanceFromPointToPlane((Vector4d)plane, (Vector3d)new Vector3d(player.field_70165_t, player.field_70163_u, player.field_70161_v)));
            double minDist = 0.15;
            if (dist < minDist) {
                double dropRate = minDist * 10.0 - dist * 10.0;
                verticalSpeed += verticalSpeed * dropRate * 8.0;
                horizontalSpeed -= 0.02 * dropRate;
            }
            double x = Math.cos(Math.toRadians(player.field_70759_as + 90.0f)) * horizontalSpeed;
            double z = Math.sin(Math.toRadians(player.field_70759_as + 90.0f)) * horizontalSpeed;
            player.field_70159_w += x;
            player.field_70179_y += z;
            player.field_70181_x = verticalSpeed;
            player.field_70143_R = 0.0f;
        }
    }
}

