/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.base.item.darksteel.upgrade.energy;

import com.enderio.core.client.handlers.SpecialTooltipHandler;
import crazypants.enderio.api.upgrades.IDarkSteelItem;
import crazypants.enderio.base.EnderIO;
import crazypants.enderio.base.config.Config;
import crazypants.enderio.base.handler.darksteel.AbstractUpgrade;
import crazypants.enderio.base.init.ModObject;
import crazypants.enderio.base.item.darksteel.upgrade.energy.EnergyUpgradeManager;
import crazypants.enderio.base.item.travelstaff.ItemTravelStaff;
import crazypants.enderio.base.lang.LangPower;
import crazypants.enderio.base.material.material.Material;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class EnergyUpgrade
extends AbstractUpgrade {
    @Nonnull
    public static final EnergyUpgrade EMPOWERED = new EnergyUpgrade(0, "enderio.darksteel.upgrade.empowered_one", Config.darkSteelUpgradeVibrantCost, new ItemStack(ModObject.itemMaterial.getItemNN(), 1, Material.VIBRANT_CYSTAL.ordinal()), Config.darkSteelPowerStorageBase, Config.darkSteelPowerStorageBase / 100);
    @Nonnull
    public static final EnergyUpgrade EMPOWERED_TWO = new EnergyUpgrade(1, "enderio.darksteel.upgrade.empowered_two", Config.darkSteelUpgradePowerOneCost, new ItemStack(ModObject.itemBasicCapacitor.getItemNN(), 1, 0), Config.darkSteelPowerStorageLevelOne, Config.darkSteelPowerStorageLevelOne / 100);
    @Nonnull
    public static final EnergyUpgrade EMPOWERED_THREE = new EnergyUpgrade(2, "enderio.darksteel.upgrade.empowered_three", Config.darkSteelUpgradePowerTwoCost, new ItemStack(ModObject.itemBasicCapacitor.getItemNN(), 1, 1), Config.darkSteelPowerStorageLevelTwo, Config.darkSteelPowerStorageLevelTwo / 100);
    @Nonnull
    public static final EnergyUpgrade EMPOWERED_FOUR = new EnergyUpgrade(3, "enderio.darksteel.upgrade.empowered_four", Config.darkSteelUpgradePowerThreeCost, new ItemStack(ModObject.itemBasicCapacitor.getItemNN(), 1, 2), Config.darkSteelPowerStorageLevelThree, Config.darkSteelPowerStorageLevelThree / 100);
    protected final int capacity;
    protected final int level;
    protected final int maxInRF;
    protected final int maxOutRF;

    public static EnergyUpgrade loadAnyFromItem(@Nonnull ItemStack stack) {
        if (EMPOWERED_FOUR.hasUpgrade(stack)) {
            return EMPOWERED_FOUR;
        }
        if (EMPOWERED_THREE.hasUpgrade(stack)) {
            return EMPOWERED_THREE;
        }
        if (EMPOWERED_TWO.hasUpgrade(stack)) {
            return EMPOWERED_TWO;
        }
        if (EMPOWERED.hasUpgrade(stack) || stack.func_77973_b() instanceof ItemTravelStaff) {
            return EMPOWERED;
        }
        return null;
    }

    public EnergyUpgrade(int level, @Nonnull String name, int levels, @Nonnull ItemStack upgradeItem, int capacity, int maxReceiveIO) {
        super("energyUpgrade", level, name, upgradeItem, levels);
        this.level = level;
        this.capacity = capacity;
        this.maxInRF = maxReceiveIO;
        this.maxOutRF = maxReceiveIO;
    }

    @Override
    public boolean canAddToItem(@Nonnull ItemStack stack, @Nonnull IDarkSteelItem item) {
        AbstractUpgrade up = EnergyUpgradeManager.next(EnergyUpgrade.loadAnyFromItem(stack));
        if (up == null) {
            return false;
        }
        return up.getUnlocalizedName().equals(this.unlocName);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void addDetailedEntries(@Nonnull ItemStack itemstack, @Nullable EntityPlayer entityplayer, @Nonnull List<String> list, boolean flag) {
        ArrayList<String> upgradeStr = new ArrayList<String>();
        upgradeStr.add(TextFormatting.DARK_AQUA + EnderIO.lang.localizeExact(this.getUnlocalizedName() + ".name"));
        if (itemstack.func_77984_f()) {
            SpecialTooltipHandler.addDetailedTooltipFromResources(upgradeStr, (String)this.getUnlocalizedName());
            String percDamage = (int)Math.round(this.getAbsorptionRatio() * 100.0) + "";
            String capString = LangPower.RF(this.capacity);
            for (int i = 0; i < upgradeStr.size(); ++i) {
                String str = (String)upgradeStr.get(i);
                str = str.replaceAll("\\$P", capString);
                str = str.replaceAll("\\$D", percDamage);
                upgradeStr.set(i, str);
            }
        }
        list.addAll(upgradeStr);
    }

    public boolean isAbsorbDamageWithPower() {
        return EnergyUpgradeManager.RANDOM.nextDouble() < this.getAbsorptionRatio();
    }

    private double getAbsorptionRatio() {
        int val = this.level;
        if (val >= Config.darkSteelPowerDamgeAbsorptionRatios.length) {
            val = 0;
        }
        return Config.darkSteelPowerDamgeAbsorptionRatios[val];
    }

    public int getLevel() {
        return this.level;
    }

    @Nonnull
    public EnergyUpgradeHolder getEnergyUpgradeHolder(@Nonnull ItemStack stack) {
        return new EnergyUpgradeHolder(stack);
    }

    public class EnergyUpgradeHolder {
        private int energy;

        private EnergyUpgradeHolder(int energy) {
            this.setEnergy(energy);
        }

        private EnergyUpgradeHolder(ItemStack stack) {
            this.setEnergy(EnergyUpgrade.this.getOrCreateUpgradeNBT(stack).func_74762_e("energy"));
        }

        public int getEnergy() {
            return this.energy;
        }

        public void setEnergy(int energy) {
            this.energy = MathHelper.func_76125_a((int)energy, (int)0, (int)EnergyUpgrade.this.capacity);
        }

        public int receiveEnergy(int maxRF, boolean simulate) {
            int energyReceived = Math.max(0, Math.min(EnergyUpgrade.this.capacity - this.energy, Math.min(EnergyUpgrade.this.maxInRF, maxRF)));
            if (!simulate) {
                this.energy += energyReceived;
            }
            return energyReceived;
        }

        public int extractEnergy(int maxExtract, boolean simulate) {
            int energyExtracted = Math.max(0, Math.min(this.energy, Math.min(EnergyUpgrade.this.maxOutRF, maxExtract)));
            if (!simulate) {
                this.energy -= energyExtracted;
            }
            return energyExtracted;
        }

        @Nonnull
        public EnergyUpgrade getUpgrade() {
            return EnergyUpgrade.this;
        }

        public void writeToItem(@Nonnull ItemStack stack, @Nonnull IDarkSteelItem item) {
            EnergyUpgrade.this.addToItem(stack, item);
            EnergyUpgrade.this.getOrCreateUpgradeNBT(stack).func_74768_a("energy", this.energy);
        }

        public int getCapacity() {
            return EnergyUpgrade.this.capacity;
        }
    }
}

