/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.base.item.darksteel;

import com.enderio.core.api.client.gui.IAdvancedTooltipProvider;
import com.enderio.core.client.handlers.SpecialTooltipHandler;
import com.enderio.core.common.transform.EnderCoreMethods;
import com.enderio.core.common.util.ItemUtil;
import com.enderio.core.common.util.NullHelper;
import com.enderio.core.common.util.OreDictionaryHelper;
import com.enderio.core.common.util.Util;
import com.google.common.collect.Multimap;
import crazypants.enderio.api.teleport.IItemOfTravel;
import crazypants.enderio.api.teleport.TravelSource;
import crazypants.enderio.api.upgrades.IDarkSteelItem;
import crazypants.enderio.api.upgrades.IDarkSteelUpgrade;
import crazypants.enderio.base.EnderIO;
import crazypants.enderio.base.EnderIOTab;
import crazypants.enderio.base.config.Config;
import crazypants.enderio.base.handler.darksteel.DarkSteelRecipeManager;
import crazypants.enderio.base.init.IModObject;
import crazypants.enderio.base.init.ModObject;
import crazypants.enderio.base.integration.tic.TicUtil;
import crazypants.enderio.base.item.darksteel.attributes.DarkSteelAttributeModifiers;
import crazypants.enderio.base.item.darksteel.upgrade.energy.EnergyUpgrade;
import crazypants.enderio.base.item.darksteel.upgrade.energy.EnergyUpgradeManager;
import crazypants.enderio.base.item.darksteel.upgrade.travel.TravelUpgrade;
import crazypants.enderio.base.material.alloy.Alloy;
import crazypants.enderio.base.render.itemoverlay.PowerBarOverlayRenderHelper;
import crazypants.enderio.base.teleport.TravelController;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.monster.EntityCreeper;
import net.minecraft.entity.monster.EntityEnderman;
import net.minecraft.entity.monster.EntitySkeleton;
import net.minecraft.entity.monster.EntityWitherSkeleton;
import net.minecraft.entity.monster.EntityZombie;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemSword;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.util.EnumHelper;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.event.entity.living.EnderTeleportEvent;
import net.minecraftforge.event.entity.living.LivingDropsEvent;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemDarkSteelSword
extends ItemSword
implements IAdvancedTooltipProvider,
IDarkSteelItem,
IItemOfTravel,
EnderCoreMethods.IOverlayRenderAware {
    @Nonnull
    private static final String HIT_BY_DARK_STEEL_SWORD = "hitByDarkSteelSword";
    @Nonnull
    private static final ResourceLocation ENDERZOO_ENDERMINY = new ResourceLocation("enderzoo", "enderminy");
    @Nonnull
    static final Item.ToolMaterial MATERIAL = (Item.ToolMaterial)NullHelper.notnull((Object)EnumHelper.addToolMaterial((String)"darkSteel", (int)(Config.darkSteelPickMinesTiCArdite ? 5 : 3), (int)2000, (float)8.0f, (float)3.0001f, (int)25), (String)"failed to add tool material");
    private final int powerPerDamagePoint = Config.darkSteelPowerStorageBase / MATERIAL.func_77997_a();
    private long lastBlickTick = -1L;

    public static boolean isEquipped(EntityPlayer player) {
        return player != null && player.func_184614_ca().func_77973_b() == ModObject.itemDarkSteelSword.getItem();
    }

    public static boolean isEquippedAndPowered(EntityPlayer player, int requiredPower) {
        return ItemDarkSteelSword.getStoredPower(player) > requiredPower;
    }

    public static int getStoredPower(EntityPlayer player) {
        return EnergyUpgradeManager.getEnergyStored(player.func_184614_ca());
    }

    public static ItemDarkSteelSword create(@Nonnull IModObject modObject) {
        ItemDarkSteelSword res = new ItemDarkSteelSword(modObject);
        MinecraftForge.EVENT_BUS.register((Object)res);
        return res;
    }

    public ItemDarkSteelSword(@Nonnull IModObject modObject) {
        super(MATERIAL);
        this.func_77637_a(EnderIOTab.tabEnderIOItems);
        modObject.apply(this);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_150895_a(@Nonnull CreativeTabs tab, @Nonnull NonNullList<ItemStack> list) {
        if (this.func_194125_a(tab)) {
            ItemStack is = new ItemStack((Item)this);
            list.add((Object)is);
            is = new ItemStack((Item)this);
            EnergyUpgrade.EMPOWERED_FOUR.addToItem(is, this);
            EnergyUpgradeManager.setPowerFull(is, this);
            TravelUpgrade.INSTANCE.addToItem(is, this);
            list.add((Object)is);
        }
    }

    @Override
    public int getIngotsRequiredForFullRepair() {
        return 3;
    }

    @Override
    public boolean isItemForRepair(@Nonnull ItemStack right) {
        return OreDictionaryHelper.hasName((ItemStack)right, (String)Alloy.DARK_STEEL.getOreIngot());
    }

    @SubscribeEvent
    public void onEnderTeleport(EnderTeleportEvent evt) {
        if (evt.getEntityLiving().getEntityData().func_74767_n(HIT_BY_DARK_STEEL_SWORD)) {
            evt.setCanceled(true);
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void onEntityDrop(LivingDropsEvent evt) {
        Entity entity = evt.getSource().func_76346_g();
        EntityLivingBase entityLiving = evt.getEntityLiving();
        if (!(entity instanceof EntityPlayer) || entityLiving == null) {
            return;
        }
        EntityPlayer player = (EntityPlayer)entity;
        if (this.handleBeheadingWeapons(player, evt)) {
            return;
        }
        double skullDropChance = this.getSkullDropChance(player, evt);
        if (player instanceof FakePlayer) {
            skullDropChance *= (double)Config.fakePlayerSkullChance;
        }
        if (Math.random() <= skullDropChance) {
            this.dropSkull(evt, player);
        }
        if (ItemDarkSteelSword.isEquipped(player)) {
            ResourceLocation name = EntityList.func_191301_a((Entity)entityLiving);
            if (entityLiving instanceof EntityEnderman || ENDERZOO_ENDERMINY.equals((Object)name)) {
                double chance;
                int numPearls = 0;
                for (chance = Config.darkSteelSwordEnderPearlDropChance; chance >= 1.0; chance -= 1.0) {
                    ++numPearls;
                }
                if (chance > 0.0 && Math.random() <= chance) {
                    ++numPearls;
                }
                for (int i = 0; i < evt.getLootingLevel(); ++i) {
                    for (chance = Config.darkSteelSwordEnderPearlDropChancePerLooting; chance >= 1.0; chance -= 1.0) {
                        ++numPearls;
                    }
                    if (!(chance > 0.0) || !(Math.random() <= chance)) continue;
                    ++numPearls;
                }
                int existing = 0;
                for (EntityItem stack : evt.getDrops()) {
                    if (stack.func_92059_d().func_77973_b() != Items.field_151079_bi) continue;
                    existing += stack.func_92059_d().func_190916_E();
                }
                int toDrop = numPearls - existing;
                if (toDrop > 0) {
                    evt.getDrops().add(Util.createDrop((World)player.field_70170_p, (ItemStack)new ItemStack(Items.field_151079_bi, toDrop, 0), (double)entityLiving.field_70165_t, (double)entityLiving.field_70163_u, (double)entityLiving.field_70161_v, (boolean)false));
                }
            }
        }
    }

    protected void dropSkull(LivingDropsEvent evt, EntityPlayer player) {
        ItemStack skull = this.getSkullForEntity(evt.getEntityLiving());
        if (skull != null && !this.containsDrop(evt, skull)) {
            evt.getDrops().add(Util.createEntityItem((World)player.field_70170_p, (ItemStack)skull, (double)evt.getEntityLiving().field_70165_t, (double)evt.getEntityLiving().field_70163_u, (double)evt.getEntityLiving().field_70161_v));
        }
    }

    private boolean handleBeheadingWeapons(EntityPlayer player, LivingDropsEvent evt) {
        if (player == null) {
            return false;
        }
        ItemStack equipped = player.func_184614_ca();
        NBTTagCompound tagCompound = equipped.func_77978_p();
        if (tagCompound == null) {
            return false;
        }
        int beheading = TicUtil.getModifier(tagCompound, "beheading");
        int cleaver = TicUtil.getModifier(tagCompound, "beheading_cleaver");
        if (beheading == 0 && cleaver == 0) {
            return false;
        }
        if (!(evt.getEntityLiving() instanceof EntityEnderman)) {
            return true;
        }
        float chance = Math.max(Config.vanillaSwordSkullChance, (float)cleaver * Config.ticCleaverSkullDropChance) + Config.ticBeheadingSkullModifier * (float)beheading;
        if (player instanceof FakePlayer) {
            chance *= Config.fakePlayerSkullChance;
        }
        while (chance >= 1.0f) {
            this.dropSkull(evt, player);
            chance -= 1.0f;
        }
        if (chance > 0.0f && Math.random() <= (double)chance) {
            this.dropSkull(evt, player);
        }
        return true;
    }

    private double getSkullDropChance(@Nonnull EntityPlayer player, LivingDropsEvent evt) {
        float fromLooting;
        float fromWeapon;
        if (this.isWitherSkeleton(evt)) {
            if (ItemDarkSteelSword.isEquippedAndPowered(player, Config.darkSteelSwordPowerUsePerHit)) {
                return Config.darkSteelSwordWitherSkullChance + Config.darkSteelSwordWitherSkullLootingModifier * (float)evt.getLootingLevel();
            }
            return 0.01;
        }
        if (ItemDarkSteelSword.isEquippedAndPowered(player, Config.darkSteelSwordPowerUsePerHit)) {
            fromWeapon = Config.darkSteelSwordSkullChance;
            fromLooting = Config.darkSteelSwordSkullLootingModifier * (float)evt.getLootingLevel();
        } else {
            fromWeapon = Config.vanillaSwordSkullChance;
            fromLooting = Config.vanillaSwordSkullLootingModifier * (float)evt.getLootingLevel();
        }
        return fromWeapon + fromLooting;
    }

    protected boolean isWitherSkeleton(LivingDropsEvent evt) {
        return evt.getEntityLiving() instanceof EntityWitherSkeleton;
    }

    private boolean containsDrop(LivingDropsEvent evt, @Nonnull ItemStack skull) {
        for (EntityItem ei : evt.getDrops()) {
            if (ei == null || ei.func_92059_d().func_77973_b() != skull.func_77973_b() || ei.func_92059_d().func_77952_i() != skull.func_77952_i()) continue;
            return true;
        }
        return false;
    }

    private ItemStack getSkullForEntity(EntityLivingBase entityLiving) {
        if (entityLiving instanceof EntitySkeleton) {
            return new ItemStack(Items.field_151144_bL, 1, 0);
        }
        if (entityLiving instanceof EntityWitherSkeleton) {
            return new ItemStack(Items.field_151144_bL, 1, 1);
        }
        if (entityLiving.getClass() == EntityZombie.class) {
            return new ItemStack(Items.field_151144_bL, 1, 2);
        }
        if (entityLiving instanceof EntityCreeper) {
            return new ItemStack(Items.field_151144_bL, 1, 4);
        }
        if (entityLiving instanceof EntityEnderman) {
            return new ItemStack(ModObject.blockEndermanSkull.getBlockNN());
        }
        return null;
    }

    @Nonnull
    public Multimap<String, AttributeModifier> getAttributeModifiers(@Nonnull EntityEquipmentSlot equipmentSlot, @Nonnull ItemStack stack) {
        Multimap res = super.func_111205_h(equipmentSlot);
        if (equipmentSlot == EntityEquipmentSlot.MAINHAND && (Config.darkSteelSwordPowerUsePerHit <= 0 || EnergyUpgradeManager.getEnergyStored(stack) >= Config.darkSteelSwordPowerUsePerHit)) {
            EnergyUpgrade energyUpgrade = EnergyUpgrade.loadAnyFromItem(stack);
            int level = energyUpgrade.getLevel();
            res.put((Object)SharedMonsterAttributes.field_111264_e.func_111108_a(), (Object)DarkSteelAttributeModifiers.getAttackDamage(level));
            res.put((Object)SharedMonsterAttributes.field_188790_f.func_111108_a(), (Object)DarkSteelAttributeModifiers.getAttackSpeed(level));
        }
        return res;
    }

    public boolean func_77644_a(@Nonnull ItemStack stack, @Nonnull EntityLivingBase entity, @Nonnull EntityLivingBase playerEntity) {
        if (playerEntity instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)playerEntity;
            ItemStack sword = player.func_184614_ca();
            EnergyUpgrade.EnergyUpgradeHolder eu = EnergyUpgradeManager.loadFromItem(stack);
            if (eu != null && eu.getUpgrade().isAbsorbDamageWithPower() && eu.getEnergy() > 0) {
                eu.extractEnergy(this.powerPerDamagePoint, false);
            } else {
                super.func_77644_a(stack, entity, playerEntity);
            }
            if (eu != null) {
                eu.writeToItem(sword, this);
                if (eu.getEnergy() > Config.darkSteelSwordPowerUsePerHit) {
                    this.extractInternal(player.func_184614_ca(), Config.darkSteelSwordPowerUsePerHit);
                    entity.getEntityData().func_74757_a(HIT_BY_DARK_STEEL_SWORD, true);
                }
            }
        }
        return true;
    }

    @Override
    public int getEnergyStored(@Nonnull ItemStack container) {
        return EnergyUpgradeManager.getEnergyStored(container);
    }

    public boolean func_82789_a(@Nonnull ItemStack i1, @Nonnull ItemStack i2) {
        return false;
    }

    public void addCommonEntries(@Nonnull ItemStack itemstack, @Nullable EntityPlayer entityplayer, @Nonnull List<String> list, boolean flag) {
        DarkSteelRecipeManager.addCommonTooltipEntries(itemstack, entityplayer, list, flag);
    }

    public void addBasicEntries(@Nonnull ItemStack itemstack, @Nullable EntityPlayer entityplayer, @Nonnull List<String> list, boolean flag) {
        DarkSteelRecipeManager.addBasicTooltipEntries(itemstack, entityplayer, list, flag);
    }

    public void addDetailedEntries(@Nonnull ItemStack itemstack, @Nullable EntityPlayer entityplayer, @Nonnull List<String> list, boolean flag) {
        String str;
        if (!SpecialTooltipHandler.showDurability((boolean)flag)) {
            list.add(ItemUtil.getDurabilityString((ItemStack)itemstack));
        }
        if ((str = EnergyUpgradeManager.getStoredEnergyString(itemstack)) != null) {
            list.add(str);
        }
        DarkSteelRecipeManager.addAdvancedTooltipEntries(itemstack, entityplayer, list, flag);
    }

    public ItemStack createItemStack() {
        return new ItemStack((Item)this);
    }

    @Override
    public boolean isActive(@Nonnull EntityPlayer ep, @Nonnull ItemStack equipped) {
        return this.isTravelUpgradeActive(ep, equipped);
    }

    @Override
    public void extractInternal(@Nonnull ItemStack equipped, int power) {
        EnergyUpgradeManager.extractEnergy(equipped, this, power, false);
    }

    private boolean isTravelUpgradeActive(@Nonnull EntityPlayer ep, @Nonnull ItemStack equipped) {
        return ItemDarkSteelSword.isEquipped(ep) && ep.func_70093_af() && TravelUpgrade.INSTANCE.hasUpgrade(equipped);
    }

    @Nonnull
    public ActionResult<ItemStack> func_77659_a(@Nonnull World world, @Nonnull EntityPlayer player, @Nonnull EnumHand hand) {
        ItemStack stack;
        if (hand == EnumHand.MAIN_HAND && this.isTravelUpgradeActive(player, stack = player.func_184586_b(hand))) {
            if (world.field_72995_K && TravelController.instance.activateTravelAccessable(stack, hand, world, player, TravelSource.STAFF)) {
                player.func_184609_a(hand);
                return new ActionResult(EnumActionResult.SUCCESS, (Object)stack);
            }
            long ticksSinceBlink = EnderIO.proxy.getTickCount() - this.lastBlickTick;
            if (ticksSinceBlink < 0L) {
                this.lastBlickTick = -1L;
            }
            if (Config.travelStaffBlinkEnabled && world.field_72995_K && ticksSinceBlink >= (long)Config.travelStaffBlinkPauseTicks && TravelController.instance.doBlink(stack, hand, player)) {
                player.func_184609_a(hand);
                this.lastBlickTick = EnderIO.proxy.getTickCount();
            }
            return new ActionResult(EnumActionResult.SUCCESS, (Object)stack);
        }
        return super.func_77659_a(world, player, hand);
    }

    public void renderItemOverlayIntoGUI(@Nonnull ItemStack stack, int xPosition, int yPosition) {
        PowerBarOverlayRenderHelper.instance_upgradeable.render(stack, xPosition, yPosition);
    }

    public boolean shouldCauseReequipAnimation(@Nonnull ItemStack oldStack, @Nonnull ItemStack newStack, boolean slotChanged) {
        return slotChanged || oldStack.func_77973_b() != newStack.func_77973_b();
    }

    @Override
    public boolean isForSlot(@Nonnull EntityEquipmentSlot slot) {
        return slot == EntityEquipmentSlot.MAINHAND;
    }

    @Override
    public boolean hasUpgradeCallbacks(@Nonnull IDarkSteelUpgrade upgrade) {
        return upgrade == TravelUpgrade.INSTANCE;
    }
}

