/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.base.item.darksteel;

import com.enderio.core.api.client.gui.IAdvancedTooltipProvider;
import com.enderio.core.client.handlers.SpecialTooltipHandler;
import com.enderio.core.common.transform.EnderCoreMethods;
import com.enderio.core.common.util.ItemUtil;
import com.enderio.core.common.util.NNList;
import com.enderio.core.common.util.OreDictionaryHelper;
import com.google.common.base.Predicate;
import crazypants.enderio.api.upgrades.IDarkSteelItem;
import crazypants.enderio.base.EnderIOTab;
import crazypants.enderio.base.config.Config;
import crazypants.enderio.base.handler.darksteel.DarkSteelRecipeManager;
import crazypants.enderio.base.init.IModObject;
import crazypants.enderio.base.init.ModObject;
import crazypants.enderio.base.item.darksteel.ItemDarkSteelSword;
import crazypants.enderio.base.item.darksteel.upgrade.energy.EnergyUpgrade;
import crazypants.enderio.base.item.darksteel.upgrade.energy.EnergyUpgradeManager;
import crazypants.enderio.base.lang.Lang;
import crazypants.enderio.base.material.alloy.Alloy;
import crazypants.enderio.base.render.itemoverlay.PowerBarOverlayRenderHelper;
import crazypants.enderio.util.Prep;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemShears;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.common.IShearable;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemDarkSteelShears
extends ItemShears
implements IAdvancedTooltipProvider,
IDarkSteelItem,
EnderCoreMethods.IOverlayRenderAware {
    private final MultiHarvestComparator harvestComparator = new MultiHarvestComparator();
    private final EntityComparator entityComparator = new EntityComparator();
    @Nonnull
    private static final Predicate<Entity> selectShearable = new Predicate<Entity>(){

        public boolean apply(@Nullable Entity entity) {
            return entity instanceof IShearable && !entity.field_70128_L && ((IShearable)entity).isShearable(Prep.getEmpty(), (IBlockAccess)entity.field_70170_p, entity.func_180425_c());
        }

        public boolean equals(@Nullable Object obj) {
            return super.equals(obj);
        }

        public int hashCode() {
            return super.hashCode();
        }
    };

    public static boolean isEquipped(EntityPlayer player) {
        return player != null && player.func_184614_ca().func_77973_b() == ModObject.itemDarkSteelAxe.getItem();
    }

    public static boolean isEquippedAndPowered(EntityPlayer player, int requiredPower) {
        return ItemDarkSteelShears.getStoredPower(player) > requiredPower;
    }

    public static int getStoredPower(EntityPlayer player) {
        return EnergyUpgradeManager.getEnergyStored(player.func_184614_ca());
    }

    public static ItemDarkSteelShears create(@Nonnull IModObject modObject) {
        ItemDarkSteelShears res = new ItemDarkSteelShears(modObject);
        MinecraftForge.EVENT_BUS.register((Object)res);
        return res;
    }

    protected ItemDarkSteelShears(@Nonnull IModObject modObject) {
        this.func_77656_e(this.func_77612_l() * Config.darkSteelShearsDurabilityFactor);
        this.func_77637_a(EnderIOTab.tabEnderIOItems);
        modObject.apply(this);
    }

    @Override
    public int getIngotsRequiredForFullRepair() {
        return 2;
    }

    @Override
    public boolean isItemForRepair(@Nonnull ItemStack right) {
        return OreDictionaryHelper.hasName((ItemStack)right, (String)Alloy.DARK_STEEL.getOreIngot());
    }

    @SideOnly(value=Side.CLIENT)
    public void func_150895_a(@Nonnull CreativeTabs tab, @Nonnull NonNullList<ItemStack> list) {
        if (this.func_194125_a(tab)) {
            ItemStack is = new ItemStack((Item)this);
            list.add((Object)is);
            is = new ItemStack((Item)this);
            EnergyUpgrade.EMPOWERED_FOUR.addToItem(is, this);
            EnergyUpgradeManager.setPowerFull(is, this);
            list.add((Object)is);
        }
    }

    public boolean onBlockStartBreak(@Nonnull ItemStack itemstack, @Nonnull BlockPos pos, @Nonnull EntityPlayer player) {
        if (player.field_70170_p.field_72995_K) {
            return false;
        }
        int powerStored = ItemDarkSteelShears.getStoredPower(player);
        if (powerStored < Config.darkSteelShearsPowerUsePerDamagePoint) {
            return super.onBlockStartBreak(itemstack, pos, player);
        }
        ArrayList<BlockPos> res = new ArrayList<BlockPos>();
        int x = pos.func_177958_n();
        int y = pos.func_177956_o();
        int z = pos.func_177952_p();
        for (int dx = -Config.darkSteelShearsBlockAreaBoostWhenPowered; dx <= Config.darkSteelShearsBlockAreaBoostWhenPowered; ++dx) {
            for (int dy = -Config.darkSteelShearsBlockAreaBoostWhenPowered; dy <= Config.darkSteelShearsBlockAreaBoostWhenPowered; ++dy) {
                for (int dz = -Config.darkSteelShearsBlockAreaBoostWhenPowered; dz <= Config.darkSteelShearsBlockAreaBoostWhenPowered; ++dz) {
                    Block block2 = player.field_70170_p.func_180495_p(new BlockPos(x + dx, y + dy, z + dz)).func_177230_c();
                    if (!(block2 instanceof IShearable) || !((IShearable)block2).isShearable(itemstack, (IBlockAccess)player.field_70170_p, new BlockPos(x + dx, y + dy, z + dz))) continue;
                    res.add(new BlockPos(x + dx, y + dy, z + dz));
                }
            }
        }
        NNList sortedTargets = new NNList(res);
        this.harvestComparator.refPoint = pos;
        Collections.sort(sortedTargets, this.harvestComparator);
        int maxBlocks = Math.min(sortedTargets.size(), powerStored / Config.darkSteelShearsPowerUsePerDamagePoint);
        for (int i = 0; i < maxBlocks; ++i) {
            BlockPos bc2 = (BlockPos)sortedTargets.get(i);
            super.onBlockStartBreak(itemstack, bc2, player);
            if (bc2 == pos) continue;
            player.field_70170_p.func_175698_g(bc2);
        }
        return false;
    }

    public boolean func_111207_a(@Nonnull ItemStack itemstack, @Nonnull EntityPlayer player, @Nonnull EntityLivingBase entity, @Nonnull EnumHand hand) {
        if (entity.field_70170_p.field_72995_K) {
            return false;
        }
        int powerStored = ItemDarkSteelShears.getStoredPower(player);
        if (powerStored < Config.darkSteelShearsPowerUsePerDamagePoint) {
            return super.func_111207_a(itemstack, player, entity, hand);
        }
        if (entity instanceof IShearable) {
            AxisAlignedBB bb = new AxisAlignedBB(entity.field_70165_t - (double)Config.darkSteelShearsEntityAreaBoostWhenPowered, entity.field_70163_u - (double)Config.darkSteelShearsEntityAreaBoostWhenPowered, entity.field_70161_v - (double)Config.darkSteelShearsEntityAreaBoostWhenPowered, entity.field_70165_t + (double)Config.darkSteelShearsEntityAreaBoostWhenPowered, entity.field_70163_u + (double)Config.darkSteelShearsEntityAreaBoostWhenPowered, entity.field_70161_v + (double)Config.darkSteelShearsEntityAreaBoostWhenPowered);
            ArrayList sortedTargets = new ArrayList(entity.field_70170_p.func_175647_a(Entity.class, bb, selectShearable));
            this.entityComparator.refPoint = entity;
            Collections.sort(sortedTargets, this.entityComparator);
            boolean result = false;
            int maxSheep = Math.min(sortedTargets.size(), powerStored / Config.darkSteelShearsPowerUsePerDamagePoint);
            for (int i = 0; i < maxSheep; ++i) {
                Entity entity2 = (Entity)sortedTargets.get(i);
                if (!(entity2 instanceof EntityLivingBase) || !super.func_111207_a(itemstack, player, (EntityLivingBase)entity2, hand)) continue;
                result = true;
            }
            return result;
        }
        return false;
    }

    @SubscribeEvent
    public void onBreakSpeedEvent(PlayerEvent.BreakSpeed evt) {
        if ((double)evt.getOriginalSpeed() > 2.0 && ItemDarkSteelShears.isEquippedAndPowered(evt.getEntityPlayer(), Config.darkSteelShearsPowerUsePerDamagePoint)) {
            evt.setNewSpeed(evt.getOriginalSpeed() * Config.darkSteelShearsEffeciencyBoostWhenPowered);
        }
    }

    public void setDamage(@Nonnull ItemStack stack, int newDamage) {
        int oldDamage = this.getDamage(stack);
        if (newDamage <= oldDamage) {
            super.setDamage(stack, newDamage);
        }
        int damage = newDamage - oldDamage;
        EnergyUpgrade.EnergyUpgradeHolder eu = EnergyUpgradeManager.loadFromItem(stack);
        if (eu != null && eu.getUpgrade().isAbsorbDamageWithPower() && eu.getEnergy() > 0) {
            eu.extractEnergy(damage * Config.darkSteelShearsPowerUsePerDamagePoint, false);
        } else {
            super.setDamage(stack, newDamage);
        }
        if (eu != null) {
            eu.writeToItem(stack, this);
        }
    }

    public boolean func_82789_a(@Nonnull ItemStack i1, @Nonnull ItemStack i2) {
        return false;
    }

    public int func_77619_b() {
        return ItemDarkSteelSword.MATERIAL.func_77995_e();
    }

    public void addCommonEntries(@Nonnull ItemStack itemstack, @Nullable EntityPlayer entityplayer, @Nonnull List<String> list, boolean flag) {
        DarkSteelRecipeManager.addCommonTooltipEntries(itemstack, entityplayer, list, flag);
    }

    public void addBasicEntries(@Nonnull ItemStack itemstack, @Nullable EntityPlayer entityplayer, @Nonnull List<String> list, boolean flag) {
        DarkSteelRecipeManager.addBasicTooltipEntries(itemstack, entityplayer, list, flag);
    }

    public void addDetailedEntries(@Nonnull ItemStack itemstack, @Nullable EntityPlayer entityplayer, @Nonnull List<String> list, boolean flag) {
        String str;
        if (!SpecialTooltipHandler.showDurability((boolean)flag)) {
            list.add(ItemUtil.getDurabilityString((ItemStack)itemstack));
        }
        if ((str = EnergyUpgradeManager.getStoredEnergyString(itemstack)) != null) {
            list.add(str);
        }
        if (EnergyUpgradeManager.itemHasAnyPowerUpgrade(itemstack)) {
            list.add(Lang.SHEARS_MULTIHARVEST.get());
            list.add(Lang.SHEARS_POWERED.get(TextFormatting.WHITE, Float.valueOf(Config.darkSteelShearsEffeciencyBoostWhenPowered)));
        }
        DarkSteelRecipeManager.addAdvancedTooltipEntries(itemstack, entityplayer, list, flag);
    }

    public ItemStack createItemStack() {
        return new ItemStack((Item)this);
    }

    public void renderItemOverlayIntoGUI(@Nonnull ItemStack stack, int xPosition, int yPosition) {
        PowerBarOverlayRenderHelper.instance_upgradeable.render(stack, xPosition, yPosition);
    }

    public boolean shouldCauseReequipAnimation(@Nonnull ItemStack oldStack, @Nonnull ItemStack newStack, boolean slotChanged) {
        return slotChanged || oldStack.func_77973_b() != newStack.func_77973_b();
    }

    @Override
    public boolean isForSlot(@Nonnull EntityEquipmentSlot slot) {
        return slot == EntityEquipmentSlot.MAINHAND;
    }

    private static class EntityComparator
    implements Comparator<Entity> {
        Entity refPoint;

        private EntityComparator() {
        }

        @Override
        public int compare(Entity paramT1, Entity paramT2) {
            double distanceSqToEntity2;
            double distanceSqToEntity1 = paramT1 == null ? 0.0 : this.refPoint.func_70068_e(paramT1);
            double d = distanceSqToEntity2 = paramT2 == null ? 0.0 : this.refPoint.func_70068_e(paramT2);
            if (distanceSqToEntity1 < distanceSqToEntity2) {
                return -1;
            }
            if (distanceSqToEntity1 > distanceSqToEntity2) {
                return 1;
            }
            return 0;
        }
    }

    private static class MultiHarvestComparator
    implements Comparator<BlockPos> {
        BlockPos refPoint;

        private MultiHarvestComparator() {
        }

        @Override
        public int compare(BlockPos arg0, BlockPos arg1) {
            double d1 = this.refPoint.func_177954_c((double)arg0.func_177958_n(), (double)arg0.func_177956_o(), (double)arg0.func_177952_p());
            double d2 = this.refPoint.func_177954_c((double)arg1.func_177958_n(), (double)arg1.func_177956_o(), (double)arg1.func_177952_p());
            return MultiHarvestComparator.compare(d1, d2);
        }

        public static int compare(double x, double y) {
            return x < y ? -1 : (x == y ? 0 : 1);
        }
    }
}

