/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.base.item.darksteel;

import com.enderio.core.api.client.gui.IAdvancedTooltipProvider;
import com.enderio.core.client.handlers.SpecialTooltipHandler;
import com.enderio.core.common.transform.EnderCoreMethods;
import com.enderio.core.common.util.ItemUtil;
import com.enderio.core.common.util.OreDictionaryHelper;
import crazypants.enderio.api.upgrades.IDarkSteelItem;
import crazypants.enderio.base.EnderIOTab;
import crazypants.enderio.base.config.Config;
import crazypants.enderio.base.handler.darksteel.DarkSteelRecipeManager;
import crazypants.enderio.base.init.IModObject;
import crazypants.enderio.base.item.darksteel.upgrade.energy.EnergyUpgrade;
import crazypants.enderio.base.item.darksteel.upgrade.energy.EnergyUpgradeManager;
import crazypants.enderio.base.material.material.Material;
import crazypants.enderio.base.render.itemoverlay.PowerBarOverlayRenderHelper;
import crazypants.enderio.util.Prep;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.projectile.EntityArrow;
import net.minecraft.init.Enchantments;
import net.minecraft.init.Items;
import net.minecraft.init.SoundEvents;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.EnumAction;
import net.minecraft.item.IItemPropertyGetter;
import net.minecraft.item.Item;
import net.minecraft.item.ItemArrow;
import net.minecraft.item.ItemBow;
import net.minecraft.item.ItemStack;
import net.minecraft.stats.StatList;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.world.World;
import net.minecraftforge.client.event.FOVUpdateEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemDarkSteelBow
extends ItemBow
implements IDarkSteelItem,
IAdvancedTooltipProvider,
EnderCoreMethods.IOverlayRenderAware {
    private float damageBonus = Config.darkSteelBowDamageBonus;

    public static ItemDarkSteelBow create(@Nonnull IModObject modObject) {
        ItemDarkSteelBow res = new ItemDarkSteelBow(modObject);
        MinecraftForge.EVENT_BUS.register((Object)res);
        return res;
    }

    protected ItemDarkSteelBow(@Nonnull IModObject modObject) {
        modObject.apply(this);
        this.func_77637_a(EnderIOTab.tabEnderIOItems);
        this.func_77656_e(300);
        this.func_77627_a(false);
        this.func_185043_a(new ResourceLocation("pull"), new IItemPropertyGetter(){

            @SideOnly(value=Side.CLIENT)
            public float func_185085_a(@Nonnull ItemStack stack, @Nullable World worldIn, @Nullable EntityLivingBase entityIn) {
                return ItemDarkSteelBow.this.updatePullProperty(stack, worldIn, entityIn);
            }
        });
        this.func_185043_a(new ResourceLocation("pulling"), new IItemPropertyGetter(){

            @SideOnly(value=Side.CLIENT)
            public float func_185085_a(@Nonnull ItemStack stack, @Nullable World worldIn, @Nullable EntityLivingBase entityIn) {
                return ItemDarkSteelBow.this.updatePullingProperty(stack, entityIn);
            }
        });
    }

    private float updatePullProperty(@Nonnull ItemStack stack, @Nullable World worldIn, @Nullable EntityLivingBase entityIn) {
        if (stack.func_77973_b() != this || entityIn == null) {
            return 0.0f;
        }
        float res = (float)(stack.func_77988_m() - entityIn.func_184605_cv()) / (float)this.getDrawTime(stack);
        return res;
    }

    private float updatePullingProperty(@Nonnull ItemStack stack, @Nullable EntityLivingBase entityIn) {
        float res = entityIn != null && entityIn.func_184587_cr() && entityIn.func_184607_cu() == stack ? 1.0f : 0.0f;
        return res;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_150895_a(@Nonnull CreativeTabs tab, @Nonnull NonNullList<ItemStack> list) {
        if (this.func_194125_a(tab)) {
            ItemStack is = new ItemStack((Item)this);
            list.add((Object)is);
            is = new ItemStack((Item)this);
            EnergyUpgrade.EMPOWERED_FOUR.addToItem(is, this);
            EnergyUpgradeManager.setPowerFull(is, this);
            list.add((Object)is);
        }
    }

    public void func_77615_a(@Nonnull ItemStack stack, @Nonnull World worldIn, @Nonnull EntityLivingBase entityLiving, int timeLeft) {
        if (!(entityLiving instanceof EntityPlayer)) {
            return;
        }
        EntityPlayer entityplayer = (EntityPlayer)entityLiving;
        boolean hasInfinateArrows = entityplayer.field_71075_bZ.field_75098_d || EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185312_x, (ItemStack)stack) > 0;
        ItemStack itemstack = this.getArrowsToShoot(entityplayer);
        int draw = this.func_77626_a(stack) - timeLeft;
        if ((draw = ForgeEventFactory.onArrowLoose((ItemStack)stack, (World)worldIn, (EntityPlayer)((EntityPlayer)entityLiving), (int)draw, (Prep.isValid(itemstack) || hasInfinateArrows ? 1 : 0) != 0)) < 0) {
            return;
        }
        if (itemstack.func_190926_b() && hasInfinateArrows) {
            itemstack = new ItemStack(Items.field_151032_g);
        }
        if (itemstack.func_190926_b()) {
            return;
        }
        float drawRatio = this.getCustumArrowVelocity(stack, draw);
        if ((double)drawRatio >= 0.1) {
            boolean arrowIsInfinite;
            boolean bl = arrowIsInfinite = hasInfinateArrows && itemstack.func_77973_b() instanceof ItemArrow;
            if (!worldIn.field_72995_K) {
                int knockBack;
                int powerLevel;
                EnergyUpgrade.EnergyUpgradeHolder upgrade = EnergyUpgradeManager.loadFromItem(stack);
                ItemArrow itemarrow = (ItemArrow)(itemstack.func_77973_b() instanceof ItemArrow ? itemstack.func_77973_b() : Items.field_151032_g);
                EntityArrow entityarrow = itemarrow.func_185052_a(worldIn, itemstack, (EntityLivingBase)entityplayer);
                entityarrow.func_184547_a((Entity)entityplayer, entityplayer.field_70125_A, entityplayer.field_70177_z, 0.0f, drawRatio * 3.0f * this.getForceMultiplier(upgrade), 0.25f);
                if (drawRatio == 1.0f) {
                    entityarrow.func_70243_d(true);
                }
                if ((powerLevel = EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185309_u, (ItemStack)stack)) > 0) {
                    entityarrow.func_70239_b(entityarrow.func_70242_d() + (double)powerLevel * 0.5 + 0.5);
                }
                if ((knockBack = EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185310_v, (ItemStack)stack)) > 0) {
                    entityarrow.func_70240_a(knockBack);
                }
                if (EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185311_w, (ItemStack)stack) > 0) {
                    entityarrow.func_70015_d(100);
                }
                stack.func_77972_a(1, (EntityLivingBase)entityplayer);
                if (arrowIsInfinite) {
                    entityarrow.field_70251_a = EntityArrow.PickupStatus.CREATIVE_ONLY;
                }
                entityarrow.func_70239_b(entityarrow.func_70242_d() + (double)this.damageBonus);
                worldIn.func_72838_d((Entity)entityarrow);
                int used = this.getRequiredPower(draw, upgrade);
                if (used > 0) {
                    upgrade.setEnergy(upgrade.getEnergy() - used);
                    upgrade.writeToItem(stack, this);
                }
            }
            worldIn.func_184148_a((EntityPlayer)null, entityplayer.field_70165_t, entityplayer.field_70163_u, entityplayer.field_70161_v, SoundEvents.field_187737_v, SoundCategory.NEUTRAL, 1.0f, 1.0f / (field_77697_d.nextFloat() * 0.4f + 1.2f) + drawRatio * 0.5f);
            if (!arrowIsInfinite) {
                itemstack.func_190918_g(1);
            }
            this.supressed(entityplayer);
        }
    }

    private void supressed(EntityPlayer entityplayer) {
        entityplayer.func_71029_a(StatList.func_188057_b((Item)this));
    }

    private int getRequiredPower(int drawDuration, EnergyUpgrade.EnergyUpgradeHolder upgrade) {
        if (upgrade == null || drawDuration <= 0) {
            return 0;
        }
        int drawTime = this.getDrawTime(upgrade);
        float ratio = Math.min(1.0f, (float)drawDuration / (float)drawTime);
        int powerRequired = (int)Math.ceil((float)Config.darkSteelBowPowerUsePerDraw * ratio);
        if (drawDuration > drawTime) {
            powerRequired += (drawDuration - drawTime) * Config.darkSteelBowPowerUsePerTickDrawn;
        }
        return powerRequired;
    }

    public int getRequiredPower(EntityLivingBase entity, EnergyUpgradeManager upgrade, @Nonnull ItemStack stack, int drawTime) {
        int powerRequired = 0;
        if (upgrade == null) {
            return powerRequired;
        }
        int drawDuration = this.func_77626_a(stack) - entity.func_184605_cv();
        float ratio = Math.min(1.0f, (float)drawDuration / (float)drawTime);
        powerRequired = (int)Math.ceil((float)Config.darkSteelBowPowerUsePerDraw * ratio);
        if (drawDuration > drawTime) {
            powerRequired += (drawDuration - drawTime) * Config.darkSteelBowPowerUsePerTickDrawn;
        }
        return powerRequired;
    }

    public float getCustumArrowVelocity(@Nonnull ItemStack stack, int charge) {
        float f = (float)charge / (float)this.getDrawTime(stack);
        if ((f = (f * f + f * 2.0f) / 3.0f) > 1.0f) {
            f = 1.0f;
        }
        return f;
    }

    @Nonnull
    private ItemStack getArrowsToShoot(EntityPlayer player) {
        if (this.func_185058_h_(player.func_184586_b(EnumHand.OFF_HAND))) {
            return player.func_184586_b(EnumHand.OFF_HAND);
        }
        if (this.func_185058_h_(player.func_184586_b(EnumHand.MAIN_HAND))) {
            return player.func_184586_b(EnumHand.MAIN_HAND);
        }
        for (int i = 0; i < player.field_71071_by.func_70302_i_(); ++i) {
            ItemStack itemstack = player.field_71071_by.func_70301_a(i);
            if (!this.func_185058_h_(itemstack)) continue;
            return itemstack;
        }
        return Prep.getEmpty();
    }

    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent
    public void onFovUpdateEvent(FOVUpdateEvent fovEvt) {
        ItemStack currentItem = fovEvt.getEntity().func_184614_ca();
        if (currentItem.func_77973_b() != this || fovEvt.getEntity().func_184605_cv() <= 0) {
            return;
        }
        int drawDuration = this.func_77626_a(currentItem) - fovEvt.getEntity().func_184605_cv();
        float ratio = (float)drawDuration / (float)this.getDrawTime(currentItem);
        ratio = ratio > 1.0f ? 1.0f : (ratio *= ratio);
        float mult = (float)Config.darkSteelBowFovMultipliers[0];
        EnergyUpgrade.EnergyUpgradeHolder upgrade = EnergyUpgradeManager.loadFromItem(currentItem);
        if (upgrade != null && upgrade.getEnergy() > 0) {
            mult = (float)Config.darkSteelBowFovMultipliers[upgrade.getUpgrade().getLevel() + 1];
        }
        fovEvt.setNewfov(1.0f - ratio * mult);
    }

    public int getDrawTime(@Nonnull ItemStack stack) {
        return this.getDrawTime(EnergyUpgradeManager.loadFromItem(stack));
    }

    public int getDrawTime(EnergyUpgrade.EnergyUpgradeHolder upgrade) {
        if (upgrade == null) {
            return Config.darkSteelBowDrawSpeeds[0];
        }
        if (upgrade.getEnergy() >= Config.darkSteelBowPowerUsePerDraw) {
            return Config.darkSteelBowDrawSpeeds[upgrade.getUpgrade().getLevel() + 1];
        }
        return Config.darkSteelBowDrawSpeeds[0];
    }

    private float getForceMultiplier(EnergyUpgrade.EnergyUpgradeHolder upgrade) {
        float res = (float)Config.darkSteelBowForceMultipliers[0];
        if (upgrade != null && upgrade.getEnergy() >= 0) {
            res = (float)Config.darkSteelBowForceMultipliers[upgrade.getUpgrade().getLevel() + 1];
        }
        return res;
    }

    public void setDamage(@Nonnull ItemStack stack, int newDamage) {
        int oldDamage = this.getDamage(stack);
        if (newDamage <= oldDamage) {
            super.setDamage(stack, newDamage);
        } else {
            int damage = newDamage - oldDamage;
            if (!this.absorbDamageWithEnergy(stack, damage * Config.darkSteelBowPowerUsePerDamagePoint)) {
                super.setDamage(stack, newDamage);
            }
        }
    }

    private boolean absorbDamageWithEnergy(@Nonnull ItemStack stack, int amount) {
        EnergyUpgrade.EnergyUpgradeHolder eu = EnergyUpgradeManager.loadFromItem(stack);
        if (eu != null && eu.getUpgrade().isAbsorbDamageWithPower() && eu.getEnergy() > 0) {
            eu.extractEnergy(amount, false);
            eu.writeToItem(stack, this);
            return true;
        }
        return false;
    }

    public int func_77626_a(@Nonnull ItemStack p_77626_1_) {
        return 72000;
    }

    @Nonnull
    public EnumAction func_77661_b(@Nonnull ItemStack p_77661_1_) {
        return EnumAction.BOW;
    }

    public int func_77619_b() {
        return 1;
    }

    @Override
    public int getIngotsRequiredForFullRepair() {
        return 2;
    }

    @Override
    public boolean isItemForRepair(@Nonnull ItemStack right) {
        return OreDictionaryHelper.hasName((ItemStack)right, (String)Material.NUTRITIOUS_STICK.getOreDict());
    }

    public void renderItemOverlayIntoGUI(@Nonnull ItemStack stack, int xPosition, int yPosition) {
        PowerBarOverlayRenderHelper.instance_upgradeable.render(stack, xPosition, yPosition);
    }

    public void addCommonEntries(@Nonnull ItemStack itemstack, @Nullable EntityPlayer entityplayer, @Nonnull List<String> list, boolean flag) {
        DarkSteelRecipeManager.addCommonTooltipEntries(itemstack, entityplayer, list, flag);
    }

    public void addBasicEntries(@Nonnull ItemStack itemstack, @Nullable EntityPlayer entityplayer, @Nonnull List<String> list, boolean flag) {
        DarkSteelRecipeManager.addBasicTooltipEntries(itemstack, entityplayer, list, flag);
    }

    public void addDetailedEntries(@Nonnull ItemStack itemstack, @Nullable EntityPlayer entityplayer, @Nonnull List<String> list, boolean flag) {
        String str;
        if (!SpecialTooltipHandler.showDurability((boolean)flag)) {
            list.add(ItemUtil.getDurabilityString((ItemStack)itemstack));
        }
        if ((str = EnergyUpgradeManager.getStoredEnergyString(itemstack)) != null) {
            list.add(str);
        }
        DarkSteelRecipeManager.addAdvancedTooltipEntries(itemstack, entityplayer, list, flag);
    }

    @Override
    public boolean isForSlot(@Nonnull EntityEquipmentSlot slot) {
        return slot == EntityEquipmentSlot.MAINHAND;
    }
}

