/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.base.item.darksteel;

import com.enderio.core.api.client.gui.IAdvancedTooltipProvider;
import com.enderio.core.client.handlers.SpecialTooltipHandler;
import com.enderio.core.common.transform.EnderCoreMethods;
import com.enderio.core.common.util.ItemUtil;
import com.enderio.core.common.util.NNList;
import com.enderio.core.common.util.OreDictionaryHelper;
import crazypants.enderio.api.upgrades.IDarkSteelItem;
import crazypants.enderio.base.EnderIOTab;
import crazypants.enderio.base.config.Config;
import crazypants.enderio.base.config.config.DarkSteelConfig;
import crazypants.enderio.base.farming.FarmersRegistry;
import crazypants.enderio.base.farming.farmers.HarvestResult;
import crazypants.enderio.base.farming.harvesters.AxeHarvestingTarget;
import crazypants.enderio.base.farming.harvesters.TreeHarvester;
import crazypants.enderio.base.handler.darksteel.DarkSteelRecipeManager;
import crazypants.enderio.base.init.IModObject;
import crazypants.enderio.base.init.ModObject;
import crazypants.enderio.base.item.darksteel.ItemDarkSteelPickaxe;
import crazypants.enderio.base.item.darksteel.ItemDarkSteelSword;
import crazypants.enderio.base.item.darksteel.upgrade.energy.EnergyUpgrade;
import crazypants.enderio.base.item.darksteel.upgrade.energy.EnergyUpgradeManager;
import crazypants.enderio.base.lang.Lang;
import crazypants.enderio.base.material.alloy.Alloy;
import crazypants.enderio.base.render.itemoverlay.PowerBarOverlayRenderHelper;
import crazypants.enderio.util.Prep;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Enchantments;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemAxe;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemDarkSteelAxe
extends ItemAxe
implements IAdvancedTooltipProvider,
IDarkSteelItem,
EnderCoreMethods.IOverlayRenderAware {
    private final MultiHarvestComparator harvestComparator = new MultiHarvestComparator();

    public static boolean isEquipped(EntityPlayer player) {
        return player != null && player.func_184614_ca().func_77973_b() == ModObject.itemDarkSteelAxe.getItem();
    }

    public static boolean isPowered(EntityPlayer player, int requiredPower) {
        return ItemDarkSteelAxe.getStoredPower(player) > requiredPower;
    }

    public static int getStoredPower(EntityPlayer player) {
        return EnergyUpgradeManager.getEnergyStored(player.func_184614_ca());
    }

    @Nonnull
    public static ItemDarkSteelAxe create(@Nonnull IModObject modObject) {
        ItemDarkSteelAxe res = new ItemDarkSteelAxe(modObject);
        MinecraftForge.EVENT_BUS.register((Object)res);
        return res;
    }

    protected ItemDarkSteelAxe(@Nonnull IModObject modObject) {
        super(ItemDarkSteelSword.MATERIAL, 8.0f, -3.0f);
        this.func_77637_a(EnderIOTab.tabEnderIOItems);
        modObject.apply(this);
    }

    @Override
    public int getIngotsRequiredForFullRepair() {
        return 3;
    }

    @Override
    public boolean isItemForRepair(@Nonnull ItemStack right) {
        return OreDictionaryHelper.hasName((ItemStack)right, (String)Alloy.DARK_STEEL.getOreIngot());
    }

    @SideOnly(value=Side.CLIENT)
    public void func_150895_a(@Nonnull CreativeTabs tab, @Nonnull NonNullList<ItemStack> list) {
        if (this.func_194125_a(tab)) {
            ItemStack is = new ItemStack((Item)this);
            list.add((Object)is);
            is = new ItemStack((Item)this);
            EnergyUpgrade.EMPOWERED_FOUR.addToItem(is, this);
            EnergyUpgradeManager.setPowerFull(is, this);
            list.add((Object)is);
        }
    }

    public boolean onBlockStartBreak(@Nonnull ItemStack itemstack, @Nonnull BlockPos pos, @Nonnull EntityPlayer player) {
        IBlockState bs;
        Block block;
        if (!player.field_70170_p.field_72995_K && !player.func_70093_af() && EnergyUpgradeManager.itemHasAnyPowerUpgrade(itemstack) && FarmersRegistry.isLog(block = (bs = player.field_70170_p.func_180495_p(pos)).func_177230_c())) {
            int powerStored = EnergyUpgradeManager.getEnergyStored(itemstack);
            HarvestResult res = new HarvestResult();
            AxeHarvestingTarget target = new AxeHarvestingTarget(bs, pos);
            TreeHarvester.harvest(player.field_70170_p, pos, res, target);
            NNList sortedTargets = new NNList(res.getHarvestedBlocks());
            this.harvestComparator.refPoint = pos;
            Collections.sort(sortedTargets, this.harvestComparator);
            int maxBlocks = powerStored / Config.darkSteelAxePowerUsePerDamagePointMultiHarvest;
            int numUsedPower = 0;
            for (int i = 0; numUsedPower < maxBlocks && i < sortedTargets.size(); ++i) {
                if (!this.doMultiHarvest(player, player.field_70170_p, (BlockPos)sortedTargets.get(i), block)) continue;
                ++numUsedPower;
            }
            return numUsedPower != 0;
        }
        return false;
    }

    private boolean doMultiHarvest(@Nonnull EntityPlayer player, @Nonnull World world, @Nonnull BlockPos bc, @Nonnull Block refBlock) {
        IBlockState bs = world.func_180495_p(bc);
        Block block = bs.func_177230_c();
        bs = bs.func_185899_b((IBlockAccess)world, bc);
        ItemStack held = player.func_184614_ca();
        NNList drops = new NNList();
        block.getDrops((NonNullList)drops, (IBlockAccess)world, bc, bs, 0);
        float chance = ForgeEventFactory.fireBlockHarvesting((List)drops, (World)world, (BlockPos)bc, (IBlockState)bs, (int)EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185308_t, (ItemStack)held), (float)1.0f, (EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185306_r, (ItemStack)held) != 0 ? 1 : 0) != 0, (EntityPlayer)player);
        world.func_175698_g(bc);
        boolean usedPower = false;
        for (ItemStack stack : drops) {
            if (!(world.field_73012_v.nextFloat() <= chance)) continue;
            world.func_72838_d((Entity)new EntityItem(world, (double)bc.func_177958_n() + 0.5, (double)bc.func_177956_o() + 0.5, (double)bc.func_177952_p() + 0.5, stack.func_77946_l()));
            if (block != refBlock) continue;
            EnergyUpgradeManager.extractEnergy(player.func_184614_ca(), this, Config.darkSteelAxePowerUsePerDamagePointMultiHarvest, false);
            usedPower = true;
        }
        return usedPower;
    }

    @SubscribeEvent
    public void onBreakSpeedEvent(PlayerEvent.BreakSpeed evt) {
        if (ItemDarkSteelAxe.isEquipped(evt.getEntityPlayer())) {
            if (evt.getEntityPlayer().func_70093_af() && ItemDarkSteelAxe.isPowered(evt.getEntityPlayer(), Config.darkSteelAxePowerUsePerDamagePointMultiHarvest) && FarmersRegistry.isLog(evt.getState().func_177230_c())) {
                evt.setNewSpeed(evt.getOriginalSpeed() / Config.darkSteelAxeSpeedPenaltyMultiHarvest);
            } else if (evt.getState().func_185904_a() == Material.field_151584_j) {
                evt.setNewSpeed(6.0f);
            }
        }
    }

    @Nonnull
    public EnumActionResult func_180614_a(@Nonnull EntityPlayer player, @Nonnull World world, @Nonnull BlockPos pos, @Nonnull EnumHand hand, @Nonnull EnumFacing side, float hitX, float hitY, float hitZ) {
        if (world.field_72995_K && DarkSteelConfig.rightClickPlaceEnabled_axe.get().booleanValue()) {
            return ItemDarkSteelPickaxe.doRightClickItemPlace(player, world, pos, side, hand, hitX, hitY, hitZ);
        }
        return EnumActionResult.PASS;
    }

    public void setDamage(@Nonnull ItemStack stack, int newDamage) {
        int oldDamage = this.getDamage(stack);
        if (newDamage <= oldDamage) {
            super.setDamage(stack, newDamage);
        } else {
            int damage = newDamage - oldDamage;
            if (!this.absorbDamageWithEnergy(stack, damage * Config.darkSteelAxePowerUsePerDamagePoint)) {
                super.setDamage(stack, newDamage);
            }
        }
    }

    private boolean absorbDamageWithEnergy(@Nonnull ItemStack stack, int amount) {
        EnergyUpgrade.EnergyUpgradeHolder eu = EnergyUpgradeManager.loadFromItem(stack);
        if (eu != null && eu.getUpgrade().isAbsorbDamageWithPower() && eu.getEnergy() > 0) {
            eu.extractEnergy(amount, false);
            eu.writeToItem(stack, this);
            return true;
        }
        return false;
    }

    public float func_150893_a(@Nonnull ItemStack stack, @Nonnull IBlockState state) {
        if (ItemDarkSteelPickaxe.isToolEffective(state, stack)) {
            if (Config.darkSteelAxePowerUsePerDamagePoint <= 0 ? EnergyUpgradeManager.itemHasAnyPowerUpgrade(stack) : EnergyUpgradeManager.getEnergyStored(stack) > 0) {
                return this.field_77862_b.func_77998_b() + Config.darkSteelAxeEffeciencyBoostWhenPowered;
            }
            return this.field_77862_b.func_77998_b();
        }
        return super.func_150893_a(stack, state);
    }

    public boolean func_82789_a(@Nonnull ItemStack i1, @Nonnull ItemStack i2) {
        return false;
    }

    public void addCommonEntries(@Nonnull ItemStack itemstack, @Nullable EntityPlayer entityplayer, @Nonnull List<String> list, boolean flag) {
        DarkSteelRecipeManager.addCommonTooltipEntries(itemstack, entityplayer, list, flag);
    }

    public void addBasicEntries(@Nonnull ItemStack itemstack, @Nullable EntityPlayer entityplayer, @Nonnull List<String> list, boolean flag) {
        DarkSteelRecipeManager.addBasicTooltipEntries(itemstack, entityplayer, list, flag);
    }

    public void addDetailedEntries(@Nonnull ItemStack itemstack, @Nullable EntityPlayer entityplayer, @Nonnull List<String> list, boolean flag) {
        String str;
        if (!SpecialTooltipHandler.showDurability((boolean)flag)) {
            list.add(ItemUtil.getDurabilityString((ItemStack)itemstack));
        }
        if ((str = EnergyUpgradeManager.getStoredEnergyString(itemstack)) != null) {
            list.add(str);
        }
        if (EnergyUpgradeManager.itemHasAnyPowerUpgrade(itemstack)) {
            list.add(Lang.AXE_MULTIHARVEST.get());
            list.add(Lang.AXE_POWERED.get(TextFormatting.WHITE, Float.valueOf(Config.darkSteelAxeEffeciencyBoostWhenPowered)));
        }
        DarkSteelRecipeManager.addAdvancedTooltipEntries(itemstack, entityplayer, list, flag);
    }

    public void renderItemOverlayIntoGUI(@Nonnull ItemStack stack, int xPosition, int yPosition) {
        PowerBarOverlayRenderHelper.instance_upgradeable.render(stack, xPosition, yPosition);
    }

    public boolean shouldCauseReequipAnimation(@Nonnull ItemStack oldStack, @Nonnull ItemStack newStack, boolean slotChanged) {
        return slotChanged || Prep.isInvalid(oldStack) || Prep.isInvalid(newStack) || oldStack.func_77973_b() != newStack.func_77973_b();
    }

    @Override
    public boolean isForSlot(@Nonnull EntityEquipmentSlot slot) {
        return slot == EntityEquipmentSlot.MAINHAND;
    }

    @Override
    public boolean isAxe() {
        return true;
    }

    private static class MultiHarvestComparator
    implements Comparator<BlockPos> {
        BlockPos refPoint;

        private MultiHarvestComparator() {
        }

        @Override
        public int compare(BlockPos arg0, BlockPos arg1) {
            double d1 = this.refPoint.func_177954_c((double)arg0.func_177958_n(), (double)arg0.func_177956_o(), (double)arg0.func_177952_p());
            double d2 = this.refPoint.func_177954_c((double)arg1.func_177958_n(), (double)arg1.func_177956_o(), (double)arg1.func_177952_p());
            return MultiHarvestComparator.compare(d1, d2);
        }

        public static int compare(double x, double y) {
            return x < y ? -1 : (x == y ? 0 : 1);
        }
    }
}

