/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.base.item.darksteel;

import com.enderio.core.api.client.gui.IAdvancedTooltipProvider;
import com.enderio.core.client.handlers.SpecialTooltipHandler;
import com.enderio.core.common.transform.EnderCoreMethods;
import com.enderio.core.common.util.ItemUtil;
import com.enderio.core.common.util.NNMap;
import com.enderio.core.common.util.NullHelper;
import com.enderio.core.common.util.OreDictionaryHelper;
import com.google.common.collect.Multimap;
import crazypants.enderio.api.upgrades.IDarkSteelItem;
import crazypants.enderio.api.upgrades.IDarkSteelUpgrade;
import crazypants.enderio.api.upgrades.IHasPlayerRenderer;
import crazypants.enderio.api.upgrades.IRenderUpgrade;
import crazypants.enderio.base.EnderIOTab;
import crazypants.enderio.base.config.Config;
import crazypants.enderio.base.handler.darksteel.DarkSteelController;
import crazypants.enderio.base.handler.darksteel.DarkSteelRecipeManager;
import crazypants.enderio.base.handler.darksteel.PacketUpgradeState;
import crazypants.enderio.base.init.IModObject;
import crazypants.enderio.base.init.ModObject;
import crazypants.enderio.base.integration.thaumcraft.GogglesOfRevealingUpgrade;
import crazypants.enderio.base.item.darksteel.PaintedHelmetLayer;
import crazypants.enderio.base.item.darksteel.upgrade.elytra.ElytraUpgrade;
import crazypants.enderio.base.item.darksteel.upgrade.energy.EnergyUpgrade;
import crazypants.enderio.base.item.darksteel.upgrade.energy.EnergyUpgradeManager;
import crazypants.enderio.base.item.darksteel.upgrade.glider.GliderUpgrade;
import crazypants.enderio.base.item.darksteel.upgrade.nightvision.NightVisionUpgrade;
import crazypants.enderio.base.item.darksteel.upgrade.sound.SoundDetectorUpgrade;
import crazypants.enderio.base.lang.Lang;
import crazypants.enderio.base.material.alloy.Alloy;
import crazypants.enderio.base.network.PacketHandler;
import crazypants.enderio.base.paint.PaintUtil;
import crazypants.enderio.base.recipe.MachineRecipeRegistry;
import crazypants.enderio.base.recipe.painter.HelmetPainterTemplate;
import crazypants.enderio.base.render.itemoverlay.PowerBarOverlayRenderHelper;
import crazypants.enderio.util.Prep;
import forestry.api.apiculture.IArmorApiarist;
import forestry.api.core.IArmorNaturalist;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.model.ModelBiped;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.DamageSource;
import net.minecraft.util.NonNullList;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.common.ISpecialArmor;
import net.minecraftforge.common.util.EnumHelper;
import net.minecraftforge.fml.common.Optional;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@Optional.InterfaceList(value={@Optional.Interface(iface="thaumcraft.api.items.IGoggles", modid="Thaumcraft"), @Optional.Interface(iface="thaumcraft.api.items.IVisDiscountGear", modid="Thaumcraft"), @Optional.Interface(iface="thaumcraft.api.items.IRevealer", modid="Thaumcraft"), @Optional.Interface(iface="forestry.api.apiculture.IArmorApiarist", modid="forestry"), @Optional.Interface(iface="forestry.api.core.IArmorNaturalist", modid="forestry")})
public class ItemDarkSteelArmor
extends ItemArmor
implements ISpecialArmor,
IAdvancedTooltipProvider,
IDarkSteelItem,
EnderCoreMethods.IOverlayRenderAware,
IHasPlayerRenderer,
PaintUtil.IWithPaintName,
EnderCoreMethods.IElytraFlyingProvider,
IArmorApiarist,
IArmorNaturalist {
    public static final ItemArmor.ArmorMaterial MATERIAL = ItemDarkSteelArmor.createMaterial();
    boolean gogglesUgradeActive = true;
    private final int powerPerDamagePoint;
    private static final NNMap<EntityEquipmentSlot, UUID> ARMOR_MODIFIERS = new NNMap.Brutal();
    @GameRegistry.ObjectHolder(value="enderiointegrationforestry:apiarist_armor_feet")
    public static final IDarkSteelUpgrade FORESTRY_FEET;
    @GameRegistry.ObjectHolder(value="enderiointegrationforestry:apiarist_armor_legs")
    public static final IDarkSteelUpgrade FORESTRY_LEGS;
    @GameRegistry.ObjectHolder(value="enderiointegrationforestry:apiarist_armor_chest")
    public static final IDarkSteelUpgrade FORESTRY_CHEST;
    @GameRegistry.ObjectHolder(value="enderiointegrationforestry:apiarist_armor_head")
    public static final IDarkSteelUpgrade FORESTRY_HEAD;
    @GameRegistry.ObjectHolder(value="enderiointegrationforestry:naturalist_eye")
    public static final IDarkSteelUpgrade FORESTRY_EYES;

    public static ItemDarkSteelArmor createDarkSteelBoots(@Nonnull IModObject modObject) {
        return ItemDarkSteelArmor.create(modObject, EntityEquipmentSlot.FEET);
    }

    public static ItemDarkSteelArmor createDarkSteelLeggings(@Nonnull IModObject modObject) {
        return ItemDarkSteelArmor.create(modObject, EntityEquipmentSlot.LEGS);
    }

    public static ItemDarkSteelArmor createDarkSteelChestplate(@Nonnull IModObject modObject) {
        return ItemDarkSteelArmor.create(modObject, EntityEquipmentSlot.CHEST);
    }

    public static ItemDarkSteelArmor createDarkSteelHelmet(@Nonnull IModObject modObject) {
        ItemDarkSteelArmor helmet = ItemDarkSteelArmor.create(modObject, EntityEquipmentSlot.HEAD);
        MachineRecipeRegistry.instance.registerRecipe("painter", new HelmetPainterTemplate(helmet));
        return helmet;
    }

    @Nonnull
    public static ItemDarkSteelArmor create(@Nonnull IModObject modObject, @Nonnull EntityEquipmentSlot armorType) {
        return new ItemDarkSteelArmor(modObject, armorType);
    }

    private static ItemArmor.ArmorMaterial createMaterial() {
        Class[] params = new Class[]{String.class, Integer.TYPE, int[].class, Integer.TYPE, SoundEvent.class, Float.TYPE};
        return (ItemArmor.ArmorMaterial)EnumHelper.addEnum(ItemArmor.ArmorMaterial.class, (String)"darkSteel", (Class[])params, (Object[])new Object[]{"darkSteel", 35, new int[]{2, 5, 6, 2}, 15, SoundEvents.field_187725_r, Float.valueOf(1.0f)});
    }

    public static int getPoweredProtectionIncrease(int armorType) {
        switch (armorType) {
            case 0: {
                return 1;
            }
            case 1: {
                return 2;
            }
            case 2: 
            case 3: {
                return 1;
            }
        }
        return 0;
    }

    protected ItemDarkSteelArmor(@Nonnull IModObject modObject, @Nonnull EntityEquipmentSlot armorType) {
        super(MATERIAL, 0, armorType);
        this.func_77637_a(EnderIOTab.tabEnderIOItems);
        modObject.apply(this);
        this.powerPerDamagePoint = Config.darkSteelPowerStorageBase / MATERIAL.func_78046_a(armorType);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_150895_a(@Nonnull CreativeTabs tab, @Nonnull NonNullList<ItemStack> par3List) {
        if (this.func_194125_a(tab)) {
            ItemStack is = new ItemStack((Item)this);
            par3List.add((Object)is);
            is = new ItemStack((Item)this);
            EnergyUpgrade.EMPOWERED_FOUR.addToItem(is, this);
            EnergyUpgradeManager.setPowerFull(is, this);
            Iterator<IDarkSteelUpgrade> iter = DarkSteelRecipeManager.recipeIterator();
            while (iter.hasNext()) {
                IDarkSteelUpgrade upgrade = iter.next();
                if (upgrade instanceof EnergyUpgrade || upgrade instanceof GliderUpgrade || upgrade instanceof ElytraUpgrade || !upgrade.canAddToItem(is, this)) continue;
                upgrade.addToItem(is, this);
            }
            if (GliderUpgrade.INSTANCE.canAddToItem(is, this)) {
                ItemStack is2 = is.func_77946_l();
                GliderUpgrade.INSTANCE.addToItem(is2, this);
                par3List.add((Object)is2);
                if (ElytraUpgrade.INSTANCE.canAddToItem(is, this)) {
                    ItemStack is3 = is.func_77946_l();
                    ElytraUpgrade.INSTANCE.addToItem(is3, this);
                    par3List.add((Object)is3);
                }
                return;
            }
            par3List.add((Object)is);
        }
    }

    @Override
    public int getIngotsRequiredForFullRepair() {
        switch (this.field_77881_a) {
            case HEAD: {
                return 5;
            }
            case CHEST: {
                return 8;
            }
            case LEGS: {
                return 7;
            }
        }
        return 4;
    }

    public void addCommonEntries(@Nonnull ItemStack itemstack, @Nullable EntityPlayer entityplayer, @Nonnull List<String> list, boolean flag) {
        DarkSteelRecipeManager.addCommonTooltipEntries(itemstack, entityplayer, list, flag);
    }

    public void addBasicEntries(@Nonnull ItemStack itemstack, @Nullable EntityPlayer entityplayer, @Nonnull List<String> list, boolean flag) {
        DarkSteelRecipeManager.addBasicTooltipEntries(itemstack, entityplayer, list, flag);
    }

    public void addDetailedEntries(@Nonnull ItemStack itemstack, @Nullable EntityPlayer entityplayer, @Nonnull List<String> list, boolean flag) {
        String str;
        if (!SpecialTooltipHandler.showDurability((boolean)flag)) {
            list.add(ItemUtil.getDurabilityString((ItemStack)itemstack));
        }
        if ((str = EnergyUpgradeManager.getStoredEnergyString(itemstack)) != null) {
            list.add(str);
        }
        if (EnergyUpgradeManager.itemHasAnyPowerUpgrade(itemstack)) {
            list.addAll((Collection<String>)Lang.DARK_STEEL_POWERED.getLines(TextFormatting.WHITE));
            if (itemstack.func_77973_b() == ModObject.itemDarkSteelBoots.getItemNN()) {
                list.addAll((Collection<String>)Lang.DARK_BOOTS_POWERED.getLines(TextFormatting.WHITE));
            }
        }
        DarkSteelRecipeManager.addAdvancedTooltipEntries(itemstack, entityplayer, list, flag);
    }

    public String getArmorTexture(@Nonnull ItemStack itemStack, @Nonnull Entity entity, @Nonnull EntityEquipmentSlot slot, @Nonnull String layer) {
        if (this.field_77881_a == EntityEquipmentSlot.LEGS || this.field_77881_a == EntityEquipmentSlot.HEAD && !NightVisionUpgrade.INSTANCE.hasUpgrade(itemStack) && !SoundDetectorUpgrade.INSTANCE.hasUpgrade(itemStack)) {
            return "enderio:textures/models/armor/dark_steel_layer_2.png";
        }
        return "enderio:textures/models/armor/dark_steel_layer_1.png";
    }

    public ISpecialArmor.ArmorProperties getProperties(EntityLivingBase player, @Nonnull ItemStack armor, DamageSource source, double damage, int slot) {
        if (source.func_76363_c()) {
            return new ISpecialArmor.ArmorProperties(0, 0.0, armor.func_77958_k() + 1 - armor.func_77952_i());
        }
        double damageRatio = this.field_77879_b + (EnergyUpgradeManager.getEnergyStored(armor) > 0 ? ItemDarkSteelArmor.getPoweredProtectionIncrease(3 - slot) : 0);
        ISpecialArmor.ArmorProperties ap = new ISpecialArmor.ArmorProperties(0, damageRatio /= 25.0, armor.func_77958_k() + 1 - armor.func_77952_i());
        return ap;
    }

    public int getArmorDisplay(EntityPlayer player, @Nonnull ItemStack armor, int slot) {
        int powerBonus = EnergyUpgradeManager.getEnergyStored(armor) > 0 ? ItemDarkSteelArmor.getPoweredProtectionIncrease(3 - slot) : 0;
        return this.func_82812_d().func_78044_b(this.field_77881_a) + powerBonus;
    }

    @Nonnull
    public Multimap<String, AttributeModifier> getAttributeModifiers(@Nonnull EntityEquipmentSlot equipmentSlot, @Nonnull ItemStack stack) {
        Multimap multimap = super.func_111205_h(equipmentSlot);
        if (equipmentSlot == this.field_77881_a) {
            boolean isPowered;
            boolean bl = isPowered = EnergyUpgradeManager.getEnergyStored(stack) > 0;
            if (isPowered) {
                boolean toughnessBonus = true;
                multimap.removeAll((Object)SharedMonsterAttributes.field_189429_h.func_111108_a());
                multimap.put((Object)SharedMonsterAttributes.field_189429_h.func_111108_a(), (Object)new AttributeModifier((UUID)ARMOR_MODIFIERS.get((Object)equipmentSlot), "Armor toughness", (double)(this.field_189415_e + (float)toughnessBonus), 0));
                int powerBonus = ItemDarkSteelArmor.getPoweredProtectionIncrease(3 - equipmentSlot.func_188454_b());
                multimap.removeAll((Object)SharedMonsterAttributes.field_188791_g.func_111108_a());
                multimap.put((Object)SharedMonsterAttributes.field_188791_g.func_111108_a(), (Object)new AttributeModifier((UUID)ARMOR_MODIFIERS.get((Object)equipmentSlot), "Armor modifier", (double)(this.field_77879_b + powerBonus), 0));
            }
        }
        return multimap;
    }

    public void damageArmor(EntityLivingBase entity, @Nonnull ItemStack stack, DamageSource source, int damage, int slot) {
        EnergyUpgrade.EnergyUpgradeHolder eu = EnergyUpgradeManager.loadFromItem(stack);
        if (eu != null && eu.getUpgrade().isAbsorbDamageWithPower() && eu.getEnergy() > 0) {
            eu.extractEnergy(damage * this.powerPerDamagePoint, false);
            eu.writeToItem(stack, this);
        } else {
            stack.func_77972_a(damage, (EntityLivingBase)NullHelper.notnullF((Object)entity, (String)"damageArmor() needs an entity"));
        }
    }

    public boolean func_82789_a(@Nonnull ItemStack i1, @Nonnull ItemStack i2) {
        return false;
    }

    public boolean isGogglesUgradeActive() {
        return this.gogglesUgradeActive;
    }

    public void setGogglesUgradeActive(boolean gogglesUgradeActive) {
        this.gogglesUgradeActive = gogglesUgradeActive;
    }

    public void renderItemOverlayIntoGUI(@Nonnull ItemStack stack, int xPosition, int yPosition) {
        PowerBarOverlayRenderHelper.instance_upgradeable.render(stack, xPosition, yPosition);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    @Nonnull
    public IRenderUpgrade getRender() {
        return this.field_77881_a == EntityEquipmentSlot.HEAD ? PaintedHelmetLayer.instance : PaintedHelmetLayer.not_an_helmet;
    }

    @SideOnly(value=Side.CLIENT)
    public ModelBiped getArmorModel(@Nonnull EntityLivingBase entityLiving, @Nonnull ItemStack itemStack, @Nonnull EntityEquipmentSlot armorSlot, @Nonnull ModelBiped _default) {
        if (this.field_77881_a == EntityEquipmentSlot.HEAD && Prep.isValid(itemStack) && itemStack.func_77942_o() && itemStack.func_77978_p().func_74764_b("DSPAINT")) {
            return new ModelBiped(){

                public void func_78088_a(@Nonnull Entity entityIn, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch, float scale) {
                }
            };
        }
        return null;
    }

    @Override
    public String getPaintName(@Nonnull ItemStack itemStack) {
        ItemStack paintSource;
        NBTTagCompound subCompound = itemStack.func_179543_a("DSPAINT");
        if (subCompound != null && Prep.isValid(paintSource = new ItemStack(subCompound))) {
            return paintSource.func_82833_r();
        }
        return null;
    }

    public boolean isElytraFlying(@Nonnull EntityLivingBase entity, @Nonnull ItemStack itemstack, boolean shouldStop) {
        if (entity instanceof EntityPlayer && DarkSteelController.isElytraUpgradeEquipped(itemstack) && DarkSteelController.isElytraActive((EntityPlayer)entity)) {
            if (shouldStop && !entity.field_70170_p.field_72995_K) {
                DarkSteelController.setActive((EntityPlayer)entity, PacketUpgradeState.Type.ELYTRA, false);
                PacketHandler.INSTANCE.sendToDimension((IMessage)new PacketUpgradeState(PacketUpgradeState.Type.ELYTRA, false, entity.func_145782_y()), entity.field_70170_p.field_73011_w.getDimension());
            }
            return true;
        }
        return false;
    }

    @Optional.Method(modid="forestry")
    public boolean canSeePollination(@Nonnull EntityPlayer player, @Nonnull ItemStack armor, boolean doSee) {
        if (armor.func_77973_b() != ModObject.itemDarkSteelHelmet.getItemNN()) {
            return false;
        }
        return FORESTRY_EYES != null && FORESTRY_EYES.hasUpgrade(player.func_184582_a(EntityEquipmentSlot.HEAD));
    }

    @Optional.Method(modid="forestry")
    public boolean protectEntity(@Nonnull EntityLivingBase entity, @Nonnull ItemStack armor, @Nullable String cause, boolean doProtect) {
        return FORESTRY_HEAD != null && FORESTRY_HEAD.hasUpgrade(armor) || FORESTRY_CHEST != null && FORESTRY_CHEST.hasUpgrade(armor) || FORESTRY_FEET != null && FORESTRY_FEET.hasUpgrade(armor) || FORESTRY_LEGS != null && FORESTRY_LEGS.hasUpgrade(armor);
    }

    @Override
    public boolean isItemForRepair(@Nonnull ItemStack right) {
        return OreDictionaryHelper.hasName((ItemStack)right, (String)Alloy.DARK_STEEL.getOreIngot());
    }

    @Override
    public boolean isForSlot(@Nonnull EntityEquipmentSlot slot) {
        return slot == this.field_77881_a;
    }

    @Override
    public boolean hasUpgradeCallbacks(@Nonnull IDarkSteelUpgrade upgrade) {
        return upgrade == FORESTRY_FEET || upgrade == FORESTRY_LEGS || upgrade == FORESTRY_CHEST || upgrade == FORESTRY_HEAD || upgrade == FORESTRY_EYES || upgrade == ElytraUpgrade.INSTANCE || upgrade == GogglesOfRevealingUpgrade.INSTANCE;
    }

    static {
        ARMOR_MODIFIERS.put((Object)EntityEquipmentSlot.FEET, (Object)UUID.fromString("845DB27C-C624-495F-8C9F-6020A9A58B6B"));
        ARMOR_MODIFIERS.put((Object)EntityEquipmentSlot.LEGS, (Object)UUID.fromString("D8499B04-0E66-4726-AB29-64469D734E0D"));
        ARMOR_MODIFIERS.put((Object)EntityEquipmentSlot.CHEST, (Object)UUID.fromString("9F3D476D-C118-4544-8365-64846904B48E"));
        ARMOR_MODIFIERS.put((Object)EntityEquipmentSlot.HEAD, (Object)UUID.fromString("2AD3F246-FEE1-4E67-B886-69FD380BB150"));
        FORESTRY_FEET = null;
        FORESTRY_LEGS = null;
        FORESTRY_CHEST = null;
        FORESTRY_HEAD = null;
        FORESTRY_EYES = null;
    }
}

