/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.base.item.conduitprobe;

import com.enderio.core.api.client.gui.IResourceTooltipProvider;
import com.enderio.core.common.TileEntityBase;
import crazypants.enderio.api.tool.IHideFacades;
import crazypants.enderio.base.EnderIOTab;
import crazypants.enderio.base.conduit.IConduitBundle;
import crazypants.enderio.base.conduit.IServerConduit;
import crazypants.enderio.base.init.IModObject;
import crazypants.enderio.base.item.conduitprobe.PacketConduitProbe;
import crazypants.enderio.base.lang.Lang;
import crazypants.enderio.base.network.PacketHandler;
import crazypants.enderio.base.render.IHaveRenderers;
import java.util.Collection;
import javax.annotation.Nonnull;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemConduitProbe
extends Item
implements IResourceTooltipProvider,
IHideFacades,
IHaveRenderers {
    public static ItemConduitProbe create(@Nonnull IModObject modObject) {
        return new ItemConduitProbe(modObject);
    }

    protected ItemConduitProbe(@Nonnull IModObject modObject) {
        this.func_77637_a(EnderIOTab.tabEnderIOItems);
        modObject.apply(this);
        this.func_77625_d(1);
        this.func_77627_a(true);
    }

    public static boolean copyPasteSettings(@Nonnull EntityPlayer player, @Nonnull ItemStack stack, @Nonnull IConduitBundle bundle, @Nonnull EnumFacing dir) {
        if (player.field_70170_p.field_72995_K) {
            return true;
        }
        boolean isCopy = player.func_70093_af();
        boolean clearedData = false;
        if (!isCopy && !stack.func_77942_o()) {
            return false;
        }
        boolean performedAction = false;
        Collection<IServerConduit> conduits = bundle.getServerConduits();
        for (IServerConduit conduit : conduits) {
            NBTTagCompound nbt;
            if (!conduit.getExternalConnections().contains(dir)) continue;
            if (isCopy && !clearedData) {
                clearedData = true;
            }
            if (isCopy) {
                nbt = new NBTTagCompound();
                performedAction |= conduit.writeConnectionSettingsToNBT(dir, nbt);
                stack.func_77982_d(nbt);
                continue;
            }
            nbt = stack.func_77978_p();
            performedAction |= nbt != null && conduit.readConduitSettingsFromNBT(dir, nbt);
        }
        if (isCopy && performedAction) {
            player.func_146105_b((ITextComponent)Lang.GUI_PROBE_COPIED.toChatServer(), true);
        }
        return performedAction;
    }

    @Nonnull
    public EnumActionResult func_180614_a(@Nonnull EntityPlayer playerIn, @Nonnull World world, @Nonnull BlockPos pos, @Nonnull EnumHand hand, @Nonnull EnumFacing side, float hitX, float hitY, float hitZ) {
        ItemStack itemStack;
        TileEntity tileEntity;
        if (playerIn.func_184812_l_() && (tileEntity = world.func_175625_s(pos)) instanceof TileEntityBase) {
            playerIn.func_145747_a((ITextComponent)new TextComponentString((world.field_72995_K ? "CLIENT: " : "SERVER: ") + tileEntity.func_189517_E_().toString()));
            if (!world.field_72995_K) {
                playerIn.func_145747_a((ITextComponent)new TextComponentString("SAVE: " + tileEntity.func_189515_b(new NBTTagCompound()).toString()));
            }
        }
        if ((itemStack = playerIn.func_184586_b(hand)).func_77952_i() == 0 && PacketConduitProbe.canCreatePacket(world, pos)) {
            if (world.field_72995_K) {
                PacketHandler.INSTANCE.sendToServer((IMessage)new PacketConduitProbe(pos, side));
            }
            return EnumActionResult.SUCCESS;
        }
        return EnumActionResult.PASS;
    }

    @Nonnull
    public String getUnlocalizedNameForTooltip(@Nonnull ItemStack stack) {
        return this.func_77658_a();
    }

    public boolean doesSneakBypassUse(@Nonnull ItemStack stack, @Nonnull IBlockAccess world, @Nonnull BlockPos pos, @Nonnull EntityPlayer player) {
        return true;
    }

    @Override
    public boolean shouldHideFacades(@Nonnull ItemStack stack, @Nonnull EntityPlayer player) {
        return true;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void registerRenderers(@Nonnull IModObject modObject) {
        ModelLoader.setCustomModelResourceLocation((Item)this, (int)0, (ModelResourceLocation)new ModelResourceLocation(modObject.getRegistryName(), "variant=probe"));
        ModelLoader.setCustomModelResourceLocation((Item)this, (int)1, (ModelResourceLocation)new ModelResourceLocation(modObject.getRegistryName(), "variant=copy"));
    }
}

