/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.base.integration.top;

import com.enderio.core.api.client.render.IWidgetIcon;
import com.enderio.core.api.common.util.ITankAccess;
import com.enderio.core.common.BlockEnder;
import com.enderio.core.common.fluid.SmartTank;
import com.enderio.core.common.util.NullHelper;
import com.google.common.base.Function;
import com.mojang.authlib.GameProfile;
import crazypants.enderio.api.ILocalizable;
import crazypants.enderio.base.BlockEio;
import crazypants.enderio.base.EnderIO;
import crazypants.enderio.base.Log;
import crazypants.enderio.base.config.config.TopConfig;
import crazypants.enderio.base.fluid.ItemTankHelper;
import crazypants.enderio.base.gui.IconEIO;
import crazypants.enderio.base.init.ModObject;
import crazypants.enderio.base.integration.top.TOPData;
import crazypants.enderio.base.lang.LangPower;
import crazypants.enderio.base.material.material.Material;
import crazypants.enderio.base.paint.IPaintable;
import crazypants.enderio.util.CapturedMob;
import crazypants.enderio.util.NbtValue;
import crazypants.enderio.util.Prep;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mcjty.theoneprobe.api.ElementAlignment;
import mcjty.theoneprobe.api.ILayoutStyle;
import mcjty.theoneprobe.api.IProbeConfig;
import mcjty.theoneprobe.api.IProbeConfigProvider;
import mcjty.theoneprobe.api.IProbeHitData;
import mcjty.theoneprobe.api.IProbeHitEntityData;
import mcjty.theoneprobe.api.IProbeInfo;
import mcjty.theoneprobe.api.IProbeInfoProvider;
import mcjty.theoneprobe.api.ITheOneProbe;
import mcjty.theoneprobe.api.ProbeMode;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fluids.FluidStack;

public class TOPCompatibility
implements Function<ITheOneProbe, Void>,
IProbeInfoProvider,
IProbeConfigProvider {
    public static ITheOneProbe probe;

    @Nullable
    public Void apply(@Nullable ITheOneProbe theOneProbe) {
        if (TopConfig.enabled.get().booleanValue()) {
            probe = theOneProbe;
            Log.info("Enabled support for The One Probe");
            probe.registerProvider((IProbeInfoProvider)this);
            probe.registerProbeConfigProvider((IProbeConfigProvider)this);
        } else {
            Log.info("Support for The One Probe is DISABLED by a configuration setting");
        }
        return null;
    }

    public String getID() {
        return "enderio:default";
    }

    public void addProbeInfo(ProbeMode mode, IProbeInfo probeInfo, EntityPlayer player, World world, IBlockState blockState, IProbeHitData hitData) {
        TileEntity tileEntity;
        if (mode == ProbeMode.DEBUG) {
            probeInfo.text(blockState.toString());
        }
        if (probeInfo != null && world != null && blockState != null && hitData != null && (blockState.func_177230_c() instanceof BlockEio || blockState.func_177230_c() instanceof IPaintable) && (tileEntity = BlockEnder.getAnyTileEntitySafe((IBlockAccess)world, (BlockPos)((BlockPos)NullHelper.notnull((Object)hitData.getPos(), (String)"JEI wants it so")))) != null) {
            EioBox eiobox = new EioBox(probeInfo);
            TOPData data = new TOPData(tileEntity, hitData);
            this.mkOwner(mode, eiobox, data);
            this.mkPaint(mode, eiobox, data);
            this.mkNotificationLine(mode, eiobox, data);
            this.mkProgressLine(mode, eiobox, data);
            this.mkRfLine(mode, eiobox, data);
            this.mkXPLine(mode, eiobox, data);
            this.mkRedstoneLine(mode, eiobox, data);
            this.mkSideConfigLine(mode, eiobox, data);
            this.mkRangeLine(mode, eiobox, data);
            this.mkTankLines(mode, eiobox, data);
            this.mkItemFillLevelLine(mode, eiobox, data);
            eiobox.finish();
            EioBox mobbox = new EioBox(probeInfo);
            this.mkMobsBox(mode, mobbox, world, data);
            mobbox.finish();
        }
    }

    @Nonnull
    private String locRaw(@Nonnull String string) {
        return "{*" + string + "*}";
    }

    @Nonnull
    private String loc(String string) {
        return string == null ? "(???)" : this.locRaw(EnderIO.lang.addPrefix(string));
    }

    @Nonnull
    private String loc(@Nonnull String langKey, @Nonnull String param) {
        return this.loc(langKey + ".pre") + param + this.loc(langKey + ".post");
    }

    @Nonnull
    private String loc(@Nonnull String langKey, @Nonnull String param1, @Nonnull String param2) {
        return this.loc(langKey + ".pre") + param1 + this.loc(langKey + ".middle") + param2 + this.loc(langKey + ".post");
    }

    private void mkMobsBox(ProbeMode mode, EioBox mobbox, World world, TOPData data) {
        if (data.hasMobs) {
            if (mode != ProbeMode.NORMAL || TopConfig.showMobsByDefault.get().booleanValue()) {
                mobbox.get().text(this.loc("top.action.header", this.loc(data.mobAction)));
                if (data.mobs.isEmpty()) {
                    mobbox.get().text(this.loc("top.action.none"));
                } else if (data.mobs.size() <= 4) {
                    for (CapturedMob capturedMob : data.mobs) {
                        mobbox.get().horizontal(mobbox.center()).entity(capturedMob.getEntity(world, false)).text(this.locRaw("entity." + capturedMob.getTranslationName() + ".name"));
                    }
                } else {
                    IProbeInfo mobList = mobbox.get().horizontal(mobbox.center());
                    int count = 0;
                    for (CapturedMob capturedMob : data.mobs) {
                        if (count++ >= 4) {
                            mobList = mobbox.get().horizontal(mobbox.center());
                            count = 0;
                        }
                        mobList.entity(capturedMob.getEntity(world, false));
                    }
                }
            } else {
                mobbox.addMore();
            }
        }
    }

    private void mkRangeLine(ProbeMode mode, EioBox eiobox, TOPData data) {
        if (data.hasRange) {
            if (mode != ProbeMode.NORMAL || TopConfig.showRangeByDefault.get().booleanValue()) {
                int sizeX = (int)data.bounds.sizeX();
                int sizeY = (int)data.bounds.sizeY();
                int sizeZ = (int)data.bounds.sizeZ();
                TOPCompatibility.addIcon(eiobox.get().horizontal(eiobox.center()), IconEIO.SHOW_RANGE).text(this.loc("top.range.header", EnderIO.lang.localize("top.range", new Object[]{sizeX, sizeY, sizeZ})));
            } else {
                eiobox.addMore();
            }
        }
    }

    private void mkNotificationLine(ProbeMode mode, EioBox eiobox, TOPData data) {
        if (data.notifications != null && !data.notifications.isEmpty()) {
            IProbeInfo vertical = TOPCompatibility.addIcon(eiobox.get().horizontal(eiobox.center()), IconEIO.REDSTONE_MODE_NEVER).vertical(eiobox.getProbeinfo().defaultLayoutStyle().spacing(-1));
            for (ILocalizable iLocalizable : data.notifications) {
                vertical.text(this.locRaw(iLocalizable.getUnlocalizedName()));
            }
        }
    }

    private void mkSideConfigLine(ProbeMode mode, EioBox eiobox, TOPData data) {
        if (data.hasIOMode) {
            if (mode != ProbeMode.NORMAL || TopConfig.showSideConfigByDefault.get().booleanValue()) {
                TOPCompatibility.addIcon(eiobox.get().horizontal(eiobox.center()), IconEIO.IO_CONFIG_UP).vertical(eiobox.getProbeinfo().defaultLayoutStyle().spacing(-1)).text(TextFormatting.YELLOW + this.loc("top.machine.side", TextFormatting.WHITE + this.loc("top.machine.side." + data.sideName))).text(TextFormatting.YELLOW + this.loc("top.machine.ioMode", this.loc(data.ioMode.getColorerUnlocalizedName())));
            } else {
                eiobox.addMore();
            }
        }
    }

    private void mkRedstoneLine(ProbeMode mode, EioBox eiobox, TOPData data) {
        if (data.hasRedstone) {
            if (mode != ProbeMode.NORMAL || TopConfig.showRedstoneByDefault.get().booleanValue()) {
                TOPCompatibility.addIcon(eiobox.get().horizontal(eiobox.center()), data.redstoneIcon).vertical(eiobox.getProbeinfo().defaultLayoutStyle().spacing(-1)).text(this.loc(data.redstoneTooltip)).text(this.loc("top.redstone.header", this.loc("top.redstone." + data.redstoneControlStatus)));
            } else {
                eiobox.addMore();
            }
        }
    }

    private void mkPaint(ProbeMode mode, EioBox eiobox, TOPData data) {
        if (data.isPainted) {
            IProbeInfo info = eiobox.get().horizontal(eiobox.center()).item(new ItemStack(Items.field_151159_an)).vertical(eiobox.getProbeinfo().defaultLayoutStyle().spacing(-1)).text(this.loc("top.paint.header"));
            if (Prep.isValid(data.paint2)) {
                info.horizontal(eiobox.center()).item(data.paint2).text(data.paint2.func_82833_r());
            }
            if (Prep.isValid(data.paint1)) {
                info.horizontal(eiobox.center()).item(data.paint1).text(data.paint1.func_82833_r());
            }
        }
    }

    private void mkOwner(ProbeMode mode, EioBox eiobox, TOPData data) {
        if (mode == ProbeMode.DEBUG && data.owner != null) {
            ItemStack skull = new ItemStack(Items.field_151144_bL, 1, 3);
            NBTTagCompound nbt = new NBTTagCompound();
            nbt.func_74782_a("SkullOwner", (NBTBase)NBTUtil.func_180708_a((NBTTagCompound)new NBTTagCompound(), (GameProfile)data.owner.getAsGameProfile()));
            skull.func_77982_d(nbt);
            eiobox.get().horizontal(eiobox.center()).item(skull).vertical(eiobox.getProbeinfo().defaultLayoutStyle().spacing(-1)).text(this.loc("top.owner.header")).text(data.owner.getPlayerName());
        }
    }

    private void mkRfLine(ProbeMode mode, EioBox eiobox, TOPData data) {
        if (data.hasRF) {
            if (mode != ProbeMode.NORMAL || TopConfig.showPowerByDefault.get().booleanValue()) {
                IProbeInfo rfLine = eiobox.get().horizontal(eiobox.center()).item(Material.POWDER_INFINITY.getStack());
                if (data.hasRFIO) {
                    rfLine = rfLine.vertical();
                }
                if (data.isPowered) {
                    rfLine.progress(data.rf, data.maxrf, eiobox.getProbeinfo().defaultProgressStyle().suffix(EnderIO.lang.localize("top.suffix.rf")).filledColor(-2739677).alternateFilledColor(-2739677));
                } else {
                    rfLine.text(this.loc("top.machine.outofpower"));
                }
                if (data.hasRFIO) {
                    rfLine = rfLine.horizontal();
                    rfLine.vertical(eiobox.getProbeinfo().defaultLayoutStyle().spacing(-1)).text(this.loc("top.rf.header.avg")).text(this.loc("top.rf.header.maxin")).text(this.loc("top.rf.header.maxout"));
                    String line1 = this.loc("top.rf.value", (data.avgRF == 0 ? TextFormatting.WHITE : (data.avgRF > 0 ? TextFormatting.GREEN + "+" : TextFormatting.RED)) + LangPower.format(data.avgRF));
                    String line2 = this.loc("top.rf.value", LangPower.format(data.maxRFIn));
                    String line3 = this.loc("top.rf.value", LangPower.format(data.maxRFOut));
                    rfLine = rfLine.vertical(eiobox.getProbeinfo().defaultLayoutStyle().spacing(-1)).text(line1).text(line2).text(line3);
                }
            } else {
                eiobox.addMore();
            }
        }
    }

    private void mkXPLine(ProbeMode mode, EioBox eiobox, TOPData data) {
        if (data.hasXP) {
            if (mode != ProbeMode.NORMAL || TopConfig.showXPByDefault.get().booleanValue()) {
                int scalemax = data.xpBarScaled > 0 ? data.experienceLevel * 100 / data.xpBarScaled : Integer.MAX_VALUE;
                eiobox.get().horizontal(eiobox.center()).item(new ItemStack(Items.field_151062_by)).progress(data.experienceLevel, scalemax, eiobox.getProbeinfo().defaultProgressStyle().suffix(EnderIO.lang.localize("top.suffix.levels")).filledColor(-16711921).alternateFilledColor(-16733686).borderColor(-16733686));
            } else {
                eiobox.addMore();
            }
        }
    }

    private void mkItemFillLevelLine(ProbeMode mode, EioBox eiobox, TOPData data) {
        if (data.hasItemFillLevel) {
            if (mode != ProbeMode.NORMAL || TopConfig.showItemCountDefault.get().booleanValue()) {
                eiobox.get().horizontal(eiobox.center()).item(new ItemStack((Block)Blocks.field_150486_ae)).progress(data.fillCur, data.fillMax, eiobox.getProbeinfo().defaultProgressStyle().suffix(EnderIO.lang.localize("top.suffix.items")).filledColor(-460740).alternateFilledColor(-3167221).borderColor(-3167221));
            } else {
                eiobox.addMore();
            }
        }
    }

    private void mkTankLines(ProbeMode mode, EioBox eiobox, TOPData data) {
        if (data.tankData != null && !data.tankData.isEmpty()) {
            if (mode != ProbeMode.NORMAL || TopConfig.showTanksByDefault.get().booleanValue()) {
                for (ITankAccess.ITankData tank : data.tankData) {
                    String content2;
                    String content1;
                    SmartTank smartTank = new SmartTank(1000);
                    FluidStack fluid = tank.getContent();
                    if (fluid != null) {
                        FluidStack fluid2 = fluid.copy();
                        fluid2.amount = fluid.amount * 1000 / tank.getCapacity();
                        smartTank.setFluid(fluid2);
                        content1 = (String)NullHelper.first((Object[])new String[]{fluid.getLocalizedName(), "(???)"});
                        content2 = this.loc("top.tank.content", "" + fluid.amount, "" + tank.getCapacity());
                    } else {
                        content1 = this.loc("top.tank.content.empty");
                        content2 = this.loc("top.tank.content", "0", "" + tank.getCapacity());
                    }
                    switch (tank.getTankType()) {
                        case INPUT: {
                            content1 = this.loc("top.tank.header.input", content1);
                            break;
                        }
                        case OUTPUT: {
                            content1 = this.loc("top.tank.header.output", content1);
                            break;
                        }
                        case STORAGE: {
                            content1 = this.loc("top.tank.header.storage", content1);
                        }
                    }
                    ItemStack stack = new ItemStack(ModObject.blockFusedQuartz.getBlockNN());
                    ItemTankHelper.setTank(stack, smartTank);
                    NbtValue.FAKE.setBoolean(stack, true);
                    eiobox.get().horizontal(eiobox.center()).item(stack).vertical(eiobox.getProbeinfo().defaultLayoutStyle().spacing(-1)).text(content1).text(content2);
                }
            } else {
                eiobox.addMore();
            }
        }
    }

    private void mkProgressLine(ProbeMode mode, EioBox eiobox, TOPData data) {
        if (data.progressResult != TOPData.ProgressResult.NONE) {
            if (mode != ProbeMode.NORMAL || TopConfig.showProgressByDefault.get().booleanValue() || data.progressResult == TOPData.ProgressResult.PROGRESS_NO_POWER) {
                IProbeInfo progressLine = eiobox.get().horizontal(eiobox.center()).item(new ItemStack(Items.field_151113_aN));
                switch (data.progressResult) {
                    case PROGRESS: {
                        progressLine.progress((int)(data.progress * 100.0f), 100, eiobox.getProbeinfo().defaultProgressStyle().suffix(EnderIO.lang.localize("top.suffix.percent")).filledColor(-18944).alternateFilledColor(-18944));
                        break;
                    }
                    case PROGRESS_NO_POWER: {
                        progressLine.text(this.loc("top.progress.outofpower"));
                        break;
                    }
                    case PROGRESS_ACTIVE: 
                    case NO_PROGRESS_ACTIVE: {
                        progressLine.text(this.loc("top.machine.active"));
                        break;
                    }
                    case PROGRESS_IDLE: 
                    case NO_PROGRESS_IDLE: {
                        progressLine.text(this.loc("top.machine.idle"));
                        break;
                    }
                }
            } else {
                eiobox.addMore();
            }
        }
    }

    public int hashCode() {
        return super.hashCode();
    }

    public boolean equals(@Nullable Object obj) {
        return super.equals(obj);
    }

    public void getProbeConfig(IProbeConfig config, EntityPlayer player, World world, Entity entity, IProbeHitEntityData data) {
    }

    public void getProbeConfig(IProbeConfig config, EntityPlayer player, World world, IBlockState blockState, IProbeHitData data) {
        if (config != null && blockState != null && blockState.func_177230_c() instanceof BlockEio) {
            config.setRFMode(0);
        }
    }

    private static IProbeInfo addIcon(IProbeInfo probeInfo, IWidgetIcon icon) {
        return TOPCompatibility.addIcon(probeInfo, icon, 4);
    }

    private static IProbeInfo addIcon(IProbeInfo probeInfo, IWidgetIcon icon, int border) {
        ResourceLocation texture = icon.getMap().getTexture();
        int x = icon.getX();
        int y = icon.getY();
        int width = icon.getWidth();
        int height = icon.getHeight();
        return probeInfo.icon(texture, x, y, width, height, probeInfo.defaultIconStyle().width(width + border).height(height + border));
    }

    private static class EioBox {
        private final IProbeInfo probeinfo;
        private IProbeInfo eiobox;
        private boolean addMoreIndicator = false;

        public EioBox(IProbeInfo probeinfo) {
            this.probeinfo = probeinfo;
        }

        public IProbeInfo getProbeinfo() {
            return this.probeinfo;
        }

        public IProbeInfo get() {
            if (this.eiobox == null) {
                this.eiobox = this.probeinfo.vertical(this.probeinfo.defaultLayoutStyle().borderColor(Integer.valueOf(-65536)));
            }
            return this.eiobox;
        }

        public ILayoutStyle center() {
            return this.probeinfo.defaultLayoutStyle().alignment(ElementAlignment.ALIGN_CENTER);
        }

        public ILayoutStyle right() {
            return this.probeinfo.defaultLayoutStyle().alignment(ElementAlignment.ALIGN_BOTTOMRIGHT);
        }

        public void addMore() {
            this.addMoreIndicator = true;
        }

        public void finish() {
            if (this.eiobox != null) {
                if (this.addMoreIndicator) {
                    TOPCompatibility.addIcon(TOPCompatibility.addIcon(this.get().horizontal(this.center()), IconEIO.TOP_NOICON, 0), IconEIO.TOP_MORE, 0);
                } else {
                    TOPCompatibility.addIcon(TOPCompatibility.addIcon(this.get().horizontal(this.center()), IconEIO.TOP_NOICON, 0), IconEIO.TOP_NOMORE, 0);
                }
            } else if (this.addMoreIndicator) {
                TOPCompatibility.addIcon(TOPCompatibility.addIcon(this.probeinfo.vertical().horizontal(this.center()), IconEIO.TOP_NOICON_WIDE, 0), IconEIO.TOP_MORE, 0);
            }
        }
    }
}

