/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.base.integration.thaumcraft;

import crazypants.enderio.api.upgrades.IDarkSteelItem;
import crazypants.enderio.base.config.Config;
import crazypants.enderio.base.handler.darksteel.AbstractUpgrade;
import crazypants.enderio.util.Prep;
import javax.annotation.Nonnull;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;

public class GogglesOfRevealingUpgrade
extends AbstractUpgrade {
    @Nonnull
    private static final String UPGRADE_NAME = "gogglesRevealing";
    @Nonnull
    public static final GogglesOfRevealingUpgrade INSTANCE = new GogglesOfRevealingUpgrade();

    @Nonnull
    public static ItemStack getGoggles() {
        Item i = (Item)Item.field_150901_e.func_82594_a((Object)new ResourceLocation("Thaumcraft", "ItemGoggles"));
        if (i != null) {
            return new ItemStack(i);
        }
        return Prep.getEmpty();
    }

    public static boolean isUpgradeEquipped(@Nonnull EntityPlayer player) {
        ItemStack helmet = player.func_184582_a(EntityEquipmentSlot.HEAD);
        return INSTANCE.hasUpgrade(helmet);
    }

    public GogglesOfRevealingUpgrade() {
        super(UPGRADE_NAME, "enderio.darksteel.upgrade.gogglesOfRevealing", GogglesOfRevealingUpgrade.getGoggles(), Config.darkSteelGogglesOfRevealingCost);
    }

    @Override
    public boolean canAddToItem(@Nonnull ItemStack stack, @Nonnull IDarkSteelItem item) {
        if (!item.isForSlot(EntityEquipmentSlot.HEAD) || Prep.isInvalid(GogglesOfRevealingUpgrade.getGoggles())) {
            return false;
        }
        return item.hasUpgradeCallbacks(this) && !this.hasUpgrade(stack, item);
    }

    @Override
    @Nonnull
    public ItemStack getUpgradeItem() {
        if (Prep.isValid(this.upgradeItem)) {
            return this.upgradeItem;
        }
        this.upgradeItem = GogglesOfRevealingUpgrade.getGoggles();
        return this.upgradeItem;
    }

    @Override
    @Nonnull
    public String getUpgradeItemName() {
        if (Prep.isInvalid(this.getUpgradeItem())) {
            return "Goggles of Revealing";
        }
        return super.getUpgradeItemName();
    }
}

