/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.base.integration.natura;

import crazypants.enderio.api.farm.FarmNotification;
import crazypants.enderio.api.farm.IFarmer;
import crazypants.enderio.api.farm.IHarvestResult;
import crazypants.enderio.base.farming.FarmingTool;
import crazypants.enderio.base.farming.farmers.HarvestResult;
import crazypants.enderio.base.farming.farmers.PickableFarmer;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.BlockPos;

public class NaturaBerryFarmer
extends PickableFarmer {
    public NaturaBerryFarmer(@Nonnull Block plantedBlock, int plantedBlockMeta, int grownBlockMeta, @Nonnull ItemStack seeds) {
        super(plantedBlock, plantedBlockMeta, grownBlockMeta, seeds);
        this.requiresTilling = false;
        this.checkGroundForFarmland = false;
    }

    @Override
    public IHarvestResult harvestBlock(@Nonnull IFarmer farm, @Nonnull BlockPos bc, @Nonnull Block block, @Nonnull IBlockState meta) {
        if (block != this.getPlantedBlock()) {
            return null;
        }
        if (!farm.hasTool(FarmingTool.HOE)) {
            farm.setNotification(FarmNotification.NO_HOE);
            return null;
        }
        HarvestResult res = new HarvestResult();
        BlockPos checkBlock = bc;
        while (checkBlock != null && checkBlock.func_177956_o() <= 255 && farm.hasTool(FarmingTool.HOE)) {
            IHarvestResult blockRes;
            meta = farm.getBlockState(checkBlock);
            block = meta.func_177230_c();
            if (block != this.getPlantedBlock()) {
                checkBlock = null;
                continue;
            }
            if (this.getFullyGrownBlockMeta() == block.func_176201_c(meta) && (blockRes = super.harvestBlock(farm, checkBlock, block, meta)) != null) {
                res.getHarvestedBlocks().add((Object)checkBlock);
                res.getDrops().addAll(blockRes.getDrops());
            }
            checkBlock = checkBlock.func_177984_a();
        }
        if (res.getHarvestedBlocks().isEmpty()) {
            return null;
        }
        return res;
    }

    @Override
    public boolean canHarvest(@Nonnull IFarmer farm, @Nonnull BlockPos bc, @Nonnull Block block, @Nonnull IBlockState bs) {
        BlockPos checkBlock = bc;
        while (checkBlock.func_177956_o() <= 255) {
            if (block != this.getPlantedBlock()) {
                return false;
            }
            if (super.canHarvest(farm, checkBlock, block, bs)) {
                return true;
            }
            checkBlock = checkBlock.func_177984_a();
            bs = farm.getBlockState(checkBlock);
            block = bs.func_177230_c();
        }
        return false;
    }
}

