/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.base.integration.jei;

import com.enderio.core.common.util.NNList;
import crazypants.enderio.base.Log;
import crazypants.enderio.base.filter.gui.AbstractFilterGui;
import crazypants.enderio.base.init.ModObject;
import crazypants.enderio.base.integration.jei.AdvancedGuiHandlerEnderIO;
import crazypants.enderio.base.integration.jei.DarkSteelUpgradeRecipeCategory;
import crazypants.enderio.base.integration.jei.DescriptionRecipeCategory;
import crazypants.enderio.base.integration.jei.GhostIngredientHandlerEnderIO;
import crazypants.enderio.base.integration.jei.InfinityRecipeCategory;
import crazypants.enderio.base.integration.jei.JeiAccessor;
import crazypants.enderio.base.integration.jei.MobContainerSubtypeInterpreter;
import crazypants.enderio.base.integration.jei.energy.EnergyIngredient;
import crazypants.enderio.base.integration.jei.energy.EnergyIngredientHelper;
import crazypants.enderio.base.integration.jei.energy.EnergyIngredientRenderer;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;
import mezz.jei.api.IGuiHelper;
import mezz.jei.api.IJeiHelpers;
import mezz.jei.api.IJeiRuntime;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.IModRegistry;
import mezz.jei.api.ISubtypeRegistry;
import mezz.jei.api.JEIPlugin;
import mezz.jei.api.gui.IAdvancedGuiHandler;
import mezz.jei.api.gui.IGhostIngredientHandler;
import mezz.jei.api.ingredients.IIngredientHelper;
import mezz.jei.api.ingredients.IIngredientRenderer;
import mezz.jei.api.ingredients.IModIngredientRegistration;
import mezz.jei.api.recipe.IRecipeCategory;
import mezz.jei.api.recipe.IRecipeCategoryRegistration;
import net.minecraft.item.ItemStack;

@JEIPlugin
public class JeiPlugin
implements IModPlugin {
    private static IJeiRuntime jeiRuntime = null;

    public void registerItemSubtypes(@Nonnull ISubtypeRegistry subtypeRegistry) {
        DarkSteelUpgradeRecipeCategory.registerSubtypes(subtypeRegistry);
        MobContainerSubtypeInterpreter.registerSubtypes(subtypeRegistry);
    }

    public void registerCategories(@Nonnull IRecipeCategoryRegistration registry) {
        IJeiHelpers jeiHelpers = registry.getJeiHelpers();
        IGuiHelper guiHelper = jeiHelpers.getGuiHelper();
        registry.addRecipeCategories(new IRecipeCategory[]{new InfinityRecipeCategory(guiHelper)});
    }

    public void register(@Nonnull IModRegistry registry) {
        DarkSteelUpgradeRecipeCategory.register(registry);
        DescriptionRecipeCategory.register(registry);
        InfinityRecipeCategory.registerExtras(registry);
        registry.addAdvancedGuiHandlers(new IAdvancedGuiHandler[]{new AdvancedGuiHandlerEnderIO()});
        registry.addGhostIngredientHandler(AbstractFilterGui.class, (IGhostIngredientHandler)new GhostIngredientHandlerEnderIO());
        if (!JeiAccessor.ALTERNATIVES.isEmpty()) {
            registry.addRecipes(JeiAccessor.ALTERNATIVES, "minecraft.crafting");
            Log.debug("Provided " + JeiAccessor.ALTERNATIVES.size() + " synthetic crafting recipes to JEI");
        }
        registry.getJeiHelpers().getIngredientBlacklist().addIngredientToBlacklist((Object)new ItemStack(ModObject.itemEnderface.getItemNN()));
    }

    public void onRuntimeAvailable(@Nonnull IJeiRuntime jeiRuntimeIn) {
        jeiRuntime = jeiRuntimeIn;
        JeiAccessor.jeiRuntimeAvailable = true;
    }

    public static void setFilterText(@Nonnull String filterText) {
        jeiRuntime.getIngredientFilter().setFilterText(filterText);
    }

    @Nonnull
    public static String getFilterText() {
        return jeiRuntime.getIngredientFilter().getFilterText();
    }

    public static void showCraftingRecipes() {
        jeiRuntime.getRecipesGui().showCategories((List)new NNList((Object[])new String[]{"minecraft.crafting"}));
    }

    public void registerIngredients(@Nonnull IModIngredientRegistration ingredientRegistration) {
        ingredientRegistration.register(EnergyIngredient.class, Collections.singletonList(new EnergyIngredient()), (IIngredientHelper)new EnergyIngredientHelper(), (IIngredientRenderer)EnergyIngredientRenderer.INSTANCE);
    }
}

