/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.base.init;

import com.enderio.core.common.util.stackable.IProducer;
import crazypants.enderio.base.gui.handler.GuiHelper;
import crazypants.enderio.base.init.IModTileEntity;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;

public interface IModObject
extends IProducer {
    @Nonnull
    public String getUnlocalisedName();

    @Nonnull
    default public ResourceLocation getRegistryName() {
        return new ResourceLocation("enderio", this.getUnlocalisedName());
    }

    @Nonnull
    default public <B extends Block> B apply(@Nonnull B block) {
        block.func_149663_c(this.getUnlocalisedName());
        block.setRegistryName(this.getRegistryName());
        return block;
    }

    @Nonnull
    default public <I extends Item> I apply(@Nonnull I item) {
        item.func_77655_b(this.getUnlocalisedName());
        item.setRegistryName(this.getRegistryName());
        return item;
    }

    @Nullable
    default public Class<? extends TileEntity> getTEClass() {
        IModTileEntity tileEntity;
        if (this instanceof Registerable && (tileEntity = ((Registerable)this).getTileEntity()) != null) {
            return tileEntity.getTileEntityClass();
        }
        return null;
    }

    public static interface LifecyclePostInit {
        public void init(@Nonnull IModObject var1, @Nonnull FMLPostInitializationEvent var2);
    }

    public static interface LifecycleInit {
        public void init(@Nonnull IModObject var1, @Nonnull FMLInitializationEvent var2);
    }

    public static interface WithBlockItem {
        @Nullable
        default public Item createBlockItem(@Nonnull IModObject modObject) {
            return modObject.apply(new ItemBlock((Block)this));
        }
    }

    public static interface Registerable
    extends IModObject {
        @Nonnull
        public Class<?> getClazz();

        @Nullable
        public String getBlockMethodName();

        @Nullable
        public String getItemMethodName();

        @Nullable
        public IModTileEntity getTileEntity();

        public void setItem(@Nullable Item var1);

        public void setBlock(@Nullable Block var1);

        default public boolean openGui(@Nonnull World world, @Nonnull BlockPos pos, @Nonnull EntityPlayer entityPlayer) {
            return this.openGui(world, pos, entityPlayer, null, 0);
        }

        default public boolean openGui(@Nonnull World world, @Nonnull BlockPos pos, @Nonnull EntityPlayer entityPlayer, @Nullable EnumFacing side) {
            return this.openGui(world, pos, entityPlayer, side, 0);
        }

        default public boolean openGui(@Nonnull World world, @Nonnull BlockPos pos, @Nonnull EntityPlayer entityPlayer, @Nullable EnumFacing side, int param) {
            return GuiHelper.openGui((IModObject)this, world, pos, entityPlayer, side, param);
        }

        default public boolean openGui(@Nonnull World world, @Nonnull EntityPlayer entityPlayer, int a, int b, int c) {
            return GuiHelper.openGui((IModObject)this, world, entityPlayer, a, b, c);
        }

        default public boolean openClientGui(@Nonnull World world, @Nonnull BlockPos pos, @Nonnull EntityPlayer entityPlayer, @Nullable EnumFacing side, int param) {
            return GuiHelper.openClientGui((IModObject)this, world, pos, entityPlayer, side, param);
        }

        default public boolean openClientGui(@Nonnull World world, @Nonnull EntityPlayer entityPlayer, int a, int b, int c) {
            return GuiHelper.openClientGui((IModObject)this, world, entityPlayer, a, b, c);
        }
    }
}

