/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.base.handler.darksteel;

import com.enderio.core.api.client.gui.IAdvancedTooltipProvider;
import com.enderio.core.client.handlers.SpecialTooltipHandler;
import crazypants.enderio.api.upgrades.IDarkSteelItem;
import crazypants.enderio.api.upgrades.IDarkSteelUpgrade;
import crazypants.enderio.base.EnderIO;
import crazypants.enderio.base.config.factory.IValue;
import crazypants.enderio.util.NbtValue;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.registries.IForgeRegistryEntry;

public abstract class AbstractUpgrade
extends IForgeRegistryEntry.Impl<IDarkSteelUpgrade>
implements IAdvancedTooltipProvider,
IDarkSteelUpgrade {
    @Nonnull
    public static final String KEY_UPGRADE_PREFIX = "enderio.darksteel.upgrade.";
    @Nonnull
    private static final String KEY_VARIANT = "level";
    protected final int variant;
    protected final IValue<Integer> levelCost;
    @Nonnull
    protected final String id;
    @Nonnull
    protected final String unlocName;
    @Nonnull
    protected ItemStack upgradeItem;

    @Deprecated
    protected AbstractUpgrade(@Nonnull String id, @Nonnull String unlocName, @Nonnull ItemStack upgradeItem, int levelCost) {
        this(id, 0, unlocName, upgradeItem, levelCost);
    }

    @Deprecated
    protected AbstractUpgrade(@Nonnull String id, int variant, @Nonnull String unlocName, @Nonnull ItemStack upgradeItem, int levelCost) {
        this("enderio", id, variant, unlocName, upgradeItem, levelCost);
    }

    @Deprecated
    protected AbstractUpgrade(@Nonnull String domain, @Nonnull String id, int variant, @Nonnull String unlocName, @Nonnull ItemStack upgradeItem, final int levelCost) {
        this(domain, id, variant, unlocName, upgradeItem, new IValue<Integer>(){

            @Override
            @Nonnull
            public Integer get() {
                return levelCost;
            }
        });
    }

    protected AbstractUpgrade(@Nonnull String id, @Nonnull String unlocName, @Nonnull ItemStack upgradeItem, IValue<Integer> levelCost) {
        this(id, 0, unlocName, upgradeItem, levelCost);
    }

    protected AbstractUpgrade(@Nonnull String domain, @Nonnull String id, @Nonnull String unlocName, @Nonnull ItemStack upgradeItem, IValue<Integer> levelCost) {
        this(domain, id, 0, unlocName, upgradeItem, levelCost);
    }

    protected AbstractUpgrade(@Nonnull String id, int variant, @Nonnull String unlocName, @Nonnull ItemStack upgradeItem, IValue<Integer> levelCost) {
        this("enderio", id, variant, unlocName, upgradeItem, levelCost);
    }

    protected AbstractUpgrade(@Nonnull String domain, @Nonnull String id, int variant, @Nonnull String unlocName, @Nonnull ItemStack upgradeItem, IValue<Integer> levelCost) {
        this.id = KEY_UPGRADE_PREFIX + id;
        this.unlocName = unlocName;
        this.upgradeItem = upgradeItem;
        this.levelCost = levelCost;
        this.variant = variant;
        this.setRegistryName(domain, id + (variant != 0 ? Integer.valueOf(variant) : ""));
    }

    @Override
    @Nonnull
    public ItemStack getUpgradeItem() {
        return this.upgradeItem;
    }

    @SideOnly(value=Side.CLIENT)
    public void addCommonEntries(@Nonnull ItemStack itemstack, @Nullable EntityPlayer entityplayer, @Nonnull List<String> list, boolean flag) {
        SpecialTooltipHandler.addCommonTooltipFromResources(list, (String)this.getUnlocalizedName());
    }

    @SideOnly(value=Side.CLIENT)
    public void addBasicEntries(@Nonnull ItemStack itemstack, @Nullable EntityPlayer entityplayer, @Nonnull List<String> list, boolean flag) {
        list.add(TextFormatting.DARK_AQUA + EnderIO.lang.localizeExact(this.getUnlocalizedName() + ".name"));
    }

    @SideOnly(value=Side.CLIENT)
    public void addDetailedEntries(@Nonnull ItemStack itemstack, @Nullable EntityPlayer entityplayer, @Nonnull List<String> list, boolean flag) {
        list.add(TextFormatting.DARK_AQUA + EnderIO.lang.localizeExact(this.getUnlocalizedName() + ".name"));
        SpecialTooltipHandler.addDetailedTooltipFromResources(list, (String)this.getUnlocalizedName());
    }

    @Override
    public int getLevelCost() {
        return this.levelCost.get();
    }

    @Override
    @Nonnull
    public String getUnlocalizedName() {
        return this.unlocName;
    }

    @Override
    public final boolean hasUpgrade(@Nonnull ItemStack stack) {
        return IDarkSteelUpgrade.super.hasUpgrade(stack);
    }

    @Override
    public boolean hasUpgrade(@Nonnull ItemStack stack, @Nonnull IDarkSteelItem item) {
        NBTTagCompound tagCompound = NbtValue.getReadOnlyRoot(stack);
        return tagCompound.func_74764_b(this.id) && tagCompound.func_74775_l(this.id).func_74762_e(KEY_VARIANT) == this.variant;
    }

    public boolean hasAnyUpgradeVariant(@Nonnull ItemStack stack) {
        NBTTagCompound tagCompound = NbtValue.getReadOnlyRoot(stack);
        return tagCompound.func_74764_b(this.id) && tagCompound.func_74775_l(this.id).func_74764_b(KEY_VARIANT);
    }

    @Override
    public void addToItem(@Nonnull ItemStack stack, @Nonnull IDarkSteelItem item) {
        this.getOrCreateUpgradeNBT(stack).func_74768_a(KEY_VARIANT, this.variant);
    }

    @Nonnull
    public NBTTagCompound getOrCreateUpgradeNBT(@Nonnull ItemStack stack) {
        NBTTagCompound tagCompound = NbtValue.getOrCreateRoot(stack);
        if (!tagCompound.func_74764_b(this.id)) {
            tagCompound.func_74782_a(this.id, (NBTBase)new NBTTagCompound());
        }
        return tagCompound.func_74775_l(this.id);
    }
}

