/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.base.handler;

import com.enderio.core.common.util.NullHelper;
import crazypants.enderio.base.diagnostics.Prof;
import java.util.IdentityHashMap;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.profiler.Profiler;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;

@Mod.EventBusSubscriber(modid="enderio")
public class ServerTickHandler {
    @Nonnull
    private static final IdentityHashMap<ITickListener, String> listeners = new IdentityHashMap();

    public static void addListener(@Nonnull ITickListener listener) {
        listeners.put(listener, listener.getClass().getSimpleName());
    }

    public static void removeListener(@Nonnull ITickListener listener) {
        listeners.remove(listener);
    }

    public static void flush() {
        listeners.clear();
    }

    @SubscribeEvent
    public static void onServerTick(@Nonnull TickEvent.ServerTickEvent event) {
        Profiler profiler = FMLCommonHandler.instance().getMinecraftServerInstance().field_71304_b;
        if (!profiler.field_76327_a) {
            profiler = null;
        }
        Prof.start(profiler, "root");
        Prof.start(profiler, "ServerTickEvent_" + event.phase);
        for (Map.Entry<ITickListener, String> entry : listeners.entrySet()) {
            Prof.start(profiler, (String)NullHelper.first((Object[])new String[]{entry.getValue(), "(unnamed)"}));
            if (event.phase == TickEvent.Phase.START) {
                entry.getKey().tickStart(event, profiler);
            } else {
                entry.getKey().tickEnd(event, profiler);
            }
            Prof.stop(profiler);
        }
        Prof.stop(profiler, 2);
    }

    public static interface ITickListener {
        public void tickStart(TickEvent.ServerTickEvent var1, @Nullable Profiler var2);

        public void tickEnd(TickEvent.ServerTickEvent var1, @Nullable Profiler var2);
    }
}

