/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.base.fluid;

import com.enderio.core.common.fluid.BlockFluidEnder;
import com.enderio.core.common.util.NNList;
import com.enderio.core.common.util.NullHelper;
import crazypants.enderio.base.config.Config;
import crazypants.enderio.base.fluid.BlockFluidEio;
import crazypants.enderio.base.fluid.FluidFuelRegister;
import crazypants.enderio.base.fluid.FluidStateMapper;
import crazypants.enderio.base.integration.railcraft.RailcraftUtil;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.ItemMeshDefinition;
import net.minecraft.client.renderer.block.statemap.IStateMapper;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.event.ModelRegistryEvent;
import net.minecraftforge.client.event.TextureStitchEvent;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.registries.IForgeRegistryEntry;

@Mod.EventBusSubscriber(modid="enderio")
public enum Fluids {
    NUTRIENT_DISTILLATION("nutrient_distillation", Material.field_151586_h, 5922304){

        @Override
        protected Fluid init(@Nonnull Fluid fluid) {
            return fluid.setDensity(1500).setViscosity(3000);
        }

        @Override
        @Nonnull
        protected BlockFluidEnder init() {
            return new BlockFluidEio.NutrientDistillation(this.getFluid(), this.material, this.color);
        }
    }
    ,
    ENDER_DISTILLATION("ender_distillation", Material.field_151586_h, 1348917){

        @Override
        protected Fluid init(@Nonnull Fluid fluid) {
            return fluid.setDensity(200).setViscosity(1000).setTemperature(175);
        }
    }
    ,
    VAPOR_OF_LEVITY("vapor_of_levity", Material.field_151586_h, 4288874){

        @Override
        protected Fluid init(@Nonnull Fluid fluid) {
            return fluid.setDensity(-10).setViscosity(100).setTemperature(5).setGaseous(true);
        }

        @Override
        @Nonnull
        protected BlockFluidEnder init() {
            BlockFluidEio.VaporOfLevity result = new BlockFluidEio.VaporOfLevity(this.getFluid(), this.material, this.color);
            result.setQuantaPerBlock(1);
            return result;
        }
    }
    ,
    HOOTCH("hootch", Material.field_151586_h, 0xFFFFFF){

        @Override
        protected Fluid init(@Nonnull Fluid fluid) {
            return fluid.setDensity(900).setViscosity(1000);
        }

        @Override
        @Nonnull
        protected BlockFluidEnder init() {
            return new BlockFluidEio.Hootch(this.getFluid(), this.material, this.color);
        }
    }
    ,
    ROCKET_FUEL("rocket_fuel", Material.field_151586_h, 0x707044){

        @Override
        protected Fluid init(@Nonnull Fluid fluid) {
            return fluid.setDensity(900).setViscosity(1000);
        }

        @Override
        @Nonnull
        protected BlockFluidEnder init() {
            return new BlockFluidEio.RocketFuel(this.getFluid(), this.material, this.color);
        }
    }
    ,
    FIRE_WATER("fire_water", Material.field_151587_i, 9062671){

        @Override
        protected Fluid init(@Nonnull Fluid fluid) {
            return fluid.setDensity(900).setViscosity(1000).setTemperature(2000);
        }

        @Override
        @Nonnull
        protected BlockFluidEnder init() {
            return new BlockFluidEio.FireWater(this.getFluid(), this.material, this.color);
        }
    }
    ,
    XP_JUICE("xpjuice"){

        @Override
        protected Fluid init(@Nonnull Fluid fluid) {
            return fluid.setLuminosity(10).setDensity(800).setViscosity(1500);
        }
    }
    ,
    LIQUID_SUNSHINE("liquid_sunshine", Material.field_151586_h, 13813089){

        @Override
        protected Fluid init(@Nonnull Fluid fluid) {
            return fluid.setDensity(200).setViscosity(400);
        }

        @Override
        @Nonnull
        protected BlockFluidEnder init() {
            BlockFluidEio.LiquidSunshine result = new BlockFluidEio.LiquidSunshine(this.getFluid(), this.material, this.color);
            result.func_149715_a(1.0f);
            return result;
        }
    }
    ,
    CLOUD_SEED("cloud_seed", Material.field_151586_h, 2393481){

        @Override
        protected Fluid init(@Nonnull Fluid fluid) {
            return fluid.setDensity(500).setViscosity(800);
        }
    }
    ,
    CLOUD_SEED_CONCENTRATED("cloud_seed_concentrated", Material.field_151586_h, 4152413){

        @Override
        protected Fluid init(@Nonnull Fluid fluid) {
            return fluid.setDensity(1000).setViscosity(1200);
        }

        @Override
        @Nonnull
        protected BlockFluidEnder init() {
            return new BlockFluidEio.CloudSeedConcentrated(this.getFluid(), this.material, this.color);
        }
    };

    @Nonnull
    private final String name;
    private final boolean hasBlock;
    @Nonnull
    protected final Material material;
    protected final int color;
    @Deprecated
    private Fluid fluidUnsafe;

    private Fluids(String name) {
        this.name = name;
        this.hasBlock = false;
        this.material = Material.field_151579_a;
        this.color = -1;
    }

    private Fluids(String name, Material material, int color) {
        this.name = name;
        this.hasBlock = true;
        this.material = material;
        this.color = color;
    }

    protected abstract Fluid init(@Nonnull Fluid var1);

    @Nonnull
    protected BlockFluidEnder init() {
        return new BlockFluidEnder(this.getFluid(), this.material, this.color){};
    }

    @Nonnull
    public ResourceLocation getStill() {
        return new ResourceLocation("enderio", "blocks/fluid_" + this.name + "_still");
    }

    @Nonnull
    public ResourceLocation getFlowing() {
        return new ResourceLocation("enderio", "blocks/fluid_" + this.name + "_flow");
    }

    @Nonnull
    public Fluid getFluid() {
        return (Fluid)NullHelper.notnull((Object)FluidRegistry.getFluid((String)this.name), (String)("Fluid missing: " + this.name));
    }

    @Nonnull
    public ItemStack getBucket() {
        return Fluids.getBucket(this.getFluid());
    }

    @Nonnull
    public static ItemStack getBucket(@Nonnull Fluid fluid) {
        FluidStack fluidStack = new FluidStack(fluid, 1000);
        try {
            fluidStack.getFluid();
        }
        catch (NullPointerException e) {
            throw new RuntimeException("The fluid " + fluid + " (" + fluid.getUnlocalizedName() + ") is registered in the FluidRegistry, but the FluidRegistry has no delegate for it. This is impossible.", e);
        }
        return FluidUtil.getFilledBucket((FluidStack)fluidStack);
    }

    @Nonnull
    public static NNList<ItemStack> getBuckets() {
        NNList result = new NNList();
        for (Fluids fluid : Fluids.values()) {
            if (!FluidRegistry.getBucketFluids().contains(fluid.getFluid())) continue;
            result.add((Object)Fluids.getBucket(fluid.getFluid()));
        }
        return result;
    }

    @Nonnull
    public static NNList<ItemStack> getAllBuckets() {
        NNList result = new NNList();
        for (Fluid fluid : FluidRegistry.getBucketFluids()) {
            result.add((Object)Fluids.getBucket((Fluid)NullHelper.notnullF((Object)fluid, (String)"FluidRegistry.getBucketFluids() has null fluid")));
        }
        return result;
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public static void registerFluids(@Nonnull RegistryEvent.Register<Block> event) {
        for (Fluids fluid : Fluids.values()) {
            Fluid f = new Fluid(fluid.name, fluid.getStill(), fluid.getFlowing());
            FluidRegistry.registerFluid((Fluid)fluid.init(f));
            fluid.fluidUnsafe = f;
        }
    }

    @SubscribeEvent(priority=EventPriority.NORMAL)
    public static void registerBlocks(@Nonnull RegistryEvent.Register<Block> event) {
        for (Fluids fluid : Fluids.values()) {
            if (!fluid.hasBlock) continue;
            event.getRegistry().register((IForgeRegistryEntry)fluid.init());
        }
    }

    @SubscribeEvent
    public static void registerItems(@Nonnull RegistryEvent.Register<Item> event) {
        for (Fluids fluid : Fluids.values()) {
            FluidRegistry.addBucketForFluid((Fluid)fluid.fluidUnsafe);
        }
    }

    public static void registerFuels() {
        FluidFuelRegister.instance.addFuel(HOOTCH.getFluid(), Config.hootchPowerPerCycleRF, Config.hootchPowerTotalBurnTime);
        FluidFuelRegister.instance.addFuel(ROCKET_FUEL.getFluid(), Config.rocketFuelPowerPerCycleRF, Config.rocketFuelPowerTotalBurnTime);
        FluidFuelRegister.instance.addFuel(FIRE_WATER.getFluid(), Config.fireWaterPowerPerCycleRF, Config.fireWaterPowerTotalBurnTime);
        RailcraftUtil.registerFuels();
    }

    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent
    public static void registerRenderers(@Nonnull ModelRegistryEvent event) {
        for (Fluids fluid : Fluids.values()) {
            if (!fluid.hasBlock) continue;
            Fluids.registerFluidBlockRendering(fluid.getFluid());
        }
    }

    @SideOnly(value=Side.CLIENT)
    public static void registerFluidBlockRendering(@Nullable Fluid fluid) {
        if (fluid == null) {
            return;
        }
        Block block = fluid.getBlock();
        if (block == null) {
            return;
        }
        FluidStateMapper mapper = new FluidStateMapper(fluid);
        ModelLoader.setCustomStateMapper((Block)block, (IStateMapper)mapper);
        Item item = Item.func_150898_a((Block)block);
        if (item != Items.field_190931_a) {
            ModelLoader.registerItemVariants((Item)item, (ResourceLocation[])new ResourceLocation[0]);
            ModelLoader.setCustomMeshDefinition((Item)item, (ItemMeshDefinition)mapper);
        }
    }

    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent
    public static void onIconLoad(TextureStitchEvent.Pre event) {
        event.getMap().func_174942_a(XP_JUICE.getFluid().getStill());
        event.getMap().func_174942_a(XP_JUICE.getFluid().getFlowing());
    }
}

