/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.base.filter.network;

import com.enderio.core.common.network.MessageTileEntity;
import crazypants.enderio.base.filter.FilterRegistry;
import crazypants.enderio.base.filter.IFilter;
import crazypants.enderio.base.filter.ITileFilterContainer;
import crazypants.enderio.base.filter.gui.ContainerFilter;
import io.netty.buffer.ByteBuf;
import javax.annotation.Nonnull;
import jline.internal.Log;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import net.minecraftforge.fml.relauncher.Side;

public class PacketFilterUpdate
extends MessageTileEntity<TileEntity> {
    protected int filterId;
    protected int param1;
    protected IFilter filter;

    public PacketFilterUpdate() {
    }

    public PacketFilterUpdate(@Nonnull TileEntity te, @Nonnull IFilter filter, int filterId, int param1) {
        super(te);
        this.filter = filter;
        this.filterId = filterId;
        this.param1 = param1;
    }

    public void toBytes(ByteBuf buf) {
        super.toBytes(buf);
        buf.writeInt(this.filterId);
        buf.writeInt(this.param1);
        FilterRegistry.writeFilter(buf, this.filter);
    }

    public void fromBytes(ByteBuf buf) {
        super.fromBytes(buf);
        this.filterId = buf.readInt();
        this.param1 = buf.readInt();
        this.filter = FilterRegistry.readFilter(buf);
    }

    public ITileFilterContainer getFilterContainer(MessageContext ctx) {
        if (ctx.side == Side.SERVER && ctx.getServerHandler().field_147369_b.field_71070_bA instanceof ContainerFilter) {
            TileEntity tileEntity = ((ContainerFilter)ctx.getServerHandler().field_147369_b.field_71070_bA).getTileEntity();
            if (tileEntity == null || !tileEntity.func_174877_v().equals((Object)this.getPos())) {
                Log.warn((Object[])new Object[]{"Player " + ctx.getServerHandler().field_147369_b.func_70005_c_() + " tried to manipulate a filter while another gui was open!"});
                return null;
            }
            if (tileEntity instanceof ITileFilterContainer) {
                return (ITileFilterContainer)tileEntity;
            }
        }
        return null;
    }

    public static class Handler
    implements IMessageHandler<PacketFilterUpdate, IMessage> {
        public IMessage onMessage(PacketFilterUpdate message, MessageContext ctx) {
            ITileFilterContainer filterContainer = message.getFilterContainer(ctx);
            if (filterContainer != null) {
                filterContainer.setFilter(message.filterId, message.param1, message.filter);
            }
            return null;
        }
    }
}

