/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.base.filter.network;

import com.enderio.core.common.util.NNList;
import crazypants.enderio.base.filter.ITileFilterContainer;
import crazypants.enderio.base.filter.item.ExistingItemFilter;
import crazypants.enderio.base.filter.item.IItemFilter;
import crazypants.enderio.base.filter.network.PacketFilterUpdate;
import io.netty.buffer.ByteBuf;
import javax.annotation.Nonnull;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import net.minecraftforge.items.IItemHandler;

public class PacketExistingItemFilterSnapshot
extends PacketFilterUpdate {
    private Opcode opcode;

    public PacketExistingItemFilterSnapshot() {
    }

    public PacketExistingItemFilterSnapshot(TileEntity te, @Nonnull IItemFilter filter, int filterId, int param1, Opcode opcode) {
        super(te, filter, filterId, param1);
        this.opcode = opcode;
    }

    @Override
    public void fromBytes(ByteBuf buf) {
        super.fromBytes(buf);
        this.opcode = Opcode.values()[buf.readByte() & 0xFF];
    }

    @Override
    public void toBytes(ByteBuf buf) {
        super.toBytes(buf);
        buf.writeByte(this.opcode.ordinal());
    }

    public static class Handler
    implements IMessageHandler<PacketExistingItemFilterSnapshot, IMessage> {
        public PacketExistingItemFilterSnapshot onMessage(PacketExistingItemFilterSnapshot message, MessageContext ctx) {
            ITileFilterContainer filterContainer = message.getFilterContainer(ctx);
            if (filterContainer == null) {
                return null;
            }
            ExistingItemFilter filter = (ExistingItemFilter)filterContainer.getFilter(message.filterId, message.param1);
            switch (message.opcode) {
                case CLEAR: {
                    filter.setSnapshot((NNList<ItemStack>)((NNList)null));
                    break;
                }
                case SET: {
                    IItemHandler inv = filterContainer.getInventoryForSnapshot(message.filterId, message.param1);
                    if (inv == null) break;
                    filter.setSnapshot(inv);
                    break;
                }
                case MERGE: {
                    IItemHandler inv = filterContainer.getInventoryForSnapshot(message.filterId, message.param1);
                    if (inv == null) break;
                    filter.mergeSnapshot(inv);
                    break;
                }
                default: {
                    throw new AssertionError();
                }
            }
            filterContainer.setFilter(message.filterId, message.param1, filter);
            return null;
        }
    }

    public static enum Opcode {
        CLEAR,
        SET,
        MERGE;

    }
}

