/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.base.filter.item;

import com.enderio.core.common.network.NetworkUtil;
import crazypants.enderio.base.filter.item.IItemFilter;
import crazypants.enderio.util.Prep;
import io.netty.buffer.ByteBuf;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.items.IItemHandler;

public class ModItemFilter
implements IItemFilter {
    private final String[] mods = new String[3];
    private boolean blacklist = false;

    public String setMod(int index, @Nonnull ItemStack itemStack) {
        if (index < 0 || index >= this.mods.length) {
            return null;
        }
        if (itemStack.func_190926_b()) {
            this.setMod(index, (String)null);
            return null;
        }
        ResourceLocation ui = (ResourceLocation)Item.field_150901_e.func_177774_c((Object)itemStack.func_77973_b());
        if (ui == null) {
            this.setMod(index, (String)null);
            return null;
        }
        String targetMod = ui.func_110624_b();
        this.setMod(index, targetMod);
        return targetMod;
    }

    public void setMod(int index, String mod) {
        if (index < 0 || index >= this.mods.length) {
            return;
        }
        this.mods[index] = mod;
    }

    public String getModAt(int index) {
        if (index < 0 || index >= this.mods.length) {
            return null;
        }
        return this.mods[index];
    }

    public void setBlacklist(boolean value) {
        this.blacklist = value;
    }

    public boolean isBlacklist() {
        return this.blacklist;
    }

    @Override
    public boolean doesItemPassFilter(@Nullable IItemHandler inventory, @Nonnull ItemStack item) {
        if (Prep.isInvalid(item)) {
            return false;
        }
        ResourceLocation ui = (ResourceLocation)Item.field_150901_e.func_177774_c((Object)item.func_77973_b());
        if (ui == null) {
            return false;
        }
        String targetMod = ui.func_110624_b();
        for (String mod : this.mods) {
            if (!targetMod.equals(mod)) continue;
            return !this.blacklist;
        }
        return this.blacklist;
    }

    @Override
    public void setInventorySlotContents(int slot, @Nonnull ItemStack stack) {
        this.setMod(slot, stack);
    }

    @Override
    public boolean isSticky() {
        return false;
    }

    @Override
    public boolean isValid() {
        return true;
    }

    @Override
    public int getSlotCount() {
        return 0;
    }

    @Override
    public void readFromNBT(@Nonnull NBTTagCompound nbtRoot) {
        for (int i = 0; i < this.mods.length; ++i) {
            String mod = nbtRoot.func_74779_i("mod" + i);
            this.mods[i] = mod.isEmpty() || "-".equals(mod) ? null : mod;
            this.blacklist = nbtRoot.func_74764_b("blacklist") ? nbtRoot.func_74767_n("blacklist") : false;
        }
    }

    @Override
    public void writeToNBT(@Nonnull NBTTagCompound nbtRoot) {
        for (int i = 0; i < this.mods.length; ++i) {
            String mod = this.mods[i];
            if (mod == null || mod.trim().isEmpty()) {
                nbtRoot.func_74778_a("mod" + i, "-");
                continue;
            }
            nbtRoot.func_74778_a("mod" + i, mod);
        }
        nbtRoot.func_74757_a("blacklist", this.blacklist);
    }

    @Override
    public void writeToByteBuf(@Nonnull ByteBuf buf) {
        NBTTagCompound root = new NBTTagCompound();
        this.writeToNBT(root);
        NetworkUtil.writeNBTTagCompound((NBTTagCompound)root, (ByteBuf)buf);
    }

    @Override
    public void readFromByteBuf(@Nonnull ByteBuf buf) {
        NBTTagCompound tag = NetworkUtil.readNBTTagCompound((ByteBuf)buf);
        this.readFromNBT(tag);
    }
}

