/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.base.filter.gui;

import com.enderio.core.api.client.gui.IGuiScreen;
import com.enderio.core.api.client.render.IWidgetIcon;
import com.enderio.core.client.gui.button.IconButton;
import com.enderio.core.client.gui.widget.GuiToolTip;
import com.enderio.core.client.render.ColorUtil;
import crazypants.enderio.base.filter.gui.AbstractFilterGui;
import crazypants.enderio.base.filter.gui.ContainerFilter;
import crazypants.enderio.base.filter.gui.FilterGuiUtil;
import crazypants.enderio.base.filter.item.IItemFilter;
import crazypants.enderio.base.filter.item.ModItemFilter;
import crazypants.enderio.base.gui.IconEIO;
import crazypants.enderio.base.integration.jei.GhostSlotTarget;
import crazypants.enderio.base.lang.Lang;
import java.awt.Color;
import java.awt.Rectangle;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;

public class ModItemFilterGui
extends AbstractFilterGui {
    private static final int MOD_NAME_COLOR = ColorUtil.getRGB((Color)Color.white);
    @Nonnull
    private final ModItemFilter filter;
    private final Rectangle[] inputBounds;
    private final IconButton[] deleteButs;
    private final IconButton whiteListB;
    private final int inputOffsetX;
    private final int tfWidth;
    @Nonnull
    private final GuiToolTip stackInsertTooltip1;
    @Nonnull
    private final GuiToolTip stackInsertTooltip2;
    @Nonnull
    private final GuiToolTip stackInsertTooltip3;

    public ModItemFilterGui(@Nonnull InventoryPlayer playerInv, @Nonnull ContainerFilter filterContainer, TileEntity te, @Nonnull IItemFilter filterIn) {
        super(playerInv, filterContainer, te, filterIn, "mod_item_filter");
        this.filter = (ModItemFilter)filterIn;
        this.inputOffsetX = this.getGuiLeft() + 20;
        this.tfWidth = 96;
        this.inputBounds = new Rectangle[]{new Rectangle(this.inputOffsetX, 46, 16, 16), new Rectangle(this.inputOffsetX, 68, 16, 16), new Rectangle(this.inputOffsetX, 90, 16, 16)};
        this.stackInsertTooltip1 = new GuiToolTip(this.inputBounds[0], new String[]{Lang.GUI_MOD_ITEM_FILTER_SLOT.get()});
        this.stackInsertTooltip2 = new GuiToolTip(this.inputBounds[1], new String[]{Lang.GUI_MOD_ITEM_FILTER_SLOT.get()});
        this.stackInsertTooltip3 = new GuiToolTip(this.inputBounds[2], new String[]{Lang.GUI_MOD_ITEM_FILTER_SLOT.get()});
        this.deleteButs = new IconButton[this.inputBounds.length];
        for (int i = 0; i < this.deleteButs.length; ++i) {
            Rectangle r = this.inputBounds[i];
            IconButton but = new IconButton((IGuiScreen)this, FilterGuiUtil.nextButtonId(), r.x + 19, r.y, (IWidgetIcon)IconEIO.MINUS);
            but.setToolTip(new String[]{Lang.GUI_MOD_ITEM_FILTER_DELETE.get()});
            this.deleteButs[i] = but;
        }
        this.whiteListB = new IconButton((IGuiScreen)this, -1, this.inputOffsetX + 19, 24, (IWidgetIcon)IconEIO.FILTER_WHITELIST);
        this.whiteListB.setToolTip(new String[]{Lang.GUI_ITEM_FILTER_WHITELIST.get()});
    }

    @Override
    public void updateButtons() {
        super.updateButtons();
        for (IconButton but : this.deleteButs) {
            but.onGuiInit();
        }
        this.whiteListB.onGuiInit();
        if (this.filter.isBlacklist()) {
            this.whiteListB.setIcon((IWidgetIcon)IconEIO.FILTER_BLACKLIST);
            this.whiteListB.setToolTip(new String[]{Lang.GUI_ITEM_FILTER_BLACKLIST.get()});
        } else {
            this.whiteListB.setIcon((IWidgetIcon)IconEIO.FILTER_WHITELIST);
            this.whiteListB.setToolTip(new String[]{Lang.GUI_ITEM_FILTER_WHITELIST.get()});
        }
        this.addToolTip(this.stackInsertTooltip1);
        this.addToolTip(this.stackInsertTooltip2);
        this.addToolTip(this.stackInsertTooltip3);
    }

    @Override
    public void func_146284_a(@Nonnull GuiButton guiButton) throws IOException {
        super.func_146284_a(guiButton);
        for (int i = 0; i < this.deleteButs.length; ++i) {
            IconButton but = this.deleteButs[i];
            if (but.field_146127_k != guiButton.field_146127_k) continue;
            this.setMod(i, ItemStack.field_190927_a);
            return;
        }
        if (guiButton == this.whiteListB) {
            this.filter.setBlacklist(!this.filter.isBlacklist());
            this.sendFilterChange();
        }
    }

    @Override
    public void renderCustomOptions(int top, float par1, int par2, int par3) {
        FontRenderer fr = Minecraft.func_71410_x().field_71466_p;
        for (int i = 0; i < this.inputBounds.length; ++i) {
            String mod = this.filter.getModAt(i);
            if (mod == null) continue;
            Rectangle r = this.inputBounds[i];
            mod = fr.func_78269_a(mod, this.tfWidth - 6);
            fr.func_175063_a(mod, (float)(this.getGuiLeft() + r.x + 41), (float)(this.getGuiTop() + r.y + 4), MOD_NAME_COLOR);
        }
    }

    @Override
    public void func_73864_a(int x, int y, int par3) throws IOException {
        super.func_73864_a(x, y, par3);
        ItemStack st = Minecraft.func_71410_x().field_71439_g.field_71071_by.func_70445_o();
        if (st.func_190926_b()) {
            return;
        }
        int xOffset = this.getGuiLeft();
        int yOffset = this.getGuiTop();
        for (int i = 0; i < this.inputBounds.length; ++i) {
            Rectangle bound = this.inputBounds[i];
            if (!bound.contains(x - xOffset, y - yOffset)) continue;
            this.setMod(i, st);
        }
    }

    private void setMod(int i, @Nonnull ItemStack st) {
        this.filter.setMod(i, st);
        this.sendFilterChange();
    }

    @Override
    @Nonnull
    protected String getUnlocalisedNameForHeading() {
        return Lang.GUI_MOD_ITEM_FILTER.get();
    }

    @Override
    @Nonnull
    public <I> List<GhostSlotTarget<I>> getTargetSlots() {
        ArrayList<GhostSlotTarget<I>> targets = new ArrayList<GhostSlotTarget<I>>();
        for (int i = 0; i < this.inputBounds.length; ++i) {
            targets.add(new GhostSlotTarget(this.filter, i, this.getGuiLeft(), this.getGuiTop(), this.inputBounds[i].x, this.inputBounds[i].y, this));
        }
        return targets;
    }
}

